/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.dialect;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcConfig;
import org.apache.eventmesh.connector.jdbc.connection.JdbcConnection;
import org.apache.eventmesh.connector.jdbc.dialect.DatabaseDialect;
import org.apache.eventmesh.connector.jdbc.exception.JdbcConnectionException;
import org.apache.eventmesh.connector.jdbc.table.catalog.Column;
import org.apache.eventmesh.connector.jdbc.table.catalog.TableId;
import org.apache.eventmesh.connector.jdbc.type.Type;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.BooleanEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.BytesEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.DateEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.DateTimeEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.DecimalEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Float32EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Float64EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int16EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int32EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int64EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.Int8EventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.StringEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.TimeEventMeshDataType;
import org.apache.eventmesh.connector.jdbc.type.eventmesh.YearEventMeshDataType;
import org.hibernate.dialect.Dialect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGeneralDatabaseDialect<JC extends JdbcConnection, Col extends Column>
implements DatabaseDialect<JC> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractGeneralDatabaseDialect.class);
    private static final int DEFAULT_BATCH_MAX_ROWS = 20;
    private JdbcConfig config;
    private int batchMaxRows = 20;
    private final Map<String, Type> typeRegisters = new HashMap<String, Type>(32);
    private Dialect hibernateDialect;

    public AbstractGeneralDatabaseDialect(JdbcConfig config) {
        this.config = config;
    }

    @Override
    public void configure(Dialect hibernateDialect) {
        this.hibernateDialect = hibernateDialect;
    }

    @Override
    public boolean isValid(Connection connection, int timeout) throws JdbcConnectionException, SQLException {
        return connection == null ? false : connection.isValid(timeout);
    }

    @Override
    public PreparedStatement createPreparedStatement(Connection connection, String sql) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        if (this.batchMaxRows > 0) {
            preparedStatement.setFetchSize(this.batchMaxRows);
        }
        return preparedStatement;
    }

    @Override
    public Type getType(Column<?> column) {
        Type type;
        Type type2;
        Type type3;
        String nativeType = column.getNativeType();
        if (nativeType != null && (type3 = this.typeRegisters.get(nativeType)) != null) {
            log.debug("found type {} for column {}", (Object)type3.getClass().getName(), (Object)column.getName());
            return type3;
        }
        String dataTypeName = column.getDataType().getName();
        if (dataTypeName != null && (type2 = this.typeRegisters.get(dataTypeName)) != null) {
            log.debug("found type {} for column {}", (Object)type2.getClass().getName(), (Object)column.getName());
            return type2;
        }
        String jdbcTypeName = column.getJdbcType().name();
        if (jdbcTypeName != null && (type = this.typeRegisters.get(jdbcTypeName)) != null) {
            log.debug("found type {} for column {}", (Object)type.getClass().getName(), (Object)column.getName());
            return type;
        }
        return null;
    }

    protected void registerTypes() {
        this.registerType(BooleanEventMeshDataType.INSTANCE);
        this.registerType(Float32EventMeshDataType.INSTANCE);
        this.registerType(Float64EventMeshDataType.INSTANCE);
        this.registerType(Int8EventMeshDataType.INSTANCE);
        this.registerType(Int16EventMeshDataType.INSTANCE);
        this.registerType(Int32EventMeshDataType.INSTANCE);
        this.registerType(Int64EventMeshDataType.INSTANCE);
        this.registerType(StringEventMeshDataType.INSTANCE);
        this.registerType(DateEventMeshDataType.INSTANCE);
        this.registerType(TimeEventMeshDataType.INSTANCE);
        this.registerType(DateTimeEventMeshDataType.INSTANCE);
        this.registerType(DecimalEventMeshDataType.INSTANCE);
        this.registerType(BytesEventMeshDataType.INSTANCE);
        this.registerType(YearEventMeshDataType.INSTANCE);
    }

    protected void registerType(Type type) {
        type.configure(this, this.hibernateDialect);
        ((List)Optional.ofNullable(type.ofRegistrationKeys()).orElse(new ArrayList(0))).forEach(key -> this.typeRegisters.put((String)key, type));
    }

    public abstract String getQualifiedTableName(TableId var1);

    public abstract String getQualifiedText(String var1);

    @Override
    public String getTypeName(Dialect hibernateDialect, Column<?> column) {
        Type type = this.getType(column);
        if (type != null) {
            return type.getTypeName(column);
        }
        Long length = Optional.ofNullable(column.getColumnLength()).orElse(0L);
        return hibernateDialect.getTypeName(column.getJdbcType().getVendorTypeNumber().intValue(), length.longValue(), length.intValue(), Optional.ofNullable(column.getDecimal()).orElse(0).intValue());
    }
}

