/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.jdbc.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.annotation.concurrent.ThreadSafe;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.config.connector.rdb.jdbc.JdbcConfig;
import org.apache.eventmesh.connector.jdbc.JdbcDriverMetaData;
import org.apache.eventmesh.connector.jdbc.connection.PreparedParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcConnection
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JdbcConnection.class);
    private static final int CONNECTION_VALID_CHECK_TIMEOUT_IN_SEC = 3;
    private static final String STATEMENT_DELIMITER = ";";
    private final JdbcConfig jdbcConfig;
    private volatile Connection connection;
    private final InitialOperation initialOperation;
    private final ConnectionFactory connectionFactory;
    private JdbcDriverMetaData jdbcDriverMetaData;
    private boolean lazyConnection = true;

    public JdbcConnection(JdbcConfig jdbcConfig, InitialOperation initialOperation, ConnectionFactory connectionFactory) {
        this(jdbcConfig, initialOperation, connectionFactory, true);
    }

    public JdbcConnection(JdbcConfig jdbcConfig, InitialOperation initialOperation, ConnectionFactory connectionFactory, boolean lazyConnection) {
        this.jdbcConfig = jdbcConfig;
        this.initialOperation = initialOperation;
        this.connectionFactory = connectionFactory;
        this.lazyConnection = lazyConnection;
        if (!this.lazyConnection) {
            try {
                this.connection();
            }
            catch (SQLException e) {
                log.warn("Get Connection error", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() throws Exception {
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public JdbcConnection setAutoCommit(boolean autoCommit) throws SQLException {
        this.connection().setAutoCommit(autoCommit);
        return this;
    }

    public synchronized Connection connection() throws SQLException {
        return this.connection(true);
    }

    public synchronized Connection connection(boolean executeOnConnect) throws SQLException {
        if (!this.isConnected()) {
            String statements;
            this.connection = this.connectionFactory.connect(this.jdbcConfig);
            if (!this.isConnected()) {
                throw new SQLException("Unable to obtain a JDBC connection");
            }
            if (this.initialOperation != null) {
                this.execute(this.initialOperation);
            }
            if (StringUtils.isNotBlank((CharSequence)(statements = this.jdbcConfig.getInitialStatements())) && executeOnConnect) {
                String[] split = statements.split(STATEMENT_DELIMITER);
                this.execute(split);
            }
            this.jdbcDriverMetaData = this.createJdbcDriverInfo();
        }
        return this.connection;
    }

    private JdbcDriverMetaData createJdbcDriverInfo() throws SQLException {
        DatabaseMetaData metadata = this.connection.getMetaData();
        int majorVersion = metadata.getJDBCMajorVersion();
        int minorVersion = metadata.getJDBCMinorVersion();
        String driverName = metadata.getDriverName();
        String productName = metadata.getDatabaseProductName();
        String productVersion = metadata.getDatabaseProductVersion();
        return new JdbcDriverMetaData(majorVersion, minorVersion, driverName, productName, productVersion);
    }

    public JdbcDriverMetaData getJdbcDriverMetaData() {
        return this.jdbcDriverMetaData;
    }

    public JdbcConnection execute(String ... sqlStatements) throws SQLException {
        return this.execute((Statement statement) -> {
            for (String sqlStatement : sqlStatements) {
                if (sqlStatement == null) continue;
                log.debug("Executing '{}'", (Object)sqlStatement);
                statement.execute(sqlStatement);
            }
        });
    }

    public JdbcConnection execute(InitialOperation operation) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = conn.createStatement();){
            operation.apply(statement);
            this.commit();
        }
        return this;
    }

    public JdbcConnection executeWithoutCommitting(String ... sqlStatements) throws SQLException {
        Connection conn = this.connection();
        if (conn.getAutoCommit()) {
            throw new SQLException("Cannot execute without committing because auto-commit is enabled");
        }
        try (Statement statement = conn.createStatement();){
            for (String sqlStatement : sqlStatements) {
                log.debug("Executing sql statement: {}", (Object)sqlStatement);
                statement.execute(sqlStatement);
            }
        }
        return this;
    }

    public synchronized boolean isConnected() throws SQLException {
        if (this.connection == null) {
            return false;
        }
        return !this.connection.isClosed();
    }

    public synchronized boolean isValid() throws SQLException {
        return this.isConnected() && this.connection.isValid(3);
    }

    public JdbcConnection commit() throws SQLException {
        Connection conn = this.connection();
        if (!conn.getAutoCommit()) {
            conn.commit();
        }
        return this;
    }

    public JdbcConnection query(String sql, JdbcResultSetConsumer resultConsumer) throws SQLException {
        if (this.isConnected() && this.isValid()) {
            this.connection();
        }
        return this.query(sql, Connection::createStatement, resultConsumer);
    }

    public JdbcConnection query(String sql, StatementFactory statementFactory, JdbcResultSetConsumer resultConsumer) throws SQLException {
        Connection conn = this.connection();
        try (Statement statement = statementFactory.createStatement(conn);){
            log.debug("Query sql '{}'", (Object)sql);
            try (ResultSet resultSet = statement.executeQuery(sql);){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public <T> T query(String sql, ResultSetMapper<T> resultSetMapper) throws SQLException {
        if (this.isConnected() && this.isValid()) {
            this.connection();
        }
        return this.query(sql, Connection::createStatement, resultSetMapper);
    }

    public <T> T query(String sql, StatementFactory statementFactory, ResultSetMapper<T> resultSetMapper) throws SQLException {
        block13: {
            Connection conn = this.connection();
            try (Statement statement = statementFactory.createStatement(conn);){
                log.debug("Query sql '{}'", (Object)sql);
                ResultSet resultSet = statement.executeQuery(sql);
                if (resultSetMapper == null) break block13;
                T t = resultSetMapper.map(resultSet);
                return t;
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        return null;
    }

    public JdbcConnection preparedQuery(String sql, JdbcResultSetConsumer resultConsumer, PreparedParameter ... preparedParameters) throws SQLException {
        if (this.isConnected() && this.isValid()) {
            this.connection();
        }
        return this.preparedQuery(sql, (Connection conn, String statement) -> conn.prepareStatement(sql), resultConsumer, preparedParameters);
    }

    public JdbcConnection preparedQuery(String sql, PreparedStatementFactory preparedStatementFactory, JdbcResultSetConsumer resultConsumer, PreparedParameter ... preparedParameters) throws SQLException {
        Connection conn = this.connection();
        try (PreparedStatement preparedStatement = preparedStatementFactory.createPreparedStatement(conn, sql);){
            log.debug("Query sql '{}'", (Object)sql);
            if (preparedParameters != null) {
                for (int index = 0; index < preparedParameters.length; ++index) {
                    PreparedParameter preparedParameter = preparedParameters[index];
                    if (preparedParameter.getJdbcType() == null) {
                        preparedStatement.setObject(index + 1, preparedParameter.getValue());
                        continue;
                    }
                    preparedStatement.setObject(index + 1, preparedParameter.getValue(), preparedParameter.getJdbcType().getVendorTypeNumber());
                }
            }
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultConsumer != null) {
                    resultConsumer.accept(resultSet);
                }
            }
        }
        return this;
    }

    public <T> T preparedQuery(String sql, ResultSetMapper<T> resultSetMapper, PreparedParameter ... preparedParameters) throws SQLException {
        if (this.isConnected() && this.isValid()) {
            this.connection();
        }
        return this.preparedQuery(sql, (Connection conn, String statement) -> conn.prepareStatement(sql), resultSetMapper, preparedParameters);
    }

    public <T> T preparedQuery(String sql, PreparedStatementFactory preparedStatementFactory, ResultSetMapper<T> resultSetMapper, PreparedParameter ... preparedParameters) throws SQLException {
        block16: {
            Connection conn = this.connection();
            try (PreparedStatement preparedStatement = preparedStatementFactory.createPreparedStatement(conn, sql);){
                log.debug("Query sql '{}'", (Object)sql);
                if (preparedParameters != null) {
                    for (int index = 0; index < preparedParameters.length; ++index) {
                        PreparedParameter preparedParameter = preparedParameters[index];
                        if (preparedParameter.getJdbcType() == null) {
                            preparedStatement.setObject(index + 1, preparedParameter.getValue());
                            continue;
                        }
                        preparedStatement.setObject(index + 1, preparedParameter.getValue(), preparedParameter.getJdbcType().getVendorTypeNumber());
                    }
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                if (resultSetMapper == null) break block16;
                T t = resultSetMapper.map(resultSet);
                return t;
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
        }
        return null;
    }

    public Statement createStatement(int fetchSize, int defaultFetchSize) throws SQLException {
        Statement statement = this.connection().createStatement();
        statement.setFetchSize(fetchSize <= 0 ? defaultFetchSize : fetchSize);
        return statement;
    }

    public static ConnectionFactory createPatternConnectionFactory(String urlWithPlaceholder, String ... replaces) {
        return config -> {
            String url = replaces != null && replaces.length > 0 ? String.format(urlWithPlaceholder, replaces) : urlWithPlaceholder;
            log.debug("URL: {}", (Object)url);
            Connection connection = DriverManager.getConnection(url, config.asProperties());
            log.debug("User [{}] Connected to {}", (Object)config.getUser(), (Object)url);
            return connection;
        };
    }

    @Generated
    public JdbcConfig getJdbcConfig() {
        return this.jdbcConfig;
    }

    @FunctionalInterface
    public static interface JdbcResultSetConsumer {
        public void accept(ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface ResultSetMapper<T> {
        public T map(ResultSet var1) throws SQLException;
    }

    @FunctionalInterface
    @ThreadSafe
    public static interface ConnectionFactory {
        public Connection connect(JdbcConfig var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface PreparedStatementFactory {
        public PreparedStatement createPreparedStatement(Connection var1, String var2) throws SQLException;
    }

    @FunctionalInterface
    public static interface StatementFactory {
        public Statement createStatement(Connection var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface InitialOperation {
        public void apply(Statement var1) throws SQLException;
    }
}

