/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.indexing.error.MSQFault;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;

public abstract class BaseMSQFault
implements MSQFault {
    private final String errorCode;
    @Nullable
    private final String errorMessage;

    BaseMSQFault(String errorCode, @Nullable String errorMessage) {
        this.errorCode = (String)Preconditions.checkNotNull((Object)errorCode, (Object)"errorCode");
        Preconditions.checkArgument((!errorCode.contains(": ") ? 1 : 0) != 0, (String)"Error code[%s] contains restricted characters[%s]", (Object)errorCode, (Object)": ");
        this.errorMessage = errorMessage;
    }

    BaseMSQFault(String errorCode, String errorMessageFormat, Object errorMessageFirstArg, Object ... errorMessageOtherArgs) {
        this(errorCode, BaseMSQFault.format(errorMessageFormat, errorMessageFirstArg, errorMessageOtherArgs));
    }

    BaseMSQFault(String errorCode) {
        this(errorCode, null);
    }

    @Override
    public String getErrorCode() {
        return this.errorCode;
    }

    @Override
    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseMSQFault that = (BaseMSQFault)o;
        return Objects.equals(this.errorCode, that.errorCode) && Objects.equals(this.errorMessage, that.errorMessage);
    }

    public int hashCode() {
        return Objects.hash(this.errorCode, this.errorMessage);
    }

    public String toString() {
        return MSQFaultUtils.generateMessageWithErrorCode(this);
    }

    private static String format(String formatString, Object firstArg, Object ... otherArgs) {
        Object[] args = new Object[1 + (otherArgs != null ? otherArgs.length : 0)];
        args[0] = firstArg;
        if (otherArgs != null) {
            System.arraycopy(otherArgs, 0, args, 1, otherArgs.length);
        }
        return StringUtils.format((String)formatString, (Object[])args);
    }
}

