/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing;

import com.google.common.util.concurrent.ListenableFuture;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.msq.counters.ChannelCounters;

public class CountingReadableFrameChannel
implements ReadableFrameChannel {
    private final ReadableFrameChannel baseChannel;
    private final ChannelCounters channelCounters;
    private final int partitionNumber;

    public CountingReadableFrameChannel(ReadableFrameChannel baseChannel, ChannelCounters channelCounters, int partitionNumber) {
        this.baseChannel = baseChannel;
        this.channelCounters = channelCounters;
        this.partitionNumber = partitionNumber;
    }

    public boolean isFinished() {
        return this.baseChannel.isFinished();
    }

    public boolean canRead() {
        return this.baseChannel.canRead();
    }

    public Frame read() {
        Frame frame = this.baseChannel.read();
        this.channelCounters.addFrame(this.partitionNumber, frame);
        return frame;
    }

    public ListenableFuture<?> readabilityFuture() {
        return this.baseChannel.readabilityFuture();
    }

    public void close() {
        this.baseChannel.close();
    }
}

