/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import java.util.SortedMap;
import java.util.TreeMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.AutoTypeColumnSchema;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.NestedCommonFormatColumnHandler;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnFormat;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.nested.FieldTypeInfo;
import org.apache.druid.segment.nested.NestedCommonFormatColumnFormatSpec;

public interface NestedCommonFormatColumn
extends BaseColumn {
    default public Indexed<String> getStringDictionary() {
        return Indexed.empty();
    }

    default public Indexed<Long> getLongDictionary() {
        return Indexed.empty();
    }

    default public Indexed<Double> getDoubleDictionary() {
        return Indexed.empty();
    }

    default public Indexed<Object[]> getArrayDictionary() {
        return Indexed.empty();
    }

    default public SortedMap<String, FieldTypeInfo.MutableTypeSet> getFieldTypeInfo() {
        TreeMap<String, FieldTypeInfo.MutableTypeSet> fields = new TreeMap<String, FieldTypeInfo.MutableTypeSet>();
        if (!ColumnType.NESTED_DATA.equals(this.getLogicalType())) {
            FieldTypeInfo.MutableTypeSet rootOnlyType = new FieldTypeInfo.MutableTypeSet().add(this.getLogicalType());
            fields.put("$", rootOnlyType);
        }
        return fields;
    }

    public ColumnType getLogicalType();

    public static class Format
    implements ColumnFormat {
        protected final ColumnType logicalType;
        protected final boolean hasNulls;
        protected final boolean enforceLogicalType;
        protected final NestedCommonFormatColumnFormatSpec columnFormatSpec;

        public Format(ColumnType logicalType, boolean hasNulls, boolean enforceLogicalType, NestedCommonFormatColumnFormatSpec columnFormatSpec) {
            this.logicalType = logicalType;
            this.hasNulls = hasNulls;
            this.enforceLogicalType = enforceLogicalType;
            this.columnFormatSpec = columnFormatSpec;
        }

        @Override
        public ColumnType getLogicalType() {
            return this.logicalType;
        }

        @Override
        public DimensionHandler getColumnHandler(String columnName) {
            return new NestedCommonFormatColumnHandler(columnName, this.enforceLogicalType ? this.logicalType : null, this.columnFormatSpec);
        }

        @Override
        public DimensionSchema getColumnSchema(String columnName) {
            return new AutoTypeColumnSchema(columnName, this.enforceLogicalType ? this.logicalType : null, this.columnFormatSpec);
        }

        @Override
        public ColumnFormat merge(@Nullable ColumnFormat otherFormat) {
            if (otherFormat == null) {
                return this;
            }
            if (otherFormat instanceof Format) {
                Format other = (Format)otherFormat;
                if (!this.logicalType.equals(other.logicalType)) {
                    return new Format(ColumnType.leastRestrictiveType(this.logicalType, other.logicalType), this.hasNulls || other.hasNulls, false, this.columnFormatSpec);
                }
                return new Format(this.logicalType, this.hasNulls || other.hasNulls, this.enforceLogicalType || other.enforceLogicalType, this.columnFormatSpec);
            }
            throw new ISE("Cannot merge columns of type[%s] and format[%s] and with [%s] and [%s]", this.logicalType, this.getClass().getName(), otherFormat.getLogicalType(), otherFormat.getClass().getName());
        }

        @Override
        public ColumnCapabilities toColumnCapabilities() {
            if (this.logicalType.isPrimitive() || this.logicalType.isArray()) {
                return ColumnCapabilitiesImpl.createDefault().setType(this.logicalType).setDictionaryEncoded(true).setDictionaryValuesSorted(true).setDictionaryValuesUnique(true).setHasBitmapIndexes(true).setHasNulls(this.hasNulls);
            }
            return ColumnCapabilitiesImpl.createDefault().setType(this.logicalType).setHasNulls(this.hasNulls);
        }
    }
}

