/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import java.io.EOFException;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.orc.impl.InStream;
import org.apache.orc.impl.IntegerReader;
import org.apache.orc.impl.PositionProvider;
import org.apache.orc.impl.SerializationUtils;

public class RunLengthIntegerReader
implements IntegerReader {
    private InStream input;
    private final boolean signed;
    private final long[] literals = new long[128];
    private int numLiterals = 0;
    private int delta = 0;
    private int used = 0;
    private boolean repeat = false;

    public RunLengthIntegerReader(InStream input, boolean signed) throws IOException {
        this.input = input;
        this.signed = signed;
    }

    private void readValues(boolean ignoreEof) throws IOException {
        int control = this.input.read();
        if (control == -1) {
            if (!ignoreEof) {
                throw new EOFException("Read past end of RLE integer from " + this.input);
            }
            this.numLiterals = 0;
            this.used = 0;
            return;
        }
        if (control < 128) {
            this.numLiterals = control + 3;
            this.used = 0;
            this.repeat = true;
            this.delta = this.input.read();
            if (this.delta == -1) {
                throw new EOFException("End of stream in RLE Integer from " + this.input);
            }
            this.delta = (byte)(0 + this.delta);
            this.literals[0] = this.signed ? SerializationUtils.readVslong(this.input) : SerializationUtils.readVulong(this.input);
        } else {
            this.repeat = false;
            this.numLiterals = 256 - control;
            this.used = 0;
            for (int i = 0; i < this.numLiterals; ++i) {
                this.literals[i] = this.signed ? SerializationUtils.readVslong(this.input) : SerializationUtils.readVulong(this.input);
            }
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        return this.used != this.numLiterals || this.input.available() > 0;
    }

    @Override
    public long next() throws IOException {
        if (this.used == this.numLiterals) {
            this.readValues(false);
        }
        long result = this.repeat ? this.literals[0] + (long)(this.used++ * this.delta) : this.literals[this.used++];
        return result;
    }

    @Override
    public void nextVector(ColumnVector previous, long[] data, int previousLen) throws IOException {
        previous.isRepeating = true;
        for (int i = 0; i < previousLen; ++i) {
            data[i] = !previous.isNull[i] ? this.next() : 1L;
            if (!previous.isRepeating || i <= 0 || data[0] == data[i] && previous.isNull[0] == previous.isNull[i]) continue;
            previous.isRepeating = false;
        }
    }

    @Override
    public void nextVector(ColumnVector vector, int[] data, int size) throws IOException {
        block3: {
            block2: {
                if (!vector.noNulls) break block2;
                for (int r = 0; r < data.length && r < size; ++r) {
                    data[r] = (int)this.next();
                }
                break block3;
            }
            if (vector.isRepeating && vector.isNull[0]) break block3;
            for (int r = 0; r < data.length && r < size; ++r) {
                data[r] = !vector.isNull[r] ? (int)this.next() : 1;
            }
        }
    }

    @Override
    public void seek(PositionProvider index) throws IOException {
        int consumed;
        this.input.seek(index);
        if (consumed != 0) {
            for (consumed = (int)index.getNext(); consumed > 0; consumed -= this.numLiterals) {
                this.readValues(false);
                this.used = consumed;
            }
        } else {
            this.used = 0;
            this.numLiterals = 0;
        }
    }

    @Override
    public void skip(long numValues) throws IOException {
        while (numValues > 0L) {
            if (this.used == this.numLiterals) {
                this.readValues(false);
            }
            long consume = Math.min(numValues, (long)(this.numLiterals - this.used));
            this.used = (int)((long)this.used + consume);
            numValues -= consume;
        }
    }
}

