/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribePlacementGroupsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribePlacementGroupsRequestMarshaller
implements Marshaller<Request<DescribePlacementGroupsRequest>, DescribePlacementGroupsRequest> {
    public Request<DescribePlacementGroupsRequest> marshall(DescribePlacementGroupsRequest describePlacementGroupsRequest) {
        SdkInternalList describePlacementGroupsRequestGroupIdsList;
        SdkInternalList describePlacementGroupsRequestGroupNamesList;
        if (describePlacementGroupsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describePlacementGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribePlacementGroups");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describePlacementGroupsRequestFiltersList = (SdkInternalList)describePlacementGroupsRequest.getFilters();
        if (!describePlacementGroupsRequestFiltersList.isEmpty() || !describePlacementGroupsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Object describePlacementGroupsRequestFiltersListValue : describePlacementGroupsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (((Filter)describePlacementGroupsRequestFiltersListValue).getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)((Filter)describePlacementGroupsRequestFiltersListValue).getName()));
                }
                if (!(filterValuesList = (SdkInternalList)((Filter)describePlacementGroupsRequestFiltersListValue).getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describePlacementGroupsRequestGroupNamesList = (SdkInternalList)describePlacementGroupsRequest.getGroupNames()).isEmpty() || !describePlacementGroupsRequestGroupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String describePlacementGroupsRequestGroupNamesListValue : describePlacementGroupsRequestGroupNamesList) {
                if (describePlacementGroupsRequestGroupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString((String)describePlacementGroupsRequestGroupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (!(describePlacementGroupsRequestGroupIdsList = (SdkInternalList)describePlacementGroupsRequest.getGroupIds()).isEmpty() || !describePlacementGroupsRequestGroupIdsList.isAutoConstruct()) {
            int groupIdsListIndex = 1;
            for (String describePlacementGroupsRequestGroupIdsListValue : describePlacementGroupsRequestGroupIdsList) {
                if (describePlacementGroupsRequestGroupIdsListValue != null) {
                    request.addParameter("GroupId." + groupIdsListIndex, StringUtils.fromString((String)describePlacementGroupsRequestGroupIdsListValue));
                }
                ++groupIdsListIndex;
            }
        }
        return request;
    }
}

