/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.util.Set;
import org.apache.druid.catalog.MetadataCatalog;
import org.apache.druid.catalog.NullMetadataCatalog;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.sql.calcite.table.DruidTable;

public interface CatalogResolver {
    public static final CatalogResolver NULL_RESOLVER = new NullCatalogResolver();

    public boolean ingestRequiresExistingTable();

    public MetadataCatalog getMetadataCatalog();

    public DruidTable resolveDatasource(String var1, DatasourceTable.PhysicalDatasourceMetadata var2);

    public Set<String> getTableNames(Set<String> var1);

    public static class NullCatalogResolver
    implements CatalogResolver {
        @Override
        public boolean ingestRequiresExistingTable() {
            return false;
        }

        @Override
        public MetadataCatalog getMetadataCatalog() {
            return NullMetadataCatalog.INSTANCE;
        }

        @Override
        public DruidTable resolveDatasource(String tableName, DatasourceTable.PhysicalDatasourceMetadata dsMetadata) {
            return dsMetadata == null ? null : new DatasourceTable(dsMetadata);
        }

        @Override
        public Set<String> getTableNames(Set<String> datasourceNames) {
            return datasourceNames;
        }
    }
}

