/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.segment.column.ColumnType;

public class RangeValue
implements Comparable<RangeValue> {
    @Nullable
    private final Object value;
    private final ColumnType matchValueType;
    private final Comparator<Object> matchValueTypeComparator;

    public RangeValue(@Nullable Object value, ColumnType matchValueType) {
        this.value = value;
        this.matchValueType = matchValueType;
        this.matchValueTypeComparator = matchValueType.getNullableStrategy();
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Override
    public int compareTo(RangeValue o) {
        if (!this.matchValueType.equals((Object)o.matchValueType)) {
            throw new ISE("Comparator mismatch: [%s] and [%s]", new Object[]{this.matchValueType, o.matchValueType});
        }
        return this.matchValueTypeComparator.compare(this.value, o.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RangeValue that = (RangeValue)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.matchValueType, that.matchValueType);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.matchValueType);
    }

    public String toString() {
        return "RangeValue{value=" + this.value + ", matchValueType=" + this.matchValueType + "}";
    }
}

