/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.http;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.ErrorResponse;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.rpc.HttpResponseException;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;

public class ServletResourceUtils {
    private static final Logger log = new Logger(ServletResourceUtils.class);

    public static Map<String, String> sanitizeException(@Nullable Throwable t) {
        return ImmutableMap.of((Object)"error", (Object)(t == null ? "null" : (t.getMessage() == null ? t.toString() : t.getMessage())));
    }

    public static Map<String, String> jsonize(String msgFormat, Object ... args) {
        return ImmutableMap.of((Object)"error", (Object)StringUtils.nonStrictFormat((String)msgFormat, (Object[])args));
    }

    public static Response buildErrorResponseFrom(DruidException e) {
        return Response.status((int)e.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorResponse(e)).build();
    }

    public static Response buildUpdateResponse(Supplier<Boolean> updateOperation) {
        return ServletResourceUtils.buildReadResponse(() -> Map.of("success", (Boolean)updateOperation.get()));
    }

    public static <T> Response buildReadResponse(Supplier<T> readOperation) {
        try {
            return Response.ok(readOperation.get()).build();
        }
        catch (DruidException e) {
            log.error((Throwable)e, "Error executing HTTP request", new Object[0]);
            return ServletResourceUtils.buildErrorResponseFrom(e);
        }
        catch (Exception e) {
            log.error((Throwable)e, "Error executing HTTP request", new Object[0]);
            return ServletResourceUtils.buildErrorResponseFrom(InternalServerError.exception((Throwable)Throwables.getRootCause((Throwable)e), (String)"Unknown error occurred", (Object[])new Object[0]));
        }
    }

    public static <T> T getDefaultValueIfCauseIs404ElseThrow(Exception e, Supplier<T> defaultValueSupplier) {
        HttpResponseException httpException;
        Throwable rootCause = Throwables.getRootCause((Throwable)e);
        if (rootCause instanceof HttpResponseException && (httpException = (HttpResponseException)rootCause).getResponse().getStatus().equals((Object)HttpResponseStatus.NOT_FOUND)) {
            return defaultValueSupplier.get();
        }
        throw new RuntimeException(e);
    }
}

