/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.rpc;

import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscovery;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.rpc.ServiceLocation;
import org.apache.druid.rpc.ServiceLocations;
import org.apache.druid.rpc.ServiceLocator;

public class DiscoveryServiceLocator
implements ServiceLocator {
    private final DruidNodeDiscoveryProvider discoveryProvider;
    private final NodeRole nodeRole;
    private final DruidNodeDiscovery.Listener listener;
    @GuardedBy(value="this")
    private boolean started = false;
    @GuardedBy(value="this")
    private boolean initialized = false;
    @GuardedBy(value="this")
    private boolean closed = false;
    @GuardedBy(value="this")
    private final Set<ServiceLocation> locations = new HashSet<ServiceLocation>();
    @GuardedBy(value="this")
    private SettableFuture<ServiceLocations> pendingFuture = null;
    @GuardedBy(value="this")
    private DruidNodeDiscovery discovery = null;

    public DiscoveryServiceLocator(DruidNodeDiscoveryProvider discoveryProvider, NodeRole nodeRole) {
        this.discoveryProvider = discoveryProvider;
        this.nodeRole = nodeRole;
        this.listener = new Listener();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListenableFuture<ServiceLocations> locate() {
        DiscoveryServiceLocator discoveryServiceLocator = this;
        synchronized (discoveryServiceLocator) {
            if (this.closed) {
                return Futures.immediateFuture((Object)ServiceLocations.closed());
            }
            if (this.initialized) {
                return Futures.immediateFuture((Object)ServiceLocations.forLocations((Set<ServiceLocation>)ImmutableSet.copyOf(this.locations)));
            }
            if (this.pendingFuture == null) {
                this.pendingFuture = SettableFuture.create();
            }
            return Futures.nonCancellationPropagating(this.pendingFuture);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        DiscoveryServiceLocator discoveryServiceLocator = this;
        synchronized (discoveryServiceLocator) {
            if (this.started || this.closed) {
                throw new ISE("Cannot start once already started or closed", new Object[0]);
            }
            this.started = true;
            this.discovery = this.discoveryProvider.getForNodeRole(this.nodeRole);
            this.discovery.registerListener(this.listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @LifecycleStop
    public void close() {
        DiscoveryServiceLocator discoveryServiceLocator = this;
        synchronized (discoveryServiceLocator) {
            if (this.started && !this.closed) {
                if (this.discovery != null) {
                    this.discovery.removeListener(this.listener);
                }
                if (this.pendingFuture != null) {
                    this.pendingFuture.set((Object)ServiceLocations.closed());
                    this.pendingFuture = null;
                }
                this.closed = true;
            }
        }
    }

    private class Listener
    implements DruidNodeDiscovery.Listener {
        private Listener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodesAdded(Collection<DiscoveryDruidNode> nodes) {
            DiscoveryServiceLocator discoveryServiceLocator = DiscoveryServiceLocator.this;
            synchronized (discoveryServiceLocator) {
                for (DiscoveryDruidNode node : nodes) {
                    DiscoveryServiceLocator.this.locations.add(ServiceLocation.fromDruidNode(node.getDruidNode()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodesRemoved(Collection<DiscoveryDruidNode> nodes) {
            DiscoveryServiceLocator discoveryServiceLocator = DiscoveryServiceLocator.this;
            synchronized (discoveryServiceLocator) {
                for (DiscoveryDruidNode node : nodes) {
                    DiscoveryServiceLocator.this.locations.remove(ServiceLocation.fromDruidNode(node.getDruidNode()));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nodeViewInitialized() {
            DiscoveryServiceLocator discoveryServiceLocator = DiscoveryServiceLocator.this;
            synchronized (discoveryServiceLocator) {
                DiscoveryServiceLocator.this.initialized = true;
                if (DiscoveryServiceLocator.this.pendingFuture != null) {
                    DiscoveryServiceLocator.this.pendingFuture.set((Object)ServiceLocations.forLocations((Set<ServiceLocation>)ImmutableSet.copyOf(DiscoveryServiceLocator.this.locations)));
                    DiscoveryServiceLocator.this.pendingFuture = null;
                }
            }
        }

        @Override
        public void nodeViewInitializedTimedOut() {
            this.nodeViewInitialized();
        }
    }
}

