/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.metadata.segment;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.java.util.common.Intervals;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.metadata.MetadataStorageTablesConfig;
import org.apache.druid.metadata.PendingSegmentRecord;
import org.apache.druid.metadata.SQLMetadataConnector;
import org.apache.druid.metadata.SqlSegmentsMetadataQuery;
import org.apache.druid.metadata.segment.SegmentMetadataTransaction;
import org.apache.druid.segment.SegmentUtils;
import org.apache.druid.segment.realtime.appenderator.SegmentIdWithShardSpec;
import org.apache.druid.server.http.DataSegmentPlus;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.PreparedBatchPart;
import org.skife.jdbi.v2.TransactionStatus;
import org.skife.jdbi.v2.Update;

class SqlSegmentMetadataTransaction
implements SegmentMetadataTransaction {
    private static final int MAX_SEGMENTS_PER_BATCH = 100;
    private final String dataSource;
    private final Handle handle;
    private final TransactionStatus transactionStatus;
    private final SQLMetadataConnector connector;
    private final MetadataStorageTablesConfig dbTables;
    private final ObjectMapper jsonMapper;
    private final SqlSegmentsMetadataQuery query;

    SqlSegmentMetadataTransaction(String dataSource, Handle handle, TransactionStatus transactionStatus, SQLMetadataConnector connector, MetadataStorageTablesConfig dbTables, ObjectMapper jsonMapper) {
        this.dataSource = dataSource;
        this.handle = handle;
        this.connector = connector;
        this.dbTables = dbTables;
        this.jsonMapper = jsonMapper;
        this.transactionStatus = transactionStatus;
        this.query = SqlSegmentsMetadataQuery.forHandle(handle, connector, dbTables, jsonMapper);
    }

    @Override
    public Handle getHandle() {
        return this.handle;
    }

    @Override
    public SqlSegmentsMetadataQuery noCacheSql() {
        return this.query;
    }

    @Override
    public void setRollbackOnly() {
        this.transactionStatus.setRollbackOnly();
    }

    @Override
    public void close() {
    }

    @Override
    public Set<String> findExistingSegmentIds(Set<SegmentId> segmentIds) {
        HashSet<String> existingSegmentIds = new HashSet<String>();
        String sql = "SELECT id FROM %s WHERE id in (%s)";
        List partitions = Lists.partition(new ArrayList<SegmentId>(segmentIds), (int)100);
        for (List segmentIdList : partitions) {
            String segmentIdsCsv = segmentIdList.stream().map(id -> "'" + StringUtils.escapeSql((String)id.toString()) + "'").collect(Collectors.joining(","));
            existingSegmentIds.addAll(this.handle.createQuery(StringUtils.format((String)"SELECT id FROM %s WHERE id in (%s)", (Object[])new Object[]{this.dbTables.getSegmentsTable(), segmentIdsCsv})).mapTo(String.class).list());
        }
        return existingSegmentIds;
    }

    @Override
    public Set<SegmentId> findUsedSegmentIdsOverlapping(Interval interval) {
        return this.query.retrieveUsedSegmentIds(this.dataSource, interval);
    }

    @Override
    public SegmentId findHighestUnusedSegmentId(Interval interval, String version) {
        return this.query.retrieveHighestUnusedSegmentId(this.dataSource, interval, version);
    }

    @Override
    public Set<DataSegment> findUsedSegmentsOverlappingAnyOf(List<Interval> intervals) {
        HashSet<DataSegment> hashSet;
        block8: {
            CloseableIterator<DataSegment> iterator = this.query.retrieveUsedSegments(this.dataSource, intervals);
            try {
                HashSet<DataSegment> segments = new HashSet<DataSegment>();
                iterator.forEachRemaining(segments::add);
                hashSet = segments;
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw InternalServerError.exception((Throwable)e, (String)"Error while fetching segments overlapping intervals[%s].", (Object[])new Object[]{intervals});
                }
            }
            iterator.close();
        }
        return hashSet;
    }

    @Override
    public List<DataSegmentPlus> findUsedSegments(Set<SegmentId> segmentIds) {
        return this.query.retrieveSegmentsById(this.dataSource, segmentIds);
    }

    @Override
    public Set<DataSegmentPlus> findUsedSegmentsPlusOverlappingAnyOf(List<Interval> intervals) {
        ImmutableSet immutableSet;
        block8: {
            CloseableIterator<DataSegmentPlus> iterator = this.query.retrieveUsedSegmentsPlus(this.dataSource, intervals);
            try {
                immutableSet = ImmutableSet.copyOf(iterator);
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw DruidException.defensive((Throwable)e, (String)"Error while retrieving used segments", (Object[])new Object[0]);
                }
            }
            iterator.close();
        }
        return immutableSet;
    }

    @Override
    public DataSegment findSegment(SegmentId segmentId) {
        return this.query.retrieveSegmentForId(segmentId);
    }

    @Override
    public DataSegment findUsedSegment(SegmentId segmentId) {
        return this.query.retrieveUsedSegmentForId(segmentId);
    }

    @Override
    public List<DataSegmentPlus> findSegments(Set<SegmentId> segmentIds) {
        return this.query.retrieveSegmentsById(this.dataSource, segmentIds);
    }

    @Override
    public List<DataSegmentPlus> findSegmentsWithSchema(Set<SegmentId> segmentIds) {
        return this.query.retrieveSegmentsWithSchemaById(this.dataSource, segmentIds);
    }

    @Override
    public List<DataSegment> findUnusedSegments(Interval interval, @Nullable List<String> versions, @Nullable Integer limit, @Nullable DateTime maxUpdatedTime) {
        ImmutableList immutableList;
        block8: {
            CloseableIterator<DataSegment> iterator = this.query.retrieveUnusedSegments(this.dataSource, List.of(interval), versions, limit, null, null, maxUpdatedTime);
            try {
                immutableList = ImmutableList.copyOf(iterator);
                if (iterator == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (iterator != null) {
                        try {
                            iterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw DruidException.defensive((Throwable)e, (String)"Error while reading unused segments", (Object[])new Object[0]);
                }
            }
            iterator.close();
        }
        return immutableList;
    }

    @Override
    public int insertSegments(Set<DataSegmentPlus> segments) {
        return this.insertSegmentsInBatches(this.dataSource, segments, "INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated, upgraded_from_segment_id) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated, :upgraded_from_segment_id)");
    }

    @Override
    public int insertSegmentsWithMetadata(Set<DataSegmentPlus> segments) {
        return this.insertSegmentsInBatches(this.dataSource, segments, "INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, partitioned, version, used, payload, used_status_last_updated, upgraded_from_segment_id, schema_fingerprint, num_rows) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload, :used_status_last_updated, :upgraded_from_segment_id, :schema_fingerprint, :num_rows)");
    }

    @Override
    public boolean markSegmentAsUnused(SegmentId segmentId, DateTime updateTime) {
        return this.query.markSegmentsAsUnused(Set.of(segmentId), updateTime) > 0;
    }

    @Override
    public int markSegmentsAsUnused(Set<SegmentId> segmentIds, DateTime updateTime) {
        return this.query.markSegmentsAsUnused(segmentIds, updateTime);
    }

    @Override
    public int markAllSegmentsAsUnused(DateTime updateTime) {
        return this.query.markSegmentsUnused(this.dataSource, Intervals.ETERNITY, null, updateTime);
    }

    @Override
    public int markSegmentsWithinIntervalAsUnused(Interval interval, @Nullable List<String> versions, DateTime updateTime) {
        return this.query.markSegmentsUnused(this.dataSource, interval, versions, updateTime);
    }

    @Override
    public int deleteSegments(Set<SegmentId> segmentsIdsToDelete) {
        String deleteSql = StringUtils.format((String)"DELETE from %s WHERE id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()});
        PreparedBatch batch = this.handle.prepareBatch(deleteSql);
        for (SegmentId id : segmentsIdsToDelete) {
            ((PreparedBatch)batch.bind("id", id.toString())).add();
        }
        int[] deletedRows = batch.execute();
        return Arrays.stream(deletedRows).sum();
    }

    @Override
    public boolean updateSegmentPayload(DataSegment segment) {
        String sql = "UPDATE %s SET payload = :payload WHERE id = :id";
        int updatedCount = ((Update)((Update)this.handle.createStatement(StringUtils.format((String)"UPDATE %s SET payload = :payload WHERE id = :id", (Object[])new Object[]{this.dbTables.getSegmentsTable()})).bind("id", segment.getId().toString())).bind("payload", this.getJsonBytes(segment))).execute();
        return updatedCount > 0;
    }

    @Override
    public List<SegmentIdWithShardSpec> findPendingSegmentIds(String sequenceName, String sequencePreviousId) {
        return this.query.retrievePendingSegmentIds(this.dataSource, sequenceName, sequencePreviousId);
    }

    @Override
    public List<SegmentIdWithShardSpec> findPendingSegmentIdsWithExactInterval(String sequenceName, Interval interval) {
        return this.query.retrievePendingSegmentIdsWithExactInterval(this.dataSource, sequenceName, interval);
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegmentsOverlapping(Interval interval) {
        return this.query.retrievePendingSegmentsOverlappingInterval(this.dataSource, interval);
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegmentsWithExactInterval(Interval interval) {
        return this.query.retrievePendingSegmentsWithExactInterval(this.dataSource, interval);
    }

    @Override
    public List<PendingSegmentRecord> findPendingSegments(String taskAllocatorId) {
        return this.query.retrievePendingSegmentsForTaskAllocatorId(this.dataSource, taskAllocatorId);
    }

    @Override
    public boolean insertPendingSegment(PendingSegmentRecord pendingSegment, boolean skipSegmentLineageCheck) {
        SegmentIdWithShardSpec segmentId = pendingSegment.getId();
        Interval interval = segmentId.getInterval();
        int updatedCount = ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)this.handle.createStatement(this.getSqlToInsertPendingSegment()).bind("id", segmentId.toString())).bind("dataSource", this.dataSource)).bind("created_date", SqlSegmentMetadataTransaction.toNonNullString(pendingSegment.getCreatedDate()))).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("sequence_name", pendingSegment.getSequenceName())).bind("sequence_prev_id", pendingSegment.getSequencePrevId())).bind("sequence_name_prev_id_sha1", pendingSegment.computeSequenceNamePrevIdSha1(skipSegmentLineageCheck))).bind("payload", this.getJsonBytes(segmentId))).bind("task_allocator_id", pendingSegment.getTaskAllocatorId())).bind("upgraded_from_segment_id", pendingSegment.getUpgradedFromSegmentId())).execute();
        return updatedCount > 0;
    }

    @Override
    public int insertPendingSegments(List<PendingSegmentRecord> pendingSegments, boolean skipSegmentLineageCheck) {
        PreparedBatch insertBatch = this.handle.prepareBatch(this.getSqlToInsertPendingSegment());
        HashSet<SegmentIdWithShardSpec> processedSegmentIds = new HashSet<SegmentIdWithShardSpec>();
        for (PendingSegmentRecord pendingSegment : pendingSegments) {
            SegmentIdWithShardSpec segmentId = pendingSegment.getId();
            if (processedSegmentIds.contains(segmentId)) continue;
            Interval interval = segmentId.getInterval();
            ((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)insertBatch.add().bind("id", segmentId.toString())).bind("dataSource", this.dataSource)).bind("created_date", SqlSegmentMetadataTransaction.toNonNullString(pendingSegment.getCreatedDate()))).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).bind("sequence_name", pendingSegment.getSequenceName())).bind("sequence_prev_id", pendingSegment.getSequencePrevId())).bind("sequence_name_prev_id_sha1", pendingSegment.computeSequenceNamePrevIdSha1(skipSegmentLineageCheck))).bind("payload", this.getJsonBytes(segmentId))).bind("task_allocator_id", pendingSegment.getTaskAllocatorId())).bind("upgraded_from_segment_id", pendingSegment.getUpgradedFromSegmentId());
            processedSegmentIds.add(segmentId);
        }
        int[] updated = insertBatch.execute();
        return Arrays.stream(updated).sum();
    }

    @Override
    public int deleteAllPendingSegments() {
        String sql = StringUtils.format((String)"DELETE FROM %s WHERE datasource = :dataSource", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        return ((Update)this.handle.createStatement(sql).bind("dataSource", this.dataSource)).execute();
    }

    @Override
    public int deletePendingSegments(Set<String> segmentIdsToDelete) {
        if (segmentIdsToDelete.isEmpty()) {
            return 0;
        }
        List pendingSegmentIdBatches = Lists.partition(List.copyOf(segmentIdsToDelete), (int)100);
        int numDeletedPendingSegments = 0;
        for (List pendingSegmentIdBatch : pendingSegmentIdBatches) {
            numDeletedPendingSegments += this.deletePendingSegmentsBatch(pendingSegmentIdBatch);
        }
        return numDeletedPendingSegments;
    }

    @Override
    public int deletePendingSegments(String taskAllocatorId) {
        String sql = StringUtils.format((String)"DELETE FROM %s WHERE dataSource = :dataSource AND task_allocator_id = :task_allocator_id", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        return ((Update)((Update)this.handle.createStatement(sql).bind("dataSource", this.dataSource)).bind("task_allocator_id", taskAllocatorId)).execute();
    }

    @Override
    public int deletePendingSegmentsCreatedIn(Interval interval) {
        String sql = StringUtils.format((String)"DELETE FROM %s WHERE datasource = :dataSource AND created_date >= :start AND created_date < :end", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable()});
        return ((Update)((Update)((Update)this.handle.createStatement(sql).bind("dataSource", this.dataSource)).bind("start", interval.getStart().toString())).bind("end", interval.getEnd().toString())).execute();
    }

    private int deletePendingSegmentsBatch(List<String> segmentIdsToDelete) {
        Update query = (Update)this.handle.createStatement(StringUtils.format((String)"DELETE FROM %s WHERE dataSource = :dataSource %s", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), SqlSegmentsMetadataQuery.getParameterizedInConditionForColumn("id", segmentIdsToDelete)})).bind("dataSource", this.dataSource);
        SqlSegmentsMetadataQuery.bindColumnValuesToQueryWithInCondition("id", segmentIdsToDelete, query);
        return query.execute();
    }

    private int insertSegmentsInBatches(String dataSource, Set<DataSegmentPlus> segments, String insertSql) {
        List partitionedSegments = Lists.partition(new ArrayList<DataSegmentPlus>(segments), (int)100);
        boolean persistAdditionalMetadata = insertSql.contains(":schema_fingerprint");
        PreparedBatch batch = this.handle.prepareBatch(StringUtils.format((String)insertSql, (Object[])new Object[]{this.dbTables.getSegmentsTable(), this.connector.getQuoteString()}));
        int numInsertedSegments = 0;
        for (List partition : partitionedSegments) {
            for (DataSegmentPlus segmentPlus : partition) {
                DataSegment segment = segmentPlus.getDataSegment();
                PreparedBatchPart preparedBatchPart = (PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)((PreparedBatchPart)batch.add().bind("id", segment.getId().toString())).bind("dataSource", dataSource)).bind("created_date", SqlSegmentMetadataTransaction.toNonNullString(segmentPlus.getCreatedDate()))).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", true)).bind("version", segment.getVersion())).bind("used", Boolean.TRUE.equals(segmentPlus.getUsed()))).bind("payload", this.getJsonBytes(segment))).bind("used_status_last_updated", SqlSegmentMetadataTransaction.toNonNullString(segmentPlus.getUsedStatusLastUpdatedDate()))).bind("upgraded_from_segment_id", segmentPlus.getUpgradedFromSegmentId());
                if (!persistAdditionalMetadata) continue;
                ((PreparedBatchPart)preparedBatchPart.bind("num_rows", segmentPlus.getNumRows())).bind("schema_fingerprint", segmentPlus.getSchemaFingerprint());
            }
            int[] affectedRows = batch.execute();
            ArrayList<DataSegment> failedInserts = new ArrayList<DataSegment>();
            for (int i = 0; i < partition.size(); ++i) {
                if (affectedRows[i] == 1) {
                    ++numInsertedSegments;
                    continue;
                }
                failedInserts.add(((DataSegmentPlus)partition.get(i)).getDataSegment());
            }
            if (failedInserts.isEmpty()) continue;
            throw InternalServerError.exception((String)"Failed to insert segments in metadata store: %s", (Object[])new Object[]{SegmentUtils.commaSeparatedIdentifiers(failedInserts)});
        }
        return numInsertedSegments;
    }

    private String getSqlToInsertPendingSegment() {
        return StringUtils.format((String)"INSERT INTO %1$s (id, dataSource, created_date, start, %2$send%2$s, sequence_name, sequence_prev_id, sequence_name_prev_id_sha1, payload, task_allocator_id, upgraded_from_segment_id) VALUES (:id, :dataSource, :created_date, :start, :end, :sequence_name, :sequence_prev_id, :sequence_name_prev_id_sha1, :payload, :task_allocator_id, :upgraded_from_segment_id)", (Object[])new Object[]{this.dbTables.getPendingSegmentsTable(), this.connector.getQuoteString()});
    }

    private static String toNonNullString(DateTime date) {
        if (date == null) {
            throw DruidException.defensive((String)"Created date cannot be null", (Object[])new Object[0]);
        }
        return date.toString();
    }

    private <T> byte[] getJsonBytes(T object) {
        try {
            return this.jsonMapper.writeValueAsBytes(object);
        }
        catch (JsonProcessingException e) {
            throw InternalServerError.exception((String)"Could not serialize object[%s]", (Object[])new Object[]{object});
        }
    }
}

