/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join.filter;

import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.druid.query.filter.Filter;

public class JoinFilterAnalysis {
    private final boolean retainAfterJoin;
    private final Filter originalFilter;
    private final Optional<Filter> pushDownFilter;

    public JoinFilterAnalysis(boolean retainAfterJoin, Filter originalFilter, @Nullable Filter pushDownFilter) {
        this.retainAfterJoin = retainAfterJoin;
        this.originalFilter = originalFilter;
        this.pushDownFilter = pushDownFilter == null ? Optional.empty() : Optional.of(pushDownFilter);
    }

    public boolean isCanPushDown() {
        return this.pushDownFilter.isPresent();
    }

    public boolean isRetainAfterJoin() {
        return this.retainAfterJoin;
    }

    public Filter getOriginalFilter() {
        return this.originalFilter;
    }

    public Optional<Filter> getPushDownFilter() {
        return this.pushDownFilter;
    }

    public static JoinFilterAnalysis createNoPushdownFilterAnalysis(Filter originalFilter) {
        return new JoinFilterAnalysis(true, originalFilter, null);
    }
}

