/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.metadata.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.metadata.metadata.ColumnAnalysis;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.timeline.SegmentId;
import org.joda.time.Interval;

public class SegmentAnalysis
implements Comparable<SegmentAnalysis> {
    private final String id;
    private final List<Interval> interval;
    private final LinkedHashMap<String, ColumnAnalysis> columns;
    private final long size;
    private final long numRows;
    private final Map<String, AggregatorFactory> aggregators;
    private final Map<String, AggregateProjectionMetadata> projections;
    private final TimestampSpec timestampSpec;
    private final Granularity queryGranularity;
    private final Boolean rollup;

    @JsonCreator
    public SegmentAnalysis(@JsonProperty(value="id") String id, @JsonProperty(value="intervals") List<Interval> interval, @JsonProperty(value="columns") LinkedHashMap<String, ColumnAnalysis> columns, @JsonProperty(value="size") long size, @JsonProperty(value="numRows") long numRows, @JsonProperty(value="aggregators") Map<String, AggregatorFactory> aggregators, @JsonProperty(value="projections") Map<String, AggregateProjectionMetadata> projections, @JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="queryGranularity") Granularity queryGranularity, @JsonProperty(value="rollup") Boolean rollup) {
        this.id = id;
        this.interval = interval;
        this.columns = columns;
        this.size = size;
        this.numRows = numRows;
        this.aggregators = aggregators;
        this.projections = projections;
        this.timestampSpec = timestampSpec;
        this.queryGranularity = queryGranularity;
        this.rollup = rollup;
    }

    @JsonProperty
    public String getId() {
        return this.id;
    }

    @JsonProperty
    public List<Interval> getIntervals() {
        return this.interval;
    }

    @JsonProperty
    public LinkedHashMap<String, ColumnAnalysis> getColumns() {
        return this.columns;
    }

    @JsonProperty
    public long getSize() {
        return this.size;
    }

    @JsonProperty
    public long getNumRows() {
        return this.numRows;
    }

    @JsonProperty
    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    @JsonProperty
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty
    public Boolean isRollup() {
        return this.rollup;
    }

    @JsonProperty
    public Map<String, AggregatorFactory> getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public Map<String, AggregateProjectionMetadata> getProjections() {
        return this.projections;
    }

    public String toString() {
        return "SegmentAnalysis{id='" + this.id + "', interval=" + this.interval + ", columns=" + this.columns + ", size=" + this.size + ", numRows=" + this.numRows + ", aggregators=" + this.aggregators + ", projections=" + this.projections + ", timestampSpec=" + this.timestampSpec + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SegmentAnalysis that = (SegmentAnalysis)o;
        return this.size == that.size && this.numRows == that.numRows && Objects.equals(this.rollup, that.rollup) && Objects.equals(this.id, that.id) && Objects.equals(this.interval, that.interval) && Objects.equals(this.columns, that.columns) && Objects.equals(this.aggregators, that.aggregators) && Objects.equals(this.projections, that.projections) && Objects.equals(this.timestampSpec, that.timestampSpec) && Objects.equals(this.queryGranularity, that.queryGranularity);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.interval, this.columns, this.size, this.numRows, this.aggregators, this.projections, this.timestampSpec, this.queryGranularity, this.rollup);
    }

    @Override
    public int compareTo(SegmentAnalysis rhs) {
        return this.id.compareTo(rhs.getId());
    }

    public static class Builder {
        private final String segmentId;
        private final LinkedHashMap<String, ColumnAnalysis> columns = new LinkedHashMap();
        private final Map<String, AggregatorFactory> aggregators = new LinkedHashMap<String, AggregatorFactory>();
        private final Map<String, AggregateProjectionMetadata> projections = new LinkedHashMap<String, AggregateProjectionMetadata>();
        private List<Interval> intervals = null;
        private Optional<Integer> size = Optional.empty();
        private Optional<Integer> numRows = Optional.empty();
        private Optional<Boolean> rollup = Optional.empty();

        public Builder(String segmentId) {
            this.segmentId = segmentId;
        }

        public Builder(SegmentId segmentId) {
            this.segmentId = segmentId.toString();
        }

        public Builder size(int size) {
            if (!this.size.isEmpty()) {
                throw new IllegalStateException("Size is already set: " + this.size.get());
            }
            this.size = Optional.of(size);
            return this;
        }

        public Builder numRows(int numRows) {
            if (!this.numRows.isEmpty()) {
                throw new IllegalStateException("NumRows is already set: " + this.numRows.get());
            }
            this.numRows = Optional.of(numRows);
            return this;
        }

        public Builder rollup(boolean rollup) {
            if (!this.rollup.isEmpty()) {
                throw new IllegalStateException("Rollup is already set: " + this.rollup.get());
            }
            this.rollup = Optional.of(rollup);
            return this;
        }

        public Builder interval(Interval interval) {
            if (this.intervals == null) {
                this.intervals = new ArrayList<Interval>();
            }
            this.intervals.add(interval);
            return this;
        }

        public Builder column(String columnName, ColumnAnalysis columnAnalysis) {
            this.columns.put(columnName, columnAnalysis);
            return this;
        }

        public Builder aggregator(String name, AggregatorFactory aggregatorFactory) {
            this.aggregators.put(name, aggregatorFactory);
            return this;
        }

        public Builder projection(String name, AggregateProjectionMetadata projection) {
            this.projections.put(name, projection);
            return this;
        }

        public SegmentAnalysis build() {
            return new SegmentAnalysis(this.segmentId, this.intervals, this.columns, this.size.orElse(0).intValue(), this.numRows.orElse(0).intValue(), this.aggregators.isEmpty() ? null : this.aggregators, this.projections.isEmpty() ? null : this.projections, null, null, this.rollup.orElse(null));
        }
    }
}

