/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.Query;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.column.ColumnType;

public interface CacheStrategy<T, CacheType, QueryType extends Query<T>> {
    @Deprecated
    default public boolean isCacheable(QueryType ignoredQuery, boolean ignoredWillMergeRunners) {
        return false;
    }

    default public boolean isCacheable(QueryType query, boolean willMergeRunners, boolean segmentLevel) {
        return this.isCacheable(query, willMergeRunners);
    }

    public byte[] computeCacheKey(QueryType var1);

    public byte[] computeResultLevelCacheKey(QueryType var1);

    public TypeReference<CacheType> getCacheObjectClazz();

    public Function<T, CacheType> prepareForCache(boolean var1);

    public Function<CacheType, T> pullFromCache(boolean var1);

    default public Function<T, CacheType> prepareForSegmentLevelCache() {
        return this.prepareForCache(false);
    }

    default public Function<CacheType, T> pullFromSegmentLevelCache() {
        return this.pullFromCache(false);
    }

    public static void fetchAggregatorsFromCache(List<AggregatorFactory> aggregators, Iterator<Object> resultIter, boolean isResultLevelCache, AddToResultFunction addToResultFunction) {
        for (int i = 0; i < aggregators.size(); ++i) {
            boolean needsDeserialize;
            AggregatorFactory aggregator = aggregators.get(i);
            if (!resultIter.hasNext()) {
                throw new ISE("Ran out of objects while reading aggregators from cache!", new Object[0]);
            }
            ColumnType resultType = aggregator.getResultType();
            ColumnType intermediateType = aggregator.getIntermediateType();
            boolean bl = needsDeserialize = !isResultLevelCache || resultType.equals(intermediateType);
            if (needsDeserialize) {
                addToResultFunction.apply(aggregator.getName(), i, aggregator.deserialize(resultIter.next()));
                continue;
            }
            addToResultFunction.apply(aggregator.getName(), i, resultIter.next());
        }
    }

    public static interface AddToResultFunction {
        public void apply(String var1, int var2, Object var3);
    }
}

