/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.Exprs;
import org.apache.druid.math.expr.vector.BivariateFunctionVectorProcessorFactory;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.segment.column.Types;

public abstract class VectorMathBivariateDoubleProcessorFactory
implements BivariateFunctionVectorProcessorFactory {
    @Override
    public <T> ExprVectorProcessor<T> asProcessor(Expr.VectorInputBindingInspector inspector, Expr left, Expr right) {
        ExpressionType leftType = left.getOutputType(inspector);
        ExpressionType rightType = right.getOutputType(inspector);
        ExprVectorProcessor<double[]> processor = null;
        if (Types.is(leftType, ExprType.LONG)) {
            if (Types.is(rightType, ExprType.LONG)) {
                processor = this.longsProcessor(inspector, left, right);
            } else if (Types.isNullOr(rightType, ExprType.DOUBLE)) {
                processor = this.longDoubleProcessor(inspector, left, right);
            }
        } else if (Types.is(leftType, ExprType.DOUBLE)) {
            if (Types.is(rightType, ExprType.LONG)) {
                processor = this.doubleLongProcessor(inspector, left, right);
            } else if (Types.isNullOr(rightType, ExprType.DOUBLE)) {
                processor = this.doublesProcessor(inspector, left, right);
            }
        } else if (leftType == null) {
            if (Types.is(rightType, ExprType.LONG)) {
                processor = this.doubleLongProcessor(inspector, left, right);
            } else if (Types.isNullOr(rightType, ExprType.DOUBLE)) {
                processor = this.doublesProcessor(inspector, left, right);
            }
        } else {
            processor = this.doublesProcessor(inspector, left, right);
        }
        if (processor == null) {
            throw Exprs.cannotVectorize();
        }
        return processor;
    }

    public abstract ExprVectorProcessor<double[]> longsProcessor(Expr.VectorInputBindingInspector var1, Expr var2, Expr var3);

    public abstract ExprVectorProcessor<double[]> longDoubleProcessor(Expr.VectorInputBindingInspector var1, Expr var2, Expr var3);

    public abstract ExprVectorProcessor<double[]> doubleLongProcessor(Expr.VectorInputBindingInspector var1, Expr var2, Expr var3);

    public abstract ExprVectorProcessor<double[]> doublesProcessor(Expr.VectorInputBindingInspector var1, Expr var2, Expr var3);
}

