/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import java.math.BigInteger;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.math.expr.BigIntegerExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.UnaryExpr;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorMathProcessors;

class UnaryMinusExpr
extends UnaryExpr {
    UnaryMinusExpr(String op, Expr expr) {
        super(op, expr);
    }

    @Override
    UnaryExpr copy(Expr expr) {
        return new UnaryMinusExpr(this.op, expr);
    }

    @Override
    public ExprEval eval(Expr.ObjectBinding bindings) {
        if (this.expr instanceof BigIntegerExpr) {
            return ExprEval.of(((BigInteger)this.expr.getLiteralValue()).multiply(BigInteger.valueOf(-1L)).longValueExact());
        }
        ExprEval ret = this.expr.eval(bindings);
        if (ret.value() == null) {
            return ExprEval.ofType(ret.type(), null);
        }
        if (ret.type().is(ExprType.LONG)) {
            return ExprEval.of(-ret.asLong());
        }
        if (ret.type().is(ExprType.DOUBLE)) {
            return ExprEval.of(-ret.asDouble());
        }
        throw new IAE("unsupported type " + ret.type(), new Object[0]);
    }

    @Override
    public boolean canVectorize(Expr.InputBindingInspector inspector) {
        return inspector.areNumeric(this.expr) && this.expr.canVectorize(inspector);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorMathProcessors.negate().asProcessor(inspector, this.expr);
    }
}

