/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.io.Closeable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.collections.ReferenceCountingResourceHolder;
import org.apache.druid.collections.ResourceHolder;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.msq.counters.ChannelCounters;
import org.apache.druid.msq.querykit.DataSegmentProvider;
import org.apache.druid.segment.CompleteSegment;
import org.apache.druid.segment.PhysicalSegmentInspector;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.loading.SegmentCacheManager;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.utils.CloseableUtils;

public class TaskDataSegmentProvider
implements DataSegmentProvider {
    private final CoordinatorClient coordinatorClient;
    private final SegmentCacheManager segmentCacheManager;
    private final ConcurrentHashMap<SegmentId, SegmentHolder> holders;

    public TaskDataSegmentProvider(CoordinatorClient coordinatorClient, SegmentCacheManager segmentCacheManager) {
        this.coordinatorClient = coordinatorClient;
        this.segmentCacheManager = segmentCacheManager;
        this.holders = new ConcurrentHashMap();
    }

    @Override
    public Supplier<ResourceHolder<CompleteSegment>> fetchSegment(SegmentId segmentId, ChannelCounters channelCounters, boolean isReindex) {
        return () -> {
            ResourceHolder<CompleteSegment> holder = null;
            while (holder == null) {
                holder = this.holders.computeIfAbsent(segmentId, k -> new SegmentHolder(() -> this.fetchSegmentInternal(segmentId, channelCounters, isReindex), () -> this.holders.remove(segmentId))).get();
            }
            return holder;
        };
    }

    private ReferenceCountingResourceHolder<CompleteSegment> fetchSegmentInternal(SegmentId segmentId, ChannelCounters channelCounters, boolean isReindex) {
        DataSegment dataSegment;
        try {
            dataSegment = (DataSegment)FutureUtils.get((ListenableFuture)this.coordinatorClient.fetchSegment(segmentId.getDataSource(), segmentId.toString(), !isReindex), (boolean)true);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RE((Throwable)e, "Failed to fetch segment details from Coordinator for [%s]", new Object[]{segmentId});
        }
        Closer closer = Closer.create();
        try {
            this.segmentCacheManager.load(dataSegment);
            Segment segment = (Segment)closer.register((Closeable)((Segment)this.segmentCacheManager.acquireCachedSegment(dataSegment).orElseThrow()));
            closer.register(() -> this.segmentCacheManager.drop(dataSegment));
            PhysicalSegmentInspector inspector = (PhysicalSegmentInspector)segment.as(PhysicalSegmentInspector.class);
            int numRows = inspector == null ? 0 : inspector.getNumRows();
            long size = dataSegment.getSize();
            closer.register(() -> channelCounters.addFile(numRows, size));
            return new ReferenceCountingResourceHolder((Object)new CompleteSegment(dataSegment, segment), (Closeable)closer);
        }
        catch (SegmentLoadingException e) {
            throw CloseableUtils.closeInCatch((Throwable)new RE((Throwable)e, "Failed to download segment [%s]", new Object[]{segmentId}), (Closeable)closer);
        }
    }

    private static class SegmentHolder
    implements Supplier<ResourceHolder<CompleteSegment>> {
        private final Supplier<ResourceHolder<CompleteSegment>> holderSupplier;
        private final Closeable cleanupFn;
        @GuardedBy(value="this")
        private ReferenceCountingResourceHolder<CompleteSegment> holder;
        @GuardedBy(value="this")
        private boolean closing;
        @GuardedBy(value="this")
        private boolean closed;

        public SegmentHolder(Supplier<ResourceHolder<CompleteSegment>> holderSupplier, Closeable cleanupFn) {
            this.holderSupplier = holderSupplier;
            this.cleanupFn = cleanupFn;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @Nullable
        public ResourceHolder<CompleteSegment> get() {
            SegmentHolder segmentHolder = this;
            synchronized (segmentHolder) {
                if (this.closing) {
                    while (!this.closed) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new RuntimeException(e);
                        }
                    }
                    return null;
                }
                if (this.holder == null) {
                    ResourceHolder<CompleteSegment> segmentHolder2 = this.holderSupplier.get();
                    this.holder = new ReferenceCountingResourceHolder((Object)((CompleteSegment)segmentHolder2.get()), () -> {
                        SegmentHolder segmentHolder2 = this;
                        synchronized (segmentHolder2) {
                            CloseableUtils.closeAll(() -> {
                                SegmentHolder segmentHolder = this;
                                synchronized (segmentHolder) {
                                    this.closing = true;
                                }
                            }, (Closeable[])new Closeable[]{segmentHolder2, this.cleanupFn, () -> {
                                SegmentHolder segmentHolder = this;
                                synchronized (segmentHolder) {
                                    this.closed = true;
                                    this.notifyAll();
                                }
                            }});
                        }
                    });
                    ResourceHolder retVal = this.holder.increment();
                    this.holder.close();
                    return retVal;
                }
                try {
                    return this.holder.increment();
                }
                catch (IllegalStateException e) {
                    return null;
                }
            }
        }
    }
}

