/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.apache.druid.testing;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

import java.util.concurrent.TimeUnit;

/**
 * This Rule is based on {@link org.junit.rules.Timeout}, additionally deadlocked threads are detected.
 */
public final class DeadlockDetectingTimeout implements TestRule
{
  private final long timeout;
  private final TimeUnit timeoutUnit;

  public DeadlockDetectingTimeout(long timeout, TimeUnit timeoutUnit)
  {
    this.timeout = timeout;
    this.timeoutUnit = timeoutUnit;
  }

  @Override
  public Statement apply(Statement base, Description description)
  {
    return new DeadlockDetectingFailOnTimeout(timeout, timeoutUnit, base);
  }
}
