/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.ui.actions;

import org.apache.directory.studio.connection.core.Connection;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.core.BrowserCorePlugin;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IEntry;
import org.apache.directory.studio.ldapbrowser.ui.actions.Messages;
import org.apache.directory.studio.ldapbrowser.ui.dialogs.PasswordModifyExtendedOperationDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;

public class PasswordModifyExtendedOperationAction
extends BrowserAction {
    public void run() {
        ConnectionAndEntry connectionAndDn = this.getConnectionAndEntry();
        PasswordModifyExtendedOperationDialog passwordDialog = new PasswordModifyExtendedOperationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), connectionAndDn.connection, connectionAndDn.entry);
        passwordDialog.open();
    }

    private ConnectionAndEntry getConnectionAndEntry() {
        if (this.getSelectedEntries().length > 0) {
            return new ConnectionAndEntry(this.getSelectedEntries()[0].getBrowserConnection(), this.getSelectedEntries()[0]);
        }
        if (this.getSelectedSearchResults().length > 0) {
            return new ConnectionAndEntry(this.getSelectedSearchResults()[0].getEntry().getBrowserConnection(), this.getSelectedSearchResults()[0].getEntry());
        }
        if (this.getSelectedBookmarks().length > 0) {
            return new ConnectionAndEntry(this.getSelectedBookmarks()[0].getEntry().getBrowserConnection(), this.getSelectedBookmarks()[0].getEntry());
        }
        if (this.getSelectedConnections().length > 0) {
            Connection connection = this.getSelectedConnections()[0];
            IBrowserConnection browserConnection = BrowserCorePlugin.getDefault().getConnectionManager().getBrowserConnection(connection);
            return new ConnectionAndEntry(browserConnection, null);
        }
        if (this.getInput() instanceof IBrowserConnection) {
            return new ConnectionAndEntry((IBrowserConnection)this.getInput(), null);
        }
        return null;
    }

    public String getText() {
        return Messages.getString("PasswordModifyExtendedOperationAction.Text");
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getCommandId() {
        return null;
    }

    public boolean isEnabled() {
        return this.getConnectionAndEntry() != null && this.getConnectionAndEntry().connection != null && this.getConnectionAndEntry().connection.getRootDSE() != null && this.getConnectionAndEntry().connection.getRootDSE().isExtensionSupported("1.3.6.1.4.1.4203.1.11.1");
    }

    protected class ConnectionAndEntry {
        private IBrowserConnection connection;
        private IEntry entry;

        protected ConnectionAndEntry(IBrowserConnection connection, IEntry entry) {
            this.connection = connection;
            this.entry = entry;
        }
    }
}

