/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.valueeditors.objectclass;

import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.ldapbrowser.core.model.AttributeHierarchy;
import org.apache.directory.studio.ldapbrowser.core.model.IBrowserConnection;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.ldapbrowser.core.model.schema.Schema;
import org.apache.directory.studio.valueeditors.AbstractDialogStringValueEditor;
import org.apache.directory.studio.valueeditors.objectclass.Messages;
import org.apache.directory.studio.valueeditors.objectclass.ObjectClassDialog;
import org.eclipse.swt.widgets.Shell;

public class ObjectClassValueEditor
extends AbstractDialogStringValueEditor {
    public boolean openDialog(Shell shell) {
        ObjectClassValueEditorRawValueWrapper wrapper;
        ObjectClassDialog dialog;
        Object value = this.getValue();
        if (value instanceof ObjectClassValueEditorRawValueWrapper && (dialog = new ObjectClassDialog(shell, (wrapper = (ObjectClassValueEditorRawValueWrapper)value).schema, wrapper.objectClass)).open() == 0 && !"".equals(dialog.getObjectClass())) {
            this.setValue(dialog.getObjectClass());
            return true;
        }
        return false;
    }

    public String getDisplayValue(IValue value) {
        if (this.getRawValue(value) == null) {
            return ">>> Error, the configured value editor can not handle this value! <<<";
        }
        String displayValue = value.getStringValue();
        if (!this.showRawValues() && !"".equals(displayValue)) {
            Schema schema = value.getAttribute().getEntry().getBrowserConnection().getSchema();
            ObjectClass ocd = schema.getObjectClassDescription(displayValue);
            switch (ocd.getType()) {
                case STRUCTURAL: {
                    displayValue = String.valueOf(displayValue) + Messages.getString("ObjectClassValueEditor.Structural");
                    break;
                }
                case ABSTRACT: {
                    displayValue = String.valueOf(displayValue) + Messages.getString("ObjectClassValueEditor.Abstract");
                    break;
                }
                case AUXILIARY: {
                    displayValue = String.valueOf(displayValue) + Messages.getString("ObjectClassValueEditor.Auxiliary");
                }
            }
            if (ocd.isObsolete()) {
                displayValue = String.valueOf(displayValue) + Messages.getString("ObjectClassValueEditor.Obsolete");
            }
        }
        return displayValue;
    }

    public Object getRawValue(AttributeHierarchy attributeHierarchy) {
        return null;
    }

    public Object getRawValue(IValue value) {
        if (value == null || !value.isString() || !value.getAttribute().isObjectClassAttribute()) {
            return null;
        }
        return this.getRawValue(value.getAttribute().getEntry().getBrowserConnection(), value.getStringValue());
    }

    private Object getRawValue(IBrowserConnection connection, Object value) {
        Schema schema = null;
        if (connection != null) {
            schema = connection.getSchema();
        }
        if (!(value instanceof String)) {
            return null;
        }
        String ocValue = (String)value;
        ObjectClassValueEditorRawValueWrapper wrapper = new ObjectClassValueEditorRawValueWrapper(schema, ocValue);
        return wrapper;
    }

    private class ObjectClassValueEditorRawValueWrapper {
        private Schema schema;
        private String objectClass;

        private ObjectClassValueEditorRawValueWrapper(Schema schema, String objectClass) {
            this.schema = schema;
            this.objectClass = objectClass;
        }
    }
}

