/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.schemaeditor.controller.actions;

import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.ObjectClass;
import org.apache.directory.studio.schemaeditor.Activator;
import org.apache.directory.studio.schemaeditor.PluginConstants;
import org.apache.directory.studio.schemaeditor.PluginUtils;
import org.apache.directory.studio.schemaeditor.controller.actions.Messages;
import org.apache.directory.studio.schemaeditor.model.Schema;
import org.apache.directory.studio.schemaeditor.view.dialogs.RenameAttributeTypeDialog;
import org.apache.directory.studio.schemaeditor.view.dialogs.RenameObjectClassDialog;
import org.apache.directory.studio.schemaeditor.view.dialogs.RenameSchemaDialog;
import org.apache.directory.studio.schemaeditor.view.editors.EditorsUtils;
import org.apache.directory.studio.schemaeditor.view.wrappers.AttributeTypeWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.ObjectClassWrapper;
import org.apache.directory.studio.schemaeditor.view.wrappers.SchemaWrapper;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RenameSchemaElementAction
extends Action
implements IWorkbenchWindowActionDelegate {
    private TreeViewer viewer;

    public RenameSchemaElementAction(TreeViewer viewer) {
        super(Messages.getString("RenameSchemaElementAction.RenameSchemaElementAction"));
        this.setToolTipText(this.getText());
        this.setId(PluginConstants.CMD_RENAME_SCHEMA_ELEMENT);
        this.setActionDefinitionId(PluginConstants.CMD_RENAME_SCHEMA_ELEMENT);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("resources/icons/rename.gif"));
        this.setEnabled(false);
        this.viewer = viewer;
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                RenameSchemaElementAction.this.setEnabled(selection.size() == 1 && (selection.getFirstElement() instanceof SchemaWrapper || selection.getFirstElement() instanceof AttributeTypeWrapper || selection.getFirstElement() instanceof ObjectClassWrapper));
            }
        });
    }

    public void run() {
        StructuredSelection selection = (StructuredSelection)this.viewer.getSelection();
        if (!selection.isEmpty() && selection.size() == 1) {
            Object selectedElement = selection.getFirstElement();
            if (EditorsUtils.saveAllDirtyEditors()) {
                ObjectClass objectClass;
                RenameObjectClassDialog dialog;
                if (selectedElement instanceof SchemaWrapper) {
                    Schema schema = ((SchemaWrapper)selectedElement).getSchema();
                    RenameSchemaDialog dialog2 = new RenameSchemaDialog(schema.getSchemaName());
                    if (dialog2.open() == 0) {
                        Activator.getDefault().getSchemaHandler().renameSchema(schema, dialog2.getNewName());
                    }
                } else if (selectedElement instanceof AttributeTypeWrapper) {
                    AttributeType attributeType = ((AttributeTypeWrapper)selectedElement).getAttributeType();
                    RenameAttributeTypeDialog dialog3 = new RenameAttributeTypeDialog(attributeType.getNames());
                    if (dialog3.open() == 0) {
                        AttributeType modifiedAttributeType = PluginUtils.getClone(attributeType);
                        modifiedAttributeType.setNames(dialog3.getAliases());
                        Activator.getDefault().getSchemaHandler().modifyAttributeType(attributeType, modifiedAttributeType);
                    }
                } else if (selectedElement instanceof ObjectClassWrapper && (dialog = new RenameObjectClassDialog((objectClass = ((ObjectClassWrapper)selectedElement).getObjectClass()).getNames())).open() == 0) {
                    ObjectClass modifiedObjectClass = PluginUtils.getClone(objectClass);
                    modifiedObjectClass.setNames(dialog.getAliases());
                    Activator.getDefault().getSchemaHandler().modifyObjectClass(objectClass, modifiedObjectClass);
                }
            }
        }
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }
}

