/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.modifydn;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.ResponseCarryingException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.message.ModifyDnRequest;
import org.apache.directory.api.ldap.model.message.ModifyDnResponseImpl;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.message.ResultResponse;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreModifyDnRequestNewRdn
extends GrammarAction<LdapMessageContainer<ModifyDnRequest>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreModifyDnRequestNewRdn.class);

    public StoreModifyDnRequestNewRdn() {
        super("Store ModifyDN request new RDN");
    }

    public void action(LdapMessageContainer<ModifyDnRequest> container) throws DecoderException {
        ModifyDnRequest modifyDnRequest = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        if (tlv.getLength() == 0) {
            String msg = I18n.err((I18n)I18n.ERR_05126_RDN_MUST_NOT_BE_NULL, (Object[])new Object[0]);
            LOG.error(msg);
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), null);
        }
        byte[] dnBytes = tlv.getValue().getData();
        String dnStr = Strings.utf8ToString((byte[])dnBytes);
        try {
            Dn dn = new Dn(new String[]{dnStr});
            Rdn newRdn = dn.getRdn(dn.size() - 1);
            modifyDnRequest.setNewRdn(newRdn);
        }
        catch (LdapInvalidDnException ine) {
            String msg = I18n.err((I18n)I18n.ERR_05127_INVALID_NEW_RDN, (Object[])new Object[]{dnStr, Strings.dumpBytes((byte[])dnBytes)});
            LOG.error(I18n.err((I18n)I18n.ERR_05114_ERROR_MESSAGE, (Object[])new Object[]{msg, ine.getMessage()}));
            ModifyDnResponseImpl response = new ModifyDnResponseImpl(modifyDnRequest.getMessageId());
            throw new ResponseCarryingException(msg, (ResultResponse)response, ResultCodeEnum.INVALID_DN_SYNTAX, modifyDnRequest.getName(), ine);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05138_MODIFYING_WITH_NEW_RDN, (Object[])new Object[]{modifyDnRequest.getNewRdn()}));
        }
    }
}

