/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.processor.string.Camelbacker;
import org.apache.torque.generator.processor.string.ConstantNameCreator;
import org.apache.torque.generator.processor.string.WrapReservedJavaWords;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.TorqueSchemaJavaType;
import org.apache.torque.templates.transformer.om.ColumnAttributeName;
import org.apache.torque.templates.transformer.om.EnumValueAttributeName;
import org.apache.torque.templates.transformer.om.JavaFieldAttributeName;
import org.apache.torque.templates.transformer.om.TableAttributeName;
import org.apache.torque.templates.typemapping.JavaType;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.TypeMap;

public class OMColumnJavaTransformer {
    private static Logger log = LogManager.getLogger(OMColumnJavaTransformer.class);
    private static Camelbacker javaNameCamelbacker = new Camelbacker();
    private static ConstantNameCreator constantNameCreator = new ConstantNameCreator();
    private static final String DEFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.S";
    static final String CURRENT_DATE = "CURRENT_DATE";
    static final String CURRENT_TIME = "CURRENT_TIME";
    static final String CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    static final String GET_DEFAULT_DATE_METHOD_NAME = "getCurrentDate";
    static final String GET_DEFAULT_TIME_METHOD_NAME = "getCurrentTime";
    static final String GET_DEFAULT_TIMESTAMP_METHOD_NAME = "getCurrentTimestamp";
    private static WrapReservedJavaWords reservedJavaWordsWrapper = new WrapReservedJavaWords();

    protected void setJavaTypeAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_TYPE) != null) {
            return;
        }
        SourceElement databaseElement = columnElement.getParent().getParent();
        String defaultJavaType = (String)databaseElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT_JAVA_TYPE);
        if (defaultJavaType != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_TYPE, (Object)defaultJavaType);
        }
    }

    protected void setJavaNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME) != null) {
            return;
        }
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String javaName = javaNameCamelbacker.process(columnName);
        columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME, (Object)javaName);
    }

    protected void setFieldNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME) != null) {
            return;
        }
        String javaName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME);
        String fieldName = StringUtils.uncapitalize((String)javaName);
        fieldName = reservedJavaWordsWrapper.process(fieldName);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)fieldName);
    }

    protected String getDefaultValueWithDefaultSet(JavaType javaType, String defaultValue, boolean useDatabaseDefaultValue, SourceElement columnElement) throws SourceTransformerException {
        Object fieldDefaultValue;
        boolean primitiveFieldType = javaType.isPrimitive();
        if (JavaType.BOOLEAN_PRIMITIVE == javaType) {
            fieldDefaultValue = "Y".equals(defaultValue) || "1".equals(defaultValue) || "true".equalsIgnoreCase(defaultValue) ? "true" : "false";
        } else if (JavaType.BOOLEAN_OBJECT == javaType) {
            fieldDefaultValue = "Y".equals(defaultValue) || "1".equals(defaultValue) || "true".equalsIgnoreCase(defaultValue) ? "Boolean.TRUE" : "Boolean.FALSE";
        } else if (JavaType.STRING == javaType) {
            fieldDefaultValue = "\"" + defaultValue + "\"";
        } else if (JavaType.SHORT_OBJECT == javaType) {
            fieldDefaultValue = "Short.valueOf(\"" + defaultValue + "\")";
        } else if (JavaType.BYTE_OBJECT == javaType) {
            fieldDefaultValue = "Byte.valueOf(\"" + defaultValue + "\")";
        } else if (JavaType.INTEGER_OBJECT == javaType) {
            fieldDefaultValue = "Integer.valueOf(" + defaultValue + ")";
        } else if (JavaType.LONG_OBJECT == javaType) {
            fieldDefaultValue = "Long.valueOf(" + defaultValue + "L)";
        } else if (JavaType.DATE == javaType) {
            if (Stream.of(CURRENT_DATE, CURRENT_TIME, CURRENT_TIMESTAMP).anyMatch(s -> s.equalsIgnoreCase(defaultValue))) {
                if (useDatabaseDefaultValue) {
                    fieldDefaultValue = "null";
                } else if (CURRENT_DATE.equalsIgnoreCase(defaultValue)) {
                    String methodName = columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_DATE_METHOD_NAME) != null ? columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_DATE_METHOD_NAME).toString() : GET_DEFAULT_DATE_METHOD_NAME;
                    fieldDefaultValue = methodName + "()";
                } else if (CURRENT_TIME.equalsIgnoreCase(defaultValue)) {
                    String methodName = columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIME_METHOD_NAME) != null ? columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIME_METHOD_NAME).toString() : GET_DEFAULT_TIME_METHOD_NAME;
                    fieldDefaultValue = methodName + "()";
                } else {
                    String methodName = columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIMESTAMP_METHOD_NAME) != null ? columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.GET_CURRENT_TIMESTAMP_METHOD_NAME).toString() : GET_DEFAULT_TIMESTAMP_METHOD_NAME;
                    fieldDefaultValue = methodName + "()";
                }
            } else {
                fieldDefaultValue = useDatabaseDefaultValue ? "null" : "new Date(" + OMColumnJavaTransformer.getDefaultValueAsDate(defaultValue).getTime() + "L)";
            }
        } else {
            fieldDefaultValue = primitiveFieldType ? defaultValue : "new " + javaType.getFullClassName() + "(" + defaultValue + ")";
        }
        return fieldDefaultValue;
    }

    public static Date getDefaultValueAsDate(String defaultValue) throws SourceTransformerException {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DEFAULT_DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            return dateFormat.parse(defaultValue);
        }
        catch (ParseException e) {
            throw new SourceTransformerException("The default value " + defaultValue + " does not match the format String yyyy-MM-dd HH:mm:ss.S for date values");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getDefaultValueWithoutDefaultSet(JavaType javaType) throws SourceTransformerException {
        boolean primitiveFieldType = javaType.isPrimitive();
        if (!primitiveFieldType) return "null";
        if (JavaType.BOOLEAN_PRIMITIVE == javaType) {
            return "false";
        }
        if (JavaType.BYTE_PRIMITIVE == javaType) {
            return "(byte) 0";
        }
        if (JavaType.SHORT_PRIMITIVE == javaType) {
            return "(short) 0";
        }
        if (JavaType.INTEGER_PRIMITIVE == javaType) {
            return "0";
        }
        if (JavaType.LONG_PRIMITIVE == javaType) {
            return "0L";
        }
        if (JavaType.FLOAT_PRIMITIVE == javaType) {
            return "0";
        }
        if (JavaType.DOUBLE_PRIMITIVE == javaType) {
            return "0";
        }
        if (JavaType.CHAR_PRIMITIVE != javaType) throw new SourceTransformerException("unknown primitive type" + String.valueOf((Object)javaType));
        return "'\u0000'";
    }

    protected JavaType setFieldJavaType(SourceElement columnElement, SchemaType schemaType, String enumClassName) throws SourceTransformerException {
        JavaType result;
        String javaType = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_TYPE);
        if (TorqueSchemaJavaType.OBJECT.getValue().equals(javaType)) {
            result = TypeMap.getJavaObjectType(schemaType);
        } else if (TorqueSchemaJavaType.PRIMITIVE.getValue().equals(javaType) || javaType == null) {
            result = TypeMap.getJavaPrimitiveType(schemaType);
        } else {
            String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
            throw new SourceTransformerException("Unknown javaType " + javaType + " in column " + columnName);
        }
        if (enumClassName != null) {
            columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE, (Object)enumClassName);
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME, (Object)enumClassName);
            columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.ENUM_VALUE_CLASS_NAME, (Object)result.getFullClassName());
        } else {
            columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_TYPE, (Object)result.getFullClassName());
        }
        return result;
    }

    public static String setEnumAttributes(SourceElement columnElement, ControllerState controllerState) {
        String enumPackage;
        Object enumClassName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.ENUM_TYPE);
        boolean generateEnum = columnElement.getChild((SourceElementName)TorqueSchemaElementName.ENUM_VALUE) != null;
        boolean columnIsEnum = false;
        if (enumClassName != null) {
            columnIsEnum = true;
            int lastIndexOfDot = ((String)enumClassName).lastIndexOf(46);
            if (lastIndexOfDot != -1) {
                enumPackage = ((String)enumClassName).substring(0, lastIndexOfDot);
                enumClassName = ((String)enumClassName).substring(lastIndexOfDot + 1);
            } else {
                enumPackage = (String)columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_PACKAGE);
            }
        } else {
            if (columnElement.getChild((SourceElementName)TorqueSchemaElementName.ENUM_VALUE) != null) {
                columnIsEnum = true;
            }
            enumClassName = controllerState.getStringOption((OptionName)TemplateOptionName.OM_ENUM_TYPE_PREFIX) + String.valueOf(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME)) + controllerState.getStringOption((OptionName)TemplateOptionName.OM_ENUM_TYPE_SUFFIX);
            enumPackage = (String)columnElement.getParent().getAttribute((SourceAttributeName)TableAttributeName.DB_OBJECT_PACKAGE);
        }
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.ENUM_CLASS_NAME, enumClassName);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.ENUM_PACKAGE, (Object)enumPackage);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.GENERATE_ENUM, (Object)Boolean.toString(generateEnum));
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.IS_ENUM, (Object)Boolean.toString(columnIsEnum));
        if (columnIsEnum) {
            log.debug("set enumClassName to {}", enumClassName);
            return enumClassName;
        }
        return null;
    }

    protected void setEnumValueJavaNameAttribute(SourceElement enumValueElement) throws SourceTransformerException {
        if (enumValueElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME) != null) {
            return;
        }
        String value = (String)enumValueElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.VALUE);
        if (value == null) {
            throw new SourceTransformerException("value attribute must be set on all enum-value elements in enum column " + String.valueOf(enumValueElement.getParent()));
        }
        String javaName = constantNameCreator.process(value);
        enumValueElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME, (Object)javaName);
    }

    protected void setEnumValueJavaValueAttribute(SourceElement enumValueElement, JavaType columnJavaType) throws SourceTransformerException {
        if (enumValueElement.getAttribute((SourceAttributeName)EnumValueAttributeName.JAVA_VALUE) != null) {
            return;
        }
        SourceElement columnElement = enumValueElement.getParent();
        String javaValue = this.getDefaultValueWithDefaultSet(columnJavaType, (String)enumValueElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.VALUE), false, columnElement);
        enumValueElement.setAttribute((SourceAttributeName)EnumValueAttributeName.JAVA_VALUE, (Object)javaValue);
    }
}

