/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.util;

import java.io.IOException;
import java.io.Writer;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.Column;
import org.apache.torque.ColumnImpl;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.om.mapper.ObjectListMapper;
import org.apache.torque.util.BasePeerImpl;
import org.apache.torque.util.ListOrderedMapCI;
import org.apache.torque.util.TorqueConnection;
import org.apache.torque.util.Transaction;
import org.apache.torque.util.UniqueList;
import org.apache.torque.util.functions.SQLFunction;

public class SummaryHelper {
    private static final Logger log = LogManager.getLogger(SummaryHelper.class);
    private List<Column> groupByColumns;
    private ListOrderedMapCI<SQLFunction> aggregates;
    private boolean excludeExprColumns = false;

    public List<ListOrderedMapCI<Object>> summarize(Criteria crit) throws TorqueException {
        return this.summarize(crit, (List)null);
    }

    public List<ListOrderedMapCI<Object>> summarize(Criteria crit, List<Class<?>> resultTypes) throws TorqueException {
        try (TorqueConnection connection = Transaction.begin(crit.getDbName());){
            List<ListOrderedMapCI<Object>> result = this.summarize(crit, resultTypes, connection);
            Transaction.commit(connection);
            List<ListOrderedMapCI<Object>> list = result;
            return list;
        }
    }

    public List<ListOrderedMapCI<Object>> summarize(Criteria crit, Connection conn) throws TorqueException {
        return this.summarize(crit, null, conn);
    }

    public List<ListOrderedMapCI<Object>> summarize(Criteria crit, List<Class<?>> resultTypes, Connection conn) throws TorqueException {
        Criteria c = this.buildCriteria(crit);
        String databaseName = c.getDbName() == null ? Torque.getDefaultDB() : c.getDbName();
        c.setDbName(databaseName);
        BasePeerImpl<List<Object>> peer = new BasePeerImpl<List<Object>>(new ObjectListMapper(resultTypes), null, databaseName);
        List<List<Object>> rows = peer.doSelect(c, new ObjectListMapper(resultTypes), conn);
        ArrayList<ListOrderedMapCI<Object>> resultsList = new ArrayList<ListOrderedMapCI<Object>>(rows.size());
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Column column : c.getSelectColumns()) {
            columnNames.add(column.getColumnName());
        }
        columnNames.addAll(c.getAsColumns().keySet());
        for (List list : rows) {
            ListOrderedMapCI recordMap = new ListOrderedMapCI();
            for (int i = 0; i < list.size(); ++i) {
                Object value = list.get(i);
                String cName = (String)columnNames.get(i);
                if (cName == null || cName.equals("")) {
                    if (this.excludeExprColumns()) continue;
                    cName = "Expr" + i;
                }
                recordMap.put(cName, value);
            }
            resultsList.add(recordMap);
        }
        return resultsList;
    }

    public Criteria buildCriteria(Criteria c) throws TorqueException {
        c.getSelectColumns().clear();
        c.getGroupByColumns().clear();
        UniqueList<String> criteriaSelectModifiers = c.getSelectModifiers();
        this.setDistinct(criteriaSelectModifiers);
        c.setIgnoreCase(false);
        List<Column> cols = this.getGroupByColumns();
        boolean haveFromTable = !cols.isEmpty();
        for (Column column : cols) {
            c.addGroupByColumn(column);
            c.addSelectColumn(column);
        }
        if (haveFromTable) {
            log.debug("From table defined by Group By Cols");
        }
        if (!haveFromTable && c.getTopLevelCriterion() != null) {
            haveFromTable = true;
            log.debug("From table defined by a where clause");
        }
        for (Map.Entry entry : this.getAggregates().entrySet()) {
            SQLFunction f = (SQLFunction)entry.getValue();
            Column col = f.getColumn();
            c.addAsColumn((String)entry.getKey(), new ColumnImpl(null, col.getTableName(), col.getColumnName(), f.getSqlExpression()));
            if (haveFromTable) continue;
            c.andVerbatimSql(col.getColumnName() + "=" + col.getColumnName(), new Object[0]);
            haveFromTable = true;
            String table = col.getTableName();
            log.debug("From table, '{}', defined from aggregate column", (Object)table);
        }
        if (!haveFromTable) {
            throw new TorqueException("No FROM table defined by the GroupBy set, criteria.setAlias, or specified function column!");
        }
        return c;
    }

    private void setDistinct(UniqueList<String> criteriaSelectModifiers) {
        if (criteriaSelectModifiers != null && criteriaSelectModifiers.size() > 0 && criteriaSelectModifiers.contains(SqlEnum.DISTINCT.toString())) {
            criteriaSelectModifiers.remove(SqlEnum.DISTINCT.toString());
        }
    }

    public void addGroupBy(Column column) {
        this.getGroupByColumns().add(column);
    }

    public void addAggregate(String alias, SQLFunction function) {
        this.getAggregates().put(alias, function);
    }

    public void clear() {
        this.getGroupByColumns().clear();
        this.getAggregates().clear();
        this.setExcludeExprColumns(false);
    }

    public List<Column> getGroupByColumns() {
        if (this.groupByColumns == null) {
            this.groupByColumns = new Vector<Column>();
        }
        return this.groupByColumns;
    }

    public ListOrderedMapCI<SQLFunction> getAggregates() {
        if (this.aggregates == null) {
            this.aggregates = new ListOrderedMapCI();
        }
        return this.aggregates;
    }

    public void dumpResults(Writer out, List<?> results, boolean includeHeader) throws IOException {
        Iterator<?> i = results.iterator();
        boolean first = includeHeader;
        while (i.hasNext()) {
            ListOrderedMapCI rec = (ListOrderedMapCI)i.next();
            Iterator rI = rec.entrySet().iterator();
            StringBuilder heading = new StringBuilder();
            StringBuilder recString = new StringBuilder();
            while (rI.hasNext()) {
                Map.Entry entry = rI.next();
                String colId = (String)entry.getKey();
                if (first) {
                    heading.append("\"").append(colId).append("\"");
                    if (rI.hasNext()) {
                        heading.append(", ");
                    }
                }
                Object v = entry.getValue();
                recString.append(v.toString());
                if (!rI.hasNext()) continue;
                recString.append(", ");
            }
            if (first) {
                first = false;
                out.write(heading.toString());
                out.write("\n");
            }
            out.write(recString.toString());
            out.write("\n");
        }
    }

    public boolean excludeExprColumns() {
        return this.excludeExprColumns;
    }

    public void setExcludeExprColumns(boolean excludeExprColumns) {
        this.excludeExprColumns = excludeExprColumns;
    }
}

