/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.templates.transformer.om;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.OptionName;
import org.apache.torque.generator.processor.string.WrapReservedJavaWords;
import org.apache.torque.generator.source.SourceAttributeName;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.source.SourceElementName;
import org.apache.torque.generator.source.transform.SourceTransformerException;
import org.apache.torque.templates.TemplateOptionName;
import org.apache.torque.templates.TorqueSchemaAttributeName;
import org.apache.torque.templates.TorqueSchemaElementName;
import org.apache.torque.templates.TorqueSchemaInheritance;
import org.apache.torque.templates.transformer.SchemaTypeHelper;
import org.apache.torque.templates.transformer.om.ColumnAttributeName;
import org.apache.torque.templates.transformer.om.FieldHelper;
import org.apache.torque.templates.transformer.om.JavaFieldAttributeName;
import org.apache.torque.templates.transformer.om.OMColumnJavaTransformer;
import org.apache.torque.templates.transformer.om.OMInheritanceTransformer;
import org.apache.torque.templates.typemapping.JavaType;
import org.apache.torque.templates.typemapping.ResultSetGetter;
import org.apache.torque.templates.typemapping.SchemaType;
import org.apache.torque.templates.typemapping.SqlType;
import org.apache.torque.templates.typemapping.TypeMap;

public class OMColumnTransformer {
    private static Logger log = LogManager.getLogger(OMColumnTransformer.class);
    private static OMInheritanceTransformer inheritanceTransformer = new OMInheritanceTransformer();
    private static final Set<String> RESERVED_CONSTANT_NAMES;
    private static WrapReservedJavaWords reservedJavaWordsWrapper;
    protected OMColumnJavaTransformer javaTransformer = new OMColumnJavaTransformer();

    public void transform(SourceElement columnElement, ControllerState controllerState, int columnPosition) throws SourceTransformerException {
        this.checkElementName(columnElement);
        this.checkColumnNameExists(columnElement);
        this.javaTransformer.setJavaTypeAttribute(columnElement);
        this.javaTransformer.setJavaNameAttribute(columnElement);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.POSITION, (Object)columnPosition);
        this.setAttributeDefaultValues(columnElement);
        SchemaType schemaType = SchemaTypeHelper.getSchemaType(columnElement, controllerState);
        columnElement.setAttribute("schemaType", (Object)schemaType);
        this.setDomainAttributes(columnElement, controllerState);
        String enumClassName = OMColumnJavaTransformer.setEnumAttributes(columnElement, controllerState);
        JavaType fieldJavaType = this.javaTransformer.setFieldJavaType(columnElement, schemaType, enumClassName);
        JavaType fieldJavaObjectType = TypeMap.getJavaObjectType(schemaType);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.FIELD_OBJECT_TYPE, (Object)fieldJavaObjectType.getFullClassName());
        this.setPrimitiveTypeAttribute(columnElement, fieldJavaType);
        this.setNumberTypeAttribute(columnElement, fieldJavaType);
        this.setFieldNameAttribute(columnElement);
        this.setPeerColumnNameAttribute(columnElement);
        this.setQualifiedColumnNameAttribute(columnElement);
        this.setGetterNameAttribute(columnElement, fieldJavaType, controllerState);
        this.setSetterNameAttribute(columnElement);
        this.setAccessModifierAttributes(columnElement);
        this.setDefaultValueAttribute(columnElement, fieldJavaType, controllerState);
        this.setUseDatabaseDefaultValueAttribute(columnElement);
        this.setResultSetGetterAttribute(columnElement, schemaType);
        this.setSampleObjectAttribute(columnElement, schemaType);
        for (SourceElement inheritanceElement : columnElement.getChildren(TorqueSchemaElementName.INHERITANCE.getName())) {
            inheritanceTransformer.transform(inheritanceElement, controllerState);
        }
        for (SourceElement enumValueElement : columnElement.getChildren(TorqueSchemaElementName.ENUM_VALUE.getName())) {
            this.javaTransformer.setEnumValueJavaNameAttribute(enumValueElement);
            this.javaTransformer.setEnumValueJavaValueAttribute(enumValueElement, fieldJavaType);
        }
    }

    protected void setAttributeDefaultValues(SourceElement columnElement) {
        Object primaryKey;
        Object required;
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.AUTO_INCREMENT) == null) {
            String idMethod = (String)columnElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.ID_METHOD);
            if (!"none".equals(idMethod)) {
                columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.AUTO_INCREMENT, (Object)Boolean.TRUE.toString());
            } else {
                columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.AUTO_INCREMENT, (Object)Boolean.FALSE.toString());
            }
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PROTECTED) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.PROTECTED, (Object)Boolean.FALSE.toString());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.INHERITANCE) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.INHERITANCE, (Object)Boolean.FALSE.toString());
        }
        if ((required = columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.REQUIRED)) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.REQUIRED, (Object)Boolean.FALSE.toString());
        }
        if ((primaryKey = columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PRIMARY_KEY)) == null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.PRIMARY_KEY, (Object)Boolean.FALSE.toString());
        }
    }

    protected void setDomainAttributes(SourceElement columnElement, ControllerState controllerState) throws SourceTransformerException {
        SqlType domain = SchemaTypeHelper.getDomain(columnElement, controllerState);
        if (domain == null) {
            return;
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.TYPE) == null && domain.getSqlTypeName() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.TYPE, (Object)domain.getSqlTypeName());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT) == null && domain.getDefaultValue() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT, (Object)domain.getDefaultValue());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SIZE) == null && domain.getSize() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.SIZE, (Object)domain.getSize());
        }
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.SCALE) == null && domain.getScale() != null) {
            columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.SCALE, (Object)domain.getScale());
        }
    }

    protected void setAccessModifierAttributes(SourceElement columnElement) {
        boolean isProtected = "true".equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.PROTECTED));
        String accessModifier = isProtected ? "protected" : "public";
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_ACCESS_MODIFIER, (Object)accessModifier);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_ACCESS_MODIFIER, (Object)accessModifier);
    }

    protected void checkElementName(SourceElement columnElement) {
        if (!TorqueSchemaElementName.COLUMN.getName().equals(columnElement.getName())) {
            throw new IllegalArgumentException("Illegal element Name " + columnElement.getName());
        }
    }

    protected void checkColumnNameExists(SourceElement columnElement) throws SourceTransformerException {
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        if (columnName == null) {
            throw new SourceTransformerException("The attribute " + TorqueSchemaAttributeName.NAME.getName() + " on element " + columnElement.getName() + " is null");
        }
    }

    protected void setFieldNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME) != null) {
            return;
        }
        String javaName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.JAVA_NAME);
        String fieldName = StringUtils.uncapitalize((String)javaName);
        fieldName = reservedJavaWordsWrapper.process(fieldName);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME, (Object)fieldName);
    }

    protected void setPeerColumnNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.PEER_COLUMN_NAME) != null) {
            return;
        }
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String peerColumnName = columnName.toUpperCase();
        if (RESERVED_CONSTANT_NAMES.contains(peerColumnName)) {
            peerColumnName = "_" + peerColumnName;
        }
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.PEER_COLUMN_NAME, (Object)peerColumnName);
    }

    protected void setQualifiedColumnNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.QUALIFIED_COLUMN_NAME) != null) {
            return;
        }
        String tableName = (String)columnElement.getParent().getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String columnName = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.NAME);
        String qualifiedColumnName = tableName + "." + columnName;
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.QUALIFIED_COLUMN_NAME, (Object)qualifiedColumnName);
    }

    protected void setGetterNameAttribute(SourceElement columnElement, JavaType javaType, ControllerState controllerState) {
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME) != null) {
            return;
        }
        String fieldName = (String)columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME);
        String getterName = FieldHelper.getGetterName(fieldName, javaType.getFullClassName(), controllerState);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.GETTER_NAME, (Object)getterName);
    }

    protected void setSetterNameAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME) != null) {
            return;
        }
        String fieldName = (String)columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.FIELD_NAME);
        String setterName = FieldHelper.getSetterName(fieldName);
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.SETTER_NAME, (Object)setterName);
    }

    protected void setPrimitiveTypeAttribute(SourceElement columnElement, JavaType javaType) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.PRIMITIVE_TYPE) != null) {
            return;
        }
        boolean primitiveFieldType = javaType.isPrimitive();
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.PRIMITIVE_TYPE, (Object)Boolean.toString(primitiveFieldType));
    }

    protected void setNumberTypeAttribute(SourceElement columnElement, JavaType javaType) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.NUMBER_TYPE) != null) {
            return;
        }
        boolean numberFieldType = javaType.isNumber();
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.NUMBER_TYPE, (Object)Boolean.toString(numberFieldType));
    }

    protected void setDefaultValueAttribute(SourceElement columnElement, JavaType javaType, ControllerState controllerState) throws SourceTransformerException {
        String fieldDefaultValue;
        if (TorqueSchemaInheritance.SINGLE.getValue().equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.INHERITANCE)) && columnElement.getChildren((SourceElementName)TorqueSchemaElementName.INHERITANCE).isEmpty()) {
            columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)"getClass().getName()");
            return;
        }
        if (columnElement.getAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE) != null) {
            return;
        }
        String defaultAttributeValue = (String)columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.DEFAULT);
        if (defaultAttributeValue != null) {
            boolean useDatabaseDefaultValue = "true".equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.USE_DATABASE_DEFAULT_VALUE));
            fieldDefaultValue = this.javaTransformer.getDefaultValueWithDefaultSet(javaType, defaultAttributeValue, useDatabaseDefaultValue, columnElement);
        } else {
            fieldDefaultValue = "true".equals(columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.VERSION)) ? controllerState.getStringOption((OptionName)TemplateOptionName.OM_OPTIMISTIC_LOCKING_DEFAULT_VALUE) : this.javaTransformer.getDefaultValueWithoutDefaultSet(javaType);
        }
        if (!"null".equals(fieldDefaultValue) && Boolean.parseBoolean((String)columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.IS_ENUM))) {
            fieldDefaultValue = (String)columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.ENUM_CLASS_NAME) + ".getByValue(" + fieldDefaultValue + ")";
        }
        columnElement.setAttribute((SourceAttributeName)JavaFieldAttributeName.DEFAULT_VALUE, (Object)fieldDefaultValue);
    }

    protected void setUseDatabaseDefaultValueAttribute(SourceElement columnElement) {
        if (columnElement.getAttribute((SourceAttributeName)TorqueSchemaAttributeName.USE_DATABASE_DEFAULT_VALUE) != null) {
            return;
        }
        columnElement.setAttribute((SourceAttributeName)TorqueSchemaAttributeName.USE_DATABASE_DEFAULT_VALUE, (Object)Boolean.toString(false));
    }

    protected void setResultSetGetterAttribute(SourceElement columnElement, SchemaType schemaType) {
        ResultSetGetter resultSetGetter = null;
        Object originalValue = columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.RESULT_SET_GETTER);
        if (originalValue != null) {
            if (originalValue instanceof String) {
                resultSetGetter = ResultSetGetter.getByMethodName((String)originalValue);
            }
        } else {
            resultSetGetter = TypeMap.getResultSetGetter(schemaType);
        }
        if (resultSetGetter != null) {
            columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.RESULT_SET_GETTER, (Object)resultSetGetter);
        }
    }

    protected void setSampleObjectAttribute(SourceElement columnElement, SchemaType schemaType) {
        if (columnElement.getAttribute((SourceAttributeName)ColumnAttributeName.SAMPLE_OBJECT) != null) {
            return;
        }
        String sampleObject = TypeMap.getJavaObject(schemaType);
        columnElement.setAttribute((SourceAttributeName)ColumnAttributeName.SAMPLE_OBJECT, (Object)sampleObject);
    }

    static {
        reservedJavaWordsWrapper = new WrapReservedJavaWords();
        HashSet<String> reservedConstantNames = new HashSet<String>();
        reservedConstantNames.add("DATABASE");
        reservedConstantNames.add("TABLE_NAME");
        reservedConstantNames.add("TABLE");
        RESERVED_CONSTANT_NAMES = Collections.unmodifiableSet(reservedConstantNames);
    }
}

