/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.configuration.option;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.configuration.option.FileOptionsConfiguration;
import org.apache.torque.generator.option.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesOptionConfiguration
extends FileOptionsConfiguration {
    private static Log log = LogFactory.getLog(PropertiesOptionConfiguration.class);

    @Override
    public Collection<Option> getOptions(ConfigurationProvider configurationProvider) throws ConfigurationException {
        Properties properties = new Properties();
        InputStream optionsInputStream = null;
        try {
            optionsInputStream = configurationProvider.getOptionsInputStream(this.getPath());
            properties.load(optionsInputStream);
        }
        catch (IOException e) {
            throw new ConfigurationException("Error reading options file " + this.getPath(), e);
        }
        catch (RuntimeException e) {
            throw new ConfigurationException("Error reading options file " + this.getPath(), e);
        }
        finally {
            if (optionsInputStream != null) {
                try {
                    optionsInputStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Could not close OptionsInputStream " + optionsInputStream), (Throwable)e);
                }
            }
        }
        return this.toOptions(properties);
    }
}

