/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.LocaleTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class TableLockBasicTest
extends BaseJDBCTestCase {
    public TableLockBasicTest(String string) {
        super(string);
    }

    public static Test suite() {
        Object object = TestConfiguration.defaultSuite(TableLockBasicTest.class);
        object = DatabasePropertyTestSetup.singleProperty(object, "derby.storage.rowLocking", "false", true);
        object = new LocaleTestSetup((Test)object, Locale.ENGLISH);
        return TestConfiguration.singleUseDatabaseDecorator(object);
    }

    protected void setUp() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
        this.createLockTableQueryEntries(statement);
        statement.close();
        this.getConnection().setTransactionIsolation(4);
        this.getConnection().setAutoCommit(false);
    }

    private void createLockTableQueryEntries(Statement statement) throws SQLException {
        statement.execute("create view lock_table as select cast(username as char(8)) as username,cast(t.type as char(8)) as trantype,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode,cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state,status from syscs_diag.lock_table l  right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' and t.type='UserTransaction'");
        statement.execute("create view full_lock_table as select cast(username as char(8)) as username, cast(t.type as char(8)) as trantype,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode, cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state,status from syscs_diag.lock_table l right outer join syscs_diag.transaction_table t on l.xid = t.xid where l.tableType <> 'S' ");
        statement.execute("create view lock_table2 as select cast(l.xid as char(8)) as xid,cast(l.type as char(8)) as type,cast(lockcount as char(3)) as cnt,mode,cast(tablename as char(12)) as tabname,cast(lockname as char(10)) as lockname,state from syscs_diag.lock_table l where l.tableType <> 'S' ");
        statement.execute("create view tran_table as select * from syscs_diag.transaction_table");
    }

    @Override
    public void tearDown() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("DROP FUNCTION PADSTRING");
        statement.execute("drop view lock_table");
        statement.execute("drop view full_lock_table");
        statement.execute("drop view lock_table2");
        statement.execute("drop view tran_table");
        statement.close();
        this.commit();
        super.tearDown();
    }

    public void testInsertIntoHeap() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table heap_only (a int)");
        this.commit();
        statement.execute("insert into heap_only values (1)");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "X", "HEAP_ONLY", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("insert into heap_only values (2)");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "X", "HEAP_ONLY", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("heap_only");
    }

    public void testSelectFromHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructHeap(statement);
        ResultSet resultSet = statement.executeQuery("select a from heap_only where a = 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "S", "HEAP_ONLY", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("heap_only");
    }

    private void constructHeap(Statement statement) throws SQLException {
        statement.execute("create table heap_only (a int)");
        this.commit();
        statement.execute("insert into heap_only values (1)");
        this.commit();
        statement.execute("insert into heap_only values (2)");
        this.commit();
    }

    public void testDelectFromHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructHeap(statement);
        statement.execute("delete from heap_only where a = 1");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "X", "HEAP_ONLY", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("heap_only");
    }

    public void testUpdateToHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructHeap(statement);
        statement.execute("update heap_only set a = 1000 where a = 2");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "X", "HEAP_ONLY", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("heap_only");
    }

    public void testDropHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructHeap(statement);
        statement.execute("drop table heap_only");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "3", "X", "*** TRANSIEN", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("heap_only");
    }

    public void testCreateIndex() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        statement.execute("create table indexed_heap (a int, b varchar(1000))");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "X", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', '4096')");
        statement.execute("create index a_idx on indexed_heap (a, b)");
        statement.execute("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.pageSize', NULL)");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "4", "S", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "1", "X", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("indexed_heap");
    }

    public void testInsertIntoEmtpyIndexedHeaP() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table indexed_heap (a int, b varchar(1000))");
        this.commit();
        statement.execute("create index a_idx on indexed_heap (a, b)");
        this.commit();
        statement.execute("insert into indexed_heap (a) values (1)");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "X", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.execute("insert into indexed_heap (a) values (2)");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "2", "X", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("indexed_heap");
    }

    public void testSelectFromIndexedHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructIndexedHeap(statement);
        ResultSet resultSet = statement.executeQuery("select a from indexed_heap where a = 1");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "S", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("indexed_heap");
    }

    private void constructIndexedHeap(Statement statement) throws SQLException {
        statement.execute("create table indexed_heap (a int, b varchar(1000))");
        statement.execute("create index a_idx on indexed_heap (a, b)");
        statement.execute("insert into indexed_heap (a) values (1)");
        statement.execute("insert into indexed_heap (a) values (2)");
        this.commit();
    }

    public void testDeleteFromIndexedHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructIndexedHeap(statement);
        statement.execute("delete from indexed_heap where a = 1");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "3", "X", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("indexed_heap");
    }

    public void testUpdateToIndexedHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructIndexedHeap(statement);
        statement.execute("update indexed_heap set a = 1000 where a = 2");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "4", "X", "INDEXED_HEAP", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
        this.dropTable("indexed_heap");
    }

    public void testDropIndexedHeap() throws SQLException {
        Statement statement = this.createStatement();
        this.constructIndexedHeap(statement);
        statement.execute("drop table indexed_heap");
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "X", "*** TRANSIEN", "Tablelock", "GRANT", "ACTIVE"}, {"APP", "UserTran", "TABLE", "4", "X", "*** TRANSIEN", "Tablelock", "GRANT", "ACTIVE"}});
        this.commit();
        statement.close();
    }

    public void testLockTableStatement() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("create table t1(c1 int)");
        this.commit();
        PreparedStatement preparedStatement = this.prepareStatement("lock table t1 in exclusive mode");
        preparedStatement.execute();
        ResultSet resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "X", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        statement.execute("drop table t1");
        statement.execute("create table t1(c1 int)");
        preparedStatement.execute();
        this.commit();
        statement.execute("lock table t1 in share mode");
        resultSet = statement.executeQuery(" select * from lock_table order by tabname, type desc, mode, cnt, lockname");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"APP", "UserTran", "TABLE", "1", "S", "T1", "Tablelock", "GRANT", "ACTIVE"}});
        statement.execute("drop table t1");
        this.commit();
        statement.close();
    }

    public void testLockTableInSysSchema() throws SQLException {
        Statement statement = this.createStatement();
        TableLockBasicTest.assertStatementError("42X62", statement, "lock table sys.systables in exclusive mode");
        statement.close();
    }

    public void testRTSOutput() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("create table rts(c1 int)");
        statement.execute("insert into rts values 1");
        this.commit();
        ResultSet resultSet = statement.executeQuery("select * from rts with cs");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"1"}});
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Statement Name: \n\t" + (this.getTestConfiguration().getJDBCClient().isEmbedded() ? "null\n" : "SQL_CURLH000C3\n") + "Statement Text: \n\tselect * from rts with cs\nParse Time: 0\nBind Time: 0\nOptimize Time: 0\nGenerate Time: 0\nCompile Time: 0\nExecute Time: 0\nBegin Compilation Timestamp : null\nEnd Compilation Timestamp : null\nBegin Execution Timestamp : null\nEnd Execution Timestamp : null\nStatement Execution Plan Text: \nTable Scan ResultSet for RTS at read committed isolation level using instantaneous share row locking chosen by the optimizer (Actual locking used: table level locking.)\nNumber of opens = 1\nRows seen = 1\nRows filtered = 0\nFetch Size = 16\n\tconstructor time (milliseconds) = 0\n\topen time (milliseconds) = 0\n\tnext time (milliseconds) = 0\n\tclose time (milliseconds) = 0\n\tnext time in milliseconds/row = 0\n\nscan information:\n\tBit set of columns fetched=All\n\tNumber of columns fetched=1\n\tNumber of pages visited=1\n\tNumber of rows qualified=1\n\tNumber of rows visited=1\n\tScan type=heap\n\tstart position:\n\t\tnull\n\tstop position:\n\t\tnull\n\tqualifiers:\n\t\tNone\n\toptimizer estimated row count: 6.00\n\toptimizer estimated cost: 100.40"}});
        statement.execute("drop table rts");
        this.commit();
        statement.close();
    }

    public void testDDLTableLockMode() throws SQLException {
        Statement statement = this.createStatement();
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("create table default_granularity(c1 int)");
        statement.execute("create table row_granularity(c1 int)");
        statement.execute("alter table row_granularity locksize row");
        statement.execute("create table table_granularity(c1 int)");
        statement.execute("alter table table_granularity locksize table");
        ResultSet resultSet = statement.executeQuery("select * from default_granularity with cs");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Statement Name: \n\t" + (this.getTestConfiguration().getJDBCClient().isEmbedded() ? "null\n" : "SQL_CURLH000C2\n") + "Statement Text: \n\tselect * from default_granularity with cs\nParse Time: 0\nBind Time: 0\nOptimize Time: 0\nGenerate Time: 0\nCompile Time: 0\nExecute Time: 0\nBegin Compilation Timestamp : null\nEnd Compilation Timestamp : null\nBegin Execution Timestamp : null\nEnd Execution Timestamp : null\nStatement Execution Plan Text: \nTable Scan ResultSet for DEFAULT_GRANULARITY at read committed isolation level using instantaneous share row locking chosen by the optimizer (Actual locking used: table level locking.)\nNumber of opens = 1\nRows seen = 0\nRows filtered = 0\nFetch Size = 16\n\tconstructor time (milliseconds) = 0\n\topen time (milliseconds) = 0\n\tnext time (milliseconds) = 0\n\tclose time (milliseconds) = 0\n\nscan information:\n\tBit set of columns fetched=All\n\tNumber of columns fetched=1\n\tNumber of pages visited=1\n\tNumber of rows qualified=0\n\tNumber of rows visited=0\n\tScan type=heap\n\tstart position:\n\t\tnull\n\tstop position:\n\t\tnull\n\tqualifiers:\n\t\tNone\n\toptimizer estimated row count: 6.00\n\toptimizer estimated cost: 100.40"}});
        resultSet = statement.executeQuery("select * from default_granularity with rr");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Statement Name: \n\t" + (this.getTestConfiguration().getJDBCClient().isEmbedded() ? "null\n" : "SQL_CURLH000C2\n") + "Statement Text: \n\tselect * from default_granularity with rr\nParse Time: 0\nBind Time: 0\nOptimize Time: 0\nGenerate Time: 0\nCompile Time: 0\nExecute Time: 0\nBegin Compilation Timestamp : null\nEnd Compilation Timestamp : null\nBegin Execution Timestamp : null\nEnd Execution Timestamp : null\nStatement Execution Plan Text: \nTable Scan ResultSet for DEFAULT_GRANULARITY at serializable isolation level using share table locking chosen by the optimizer\nNumber of opens = 1\nRows seen = 0\nRows filtered = 0\nFetch Size = 16\n\tconstructor time (milliseconds) = 0\n\topen time (milliseconds) = 0\n\tnext time (milliseconds) = 0\n\tclose time (milliseconds) = 0\n\nscan information:\n\tBit set of columns fetched=All\n\tNumber of columns fetched=1\n\tNumber of pages visited=1\n\tNumber of rows qualified=0\n\tNumber of rows visited=0\n\tScan type=heap\n\tstart position:\n\t\tnull\n\tstop position:\n\t\tnull\n\tqualifiers:\n\t\tNone\n\toptimizer estimated row count: 6.00\n\toptimizer estimated cost: 100.40"}});
        resultSet = statement.executeQuery("select * from default_granularity with cs");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Statement Name: \n\t" + (this.getTestConfiguration().getJDBCClient().isEmbedded() ? "null\n" : "SQL_CURLH000C2\n") + "Statement Text: \n\tselect * from default_granularity with cs\nParse Time: 0\nBind Time: 0\nOptimize Time: 0\nGenerate Time: 0\nCompile Time: 0\nExecute Time: 0\nBegin Compilation Timestamp : null\nEnd Compilation Timestamp : null\nBegin Execution Timestamp : null\nEnd Execution Timestamp : null\nStatement Execution Plan Text: \nTable Scan ResultSet for DEFAULT_GRANULARITY at read committed isolation level using instantaneous share row locking chosen by the optimizer (Actual locking used: table level locking.)\nNumber of opens = 1\nRows seen = 0\nRows filtered = 0\nFetch Size = 16\n\tconstructor time (milliseconds) = 0\n\topen time (milliseconds) = 0\n\tnext time (milliseconds) = 0\n\tclose time (milliseconds) = 0\n\nscan information:\n\tBit set of columns fetched=All\n\tNumber of columns fetched=1\n\tNumber of pages visited=1\n\tNumber of rows qualified=0\n\tNumber of rows visited=0\n\tScan type=heap\n\tstart position:\n\t\tnull\n\tstop position:\n\t\tnull\n\tqualifiers:\n\t\tNone\n\toptimizer estimated row count: 6.00\n\toptimizer estimated cost: 100.40"}});
        resultSet = statement.executeQuery("select * from row_granularity with rr");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Statement Name: \n\t" + (this.getTestConfiguration().getJDBCClient().isEmbedded() ? "null\n" : "SQL_CURLH000C2\n") + "Statement Text: \n\tselect * from row_granularity with rr\nParse Time: 0\nBind Time: 0\nOptimize Time: 0\nGenerate Time: 0\nCompile Time: 0\nExecute Time: 0\nBegin Compilation Timestamp : null\nEnd Compilation Timestamp : null\nBegin Execution Timestamp : null\nEnd Execution Timestamp : null\nStatement Execution Plan Text: \nTable Scan ResultSet for ROW_GRANULARITY at serializable isolation level using share table locking chosen by the optimizer\nNumber of opens = 1\nRows seen = 0\nRows filtered = 0\nFetch Size = 16\n\tconstructor time (milliseconds) = 0\n\topen time (milliseconds) = 0\n\tnext time (milliseconds) = 0\n\tclose time (milliseconds) = 0\n\nscan information:\n\tBit set of columns fetched=All\n\tNumber of columns fetched=1\n\tNumber of pages visited=1\n\tNumber of rows qualified=0\n\tNumber of rows visited=0\n\tScan type=heap\n\tstart position:\n\t\tnull\n\tstop position:\n\t\tnull\n\tqualifiers:\n\t\tNone\n\toptimizer estimated row count: 6.00\n\toptimizer estimated cost: 100.40"}});
        resultSet = statement.executeQuery("select * from table_granularity with cs");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Statement Name: \n\t" + (this.getTestConfiguration().getJDBCClient().isEmbedded() ? "null\n" : "SQL_CURLH000C2\n") + "Statement Text: \n\tselect * from table_granularity with cs\nParse Time: 0\nBind Time: 0\nOptimize Time: 0\nGenerate Time: 0\nCompile Time: 0\nExecute Time: 0\nBegin Compilation Timestamp : null\nEnd Compilation Timestamp : null\nBegin Execution Timestamp : null\nEnd Execution Timestamp : null\nStatement Execution Plan Text: \nTable Scan ResultSet for TABLE_GRANULARITY at read committed isolation level using instantaneous share table locking chosen by the optimizer\nNumber of opens = 1\nRows seen = 0\nRows filtered = 0\nFetch Size = 16\n\tconstructor time (milliseconds) = 0\n\topen time (milliseconds) = 0\n\tnext time (milliseconds) = 0\n\tclose time (milliseconds) = 0\n\nscan information:\n\tBit set of columns fetched=All\n\tNumber of columns fetched=1\n\tNumber of pages visited=1\n\tNumber of rows qualified=0\n\tNumber of rows visited=0\n\tScan type=heap\n\tstart position:\n\t\tnull\n\tstop position:\n\t\tnull\n\tqualifiers:\n\t\tNone\n\toptimizer estimated row count: 6.00\n\toptimizer estimated cost: 100.40"}});
        resultSet = statement.executeQuery("select * from table_granularity with rr");
        JDBC.assertEmpty(resultSet);
        resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_RUNTIMESTATISTICS()");
        JDBC.assertFullResultSet(resultSet, new String[][]{{"Statement Name: \n\t" + (this.getTestConfiguration().getJDBCClient().isEmbedded() ? "null\n" : "SQL_CURLH000C2\n") + "Statement Text: \n\tselect * from table_granularity with rr\nParse Time: 0\nBind Time: 0\nOptimize Time: 0\nGenerate Time: 0\nCompile Time: 0\nExecute Time: 0\nBegin Compilation Timestamp : null\nEnd Compilation Timestamp : null\nBegin Execution Timestamp : null\nEnd Execution Timestamp : null\nStatement Execution Plan Text: \nTable Scan ResultSet for TABLE_GRANULARITY at serializable isolation level using share table locking chosen by the optimizer\nNumber of opens = 1\nRows seen = 0\nRows filtered = 0\nFetch Size = 16\n\tconstructor time (milliseconds) = 0\n\topen time (milliseconds) = 0\n\tnext time (milliseconds) = 0\n\tclose time (milliseconds) = 0\n\nscan information:\n\tBit set of columns fetched=All\n\tNumber of columns fetched=1\n\tNumber of pages visited=1\n\tNumber of rows qualified=0\n\tNumber of rows visited=0\n\tScan type=heap\n\tstart position:\n\t\tnull\n\tstop position:\n\t\tnull\n\tqualifiers:\n\t\tNone\n\toptimizer estimated row count: 6.00\n\toptimizer estimated cost: 100.40"}});
        statement.close();
        this.rollback();
    }
}

