/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memory;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Properties;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetStream;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobMemTest
extends BaseJDBCTestCase {
    private static final int LONG_BLOB_LENGTH = 18000000;
    private static final String LONG_BLOB_LENGTH_STRING = "18000000";
    private static final byte[] SHORT_BLOB_BYTES = new byte[]{1, 2, 3};

    public BlobMemTest(String string) {
        super(string);
    }

    private void testBlobLength(boolean bl, int n) throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        int n2;
        Object object;
        Object object2;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.executeUpdate("CREATE TABLE BLOBTAB (K INT CONSTRAINT PK PRIMARY KEY, B BLOB(18000000))");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO BLOBTAB VALUES(?,?)");
        preparedStatement.setInt(1, 1);
        int n3 = 18000000 + n;
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(n3);
        if (bl) {
            object2 = null;
            try {
                object = preparedStatement.getClass();
                object2 = ((Class)object).getMethod("setBinaryStream", Integer.TYPE, InputStream.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                BlobMemTest.println("Skipping lengthless insert because method is not available");
                return;
            }
            ((Method)object2).invoke((Object)preparedStatement, 2, loopingAlphabetStream);
        } else {
            preparedStatement.setBinaryStream(2, (InputStream)loopingAlphabetStream, n3);
        }
        if (n != 0) {
            try {
                preparedStatement.executeUpdate();
                BlobMemTest.fail((String)"Expected truncation error for blob too large");
            }
            catch (SQLException sQLException) {
                BlobMemTest.assertSQLState("Wrong SQL State for truncation", "22001", sQLException);
            }
            return;
        }
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 2);
        preparedStatement.setBytes(2, new byte[0]);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 3);
        preparedStatement.setBytes(2, null);
        preparedStatement.executeUpdate();
        preparedStatement.setInt(1, 4);
        preparedStatement.setBytes(2, SHORT_BLOB_BYTES);
        preparedStatement.executeUpdate();
        object2 = statement.executeQuery("SELECT K, LENGTH(B), B FROM BLOBTAB-- DERBY-PROPERTIES constraint=pk\n ORDER BY K");
        object2.next();
        BlobMemTest.assertEquals((String)LONG_BLOB_LENGTH_STRING, (String)object2.getString(2));
        object = object2.getBinaryStream(3);
        int n4 = 0;
        byte[] byArray = new byte[32672];
        while ((n2 = ((InputStream)object).read(byArray)) != -1) {
            int n5 = ((n4 += n2) - 1) % 26 + 97;
            if (n2 == 0) continue;
            BlobMemTest.assertEquals((int)n5, (int)byArray[n2 - 1]);
        }
        BlobMemTest.assertEquals((int)18000000, (int)n4);
        object2.next();
        BlobMemTest.assertEquals((String)"0", (String)object2.getString(2));
        byte[] byArray2 = object2.getBytes(3);
        BlobMemTest.assertEquals((int)0, (int)byArray2.length);
        object2.next();
        BlobMemTest.assertEquals(null, (String)object2.getString(2));
        byArray2 = object2.getBytes(3);
        BlobMemTest.assertEquals(null, byArray2);
        object2.next();
        BlobMemTest.assertEquals((String)"3", (String)object2.getString(2));
        byArray2 = object2.getBytes(3);
        BlobMemTest.assertTrue((boolean)Arrays.equals(SHORT_BLOB_BYTES, byArray2));
        object2.close();
        object2 = statement.executeQuery("SELECT K, LENGTH(B)  FROM BLOBTAB ORDER BY K");
        JDBC.assertFullResultSet((ResultSet)object2, new String[][]{{"1", LONG_BLOB_LENGTH_STRING}, {"2", "0"}, {"3", null}, {"4", "3"}});
    }

    public void testBlobLength() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(false, 0);
    }

    public void testBlobLengthWithLengthlessInsert() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(true, 0);
    }

    public void testBlobLengthTooLongDerby961() throws SQLException, IOException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        this.testBlobLength(false, 10000);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite();
        baseTestSuite.addTest((Test)new BlobMemTest("xtestderby6096BlobhashJoin"));
        baseTestSuite.addTest(TestConfiguration.defaultSuite(BlobMemTest.class));
        Properties properties = new Properties();
        properties.setProperty("derby.storage.pageCacheSize", "100");
        return new SystemPropertyTestSetup((Test)baseTestSuite, properties);
    }

    public void testDerby4477_3645_3646_Repro_lowmem() throws SQLException, IOException {
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        int n = 18000000;
        statement.executeUpdate("CREATE TABLE T_MAIN(ID INT  GENERATED ALWAYS AS IDENTITY PRIMARY KEY, V BLOB(" + n + ") )");
        PreparedStatement preparedStatement = this.prepareStatement("INSERT INTO T_MAIN(V) VALUES (?)");
        int n2 = n;
        LoopingAlphabetStream loopingAlphabetStream = new LoopingAlphabetStream(n2);
        preparedStatement.setBinaryStream(1, (InputStream)loopingAlphabetStream, n2);
        preparedStatement.executeUpdate();
        preparedStatement.close();
        statement.executeUpdate("CREATE TABLE T_COPY ( V1 BLOB(" + n + "), V2 BLOB(" + n + "))");
        statement.executeUpdate("INSERT INTO T_COPY SELECT  V, V FROM T_MAIN");
        ResultSet resultSet = statement.executeQuery("SELECT * FROM T_COPY");
        resultSet.next();
        InputStream inputStream = resultSet.getBinaryStream(1);
        loopingAlphabetStream.reset();
        BlobMemTest.assertEquals(loopingAlphabetStream, inputStream);
        inputStream = resultSet.getBinaryStream(2);
        loopingAlphabetStream.reset();
        BlobMemTest.assertEquals(loopingAlphabetStream, inputStream);
        resultSet.close();
        resultSet = statement.executeQuery("SELECT 'I', V, ID, V from T_MAIN");
        resultSet.next();
        inputStream = resultSet.getBinaryStream(2);
        loopingAlphabetStream.reset();
        BlobMemTest.assertEquals(loopingAlphabetStream, inputStream);
        inputStream = resultSet.getBinaryStream(4);
        loopingAlphabetStream.reset();
        BlobMemTest.assertEquals(loopingAlphabetStream, inputStream);
        loopingAlphabetStream.close();
        inputStream.close();
        statement.close();
        resultSet.close();
        this.rollback();
    }

    public void testDerby5752DoubleMaterialization() throws Exception {
        int n;
        this.setAutoCommit(false);
        Statement statement = this.createStatement();
        statement.execute("create table d5752(id int, b blob)");
        int n2 = 1000000;
        PreparedStatement preparedStatement = this.prepareStatement("insert into d5752 values (1,?)");
        preparedStatement.setBinaryStream(1, (InputStream)new LoopingAlphabetStream(n2), n2);
        preparedStatement.execute();
        this.closeStatement(preparedStatement);
        Blob[] blobArray = new Blob[15];
        for (n = 0; n < blobArray.length; ++n) {
            ResultSet resultSet = statement.executeQuery("select * from d5752 order by id");
            resultSet.next();
            blobArray[n] = resultSet.getBlob(2);
            resultSet.close();
        }
        for (n = 0; n < blobArray.length; ++n) {
            BlobMemTest.assertEquals((long)n2, (long)blobArray[n].length());
        }
    }

    public void xtestderby6096BlobhashJoin() throws SQLException {
        byte[] byArray = new byte[32000];
        Arrays.fill(byArray, (byte)97);
        Statement statement = this.createStatement();
        statement.execute("create table d6096(i int, b blob)");
        PreparedStatement preparedStatement = this.prepareStatement("insert into d6096 values (?, ?)");
        preparedStatement.setBytes(2, byArray);
        for (int i = 0; i < 2000; ++i) {
            preparedStatement.setInt(1, i);
            preparedStatement.execute();
        }
        ResultSet resultSet = statement.executeQuery("select * from d6096 t1, d6096 t2 where t1.i=t2.i");
        BlobMemTest.assertTrue((boolean)resultSet.next());
        if (TestConfiguration.getCurrent().isVerbose()) {
            System.gc();
            BlobMemTest.println("TotalMemory:" + Runtime.getRuntime().totalMemory() + " Free Memory:" + Runtime.getRuntime().freeMemory());
        }
        resultSet.close();
    }
}

