/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ConglomerateSharingTest
extends BaseJDBCTestCase {
    private final String COUNT_TABLE_CONGLOMS = "select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)";
    private final String GET_CONSTRAINT_NAMES = "select constraintname from sys.sysconstraints where tableid = (select tableid from sys.systables where tablename = ?)";

    public ConglomerateSharingTest(String string) {
        super(string);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(ConglomerateSharingTest.class));
    }

    public void testConversionToNonUnique() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)");
        Statement statement = this.createStatement();
        statement.execute("create table orders (no_w_id int not null, no_d_id int not null, no_o_id int not null, info varchar(20), constraint orders_pk primary key (no_w_id, no_d_id, no_o_id))");
        statement.execute("insert into orders values (1, 2, 3, 'info # one')");
        statement.execute("insert into orders values (1, 2, 4, 'info # two')");
        statement.execute("insert into orders values (1, 2, 5, 'info # 3')");
        statement.execute("create table neworders (no_w_id int not null, no_d_id int not null, no_o_id int not null, lname varchar(50))");
        statement.execute("alter table neworders add constraint neworders_pk primary key (no_w_id, no_d_id, no_o_id)");
        statement.execute("alter table neworders add constraint no_o_fk foreign key (no_w_id, no_d_id, no_o_id) references orders");
        statement.execute("insert into neworders values (1, 2, 3, 'Inigo')");
        statement.execute("insert into neworders values (1, 2, 4, 'Montoya')");
        statement.execute("insert into neworders values (1, 2, 5, 'Tortuga')");
        this.countConglomerates("NEWORDERS", preparedStatement, 2);
        this.checkStatementError("23503", statement, "insert into neworders values (1, 3, 5, 'SHOULD FAIL')", "NO_O_FK");
        this.checkStatementError("23505", statement, "insert into neworders values (1, 2, 4, 'SHOULD FAIL')", "NEWORDERS_PK");
        statement.execute("alter table neworders drop constraint neworders_pk");
        this.countConglomerates("NEWORDERS", preparedStatement, 2);
        this.checkStatementError("23503", statement, "insert into neworders values (1, 3, 5, 'SHOULD FAIL')", "NO_O_FK");
        statement.execute("insert into neworders values (1, 2, 4, 'SHOULD SUCCEED')");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from neworders"), new String[][]{{"1", "2", "3", "Inigo"}, {"1", "2", "4", "Montoya"}, {"1", "2", "5", "Tortuga"}, {"1", "2", "4", "SHOULD SUCCEED"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from neworders --DERBY-PROPERTIES constraint=NO_O_FK"), new String[][]{{"1", "2", "3", "Inigo"}, {"1", "2", "4", "Montoya"}, {"1", "2", "5", "Tortuga"}, {"1", "2", "4", "SHOULD SUCCEED"}});
        statement.execute("drop table neworders");
        statement.execute("drop table orders");
        this.countConglomerates("NEWORDERS", preparedStatement, 0);
        preparedStatement.close();
        statement.close();
    }

    public void testConstraintDrops() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("select constraintname from sys.sysconstraints where tableid = (select tableid from sys.systables where tablename = ?)");
        Statement statement = this.createStatement();
        statement.execute("create table dropc_t0 (i int not null, j int not null)");
        statement.execute("alter table dropc_t0 add constraint dropc_pk0 primary key (i,j)");
        this.countConglomerates("DROPC_T0", preparedStatement, 2);
        statement.execute("create table dropc_t1 (i int, j int not null)");
        statement.execute("alter table dropc_t1 add constraint dropc_pk1 primary key (j)");
        this.countConglomerates("DROPC_T1", preparedStatement, 2);
        statement.execute("create table dropc_t2 (a int, b int not null, c int not null)");
        statement.execute("create index dropc_ix1 on dropc_t2 (a,b)");
        statement.execute("create unique index dropc_uix2 on dropc_t2 (c)");
        statement.execute("alter table dropc_t2 add constraint dropc_uc1 unique (c)");
        statement.execute("alter table dropc_t2 add constraint dropc_fk0 foreign key (a,b) references dropc_t0");
        statement.execute("alter table dropc_t2 add constraint dropc_fk1 foreign key (a,b) references dropc_t0");
        statement.execute("alter table dropc_t2 add constraint dropc_fk2 foreign key (c) references dropc_t1");
        this.countConglomerates("DROPC_T2", preparedStatement, 3);
        statement.execute("insert into dropc_t0 values (1, 2)");
        statement.execute("insert into dropc_t1 values (3, 4)");
        statement.execute("insert into dropc_t2 values (1, 2, 4)");
        statement.execute("alter table DROPC_T2 drop constraint DROPC_FK0");
        this.countConglomerates("DROPC_T2", preparedStatement, 3);
        this.verifyConstraints(statement, preparedStatement2, "DROPC_T2", "DROPC_FK0", new String[][]{{"DROPC_FK1"}, {"DROPC_FK2"}, {"DROPC_UC1"}}, 1);
        this.checkStatementError("23505", statement, "insert into dropc_t2 values (1, 2, 4)", "DROPC_UIX2", "DROPC_UC1", "DROPC_FK2");
        this.checkStatementError("23503", statement, "insert into dropc_t2 values (2, 2, 4)", "DROPC_FK1");
        this.checkStatementError("23503", statement, "insert into dropc_t2 values (1, 2, 3)", "DROPC_FK2");
        statement.execute("alter table DROPC_T2 drop constraint DROPC_UC1");
        this.countConglomerates("DROPC_T2", preparedStatement, 3);
        this.verifyConstraints(statement, preparedStatement2, "DROPC_T2", "DROPC_UC1", new String[][]{{"DROPC_FK1"}, {"DROPC_FK2"}}, 1);
        this.checkStatementError("23505", statement, "insert into dropc_t2 values (1, 2, 4)", "DROPC_UIX2", "DROPC_FK2");
        this.checkStatementError("23503", statement, "insert into dropc_t2 values (2, 2, 4)", "DROPC_FK1");
        this.checkStatementError("23503", statement, "insert into dropc_t2 values (1, 2, 3)", "DROPC_FK2");
        statement.execute("drop index dropc_uix2");
        this.countConglomerates("DROPC_T2", preparedStatement, 3);
        this.verifyConstraints(statement, preparedStatement2, "DROPC_T2", null, new String[][]{{"DROPC_FK1"}, {"DROPC_FK2"}}, 1);
        this.checkStatementError("23503", statement, "insert into dropc_t2 values (2, 2, 4)", "DROPC_FK1");
        this.checkStatementError("23503", statement, "insert into dropc_t2 values (1, 2, 3)", "DROPC_FK2");
        statement.execute("insert into dropc_t2 values (1, 2, 4)");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select * from dropc_t2"), new String[][]{{"1", "2", "4"}, {"1", "2", "4"}});
        statement.execute("delete from dropc_t2");
        statement.execute("insert into dropc_t2 values (1, 2, 4)");
        statement.execute("alter table dropc_t2 drop constraint dropc_fk2");
        this.countConglomerates("DROPC_T2", preparedStatement, 2);
        statement.execute("alter table dropc_t2 add constraint dropc_uc1 unique (c)");
        statement.execute("alter table dropc_t2 add constraint dropc_fk2 foreign key (c) references dropc_t1");
        statement.execute("create unique index dropc_uix3 on dropc_t2 (a, c)");
        this.countConglomerates("DROPC_T2", preparedStatement, 4);
        statement.execute("alter table dropc_t2 drop column c");
        this.countConglomerates("DROPC_T2", preparedStatement, 2);
        this.verifyConstraints(statement, preparedStatement2, "DROPC_T2", "DROPC_FK2", new String[][]{{"DROPC_FK1"}}, 1);
        this.checkStatementError("23503", statement, "insert into dropc_t2 values (2, 2)", "DROPC_FK1");
        statement.execute("delete from dropc_t2");
        statement.execute("alter table dropc_t2 add constraint dropc_uc2 unique (b)");
        statement.execute("alter table dropc_t2 add constraint dropc_fk3 foreign key (b) references dropc_t1");
        this.countConglomerates("DROPC_T2", preparedStatement, 3);
        statement.execute("drop table dropc_t2");
        this.countConglomerates("DROPC_T2", preparedStatement, 0);
        ConglomerateSharingTest.assertStatementError("42X05", statement, "select * from dropc_t2");
        statement.execute("drop table dropc_t1");
        statement.execute("drop table dropc_t0");
        preparedStatement2.close();
        preparedStatement.close();
        statement.close();
    }

    public void testUniqueConstraintWithNullsBackingIndex() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select count (distinct conglomeratenumber) from sys.sysconglomerates where tableid =  (select tableid from sys.systables where tablename = ?)");
        Statement statement = this.createStatement();
        statement.execute("create table t1 (i int, j int not null, k int)");
        statement.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        statement.executeUpdate("create index nuix on t1(i,j)");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("insert into t1 values (null, 1, -1)");
        statement.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", preparedStatement, 3);
        statement.executeUpdate("insert into t1 values (null, 1, -1)");
        statement.executeUpdate("insert into t1 values (null, 1, -1)");
        ConglomerateSharingTest.assertStatementError("23505", statement, "insert into t1 values (1, -1, 1)");
        statement.executeUpdate("delete from t1");
        statement.executeUpdate("drop index nuix");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("alter table t1 drop constraint uc");
        this.countConglomerates("T1", preparedStatement, 1);
        statement.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        statement.executeUpdate("create unique index uix on t1(i,j)");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("insert into t1 values (null, 1, -1)");
        statement.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", preparedStatement, 2);
        ConglomerateSharingTest.assertStatementError("23505", statement, "insert into t1 values (null, 1, -1)");
        statement.executeUpdate("drop index uix");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("insert into t1 values (null, 1, -1)");
        statement.executeUpdate("alter table t1 drop constraint uc");
        statement.executeUpdate("delete from t1");
        this.countConglomerates("T1", preparedStatement, 1);
        statement.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        statement.executeUpdate("insert into t1 values (null, 1, -1)");
        statement.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("create table t2 (a int not null, b int not null)");
        statement.executeUpdate("alter table t2 add constraint pkt2 primary key(a,b)");
        this.countConglomerates("T2", preparedStatement, 2);
        statement.executeUpdate("insert into t2 values (1, -1), (2, -2), (4, -4), (3, -3)");
        statement.executeUpdate("alter table t1 add constraint fkt1 foreign key (i,j) references t2");
        this.countConglomerates("T1", preparedStatement, 2);
        ConglomerateSharingTest.assertStatementError("23505", statement, "insert into t1(i,j) values (1, -1)");
        statement.executeUpdate("alter table t1 drop constraint uc");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("insert into t1(i,j) values (1, -1)");
        statement.executeUpdate("alter table t1 drop constraint fkt1");
        statement.executeUpdate("alter table t2 drop constraint pkt2");
        statement.executeUpdate("delete from t1");
        statement.executeUpdate("delete from t2");
        this.countConglomerates("T1", preparedStatement, 1);
        this.countConglomerates("T2", preparedStatement, 1);
        statement.executeUpdate("insert into t1 values (1, -1, 1), (2, -2, 4), (4, -4, 16), (3, -3, 9)");
        statement.executeUpdate("alter table t2 add constraint pkt2 primary key(a,b)");
        this.countConglomerates("T2", preparedStatement, 2);
        statement.executeUpdate("insert into t2 values (1, -1), (2, -2),(4, -4), (3, -3)");
        statement.executeUpdate("create unique index uix on t1(i,j)");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("alter table t1 add constraint uc unique(i,j)");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("alter table t1 add constraint fkt1 foreign key (i,j) references t2");
        this.countConglomerates("T1", preparedStatement, 2);
        ConglomerateSharingTest.assertStatementError("23505", statement, "insert into t1(i,j) values (1, -1)");
        statement.executeUpdate("drop index uix");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("insert into t1(i,j) values (null, 2)");
        statement.executeUpdate("insert into t1(i,j) values (null, 2)");
        ConglomerateSharingTest.assertStatementError("23505", statement, "insert into t1 values (1, -1, 1)");
        statement.executeUpdate("alter table t1 drop constraint uc");
        this.countConglomerates("T1", preparedStatement, 2);
        statement.executeUpdate("insert into t1 values (1, -1, 1)");
        statement.executeUpdate("drop table t1");
        statement.executeUpdate("drop table t2");
        statement.close();
        preparedStatement.close();
    }

    private void countConglomerates(String string, PreparedStatement preparedStatement, int n) throws SQLException {
        preparedStatement.setString(1, string);
        JDBC.assertSingleValueResultSet(preparedStatement.executeQuery(), String.valueOf(n));
    }

    private void checkStatementError(String string, Statement statement, String string2, String ... stringArray) throws SQLException {
        block3: {
            try {
                statement.execute(string2);
                ConglomerateSharingTest.fail((String)("Expected error '" + string + "' when executing a statement, but no error was thrown."));
            }
            catch (SQLException sQLException) {
                ConglomerateSharingTest.assertSQLState(string, sQLException);
                boolean bl = false;
                for (String string3 : stringArray) {
                    if (!sQLException.getMessage().contains(string3)) continue;
                    bl = true;
                    break;
                }
                if (bl) break block3;
                ConglomerateSharingTest.fail("Error " + string + " should have been caused by one of the following indexes/constraints " + Arrays.toString(stringArray) + ", but none of them appeared in the error message.", sQLException);
            }
        }
    }

    private void verifyConstraints(Statement statement, PreparedStatement preparedStatement, String string, String string2, String[][] stringArray, int n) throws SQLException {
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (stringArray == null) {
            JDBC.assertEmpty(resultSet);
        } else {
            JDBC.assertUnorderedResultSet(resultSet, stringArray);
        }
        String string3 = "select * from " + string + " --DERBY-PROPERTIES constraint=";
        if (string2 != null) {
            ConglomerateSharingTest.assertStatementError("42Y48", statement, string3 + string2);
        }
        JDBC.assertDrainResults(statement.executeQuery("select * from " + string), n);
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            JDBC.assertDrainResults(statement.executeQuery(string3 + stringArray[i][0]), n);
        }
    }
}

