/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationRun;
import org.apache.derbyTesting.junit.BaseTestSuite;

public class ReplicationRun_Local_StateTest_part2
extends ReplicationRun {
    public ReplicationRun_Local_StateTest_part2(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = new BaseTestSuite("ReplicationRun_Local_StateTest_part2 Suite");
        baseTestSuite.addTestSuite(ReplicationRun_Local_StateTest_part2.class);
        return baseTestSuite;
    }

    public void testReplication_Local_StateTest_part2() throws Exception {
        this.cleanAllTestHosts();
        this.initEnvironment();
        this.initMaster(masterServerHost, replicatedDb);
        this.startServer(masterJvmVersion, derbyMasterVersion, masterServerHost, "0.0.0.0", masterServerPort, masterDbSubPath);
        this.startServer(slaveJvmVersion, derbySlaveVersion, slaveServerHost, "0.0.0.0", slaveServerPort, slaveDbSubPath);
        this.startServerMonitor(slaveServerHost);
        this.bootMasterDatabase(jvmVersion, masterDatabasePath + FS + masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, null);
        this.initSlave(slaveServerHost, jvmVersion, replicatedDb);
        this.startSlave(jvmVersion, replicatedDb, slaveServerHost, slaveServerPort, slaveServerHost, slaveReplPort, testClientHost);
        this.startMaster(jvmVersion, replicatedDb, masterServerHost, masterServerPort, masterServerHost, slaveServerPort, slaveServerHost, slaveReplPort);
        replicationTest = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun";
        this.util.DEBUG("replicationTest: " + replicationTest);
        replicationVerify = "org.apache.derbyTesting.functionTests.tests.replicationTests.ReplicationTestRun_Verify";
        this.util.DEBUG("replicationVerify: " + replicationVerify);
        this.runTest(replicationTest, jvmVersion, testClientHost, masterServerHost, masterServerPort, replicatedDb);
        Connection connection = this.getConnection(masterServerHost, masterServerPort, masterDatabasePath, masterDbSubPath, replicatedDb);
        this.failOver(jvmVersion, masterDatabasePath, masterDbSubPath, replicatedDb, masterServerHost, masterServerPort, testClientHost);
        this.connectPing(slaveDatabasePath + FS + slaveDbSubPath + FS + replicatedDb, slaveServerHost, slaveServerPort, testClientHost);
        this.verifySlave();
        this.verifyMaster();
        this._testPreStoppedSlave(connection);
        this.shutdownDb(jvmVersion, slaveServerHost, slaveServerPort, slaveDatabasePath + FS + slaveDbSubPath, replicatedDb, testClientHost);
        this._testPostStoppedSlave();
        this.stopServer(jvmVersion, derbyVersion, slaveServerHost, slaveServerPort);
        this._testPostStoppedSlaveServer();
        this.shutdownDb(jvmVersion, masterServerHost, masterServerPort, masterDatabasePath + FS + masterDbSubPath, replicatedDb, testClientHost);
        this._testPostStoppedMaster();
        this.stopServer(jvmVersion, derbyVersion, masterServerHost, masterServerPort);
        this._testPostStoppedServer();
    }

    private void _testPreStoppedSlave(Connection connection) throws Exception {
        this.util.DEBUG("_testPreStoppedSlave");
        this.assertException(this._startSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, slaveReplPort), "XRE09");
        this.assertException(this.stopSlave(slaveServerHost, slaveServerPort, slaveDatabasePath, replicatedDb, true), "XRE40");
        this.assertException(this._failOver(slaveServerHost, slaveServerPort, slaveDatabasePath, slaveDbSubPath, replicatedDb), "XRE07");
        this.assertException(this._startMaster(masterServerHost, masterServerPort, masterDatabasePath, replicatedDb, slaveServerHost, slaveReplPort), "XRE04");
        this.assertException(this._failOver(masterServerHost, masterServerPort, masterDatabasePath, masterDbSubPath, replicatedDb), "XRE07");
        this.assertException(this._executeQuery(connection, "select count(*) from SYS.SYSTABLES"), "08006");
        this.assertException(this._executeQuery(connection, "select count(*) from SYS.SYSTABLES"), "08003");
        Connection connection2 = this.getConnection(slaveServerHost, slaveServerPort, slaveDatabasePath, slaveDbSubPath, replicatedDb);
        this.assertException(this._executeQuery(connection2, "select count(*) from SYS.SYSTABLES"), null);
        connection2.close();
    }

    private void _testPostStoppedSlave() {
        this.util.DEBUG("_testPostStoppedSlave");
        this.util.DEBUG("_testPostStoppedSlave Not yet implemented. No value-adding suggestions here exept that calling startSlave should hang now.");
    }

    private void _testPostStoppedSlaveServer() {
        this.util.DEBUG("_testPostStoppedSlaveServer Not yet implemented. No value-adding suggestions here.");
    }

    private void _testPostStoppedMaster() {
        this.util.DEBUG("_testPostStoppedMaster Not yet implemented.No value-adding suggestions here since the stopMaster method will not do anything when called after failover");
    }

    private void _testPostStoppedServer() {
        this.util.DEBUG("_testPostStoppedServer Not yet implemented. No value-adding suggestions here.");
    }

    SQLException _startSlave(String string, int n, String string2, String string3, int n2) {
        String string4 = string2 + FS + ReplicationRun.slaveDbSubPath + FS + string3;
        String string5 = "jdbc:derby://" + string + ":" + n + "/" + string4 + ";startSlave=true;slaveHost=" + string + ";slavePort=" + n2;
        this.util.DEBUG(string5);
        try {
            Connection connection = DriverManager.getConnection(string5);
            this.util.DEBUG("startSlave Unexpectedly connected as: " + string5);
            return new SQLException("startSlave Unexpectedly connected");
        }
        catch (SQLException sQLException) {
            return sQLException;
        }
    }

    SQLException _failOver(String string, int n, String string2, String string3, String string4) {
        String string5 = string2 + FS + string3 + FS + string4;
        String string6 = "jdbc:derby://" + string + ":" + n + "/" + string5 + ";failover=true";
        this.util.DEBUG(string6);
        try {
            Connection connection = DriverManager.getConnection(string6);
            this.util.DEBUG("failOver Unexpectedly connected as: " + string6);
            return new SQLException("failOver Unexpectedly connected");
        }
        catch (SQLException sQLException) {
            return sQLException;
        }
    }

    SQLException _startMaster(String string, int n, String string2, String string3, String string4, int n2) {
        String string5 = string2 + FS + ReplicationRun.masterDbSubPath + FS + string3;
        String string6 = "jdbc:derby://" + string + ":" + n + "/" + string5 + ";startMaster=true;slaveHost=" + string4 + ";slavePort=" + n2;
        this.util.DEBUG(string6);
        try {
            Connection connection = DriverManager.getConnection(string6);
            this.util.DEBUG("startMaster Unexpectedly connected as: " + string6);
            return new SQLException("startMaster Unexpectedly connected");
        }
        catch (SQLException sQLException) {
            return sQLException;
        }
    }

    SQLException connectTo(String string, int n, String string2, String string3, String string4) {
        String string5 = string2 + FS + string3 + FS + string4;
        String string6 = "jdbc:derby://" + string + ":" + n + "/" + string5;
        this.util.DEBUG(string6);
        try {
            Connection connection = DriverManager.getConnection(string6);
            this.util.DEBUG("connectTo Unexpectedly connected as: " + string6);
            return new SQLException("connectTo Unexpectedly connected");
        }
        catch (SQLException sQLException) {
            return sQLException;
        }
    }

    SQLException _executeQuery(Connection connection, String string) {
        this.util.DEBUG("executeQuery: " + string);
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            return null;
        }
        catch (SQLException sQLException) {
            return sQLException;
        }
    }
}

