/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.log;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.services.io.FormatIdUtil;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.RePreparable;
import org.apache.derby.iapi.store.raw.Undoable;
import org.apache.derby.iapi.store.raw.xact.TransactionId;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class LogRecord
implements Formatable {
    private TransactionId xactId;
    private Loggable op;
    private int group;
    transient ObjectInput input;
    private static final int formatLength = FormatIdUtil.getFormatIdByteLength(129);

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        CompressedNumber.writeInt(out, this.group);
        out.writeObject(this.xactId);
        out.writeObject(this.op);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.group = CompressedNumber.readInt(in);
        this.input = in;
        this.xactId = null;
        this.op = null;
    }

    @Override
    public int getTypeFormatId() {
        return 129;
    }

    public void setValue(TransactionId xactId, Loggable op) {
        this.xactId = xactId;
        this.op = op;
        this.group = op.group();
    }

    public static int formatOverhead() {
        return formatLength;
    }

    public static int maxGroupStoredSize() {
        return 4;
    }

    public static int maxTransactionIdStoredSize(TransactionId tranId) {
        return tranId.getMaxStoredSize();
    }

    public static int getStoredSize(int group, TransactionId xactId) {
        SanityManager.ASSERT(xactId == null, "size calculation are based on xactId being  null");
        return formatLength + CompressedNumber.sizeInt(group) + FormatIdUtil.getFormatIdByteLength(0);
    }

    public TransactionId getTransactionId() throws IOException, ClassNotFoundException {
        if (this.xactId != null) {
            return this.xactId;
        }
        SanityManager.ASSERT(this.input != null, "xactId not objectified but object input is not set");
        Object obj = this.input.readObject();
        SanityManager.ASSERT(obj instanceof TransactionId, "log record not getting expected TransactionId");
        this.xactId = (TransactionId)obj;
        return this.xactId;
    }

    public Loggable getLoggable() throws IOException, ClassNotFoundException {
        Object obj;
        if (this.op != null) {
            return this.op;
        }
        SanityManager.ASSERT(this.input != null, "logop not objectified but object input is not set");
        if (this.xactId == null) {
            this.xactId = (TransactionId)this.input.readObject();
        }
        if (!((obj = this.input.readObject()) instanceof Loggable)) {
            SanityManager.THROWASSERT("log record not getting expected Loggable: got : " + obj.getClass().getName());
        }
        this.op = (Loggable)obj;
        this.input = null;
        return this.op;
    }

    public RePreparable getRePreparable() throws IOException, ClassNotFoundException {
        return (RePreparable)((Object)this.getLoggable());
    }

    public void skipLoggable() throws StandardException {
        if (this.op != null) {
            return;
        }
        try {
            if (this.xactId == null) {
                this.xactId = (TransactionId)this.input.readObject();
            }
            if (this.op == null) {
                this.op = (Loggable)this.input.readObject();
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw StandardException.newException("XSLA3.D", cnfe, new Object[0]);
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSLA3.D", ioe, new Object[0]);
        }
    }

    public Undoable getUndoable() throws IOException, ClassNotFoundException {
        if (this.op == null) {
            this.getLoggable();
        }
        if (this.op instanceof Undoable) {
            return (Undoable)this.op;
        }
        return null;
    }

    public boolean isCLR() {
        return (this.group & 4) != 0;
    }

    public boolean isFirst() {
        return (this.group & 1) != 0;
    }

    public boolean isComplete() {
        return (this.group & 2) != 0;
    }

    public boolean isPrepare() {
        return (this.group & 0x40) != 0;
    }

    public boolean requiresPrepareLocks() {
        return (this.group & 0x80) != 0;
    }

    public boolean isCommit() {
        SanityManager.ASSERT((this.group & 2) == 2, "calling isCommit on log record that is not last");
        SanityManager.ASSERT((this.group & 0x30) != 0, "calling isCommit on log record before commit status is recorded");
        return (this.group & 0x10) != 0;
    }

    public boolean isAbort() {
        SanityManager.ASSERT((this.group & 2) == 2, "calling isAbort on log record that is not last");
        SanityManager.ASSERT((this.group & 0x30) != 0, "calling isAbort on log record before abort status is recorded");
        return (this.group & 0x20) != 0;
    }

    public int group() {
        return this.group;
    }

    public boolean isChecksum() {
        return (this.group & 0x800) != 0;
    }
}

