/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.GlobalTransactionId;
import org.apache.derby.iapi.store.raw.LockingPolicy;
import org.apache.derby.iapi.store.raw.Loggable;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.PageTimeStamp;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.store.raw.data.RawContainerHandle;
import org.apache.derby.iapi.store.raw.xact.RawTransaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_Undoable;
import org.apache.derbyTesting.unitTests.store.T_Util;

public class T_RawStoreFactory
extends T_MultiThreadedIterations {
    protected static final String REC_001 = "McLaren";
    protected static final String REC_002 = "Ferrari";
    protected static final String REC_003 = "Benetton";
    protected static final String REC_004 = "Prost";
    protected static final String REC_005 = "Tyrell";
    protected static final String REC_006 = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
    protected static final String REC_007 = "abcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz";
    protected static final String REC_008 = "z";
    protected static final String REC_009 = "nanonano";
    protected static final String REC_010 = "fuzzbutt";
    protected static final String REC_011 = "mork";
    protected static final String REC_012 = "orson";
    protected static final String REC_013 = "mindy";
    protected static final String REC_014 = "thomas";
    protected static final String REC_015 = "henry";
    protected static final String REC_016 = "gordon";
    protected static final String REC_017 = "mavis";
    protected static final String REC_018 = "fatcontroller";
    protected static final String REC_UNDO = "Lotus";
    protected static final String REC_NULL = "NULL";
    static final FormatableBitSet BS_COL_0 = new FormatableBitSet(1);
    protected static final String SP1 = "savepoint1";
    protected static final String SP2 = "savepoint2";
    private static final String TEST_ROLLBACK_OFF = "derby.RawStore.RollbackTestOff";
    private static boolean testRollbackProperty;
    protected static boolean testRollback;
    protected static RawStoreFactory factory;
    protected static LockFactory lf;
    protected static ContextService contextService;
    protected static UUIDFactory uuidfactory;
    protected T_Util t_util;
    protected int openMode;
    protected boolean logDataForPurges = true;

    public T_RawStoreFactory() {
        BS_COL_0.set(0);
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        super.boot(create, startParams);
        contextService = T_RawStoreFactory.getContextService();
    }

    @Override
    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.store.raw.RawStoreFactory";
    }

    @Override
    protected void setupTest() throws T_Fail {
        String rollbackOff = PropertyUtil.getSystemProperty((String)TEST_ROLLBACK_OFF);
        testRollbackProperty = testRollback = Boolean.valueOf(rollbackOff) == false;
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.startParams.put("derby.__deleteOnCreate", Boolean.TRUE.toString());
        this.startParams = T_Util.setEncryptionParam(this.startParams);
        try {
            factory = (RawStoreFactory)T_RawStoreFactory.createPersistentService(this.getModuleToTestProtocolName(), this.getTestService(), this.startParams);
            if (factory == null) {
                throw T_Fail.testFailMsg(this.getModuleToTestProtocolName() + " service not started.");
            }
            lf = factory.getLockFactory();
            if (lf == null) {
                throw T_Fail.testFailMsg("LockFactory.MODULE not found");
            }
            uuidfactory = T_RawStoreFactory.getMonitor().getUUIDFactory();
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        this.REPORT("testRollback=" + testRollback);
    }

    protected String getTestService() {
        return "rawStoreTest";
    }

    @Override
    protected void joinSetupTest() throws T_Fail {
        T_Fail.T_ASSERT(factory != null, "raw store factory not setup ");
        T_Fail.T_ASSERT(lf != null, "Lock factory not setup ");
        T_Fail.T_ASSERT(contextService != null, "Context service not setup ");
        testRollback = testRollbackProperty;
    }

    @Override
    protected T_MultiThreadedIterations newTestObject() {
        try {
            Class<?> thisClass = this.getClass();
            return (T_MultiThreadedIterations)thisClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException ie) {
            return new T_RawStoreFactory();
        }
        catch (IllegalAccessException iae) {
            return new T_RawStoreFactory();
        }
        catch (NoSuchMethodException iae) {
            return new T_RawStoreFactory();
        }
        catch (InvocationTargetException iae) {
            return new T_RawStoreFactory();
        }
    }

    @Override
    protected void runTestSet() throws T_Fail {
        this.t_util = new T_Util(factory, lf, contextService);
        ContextManager cm1 = contextService.newContextManager();
        contextService.setCurrentContextManager(cm1);
        try {
            this.REPORT("Running tests with no data logged  for purges");
            this.openMode = 0;
            this.runPurgeWithNoDataLoggesTests();
            this.REPORT("Running tests with logging requested");
            this.openMode = 0;
            this.runEachTest();
            this.REPORT("Running tests for temp tables");
            testRollback = false;
            this.runTempTests();
            this.REPORT("Running tests in unlogged mode");
            this.openMode = 3;
            testRollback = false;
            this.runEachTest();
        }
        catch (StandardException se) {
            cm1.cleanupOnError((Throwable)se, false);
            throw T_Fail.exceptionFail(se);
        }
        finally {
            contextService.resetCurrentContextManager(cm1);
        }
    }

    protected void runEachTest() throws T_Fail, StandardException {
        this.t_util.setOpenMode(this.openMode);
        this.T000();
        this.T001();
        this.T002();
        this.T003();
        this.T004();
        this.T005();
        this.T006();
        this.T007();
        this.T008();
        this.T009();
        this.T010();
        this.T011();
        this.T012();
        this.C010(0);
        this.C011();
        this.C012(1L);
        this.C014();
        this.C200();
        this.C201(0);
        this.C201(1);
        this.P001(0L);
        this.P002(0L);
        this.P005(0L);
        this.P006();
        this.P007(0L);
        this.P008(0L);
        this.P009(0L);
        this.P011(0L);
        this.P012(0L);
        this.P013();
        this.P014();
        this.P015();
        this.P016();
        this.P017();
        this.P018();
        this.P019();
        this.P020();
        this.P021();
        this.P022();
        this.P023(0);
        this.P024(0L);
        this.P030(0L);
        this.P031(0L);
        this.P032(0L);
        this.P033(0L);
        this.P034(0L);
        this.P035(0L);
        if ((this.openMode & 1) == 1) {
            this.openMode = 0;
            this.t_util.setOpenMode(this.openMode);
        }
        this.P036();
        this.P037();
        this.P038();
        this.P039();
        this.P040();
        this.P041();
        this.P042();
        this.P043();
        this.P050();
        this.P051();
        this.P053();
        this.P054();
        this.P055(0L);
        this.P056(0L);
        this.P061();
        this.P071();
        this.P701(0L);
        this.P702(0L);
        this.P703(0L);
        this.P704(0L);
        this.P705(0L);
        this.P706(0L, false);
        this.P706(0L, true);
        this.P707(0L);
        this.P708(0L, false);
        this.P708(0L, true);
        this.L001();
        this.CP001();
    }

    protected void runTempTests() throws T_Fail, StandardException {
        this.REPORT("Thread " + this.threadNumber + " entering temp tests ");
        this.openMode = 0;
        this.t_util.setOpenMode(this.openMode);
        this.C010(-1);
        this.C012(-1L);
        this.P005(-1L);
        this.P011(-1L);
        this.P012(-1L);
        this.P030(-1L);
        this.P055(-1L);
        this.P056(-1L);
        this.P701(-1L);
        this.P702(-1L);
        this.P703(-1L);
        this.P704(-1L);
        this.P705(-1L);
        this.P706(-1L, false);
        this.P706(-1L, true);
        this.P707(-1L);
        this.TC001();
        this.TC002(16, true);
        this.TC002(16, false);
        this.TC002(0, false);
        this.TC003(16, true);
        this.TC003(16, false);
        this.TC003(0, false);
        this.TC003(0, true);
        this.TC003(32, true);
        this.TC003(32, false);
        this.TC004all();
        this.REPORT("Thread " + this.threadNumber + " exiting temp tests ");
    }

    protected void runPurgeWithNoDataLoggesTests() throws T_Fail, StandardException {
        this.REPORT("Thread " + this.threadNumber + " entering purges with no data logged tests ");
        this.logDataForPurges = false;
        this.P005(0L);
        this.P006();
        this.P014();
        this.P036();
        this.P037();
        this.P709();
        this.P710();
        this.P711();
        this.REPORT("Thread " + this.threadNumber + " exiting purge with no data logged tests ");
        this.logDataForPurges = true;
    }

    protected void T000() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        t1.close();
        t1 = this.t_util.t_startInternalTransaction();
        t1.close();
        t1 = this.t_util.t_startTransaction();
        Transaction ti = this.t_util.t_startInternalTransaction();
        ti.close();
        t1.close();
        this.PASS("T000");
    }

    protected void T001() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        this.t_util.t_commit(t1);
        t1.close();
        this.PASS("T001");
    }

    protected void T002() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        this.t_util.t_abort(t1);
        t1.close();
        this.PASS("T002");
    }

    protected void T003() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        this.t_util.t_commit(t1);
        this.t_util.t_commit(t1);
        this.t_util.t_abort(t1);
        t1.close();
        this.PASS("T003");
    }

    protected void T004() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        this.t_util.t_abort(t1);
        this.t_util.t_commit(t1);
        this.t_util.t_abort(t1);
        t1.close();
        this.PASS("T004");
    }

    protected void T005() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        GlobalTransactionId id1 = t1.getGlobalId();
        if (id1 != null) {
            throw T_Fail.testFailMsg("null not returned from local Transaction.getId()");
        }
        t1.close();
        byte[] global_id = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
        byte[] branch_id = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 44, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
        t1 = this.t_util.t_startGlobalTransaction(42, global_id, branch_id);
        id1 = t1.getGlobalId();
        if (!id1.equals(id1)) {
            throw T_Fail.testFailMsg("TransactionId does not compare equal to itself");
        }
        if (!id1.equals(t1.getGlobalId())) {
            throw T_Fail.testFailMsg("TransactionId has changed without any activity on Transaction");
        }
        if (id1.equals(this)) {
            throw T_Fail.testFailMsg("TransactionId compared equal to an non-transaction id object");
        }
        t1.close();
        t1 = null;
        branch_id[63] = 82;
        Transaction t2 = this.t_util.t_startGlobalTransaction(42, global_id, branch_id);
        GlobalTransactionId id2 = t2.getGlobalId();
        if (id2 == null) {
            throw T_Fail.testFailMsg("null returned from Transaction.getId()");
        }
        if (id1.equals(id2)) {
            throw T_Fail.testFailMsg("TransactionId's returned equal from different transactions");
        }
        if (id2.equals(id1)) {
            throw T_Fail.testFailMsg("TransactionId's returned equal from different transactions");
        }
        t2.close();
        this.PASS("T005");
    }

    protected void T006() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        T_Util.t_checkInvalidSavePoint(t1, "sdfjsdfg");
        t1.setSavePoint(SP1, null);
        t1.rollbackToSavePoint(SP1, null);
        t1.rollbackToSavePoint(SP1, null);
        t1.releaseSavePoint(SP1, null);
        T_Util.t_checkInvalidSavePoint(t1, SP1);
        t1.setSavePoint(SP1, null);
        t1.rollbackToSavePoint(SP1, null);
        t1.rollbackToSavePoint(SP1, null);
        t1.releaseSavePoint(SP1, null);
        T_Util.t_checkInvalidSavePoint(t1, SP1);
        this.t_util.t_commit(t1);
        t1.close();
        this.PASS("T006");
    }

    protected void T007() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        int position = 0;
        t1.setSavePoint(SP1, null);
        t1.setSavePoint(SP2, null);
        position = t1.releaseSavePoint(SP1, null);
        if (position != 0) {
            throw T_Fail.testFailMsg("Save Point Position in the stack isincorrect:" + position);
        }
        T_Util.t_checkInvalidSavePoint(t1, SP1);
        T_Util.t_checkInvalidSavePoint(t1, SP2);
        t1.setSavePoint(SP1, null);
        t1.setSavePoint(SP2, null);
        t1.rollbackToSavePoint(SP2, null);
        position = t1.rollbackToSavePoint(SP2, null);
        if (position != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the stack isincorrect:" + position);
        }
        position = t1.releaseSavePoint(SP2, null);
        if (position != 1) {
            throw T_Fail.testFailMsg("Save Point Position in the stack is incorrect:" + position);
        }
        T_Util.t_checkInvalidSavePoint(t1, SP2);
        t1.rollbackToSavePoint(SP1, null);
        t1.releaseSavePoint(SP1, null);
        T_Util.t_checkInvalidSavePoint(t1, SP1);
        t1.setSavePoint(SP1, null);
        t1.setSavePoint(SP2, null);
        position = t1.rollbackToSavePoint(SP1, null);
        if (position != 1) {
            throw T_Fail.testFailMsg("Save Point Position in the stack is incorrect:" + position);
        }
        T_Util.t_checkInvalidSavePoint(t1, SP2);
        t1.rollbackToSavePoint(SP1, null);
        t1.releaseSavePoint(SP1, null);
        this.t_util.t_commit(t1);
        t1.close();
        this.PASS("T007");
    }

    protected void T008() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        int position1 = 0;
        int position2 = 0;
        position1 = t1.setSavePoint(SP1, null);
        position2 = t1.setSavePoint(SP2, null);
        if (position1 != 1 && position2 != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the Stack seeme to wrong");
        }
        t1.commit();
        T_Util.t_checkInvalidSavePoint(t1, SP1);
        T_Util.t_checkInvalidSavePoint(t1, SP2);
        position1 = t1.setSavePoint(SP1, null);
        position2 = t1.setSavePoint(SP2, null);
        if (position1 != 1 && position2 != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the Stack seeme to wrong");
        }
        t1.abort();
        position1 = t1.setSavePoint(SP1, null);
        position2 = t1.setSavePoint(SP2, null);
        if (position1 != 1 && position2 != 2) {
            throw T_Fail.testFailMsg("Save Point Position in the Stack seeme to wrong");
        }
        t1.abort();
        T_Util.t_checkInvalidSavePoint(t1, SP1);
        T_Util.t_checkInvalidSavePoint(t1, SP2);
        t1.close();
        this.PASS("T008");
    }

    protected void T009() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L, 4096);
        this.t_util.t_dropContainer(t, 0L, cid);
        ContainerKey id = new ContainerKey(0L, cid);
        ContainerHandle ch = t.openContainer(id, 8);
        if (ch != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("T009");
    }

    protected void T010() throws StandardException, T_Fail {
        Transaction t1 = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t1, 0L);
        this.t_util.t_dropContainer(t1, 0L, cid);
        ContainerKey id = new ContainerKey(0L, cid);
        ContainerHandle ch = t1.openContainer(id, 8);
        if (ch != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        this.t_util.t_commit(t1);
        t1.close();
        this.PASS("T010");
    }

    protected void T011() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startInternalTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        t.commit();
        Page page = this.t_util.t_getPage(c, 1L);
        t.commit();
        if (!page.isLatched()) {
            throw T_Fail.testFailMsg("page not latched after commit of internal transaction");
        }
        page.unlatch();
        c.close();
        t.commit();
        c = this.t_util.t_openContainer(t, 0L, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        t.abort();
        if (page.isLatched()) {
            throw T_Fail.testFailMsg("page latched after abort of internal transaction");
        }
        try {
            page = this.t_util.t_getLastPage(c);
            throw T_Fail.testFailMsg("container open after abort of internal transaction");
        }
        catch (StandardException standardException) {
            this.t_util.t_dropContainer(t, 0L, cid);
            this.t_util.t_commit(t);
            t.close();
            this.PASS("T011");
            return;
        }
    }

    protected void T012() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
        RecordHandle new_r1 = c.makeRecordHandle(r1.getPageNumber(), r1.getId());
        T_Util.t_checkFetch(page, new_r1, REC_001);
        RecordHandle r2 = T_Util.t_insertAtSlot(page, 1, row2);
        if (r2 != null) {
            RecordHandle new_r2 = c.makeRecordHandle(r2.getPageNumber(), r2.getId());
            T_Util.t_checkFetch(page, r2, REC_002);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("T012");
    }

    protected void C010(int segment) throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, (long)segment);
        this.t_util.t_commit(t);
        ContainerHandle c1 = this.t_util.t_openContainer(t, (long)segment, cid, true);
        c1 = this.t_util.t_openContainer(t, (long)segment, cid, true);
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("C010");
    }

    protected void C011() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c1 = this.t_util.t_openContainer(t, 0L, cid, false);
        c1 = this.t_util.t_openContainer(t, 0L, cid, true);
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("C011");
    }

    protected void C012(long segment) throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        this.t_util.t_commit(t);
        ContainerHandle c1 = this.t_util.t_openContainer(t, segment, cid, true);
        this.t_util.t_dropContainer(t, segment, cid);
        if (testRollback) {
            this.t_util.t_abort(t);
            c1 = this.t_util.t_openContainer(t, segment, cid, true);
            this.REPORT("rollback of drop container tested");
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        ContainerKey id = new ContainerKey(segment, cid);
        c1 = t.openContainer(id, 4 | this.openMode);
        if (c1 != null) {
            throw T_Fail.testFailMsg("Deleted Container should fail to open");
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("C012");
    }

    protected void C014() throws T_Fail, StandardException {
        ContainerKey id;
        Transaction t = this.t_util.t_startTransaction();
        ContainerHandle c = t.openContainer(id = new ContainerKey(77L, 45L), 64);
        if (c == null) {
            throw T_Fail.testFailMsg("open of a container for lock only failed.");
        }
        RecordHandle rh1 = c.makeRecordHandle(23L, 456);
        if (rh1 == null) {
            throw T_Fail.testFailMsg("makeRecordHandle returned null");
        }
        c.getLockingPolicy().lockRecordForRead(t, c, rh1, true, true);
        RecordHandle rh2 = c.makeRecordHandle(23L, 7);
        if (rh2 == null) {
            throw T_Fail.testFailMsg("makeRecordHandle returned null");
        }
        c.getLockingPolicy().lockRecordForRead(t, c, rh2, true, false);
        RecordHandle rh3 = c.makeRecordHandle(23L, 9);
        c.getLockingPolicy().lockRecordForWrite(t, rh3, false, true);
        if (rh3 == null) {
            throw T_Fail.testFailMsg("makeRecordHandle returned null");
        }
        c.getLockingPolicy().unlockRecordAfterRead(t, c, rh2, false, true);
        c.close();
        t.commit();
        t.close();
        this.PASS("C014");
    }

    protected void C200() throws T_Fail, StandardException {
        Transaction t1 = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t1, 0L);
        this.t_util.t_commit(t1);
        this.REPORT("see if the container can be opened again");
        ContainerHandle c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        c1.close();
        this.t_util.t_commit(t1);
        this.REPORT("insert a record into the container.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        Page lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        if (lastPage.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + lastPage.getPageNumber());
        }
        T_RawStoreRow row = new T_RawStoreRow(REC_001);
        if (!lastPage.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        RecordHandle rh001 = T_Util.t_insert(lastPage, row);
        if (rh001 == null) {
            throw T_Fail.testFailMsg("Failed to insert record");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        c1 = null;
        this.REPORT("read record just inserted.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        T_Util.t_checkFetchFirst(lastPage, REC_001);
        T_Util.t_checkFetchLast(lastPage, REC_001);
        this.t_util.t_commit(t1);
        lastPage = null;
        c1 = null;
        this.REPORT("insert 2 more records.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        if (lastPage.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + lastPage.getPageNumber());
        }
        row = new T_RawStoreRow(REC_002);
        if (!lastPage.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        if (!lastPage.recordExists(rh001, false)) {
            throw T_Fail.testFailMsg("Record 001 has vanished");
        }
        RecordHandle rh002 = T_Util.t_insertAtSlot(lastPage, 0, row);
        row = new T_RawStoreRow(REC_003);
        RecordHandle rh003 = T_Util.t_insert(lastPage, row);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        c1 = null;
        this.REPORT("checks on all 3 records.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        T_Util.t_checkFetch(lastPage, rh002, REC_002);
        T_Util.t_checkFetch(lastPage, rh003, REC_003);
        T_Util.t_checkFetch(lastPage, lastPage.getRecordHandle(rh001.getId()), REC_001);
        T_Util.t_checkFetch(lastPage, lastPage.getRecordHandle(rh002.getId()), REC_002);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        this.REPORT("start deleting.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        T_Util.t_checkFetch(lastPage, rh002, REC_002);
        T_Util.t_checkFetch(lastPage, rh003, REC_003);
        int slot1 = lastPage.getSlotNumber(rh001);
        lastPage.deleteAtSlot(slot1, true, null);
        if (lastPage.fetchFromSlot(rh001, slot1, (Object[])new DataValueDescriptor[0], null, false) != null) {
            throw T_Fail.testFailMsg("deleted record is still present");
        }
        T_Util.t_checkFetch(lastPage, rh002, REC_002);
        T_Util.t_checkFetch(lastPage, rh003, REC_003);
        T_Util.t_checkFetchNext(lastPage, rh002, REC_003);
        T_Util.t_checkFetchPrevious(lastPage, rh003, REC_002);
        int slot2 = lastPage.getSlotNumber(rh002);
        lastPage.deleteAtSlot(slot2, true, null);
        if (lastPage.fetchFromSlot(rh002, slot2, (Object[])new DataValueDescriptor[0], null, false) != null) {
            throw T_Fail.testFailMsg("deleted record is still present");
        }
        T_Util.t_checkFetch(lastPage, rh003, REC_003);
        T_Util.t_checkFetchFirst(lastPage, REC_003);
        T_Util.t_checkFetchLast(lastPage, REC_003);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        this.REPORT("update the remaining record.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(lastPage, rh003, REC_003);
        T_RawStoreRow urow = new T_RawStoreRow(REC_004);
        int slot3 = lastPage.getSlotNumber(rh003);
        if (lastPage.updateAtSlot(slot3, (Object[])urow.getRow(), null) == null) {
            throw T_Fail.testFailMsg("updateAtSlot returned null");
        }
        T_Util.t_checkFetch(lastPage, rh003, REC_004);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        this.t_util.t_dropContainer(t1, 0L, cid);
        this.t_util.t_commit(t1);
        t1.close();
        this.PASS("C200");
    }

    protected void C201(int whatPage) throws T_Fail, StandardException {
        int pageSize = whatPage == 0 ? 4096 : 32768;
        Transaction t1 = this.t_util.t_startTransaction();
        this.REPORT("create container with pageSize " + pageSize + ", spareSpace 0, minimumRecordSize " + pageSize / 2);
        long cid = this.t_util.t_addContainer(t1, 0L, pageSize, 0, pageSize / 2, false);
        this.t_util.t_commit(t1);
        this.REPORT("see if the container can be opened again");
        ContainerHandle c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        c1.close();
        this.t_util.t_commit(t1);
        this.REPORT("insert a record into the container.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        Page lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        if (lastPage.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + lastPage.getPageNumber());
        }
        T_RawStoreRow row = new T_RawStoreRow(REC_001);
        if (!lastPage.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        RecordHandle rh001 = T_Util.t_insert(lastPage, row);
        if (rh001 == null) {
            throw T_Fail.testFailMsg("Failed to insert record");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        c1 = null;
        this.REPORT("read record just inserted.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        T_Util.t_checkFetchFirst(lastPage, REC_001);
        T_Util.t_checkFetchLast(lastPage, REC_001);
        this.t_util.t_commit(t1);
        lastPage = null;
        c1 = null;
        this.REPORT("try inserting 1 more record, but there should be no room on page for it.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        if (lastPage.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + lastPage.getPageNumber());
        }
        row = new T_RawStoreRow(REC_002);
        if (lastPage.spaceForInsert()) {
            throw T_Fail.testFailMsg("Did not get no room for record on page error");
        }
        if (!lastPage.recordExists(rh001, false)) {
            throw T_Fail.testFailMsg("Record 001 has vanished");
        }
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        c1 = null;
        this.t_util.t_dropContainer(t1, 0L, cid);
        this.t_util.t_commit(t1);
        this.REPORT("create container with pageSize " + pageSize + ", spareSpace 0, minimumRecordSize " + pageSize);
        this.REPORT("this should set minimumRecordSize to the default 100");
        cid = this.t_util.t_addContainer(t1, 0L, pageSize, 0, pageSize, false);
        this.t_util.t_commit(t1);
        this.REPORT("see if the container can be opened again");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        c1.close();
        this.t_util.t_commit(t1);
        this.REPORT("insert a record into the container.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        if (lastPage.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + lastPage.getPageNumber());
        }
        row = new T_RawStoreRow(REC_001);
        if (!lastPage.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        rh001 = T_Util.t_insert(lastPage, row);
        if (rh001 == null) {
            throw T_Fail.testFailMsg("Failed to insert record");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        c1 = null;
        this.REPORT("read record just inserted.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Couldn't get container's last page");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        T_Util.t_checkFetchFirst(lastPage, REC_001);
        T_Util.t_checkFetchLast(lastPage, REC_001);
        this.t_util.t_commit(t1);
        lastPage = null;
        c1 = null;
        this.REPORT("insert 2 more records.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, true);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        if (lastPage.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("Initial page must be 1, is " + lastPage.getPageNumber());
        }
        row = new T_RawStoreRow(REC_002);
        if (!lastPage.spaceForInsert()) {
            throw T_Fail.testFailMsg("No room for record on page");
        }
        if (!lastPage.recordExists(rh001, false)) {
            throw T_Fail.testFailMsg("Record 001 has vanished");
        }
        RecordHandle rh002 = T_Util.t_insertAtSlot(lastPage, 0, row);
        row = new T_RawStoreRow(REC_003);
        RecordHandle rh003 = T_Util.t_insert(lastPage, row);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        c1 = null;
        this.REPORT("checks on all 3 records.");
        c1 = this.t_util.t_openContainer(t1, 0L, cid, false);
        lastPage = this.t_util.t_getLastPage(c1);
        if (lastPage == null) {
            throw T_Fail.testFailMsg("Could get container's last page");
        }
        T_Util.t_checkFetch(lastPage, rh001, REC_001);
        T_Util.t_checkFetch(lastPage, rh002, REC_002);
        T_Util.t_checkFetch(lastPage, rh003, REC_003);
        T_Util.t_checkFetch(lastPage, lastPage.getRecordHandle(rh001.getId()), REC_001);
        T_Util.t_checkFetch(lastPage, lastPage.getRecordHandle(rh002.getId()), REC_002);
        lastPage.unlatch();
        lastPage = null;
        this.t_util.t_commit(t1);
        c1 = null;
        this.t_util.t_dropContainer(t1, 0L, cid);
        this.t_util.t_commit(t1);
        t1.close();
        this.PASS("C201 - " + whatPage);
    }

    protected void P001(long segment) throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, false);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        page.unlatch();
        page = null;
        page = this.t_util.t_getLastPage(c);
        T_Util.t_checkPageNumber(page, 1L);
        T_Util.t_checkEmptyPage(page);
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_addPage(c);
        T_Util.t_checkPageNumber(page, 2L);
        page.unlatch();
        page = this.t_util.t_addPage(c);
        T_Util.t_checkPageNumber(page, 3L);
        page.unlatch();
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        T_Util.t_updateSlotOutOfRange(page, 0);
        T_Util.t_updateSlotOutOfRange(page, -1);
        T_Util.t_updateSlotOutOfRange(page, 1);
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P001");
    }

    protected void P002(long segment) throws StandardException, T_Fail {
        int j2;
        RecordHandle rh;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        int[] recordCount = new int[]{0, 0, 0};
        int i = 0;
        while (i < 3) {
            T_RawStoreRow row = new T_RawStoreRow(REC_001 + i + "X" + recordCount[i]);
            boolean spaceThere = page.spaceForInsert();
            rh = T_Util.t_insert(page, row);
            if (rh != null) {
                int n = i;
                recordCount[n] = recordCount[n] + 1;
                if (!spaceThere) {
                    this.REPORT("record inserted after spaceForInsert() returned false, count is " + recordCount[i]);
                }
            } else if (spaceThere) {
                this.REPORT("record insert failed after spaceForInsert() returned true, count is " + recordCount[i]);
            }
            T_Util.t_checkRecordCount(page, recordCount[i], recordCount[i]);
            if (rh != null) continue;
            page.unlatch();
            page = null;
            if (++i >= 3) continue;
            page = this.t_util.t_addPage(c);
            T_Util.t_checkEmptyPage(page);
        }
        this.t_util.t_commit(t);
        for (i = 0; i < 3; ++i) {
            this.REPORT("RecordCount on page " + i + "=" + recordCount[i]);
        }
        c = this.t_util.t_openContainer(t, segment, cid, false);
        long pageNumber = 1L;
        int i2 = 0;
        while (i2 < 3) {
            page = this.t_util.t_getPage(c, pageNumber);
            T_Util.t_checkRecordCount(page, recordCount[i2], recordCount[i2]);
            rh = T_Util.t_checkFetchFirst(page, REC_001 + i2 + "X0");
            for (j2 = 1; j2 < recordCount[i2]; ++j2) {
                rh = T_Util.t_checkFetchNext(page, rh, REC_001 + i2 + "X" + j2);
            }
            try {
                rh = page.fetchFromSlot(null, page.getSlotNumber(rh) + 1, (Object[])new DataValueDescriptor[0], (FetchDescriptor)null, false);
                throw T_Fail.testFailMsg("reading more rows on page than were written");
            }
            catch (StandardException j2) {
                rh = T_Util.t_checkFetchLast(page, REC_001 + i2 + "X" + (recordCount[i2] - 1));
                for (j2 = recordCount[i2] - 2; j2 >= 0; --j2) {
                    rh = T_Util.t_checkFetchPrevious(page, rh, REC_001 + i2 + "X" + j2);
                }
                page.unlatch();
                page = null;
                ++i2;
                ++pageNumber;
            }
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, false);
        pageNumber = 1L;
        i2 = 0;
        while (i2 < 3) {
            page = this.t_util.t_getPage(c, pageNumber);
            for (j2 = 0; j2 < recordCount[i2]; ++j2) {
                T_Util.t_checkFetchBySlot(page, j2, REC_001 + i2 + "X" + j2, false, false);
            }
            T_Util.t_readOnlySlotOutOfRange(page, recordCount[i2]);
            page.unlatch();
            page = null;
            ++i2;
            ++pageNumber;
        }
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P002");
    }

    protected void P005(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page1 = this.t_util.t_getLastPage(c);
        T_RawStoreRow row0 = new T_RawStoreRow("long row xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx long row ");
        T_RawStoreRow row1 = new T_RawStoreRow("medium row yyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyyy medium row");
        T_Util.t_insertAtSlot(page1, 0, row0);
        int i = 0;
        while (page1.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page1, 1, row1) == null) break;
            ++i;
        }
        int count1 = page1.recordCount();
        Page page2 = this.t_util.t_addPage(c);
        T_Util.t_insertAtSlot(page2, 0, row0);
        i = 1;
        while (page2.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page2, i++, row1) != null) continue;
        }
        int count2 = page2.recordCount();
        page1.purgeAtSlot(1, page1.recordCount() - 1, this.logDataForPurges);
        page2.purgeAtSlot(1, page2.recordCount() - 1, this.logDataForPurges);
        if (page1.recordCount() != 1) {
            throw T_Fail.testFailMsg("purge did not clean up page");
        }
        if (page2.recordCount() != 1) {
            throw T_Fail.testFailMsg("purge did not clean up page");
        }
        i = 0;
        while (page1.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page1, 1, row1) == null) {
                return;
            }
            ++i;
        }
        if (page1.recordCount() != count1) {
            throw T_Fail.testFailMsg("cannot insert back same number of rows we purged");
        }
        i = 1;
        while (page2.spaceForInsert()) {
            if (T_Util.t_insertAtSlot(page2, i++, row1) != null) continue;
        }
        if (page2.recordCount() != count2) {
            throw T_Fail.testFailMsg("cannot insert back same number of rows we purged");
        }
        page1.unlatch();
        page2.unlatch();
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P005");
    }

    protected void P006() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page1 = this.t_util.t_getLastPage(c);
        PageTimeStamp ts = page1.currentTimeStamp();
        if (ts != null && !page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("page returns non-null time stamp which is not equal to its current time stamp");
        }
        T_RawStoreRow row = new T_RawStoreRow(REC_001);
        RecordHandle rh = T_Util.t_insert(page1, row);
        if (page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after insert operation");
        }
        page1.setTimeStamp(ts);
        if (ts != null && !page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("page returns non-null time stamp which is not equal to its current time stamp");
        }
        T_Util.t_updateSlotOutOfRange(page1, 3);
        if (ts != null && !page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("failed pdate should not change time stamp");
        }
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        int slot2 = page1.getSlotNumber(rh);
        page1.updateAtSlot(slot2, (Object[])row2.getRow(), null);
        if (page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after update operation");
        }
        page1.setTimeStamp(ts);
        T_RawStoreRow upd1 = new T_RawStoreRow(REC_003);
        int slot = page1.getSlotNumber(rh);
        page1.updateAtSlot(slot, (Object[])upd1.getRow(), BS_COL_0);
        if (page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after update field operation");
        }
        page1.setTimeStamp(ts);
        page1.deleteAtSlot(slot, true, null);
        if (page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after delete operation");
        }
        page1.setTimeStamp(ts);
        page1.purgeAtSlot(0, 1, this.logDataForPurges);
        if (page1.equalTimeStamp(ts)) {
            throw T_Fail.testFailMsg("timestamp on page not changed after delete operation");
        }
        page1.setTimeStamp(ts);
        page1.unlatch();
        if (testRollback) {
            this.t_util.t_abort(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page1 = this.t_util.t_getLastPage(c);
            if (page1.equalTimeStamp(ts)) {
                throw T_Fail.testFailMsg("timestamp on page not changed after rollback");
            }
            page1.setTimeStamp(ts);
        }
        Page page2 = c.addPage();
        Page page3 = c.addPage();
        page2.setTimeStamp(ts);
        if (ts != null) {
            try {
                if (page3.equalTimeStamp(ts)) {
                    throw T_Fail.testFailMsg("timestamp on 2 different pages should not equate");
                }
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P006");
    }

    protected void P007(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096, 0, 1, false);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getLastPage(c);
        T_RawStoreRow row = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(new String(new char[300]));
        RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row);
        RecordHandle r2 = T_Util.t_insertAtSlot(page, 1, row2);
        Object rowData = REC_001;
        for (int i = 0; i <= 900; ++i) {
            T_Util.t_checkFetch(page, r1, (String)rowData);
            rowData = (String)rowData + REC_008;
            row = new T_RawStoreRow((String)rowData);
            page.updateAtSlot(0, (Object[])row.getRow(), (FormatableBitSet)null);
        }
        this.t_util.t_dropContainer(t, segment, cid);
        cid = this.t_util.t_addContainer(t, segment, 4096, 0, 1, false);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getLastPage(c);
        long pid = page.getPageNumber();
        row = new T_RawStoreRow(2);
        row.setColumn(0, REC_001);
        row.setColumn(1, new String(new char[400]));
        r1 = T_Util.t_insertAtSlot(page, 0, row);
        r2 = T_Util.t_insertAtSlot(page, 1, row2);
        row.setColumn(0, REC_001 + new String(new char[300]));
        row.setColumn(1, new String(new char[100]));
        page.updateAtSlot(0, (Object[])row.getRow(), (FormatableBitSet)null);
        Page page2 = this.t_util.t_addPage(c);
        long pid2 = page2.getPageNumber();
        if (pid2 != pid + 1L) {
            throw T_Fail.testFailMsg("The update should not have overflowed the record");
        }
        row.setColumn(0, REC_001);
        row.setColumn(1, new String(new char[400]));
        page.updateAtSlot(0, (Object[])row.getRow(), (FormatableBitSet)null);
        Page page3 = this.t_util.t_addPage(c);
        long pid3 = page3.getPageNumber();
        if (pid3 != pid2 + 1L) {
            throw T_Fail.testFailMsg("The update should not have overflowed the record");
        }
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P007");
    }

    protected void P008(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096, 0, 1, false);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page1 = this.t_util.t_getLastPage(c);
        T_RawStoreRow row = new T_RawStoreRow(REC_001);
        T_Util.t_insertAtSlot(page1, 0, row);
        int i = 0;
        while (page1.spaceForInsert((Object[])row.getRow(), (FormatableBitSet)null, 100)) {
            if (T_Util.t_insertAtSlot(page1, 1, row) == null) {
                throw T_Fail.testFailMsg("There is space for this insert.  It shouldn't have failed.  record #" + i);
            }
            ++i;
        }
        this.REPORT(i + " rows inserted.");
        if (T_Util.t_insertAtSlot(page1, 1, row) != null) {
            throw T_Fail.testFailMsg("There is no space for this insert.  It should have failed.");
        }
        String[] s = new String[7];
        s[6] = "McLare";
        s[5] = "McLar";
        s[4] = "McLa";
        s[3] = "McL";
        s[2] = "Mc";
        s[1] = "M";
        s[0] = null;
        i = 6;
        boolean notDone = true;
        do {
            if (page1.spaceForInsert((Object[])(row = new T_RawStoreRow(s[i])).getRow(), (FormatableBitSet)null, 100)) {
                if (T_Util.t_insertAtSlot(page1, 1, row) == null) {
                    throw T_Fail.testFailMsg("There should be space for this insert, row is " + s[i]);
                }
                notDone = false;
                continue;
            }
            --i;
        } while (notDone && i >= 0);
        page1.unlatch();
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P008");
    }

    protected void P009(long segment) throws StandardException, T_Fail {
        int slot = 0;
        int i = 0;
        int j = 0;
        Object field = REC_001;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(13);
        row.setColumn(0, (String)null);
        row.setColumn(1, REC_001);
        row.setColumn(2, REC_002);
        row.setColumn(3, REC_003);
        row.setColumn(4, REC_004);
        row.setColumn(5, REC_005);
        row.setColumn(6, REC_006);
        row.setColumn(7, REC_007);
        row.setColumn(8, (String)null);
        row.setColumn(9, (String)null);
        row.setColumn(10, REC_007);
        row.setColumn(11, (String)null);
        row.setColumn(12, REC_006);
        int numRows = 0;
        slot = 0;
        while (page.spaceForInsert((Object[])row.getRow(), (FormatableBitSet)null, 100)) {
            T_Util.t_insert(page, row);
            ++numRows;
        }
        this.REPORT(numRows + " rows inserted ");
        SQLChar col = new SQLChar();
        i = 0;
        while (true) {
            if (i >= 0 + 2) break;
            for (slot = i; slot <= numRows - 1; slot += 2) {
                for (j = 0; j <= 12; ++j) {
                    if (page.updateFieldAtSlot(slot, j, (Object)col, null) != null) continue;
                    throw T_Fail.testFailMsg("Failed to update field " + j + ", in row " + slot);
                }
            }
            col = new SQLChar(REC_001);
            ++i;
        }
        SQLChar storedColumn = new SQLChar();
        field = null;
        i = 0;
        while (true) {
            if (i >= 0 + 2) break;
            for (slot = i; slot <= numRows - 1; slot += 2) {
                for (j = 0; j <= 12; ++j) {
                    T_Util.t_checkFetchColFromSlot(page, slot, j, (DataValueDescriptor)storedColumn, false, (String)field);
                }
            }
            field = REC_001;
            ++i;
        }
        if (page.spaceForInsert()) {
            throw T_Fail.testFailMsg("Did not get no room for record on page error");
        }
        col = new SQLChar(REC_006);
        for (slot = 0; slot <= numRows - 1; ++slot) {
            if (page.updateFieldAtSlot(slot, 0, (Object)col, null) != null && page.updateFieldAtSlot(slot, 12, (Object)col, null) != null) continue;
            throw T_Fail.testFailMsg("Failed to update fields to REC_006 in row " + slot);
        }
        col = new SQLChar(REC_007);
        for (slot = 0; slot <= numRows - 1; ++slot) {
            if (page.updateFieldAtSlot(slot, 5, (Object)col, null) != null && page.updateFieldAtSlot(slot, 6, (Object)col, null) != null) continue;
            throw T_Fail.testFailMsg("Failed to update fields to REC_007 in row " + slot);
        }
        i = 0;
        while (true) {
            if (i >= 0 + 2) break;
            for (slot = i; slot <= numRows - 1; slot += 2) {
                for (j = 0; j <= 12; ++j) {
                    switch (j) {
                        case 0: 
                        case 12: {
                            field = REC_006;
                            break;
                        }
                        case 5: 
                        case 6: {
                            field = REC_007;
                            break;
                        }
                        default: {
                            field = slot % 2 == 0 ? null : REC_001;
                        }
                    }
                    T_Util.t_checkFetchColFromSlot(page, slot, j, (DataValueDescriptor)storedColumn, false, (String)field);
                }
            }
            ++i;
        }
        if (page.spaceForInsert()) {
            throw T_Fail.testFailMsg("Did not get no room for record on page error");
        }
        field = REC_007;
        i = 0;
        String field_pre = null;
        while (true) {
            if (i % 5 != 0) {
                field_pre = field;
                field = (String)field + REC_008;
            } else {
                field = field_pre;
            }
            if (i % 10 == 3 || i % 10 == 7) {
                page.unlatch();
                page = null;
                factory.idle();
                page = this.t_util.t_getPage(c, 1L);
            }
            col = new SQLChar((String)field);
            try {
                page.updateFieldAtSlot(0, 5, (Object)col, null);
            }
            catch (StandardException se) {
                if (i < 809) {
                    throw T_Fail.testFailMsg("should be able to update Row 0 Column 5 809 times, but only updated " + i + " times.  Note: you maybe getting this error if your page format has changed.");
                }
                this.REPORT("Row 0 Column 5 was updated " + i + " times.");
                break;
            }
            ++i;
        }
        page.unlatch();
        page = null;
        factory.idle();
        page = this.t_util.t_getPage(c, 1L);
        col = new SQLChar(REC_002);
        if (page.updateFieldAtSlot(1, 1, (Object)col, null) == null) {
            throw T_Fail.testFailMsg("update Row 1 and Column 1 to same length data failed.");
        }
        this.REPORT("updated col1 in row 1 to same length");
        page.unlatch();
        page = null;
        factory.idle();
        page = this.t_util.t_getPage(c, 1L);
        field = "Ferrariz";
        col = new SQLChar((String)field);
        try {
            page.updateFieldAtSlot(1, 1, (Object)col, null);
            throw T_Fail.testFailMsg("update Row 1 and Column 1 to longer length should have failed.");
        }
        catch (StandardException standardException) {
            if (segment != -1L) {
                this.t_util.t_dropContainer(t, segment, cid);
            }
            this.t_util.t_commit(t);
            t.close();
            this.PASS("P009: segment " + segment);
            return;
        }
    }

    protected void P011(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
        T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
        try {
            RecordHandle r = T_Util.t_insertAtSlot(page, -1, row1);
            throw T_Fail.testFailMsg("insert at slot -1 succeeded");
        }
        catch (StandardException se) {
            if (se.getSeverity() > 20000) {
                throw se;
            }
            try {
                RecordHandle r = T_Util.t_insertAtSlot(page, 1, row1);
                throw T_Fail.testFailMsg("insert at slot 1 succeeded");
            }
            catch (StandardException se2) {
                if (se2.getSeverity() > 20000) {
                    throw se2;
                }
                RecordHandle r3 = T_Util.t_insertAtSlot(page, 0, row3);
                T_Util.t_checkFetch(page, r3, REC_003);
                T_Util.t_checkFetchBySlot(page, 0, REC_003, false, false);
                RecordHandle r4 = null;
                RecordHandle r2 = null;
                RecordHandle r1 = null;
                r1 = T_Util.t_insertAtSlot(page, 0, row1);
                if (r1 == null) {
                    this.t_util.t_abort(t);
                    t.close();
                    this.REPORT("P011 not run - could not fit 4 rows on page");
                    return;
                }
                T_Util.t_checkFetch(page, r1, REC_001);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, false);
                r2 = T_Util.t_insertAtSlot(page, 1, row2);
                if (r2 == null) {
                    this.t_util.t_abort(t);
                    t.close();
                    this.REPORT("P011 not completed - could not fit 4 rows on page");
                    return;
                }
                T_Util.t_checkFetch(page, r2, REC_002);
                T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
                r4 = T_Util.t_insertAtSlot(page, 3, row4);
                if (r4 == null) {
                    this.t_util.t_abort(t);
                    t.close();
                    this.REPORT("P011 not completed - could not fit 4 rows on page");
                    return;
                }
                T_Util.t_checkFetch(page, r4, REC_004);
                T_Util.t_checkFetchBySlot(page, 3, REC_004, false, false);
                T_Util.t_checkFetchFirst(page, REC_001);
                T_Util.t_checkFetchNext(page, r1, REC_002);
                T_Util.t_checkFetchNext(page, r2, REC_003);
                T_Util.t_checkFetchNext(page, r3, REC_004);
                T_Util.t_checkFetchLast(page, REC_004);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_002, false, false);
                T_Util.t_checkFetchBySlot(page, 2, REC_003, false, true);
                T_Util.t_checkFetchBySlot(page, 3, REC_004, false, false);
                this.t_util.t_dropContainer(t, segment, cid);
                this.t_util.t_commit(t);
                t.close();
                this.PASS("P011");
                return;
            }
        }
    }

    protected void P012(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(2);
        row2.setColumn(0, (String)null);
        row2.setColumn(1, REC_001);
        T_RawStoreRow row3 = new T_RawStoreRow(3);
        row3.setColumn(0, REC_001);
        row3.setColumn(1, REC_002);
        row3.setColumn(2, REC_003);
        RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
        RecordHandle r3 = null;
        RecordHandle r2 = null;
        r2 = T_Util.t_insertAtSlot(page, 1, row2);
        if (r2 == null) {
            this.REPORT("P012 not completed - cannot insert second row");
            return;
        }
        r3 = T_Util.t_insertAtSlot(page, 2, row3);
        if (r3 == null) {
            this.REPORT("P012 not completed - cannot insert third row");
            return;
        }
        T_Util.t_checkFetch(page, r1, row1);
        T_Util.t_checkFetch(page, r2, row2);
        T_Util.t_checkFetch(page, r3, row3);
        T_RawStoreRow upd1 = new T_RawStoreRow(2);
        upd1.setColumn(0, (String)null);
        upd1.setColumn(1, REC_001);
        r1 = page.updateAtSlot(0, (Object[])upd1.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, r1, upd1);
        T_Util.t_checkFetch(page, r2, row2);
        T_Util.t_checkFetch(page, r3, row3);
        T_RawStoreRow upd2 = new T_RawStoreRow(REC_004);
        r2 = page.updateAtSlot(1, (Object[])upd2.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, r1, upd1);
        T_Util.t_checkFetch(page, r2, upd2);
        T_Util.t_checkFetch(page, r3, row3);
        T_RawStoreRow upd3 = new T_RawStoreRow(3);
        upd3.setColumn(0, REC_003);
        upd3.setColumn(1, REC_002);
        upd3.setColumn(2, REC_001);
        r3 = page.updateAtSlot(2, (Object[])upd3.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, r1, upd1);
        T_Util.t_checkFetch(page, r2, upd2);
        T_Util.t_checkFetch(page, r3, upd3);
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P012");
    }

    protected void P013() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
        RecordHandle r2 = T_Util.t_insertAtSlot(page, 1, row2);
        if (r2 == null) {
            this.REPORT("P013 not completed - could not fit two rows on a page");
            return;
        }
        T_Util.t_checkRecordCount(page, 2, 2);
        page.deleteAtSlot(0, true, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 1);
        if (!page.isDeletedAtSlot(0)) {
            throw T_Fail.testFailMsg("Failed to delete record 0");
        }
        if (page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Record mistakenly deleted");
        }
        page.deleteAtSlot(1, true, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 0);
        if (!page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Failed to delete record 1");
        }
        page.deleteAtSlot(0, false, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 1);
        if (page.isDeletedAtSlot(0)) {
            throw T_Fail.testFailMsg("Failed to undelete record 0");
        }
        if (!page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Record mistakenly undeleted");
        }
        page.deleteAtSlot(1, false, (LogicalUndo)null);
        T_Util.t_checkRecordCount(page, 2, 2);
        if (page.isDeletedAtSlot(1)) {
            throw T_Fail.testFailMsg("Failed to undelete record 1");
        }
        try {
            page.deleteAtSlot(0, false, (LogicalUndo)null);
            throw T_Fail.testFailMsg("undeleted on undeleted record succeeded");
        }
        catch (StandardException se) {
            if (se.getSeverity() > 20000) {
                throw se;
            }
            page.deleteAtSlot(0, true, (LogicalUndo)null);
            try {
                page.deleteAtSlot(0, true, (LogicalUndo)null);
                throw T_Fail.testFailMsg("deleted on deleted record succeeded");
            }
            catch (StandardException se2) {
                if (se2.getSeverity() > 20000) {
                    throw se2;
                }
                T_Util.t_checkRecordCount(page, 2, 1);
                this.PASS("P013");
                this.t_util.t_dropContainer(t, 0L, cid);
                this.t_util.t_commit(t);
                t.close();
                return;
            }
        }
    }

    protected void P014() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row0 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
        T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
        RecordHandle r0 = T_Util.t_insertAtSlot(page, 0, row0);
        RecordHandle r1 = T_Util.t_insertAtSlot(page, 1, row1);
        RecordHandle r2 = T_Util.t_insertAtSlot(page, 2, row2);
        RecordHandle r3 = T_Util.t_insertAtSlot(page, 3, row3);
        RecordHandle r4 = T_Util.t_insertAtSlot(page, 4, row4);
        if (r3 != null) {
            page.deleteAtSlot(3, true, (LogicalUndo)null);
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, 0L, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        try {
            page.purgeAtSlot(-1, 1, this.logDataForPurges);
            throw T_Fail.testFailMsg("negative slot number did not cause an exception");
        }
        catch (StandardException standardException) {
            try {
                page.purgeAtSlot(4, 4, this.logDataForPurges);
                throw T_Fail.testFailMsg("purging more rows than is on page did not cause an exception");
            }
            catch (StandardException standardException2) {
                if (r4 == null) {
                    int rcount = page.recordCount();
                    page.purgeAtSlot(0, 1, this.logDataForPurges);
                    if (page.recordCount() != rcount - 1) {
                        T_Fail.testFailMsg("failed to purge a record, expect " + (rcount - 1) + " got " + page.recordCount());
                    }
                    if (testRollback) {
                        this.t_util.t_abort(t);
                        c = this.t_util.t_openContainer(t, 0L, cid, true);
                        page = this.t_util.t_getPage(c, 1L);
                        if (this.logDataForPurges) {
                            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        } else {
                            T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        }
                        if (page.recordCount() != rcount) {
                            T_Fail.testFailMsg("failed to rollback purge, expect " + rcount + " got " + page.recordCount());
                        }
                    } else {
                        this.t_util.t_commit(t);
                    }
                    this.PASS("minimal P014");
                    return;
                }
                page.purgeAtSlot(1, 2, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_003, true, true);
                T_Util.t_checkFetchBySlot(page, 2, REC_004, false, true);
                if (page.recordCount() != 3) {
                    T_Fail.testFailMsg("page expect to have 3 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(0, 3, this.logDataForPurges);
                if (page.recordCount() != 0) {
                    T_Fail.testFailMsg("page expect to have 0 records, recordCount() = " + page.recordCount());
                }
                if (testRollback) {
                    this.REPORT("testing rollback");
                    this.t_util.t_abort(t);
                    c = this.t_util.t_openContainer(t, 0L, cid, true);
                    page = this.t_util.t_getPage(c, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    page.purgeAtSlot(2, 3, this.logDataForPurges);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 2) {
                        T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                    }
                    this.t_util.t_abort(t);
                    c = this.t_util.t_openContainer(t, 0L, cid, true);
                    page = this.t_util.t_getPage(c, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    if (page.isDeletedAtSlot(1)) {
                        T_Fail.testFailMsg("rolled back purged undeleted record cause record to be deleted");
                    }
                    if (!page.isDeletedAtSlot(3)) {
                        T_Fail.testFailMsg("rolled back purged deleted record cause record to be undeleted");
                    }
                }
                this.PASS("P014");
                this.t_util.t_dropContainer(t, 0L, cid);
                this.t_util.t_commit(t);
                t.close();
                return;
            }
        }
    }

    protected void P015() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(2);
        row2.setColumn(0, (String)null);
        row2.setColumn(1, REC_001);
        T_RawStoreRow row3 = new T_RawStoreRow(3);
        row3.setColumn(0, REC_001);
        row3.setColumn(1, REC_002);
        row3.setColumn(2, REC_003);
        RecordHandle r1 = T_Util.t_insertAtSlot(page, 0, row1);
        RecordHandle r3 = null;
        RecordHandle r2 = null;
        r2 = T_Util.t_insertAtSlot(page, 1, row2);
        if (r2 == null) {
            this.REPORT("P015 not completed - cannot insert second row");
            return;
        }
        r3 = T_Util.t_insertAtSlot(page, 2, row3);
        if (r3 == null) {
            this.REPORT("P015 not completed - cannot insert third row");
            return;
        }
        T_Util.t_checkFetch(page, r1, row1);
        T_Util.t_checkFetch(page, r2, row2);
        T_Util.t_checkFetch(page, r3, row3);
        T_RawStoreRow row2u = new T_RawStoreRow(2);
        row2u.setColumn(0, REC_006);
        row2u.setColumn(1, "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789");
        page.updateAtSlot(1, (Object[])row2u.getRow(), (FormatableBitSet)null);
        T_Util.t_checkFetch(page, r2, row2u);
        row1.setColumn(0, REC_007);
        FormatableBitSet validColumn = new FormatableBitSet(2);
        validColumn.clear();
        validColumn.set(0);
        page.updateAtSlot(0, (Object[])row1.getRow(), validColumn);
        T_Util.t_checkFetch(page, r1, row1);
        row3.setColumn(1, "XXabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyzabcdefghijklmnopqrstuvwxyz");
        validColumn.clear();
        validColumn.set(1);
        page.updateAtSlot(2, (Object[])row3.getRow(), validColumn);
        T_Util.t_checkFetch(page, r3, row3);
        this.PASS("P015");
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
    }

    protected void P016() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        long cid2 = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page1 = this.t_util.t_getPage(c, 1L);
        Page page2 = this.t_util.t_addPage(c);
        long pid1 = page1.getPageNumber();
        long pid2 = page2.getPageNumber();
        T_Util.t_checkEmptyPage(page2);
        int i = 0;
        int deleted = 0;
        i = 0;
        T_RawStoreRow row = new T_RawStoreRow("row at slot " + i);
        while (page1.spaceForInsert()) {
            RecordHandle rh = T_Util.t_insertAtSlot(page1, i, row);
            if (rh == null) break;
            if (i % 3 == 1) {
                ++deleted;
                page1.deleteAtSlot(i, true, null);
            }
            row = new T_RawStoreRow("row at slot " + ++i);
        }
        int recordCount = i;
        ContainerHandle c2 = this.t_util.t_openContainer(t, 0L, cid2, true);
        Page wrongPage = this.t_util.t_getPage(c2, 1L);
        try {
            page1.copyAndPurge(wrongPage, 0, recordCount, 0);
            throw T_Fail.testFailMsg("copying to page from a different contaier should cause and exception");
        }
        catch (StandardException standardException) {
            try {
                page1.copyAndPurge(page2, 1, 0, 0);
                throw T_Fail.testFailMsg("copying zero rows should cause an exception");
            }
            catch (StandardException standardException2) {
                try {
                    page1.copyAndPurge(page2, 1, recordCount, 0);
                    throw T_Fail.testFailMsg("copying more rows than page contains should cause an exception");
                }
                catch (StandardException standardException3) {
                    try {
                        page1.copyAndPurge(page2, 0, 1, 1);
                        throw T_Fail.testFailMsg("copying rows to nonexistant slot should cause an exception");
                    }
                    catch (StandardException standardException4) {
                        page1.copyAndPurge(page2, 0, recordCount, 0);
                        T_Util.t_checkEmptyPage(page1);
                        for (i = 0; i < recordCount; ++i) {
                            T_Util.t_checkFetchBySlot(page2, i, "row at slot " + i, i % 3 == 1, true);
                        }
                        T_Util.t_checkRecordCount(page2, recordCount, recordCount - deleted);
                        this.t_util.t_commit(t);
                        if (recordCount > 2) {
                            c = this.t_util.t_openContainer(t, 0L, cid, true);
                            page1 = this.t_util.t_getPage(c, pid1);
                            page2 = this.t_util.t_getPage(c, pid2);
                            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
                            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
                            T_Util.t_insertAtSlot(page1, 0, row1);
                            T_Util.t_insertAtSlot(page1, 1, row2);
                            page2.copyAndPurge(page1, 1, recordCount - 2, 1);
                            T_Util.t_checkFetchBySlot(page2, 0, "row at slot 0", false, true);
                            boolean tdeleted = (recordCount - 1) % 3 == 1;
                            T_Util.t_checkFetchBySlot(page2, 1, "row at slot " + (recordCount - 1), tdeleted, true);
                            if ((recordCount - 1) % 3 == 1) {
                                T_Util.t_checkRecordCount(page2, 2, 1);
                            } else {
                                T_Util.t_checkRecordCount(page2, 2, 2);
                            }
                            T_Util.t_checkFetchBySlot(page1, 0, REC_001, false, false);
                            for (i = 1; i < recordCount - 1; ++i) {
                                T_Util.t_checkFetchBySlot(page1, i, "row at slot " + i, i % 3 == 1, false);
                            }
                            T_Util.t_checkFetchBySlot(page1, recordCount - 1, REC_002, false, false);
                            if ((recordCount - 1) % 3 == 1) {
                                T_Util.t_checkRecordCount(page1, recordCount, recordCount - deleted + 1);
                            } else {
                                T_Util.t_checkRecordCount(page1, recordCount, recordCount - deleted);
                            }
                            if (testRollback) {
                                this.t_util.t_abort(t);
                                c = this.t_util.t_openContainer(t, 0L, cid, true);
                                page1 = this.t_util.t_getPage(c, pid1);
                                page2 = this.t_util.t_getPage(c, pid2);
                                T_Util.t_checkFetchBySlot(page1, 0, REC_001, true, false);
                                T_Util.t_checkFetchBySlot(page1, 1, REC_002, true, false);
                                T_Util.t_checkRecordCount(page1, 2, 0);
                                for (i = 0; i < recordCount; ++i) {
                                    T_Util.t_checkFetchBySlot(page2, i, "row at slot " + i, i % 3 == 1, true);
                                }
                                T_Util.t_checkRecordCount(page2, recordCount, recordCount - deleted);
                                this.REPORT("tested roll back of copyAndPurge");
                            }
                            this.PASS("P016");
                        }
                        this.t_util.t_dropContainer(t, 0L, cid);
                        this.t_util.t_dropContainer(t, 0L, cid2);
                        this.t_util.t_commit(t);
                        t.close();
                        return;
                    }
                }
            }
        }
    }

    protected void P017() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page1 = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        RecordHandle valid = T_Util.t_insert(page1, row1);
        RecordHandle[] rhs = new RecordHandle[]{page1.getInvalidRecordHandle(), page1.makeRecordHandle(1), page1.makeRecordHandle(2), page1.makeRecordHandle(3), page1.makeRecordHandle(4), page1.makeRecordHandle(5)};
        for (int i = 0; i < 6; ++i) {
            try {
                page1.recordExists(rhs[i], true);
                throw T_Fail.testFailMsg("record exists for invalid record " + rhs[i]);
            }
            catch (StandardException standardException) {
                try {
                    int slot = page1.getSlotNumber(rhs[i]);
                    page1.fetchFromSlot(rhs[i], slot, (Object[])new DataValueDescriptor[0], null, false);
                    throw T_Fail.testFailMsg("fetched an invalid record " + rhs[i]);
                }
                catch (StandardException slot) {
                    try {
                        int slot2 = page1.getSlotNumber(rhs[i]);
                        page1.updateAtSlot(slot2, (Object[])row1.getRow(), null);
                        throw T_Fail.testFailMsg("updated an invalid record " + rhs[i]);
                    }
                    catch (StandardException slot2) {
                        try {
                            int slot3 = page1.getSlotNumber(rhs[i]);
                            page1.updateAtSlot(slot3, (Object[])row1.getRow(), BS_COL_0);
                            throw T_Fail.testFailMsg("updated an invalid record field");
                        }
                        catch (StandardException slot3) {
                            try {
                                int slot4 = page1.getSlotNumber(rhs[i]);
                                page1.deleteAtSlot(slot4, true, null);
                                throw T_Fail.testFailMsg("delete an invalid record " + rhs[i]);
                            }
                            catch (StandardException standardException2) {
                                try {
                                    page1.fetchNumFields(rhs[i]);
                                    throw T_Fail.testFailMsg("fetch num fields on invalid record " + rhs[i]);
                                }
                                catch (StandardException standardException3) {
                                    try {
                                        page1.getSlotNumber(rhs[i]);
                                        throw T_Fail.testFailMsg("got slot number of invalid record " + rhs[i]);
                                    }
                                    catch (StandardException standardException4) {
                                        continue;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        this.PASS("P017");
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
    }

    protected void P018() throws StandardException, T_Fail {
        RecordHandle rh;
        T_RawStoreRow row;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L, 4096, 0, 1, false);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page1 = this.t_util.t_getPage(c, 1L);
        Page page2 = this.t_util.t_addPage(c);
        long pid1 = page1.getPageNumber();
        long pid2 = page2.getPageNumber();
        T_Util.t_checkEmptyPage(page2);
        int i = 0;
        boolean deleted = false;
        for (i = 0; i < 100; ++i) {
            row = new T_RawStoreRow("r" + i);
            rh = T_Util.t_insertAtSlot(page1, 0, row);
            page1.purgeAtSlot(0, 1, this.logDataForPurges);
        }
        i = 0;
        while (true) {
            row = new T_RawStoreRow("r" + i);
            rh = T_Util.t_insertAtSlot(page2, i, row);
            if (rh == null) break;
            ++i;
        }
        try {
            page2.copyAndPurge(page1, 0, page2.recordCount(), 0);
            throw T_Fail.testFailMsg("copying rows with expanding recids should cause an exception");
        }
        catch (StandardException standardException) {
            this.t_util.t_dropContainer(t, 0L, cid);
            this.t_util.t_commit(t);
            cid = this.t_util.t_addContainer(t, 0L, 4096, 0, 1, true);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page1 = this.t_util.t_getPage(c, 1L);
            page2 = this.t_util.t_addPage(c);
            pid1 = page1.getPageNumber();
            pid2 = page2.getPageNumber();
            T_Util.t_checkEmptyPage(page2);
            i = 0;
            for (i = 0; i < 100; ++i) {
                row = new T_RawStoreRow("r" + i);
                rh = T_Util.t_insertAtSlot(page1, 0, row);
                page1.purgeAtSlot(0, 1, this.logDataForPurges);
            }
            i = 0;
            while (true) {
                row = new T_RawStoreRow("r" + i);
                rh = T_Util.t_insertAtSlot(page2, i, row);
                if (rh == null) break;
                ++i;
            }
            long pnum2 = page2.getPageNumber();
            int numrows = page2.recordCount();
            try {
                page2.copyAndPurge(page1, 0, page2.recordCount(), 0);
                throw T_Fail.testFailMsg("copying rows with expanding recids should cause an exception");
            }
            catch (StandardException standardException2) {
                this.t_util.t_removePage(c, page1);
                this.t_util.t_commit(t);
                c = this.t_util.t_openContainer(t, 0L, cid, true);
                page1 = this.t_util.t_addPage(c);
                int tries = 0;
                while (page1.getPageNumber() != 1L) {
                    this.REPORT("getting page " + page1.getPageNumber());
                    this.t_util.t_commit(t);
                    if (tries++ > 100) {
                        throw T_Fail.testFailMsg("failed to get back first page after " + tries + " tries");
                    }
                    c = this.t_util.t_openContainer(t, 0L, cid, true);
                    page1 = this.t_util.t_addPage(c);
                }
                page2 = this.t_util.t_getPage(c, pnum2);
                T_Util.t_checkRecordCount(page2, numrows, numrows);
                T_Util.t_checkEmptyPage(page1);
                try {
                    page2.copyAndPurge(page1, 0, page2.recordCount(), 0);
                }
                catch (StandardException se) {
                    throw T_Fail.testFailMsg("copying rows with non-expanding recids should not cause an exception");
                }
                this.PASS("P018");
                this.t_util.t_dropContainer(t, 0L, cid);
                this.t_util.t_commit(t);
                t.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P019() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L, 4096, 0, 1, false);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page p1 = c.addPage(2);
        long pnum1 = p1.getPageNumber();
        p1.unlatch();
        Page p2 = c.addPage();
        long pnum2 = p2.getPageNumber();
        p2.unlatch();
        Page p3 = c.addPage(2);
        long pnum3 = p3.getPageNumber();
        p3.unlatch();
        Page p = c.getFirstPage();
        try {
            long pnum0 = p.getPageNumber();
            p.unlatch();
            p = c.getNextPage(pnum0);
            if (p.getPageNumber() != pnum1) {
                throw T_Fail.testFailMsg("expected pagenum " + pnum1 + " got " + p.getPageNumber());
            }
            p.unlatch();
            p = null;
            p = c.getNextPage(pnum1);
            if (p.getPageNumber() != pnum2) {
                throw T_Fail.testFailMsg("expected pagenum " + pnum2 + " got " + p.getPageNumber());
            }
            p.unlatch();
            p = null;
            p = c.getNextPage(pnum2);
            if (p.getPageNumber() != pnum3) {
                throw T_Fail.testFailMsg("expected pagenum " + pnum3 + " got " + p.getPageNumber());
            }
            p.unlatch();
            p = null;
            p = c.getNextPage(pnum3);
            if (p != null) {
                throw T_Fail.testFailMsg("expected null page after " + pnum3 + " got " + p.getPageNumber());
            }
            if (testRollback) {
                this.t_util.t_abort(t);
                c = this.t_util.t_openContainer(t, 0L, cid, true);
                p = this.t_util.t_getPage(c, pnum0);
                T_Util.t_checkEmptyPage(p);
                p.unlatch();
                p = null;
                p = this.t_util.t_getPage(c, pnum1);
                T_Util.t_checkEmptyPage(p);
                p.unlatch();
                p = null;
                p = this.t_util.t_getPage(c, pnum2);
                T_Util.t_checkEmptyPage(p);
                p.unlatch();
                p = null;
                p = this.t_util.t_getPage(c, pnum3);
                T_Util.t_checkEmptyPage(p);
                p.unlatch();
                p = null;
                p = this.t_util.t_getLastPage(c);
                if (p.getPageNumber() != pnum3) {
                    throw T_Fail.testFailMsg("expect last page to be " + pnum3 + " got " + p.getPageNumber());
                }
                p.unlatch();
                p = null;
            }
            this.t_util.t_dropContainer(t, 0L, cid);
        }
        finally {
            if (p != null) {
                p.unlatch();
            }
            p = null;
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P019 - container " + cid);
    }

    protected void P020() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        Properties tableProperties = new Properties();
        tableProperties.put("derby.storage.pageSize", Integer.toString(4096));
        tableProperties.put("derby.storage.initialPages", Integer.toString(100));
        long cid = this.t_util.t_addContainer(t, 0L, tableProperties);
        if (cid < 0L) {
            throw T_Fail.testFailMsg("addContainer");
        }
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page p1 = c.getFirstPage();
        if (p1.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("expect first page to have FIRST_PAGE_NUMBER");
        }
        p1.unlatch();
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("expect to have only 1 page allocated");
        }
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P020 - container " + cid);
    }

    protected void P021() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        c.preAllocate(10);
        Page p1 = c.getFirstPage();
        if (p1.getPageNumber() != 1L) {
            throw T_Fail.testFailMsg("expect first page to have FIRST_PAGE_NUMBER");
        }
        p1.unlatch();
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("expect to have only 1 page allocated");
        }
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P021 - container " + cid);
    }

    protected void P022() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L, 4096, 0, 9, false);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page1 = this.t_util.t_getPage(c, 1L);
        for (int i = 0; i < 60; ++i) {
            T_RawStoreRow row = new T_RawStoreRow("r" + i);
            RecordHandle rh = T_Util.t_insertAtSlot(page1, 0, row);
        }
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P022");
    }

    protected void P023(int segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096, 0, 0, false);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, (long)segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        int overflowThreshold = 50;
        T_Util.t_checkEmptyPage(page);
        boolean insertFlag = true;
        T_RawStoreRow r1 = new T_RawStoreRow(1);
        r1.setColumn(0, 200, REC_001);
        RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh1 == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        RecordHandle rh2 = T_Util.t_insertAtSlot(page, 1, r1, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh2 == null) {
            throw T_Fail.testFailMsg("insert of second long row failed.");
        }
        T_Util.t_checkFetch(page, rh1, r1);
        T_Util.t_checkFetch(page, rh2, r1);
        page.unlatch();
        page = null;
        this.REPORT("test 1: 2 rows under threshold inserted...");
        page = this.t_util.t_addPage(c);
        T_RawStoreRow r2 = new T_RawStoreRow(1);
        r2.setColumn(0, 2000, REC_001);
        rh1 = T_Util.t_insertAtSlot(page, 0, r2, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh1 != null) {
            throw T_Fail.testFailMsg("insert of 1st over threshold row should failed.");
        }
        rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh2 != null) {
            throw T_Fail.testFailMsg("insert of 2nd over threshold row should failed.");
        }
        page.unlatch();
        page = null;
        this.REPORT("test 2: 2 rows over threshold not inserted...");
        page = this.t_util.t_addPage(c);
        T_RawStoreRow r3 = new T_RawStoreRow(2);
        r3.setColumn(0, 400, REC_001);
        r3.setColumn(1, 400, REC_001);
        rh1 = T_Util.t_insertAtSlot(page, 0, r3, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh1 == null) {
            throw T_Fail.testFailMsg("insert of 1st 2-column row failed.");
        }
        rh2 = T_Util.t_insertAtSlot(page, 1, r3, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh2 == null) {
            throw T_Fail.testFailMsg("insert of 2nd 2-column row failed.");
        }
        page.unlatch();
        page = null;
        this.REPORT("test 3: 2 rows with 2 columns under the threshold inserted...");
        page = this.t_util.t_addPage(c);
        T_RawStoreRow r4 = new T_RawStoreRow(2);
        r4.setColumn(0, 800, REC_001);
        r4.setColumn(1, 800, REC_001);
        rh1 = T_Util.t_insertAtSlot(page, 0, r4, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh1 != null) {
            SanityManager.DEBUG_PRINT((String)"bug", (String)("page = " + page));
            throw T_Fail.testFailMsg("insert of 1st 2-column row (OT) should failed.");
        }
        rh2 = T_Util.t_insertAtSlot(page, 0, r4, (byte)(insertFlag ? 1 : 0), overflowThreshold);
        if (rh2 != null) {
            throw T_Fail.testFailMsg("insert of 2nd 2-column row (OT) should failed.");
        }
        page.unlatch();
        page = null;
        this.REPORT("test 4: 2 rows with 2 columns over the threshold not inserted...");
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P023");
    }

    protected void P024(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096, 0, 1, false);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page1 = this.t_util.t_getLastPage(c);
        Page page2 = this.t_util.t_addPage(c);
        long p1 = page1.getPageNumber();
        long p2 = page2.getPageNumber();
        this.t_util.t_checkGetLatchedPage(c, p1);
        this.t_util.t_checkGetLatchedPage(c, p2);
        page1.unlatch();
        this.t_util.t_checkGetLatchedPage(c, p2);
        page1 = this.t_util.t_getPage(c, p1);
        page1.unlatch();
        page2.unlatch();
        this.t_util.t_dropContainer(t, segment, cid);
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P024");
    }

    protected void P030(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow r0 = new T_RawStoreRow(0);
        T_RawStoreRow r1 = new T_RawStoreRow(null);
        T_RawStoreRow r2 = new T_RawStoreRow("0123456789");
        T_Util.t_insertAtSlot(page, 0, r0);
        T_Util.t_insertAtSlot(page, 1, r1);
        T_Util.t_insertAtSlot(page, 2, r2);
        T_Util.t_checkRecordCount(page, 3, 3);
        page.unlatch();
        page = null;
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        this.t_util.t_checkStringLengthFetch(page, 1, -1);
        this.t_util.t_checkStringLengthFetch(page, 2, 10);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        T_RawStoreRow r1u = new T_RawStoreRow(String.valueOf(new char[1937]));
        page.updateAtSlot(1, (Object[])r1u.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 10);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        T_RawStoreRow r2u = new T_RawStoreRow(String.valueOf(new char[1099]));
        page = this.t_util.t_getPage(c, 1L);
        page.updateAtSlot(2, (Object[])r2u.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 0);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow r0u = new T_RawStoreRow(String.valueOf(new char[423]));
        page.updateAtSlot(0, (Object[])r0u.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 0, 423);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 1);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        r0u = new T_RawStoreRow(String.valueOf(new char[399]));
        page.updateAtSlot(0, (Object[])r0u.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 0, 399);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 1);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        r0u = new T_RawStoreRow(String.valueOf(new char[1400]));
        page.updateAtSlot(0, (Object[])r0u.getRow(), (FormatableBitSet)null);
        this.t_util.t_checkStringLengthFetch(page, 0, 1400);
        this.t_util.t_checkStringLengthFetch(page, 1, 1937);
        this.t_util.t_checkStringLengthFetch(page, 2, 1099);
        T_Util.t_checkFieldCount(page, 0, 1);
        T_Util.t_checkFieldCount(page, 1, 1);
        T_Util.t_checkFieldCount(page, 2, 1);
        page.unlatch();
        if (c.getNextPage(1L) != null) {
            throw T_Fail.testFailMsg("an extra page has appeared in the container");
        }
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P030: segment = " + segment);
    }

    protected void P031(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow r0 = new T_RawStoreRow(4);
        r0.setColumn(0, 256, REC_001);
        r0.setColumn(1, 256, REC_002);
        r0.setColumn(2, 256, REC_003);
        r0.setColumn(3, 256, REC_004);
        int insertFlag = 0;
        insertFlag |= 8;
        RecordHandle rh0 = null;
        try {
            rh0 = T_Util.t_insertAtSlot(page, 0, r0, (byte)insertFlag);
        }
        catch (StandardException se) {
            throw T_Fail.testFailMsg("insert of long row failed.");
        }
        if (rh0 == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        this.REPORT("about to check fetch...");
        SQLChar column = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, false, REC_001, 256);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, false, REC_002, 256);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column, false, REC_003, 256);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column, false, REC_004, 256);
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P031: segment = " + segment);
    }

    protected void P032(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        int insertFlag = 0;
        insertFlag |= 8;
        T_RawStoreRow r0 = new T_RawStoreRow(60);
        for (int i = 0; i < 60; ++i) {
            r0.setColumn(i, 1200, REC_001);
        }
        RecordHandle rh0 = null;
        try {
            rh0 = T_Util.t_insertAtSlot(page, 0, r0, (byte)insertFlag);
        }
        catch (StandardException se) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        if (rh0 == null) {
            throw T_Fail.testFailMsg("insert of a 60-column (300 bytes per column) row failed.");
        }
        this.REPORT("about to check fetch the first long row inserted...");
        SQLChar column = new SQLChar();
        for (int i = 0; i < 60; ++i) {
            T_Util.t_checkFetchColFromSlot(page, 0, i, (DataValueDescriptor)column, false, REC_001, 1200);
        }
        for (int i = 0; i < 60; ++i) {
            r0.setColumn(i, REC_001);
        }
        RecordHandle rh1 = null;
        try {
            rh1 = T_Util.t_insertAtSlot(page, 1, r0, (byte)insertFlag);
        }
        catch (StandardException se) {
            throw T_Fail.testFailMsg("insert of second long row failed.");
        }
        if (rh1 == null) {
            throw T_Fail.testFailMsg("insert of a 60-column (~10 bytes per column) row failed.");
        }
        this.REPORT("about to check fetch the second long row inserted ...");
        SQLChar column2 = new SQLChar();
        for (int i = 0; i < 60; ++i) {
            T_Util.t_checkFetchColFromSlot(page, 1, i, (DataValueDescriptor)column2, false, REC_001);
        }
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P032: segment = " + segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P033(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            T_RawStoreRow r0 = new T_RawStoreRow(100);
            for (int i = 0; i < 100; ++i) {
                r0.setColumn(i, REC_007);
            }
            int insertFlag = 8;
            RecordHandle rh0 = null;
            try {
                rh0 = T_Util.t_insertAtSlot(page, 0, r0, (byte)insertFlag);
            }
            catch (StandardException se) {
                throw T_Fail.testFailMsg("insert of long row failed.");
            }
            if (rh0 == null) {
                throw T_Fail.testFailMsg("insert of first long row failed.");
            }
            this.REPORT("about to check fetch...");
            SQLChar column = new SQLChar();
            for (int i = 0; i < 100; ++i) {
                T_Util.t_checkFetchColFromSlot(page, 0, i, (DataValueDescriptor)column, false, REC_007);
            }
            page.unlatch();
            page = null;
            if (segment != -1L) {
                this.t_util.t_dropContainer(t, segment, cid);
            }
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P033: segment = " + segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P034(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(401);
            for (int i = 0; i < 400; ++i) {
                r1.setColumn(i, REC_001);
            }
            r1.setColumn(400, 1500, REC_001);
            RecordHandle rh = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh, r1);
            page.unlatch();
            page = null;
            if (segment != -1L) {
                this.t_util.t_dropContainer(t, segment, cid);
            }
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P034: segment = " + segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P035(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(1);
            r1.setColumn(0, 500, REC_001);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            this.REPORT("row 1 inserted...");
            T_RawStoreRow r2 = new T_RawStoreRow(6);
            r2.setColumn(0, 400, REC_001);
            r2.setColumn(1, 500, REC_002);
            r2.setColumn(2, 400, REC_001);
            r2.setColumn(3, 500, REC_002);
            r2.setColumn(4, 400, REC_001);
            r2.setColumn(5, 500, REC_002);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh2, r2);
            this.REPORT("row 2 inserted...");
            r1.setColumn(0, 1500, REC_001);
            RecordHandle rh3 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            if (rh3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            if (segment != -1L) {
                this.t_util.t_dropContainer(t, segment, cid);
            }
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P035: segment = " + segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P036() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(400);
            for (int i = 0; i < 400; ++i) {
                r1.setColumn(i, 100 + i, REC_001);
            }
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.REPORT("P036 - Nextpage is " + nextPageNumber);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh2, r1);
            page.unlatch();
            page = null;
            nextPage = this.t_util.t_addPage(c);
            long checkNextPageNumber = nextPage.getPageNumber();
            nextPage.unlatch();
            if (nextPageNumber != checkNextPageNumber) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + nextPageNumber + " but got " + checkNextPageNumber);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            t.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            page.unlatch();
            page = null;
            Page testPage = this.t_util.t_addPage(c);
            T_RawStoreRow testRow = new T_RawStoreRow(REC_001);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            t.rollbackToSavePoint(SP1, null);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            if ((this.openMode & 1) == 0) {
                page = this.t_util.t_getPage(c, 1L);
                if (this.logDataForPurges) {
                    T_Util.t_checkFetch(page, rh2, r1);
                } else {
                    int i;
                    T_RawStoreRow r1_wnl = new T_RawStoreRow(400);
                    for (i = 0; i < 18; ++i) {
                        r1_wnl.setColumn(i, 4, REC_NULL);
                    }
                    for (i = 18; i < 400; ++i) {
                        r1_wnl.setColumn(i, 100 + i, REC_001);
                    }
                    T_Util.t_checkFetch(page, rh2, r1_wnl);
                }
                page.unlatch();
                page = null;
            }
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P036");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P037() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(1);
            r1.setColumn(0, 5500, REC_001);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            T_RawStoreRow r2 = new T_RawStoreRow(6);
            r2.setColumn(0, 660, REC_001);
            r2.setColumn(1, 5000, REC_002);
            r2.setColumn(2, 660, REC_001);
            r2.setColumn(3, 5000, REC_002);
            r2.setColumn(4, 660, REC_001);
            r2.setColumn(5, 5000, REC_002);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh2, r2);
            RecordHandle rh3 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            if (rh3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.REPORT("P037 - Nextpage is " + nextPageNumber);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)insertFlag);
            rh3 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            T_Util.t_checkFetch(page, rh2, r2);
            if (rh3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            nextPage = this.t_util.t_addPage(c);
            long checkNextPageNumber = nextPage.getPageNumber();
            nextPage.unlatch();
            if (nextPageNumber != checkNextPageNumber) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + nextPageNumber + " but got " + checkNextPageNumber);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            t.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            Page testPage = this.t_util.t_addPage(c);
            T_RawStoreRow testRow = new T_RawStoreRow(REC_001);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            t.rollbackToSavePoint(SP1, null);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            T_Util.t_checkFetch(page, rh1, r1);
            if (this.logDataForPurges) {
                T_Util.t_checkFetch(page, rh2, r2);
            } else {
                T_RawStoreRow r2_wnl = new T_RawStoreRow(6);
                r2_wnl.setColumn(0, 4, REC_NULL);
                r2_wnl.setColumn(1, 5000, REC_002);
                r2_wnl.setColumn(2, 4, REC_NULL);
                r2_wnl.setColumn(3, 5000, REC_002);
                r2_wnl.setColumn(4, 4, REC_NULL);
                r2_wnl.setColumn(5, 5000, REC_002);
                T_Util.t_checkFetch(page, rh2, r2_wnl);
            }
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P037");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P038() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 10;
            T_RawStoreRow r1 = new T_RawStoreRow(1);
            r1.setColumn(0, 1500, REC_001);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_RawStoreRow r2 = new T_RawStoreRow(6);
            r2.setColumn(0, 400, REC_001);
            r2.setColumn(1, 500, REC_002);
            r2.setColumn(2, 400, REC_001);
            r2.setColumn(3, 500, REC_002);
            r2.setColumn(4, 400, REC_001);
            r2.setColumn(5, 500, REC_002);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)insertFlag);
            RecordHandle rh3 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            if (rh3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page = null;
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.REPORT("P038 - Nextpage is " + nextPageNumber);
            this.t_util.t_abort(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            nextPage = this.t_util.t_getPage(c, nextPageNumber);
            this.t_util.t_removePage(c, nextPage);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkEmptyPage(page);
            rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)insertFlag);
            rh3 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            T_Util.t_checkFetch(page, rh2, r2);
            if (rh3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            nextPage = this.t_util.t_addPage(c);
            long checkNextPageNumber = nextPage.getPageNumber();
            nextPage.unlatch();
            if (nextPageNumber != checkNextPageNumber) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + nextPageNumber + " but got " + checkNextPageNumber);
            }
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P038");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P039() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 8192);
        T_RawStoreRow bigRow = new T_RawStoreRow(3);
        bigRow.setColumn(0, 50, REC_001);
        bigRow.setColumn(1, 750, REC_002);
        bigRow.setColumn(2, 200, REC_003);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            RecordHandle rh1 = T_Util.t_insert(page, bigRow);
            RecordHandle rh2 = T_Util.t_insert(page, bigRow);
            RecordHandle rh3 = T_Util.t_insert(page, bigRow);
            T_Util.t_checkFetch(page, rh1, bigRow);
            T_Util.t_checkFetch(page, rh2, bigRow);
            T_Util.t_checkFetch(page, rh3, bigRow);
            T_RawStoreRow smallRow = new T_RawStoreRow(1);
            smallRow.setColumn(0, 500, REC_004);
            while (page.spaceForInsert()) {
                if (T_Util.t_insert(page, smallRow) != null) continue;
            }
            this.REPORT("P039: " + (page.recordCount() - 3) + " small rows have been inserted");
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            bigRow.setColumn(1, 2000, REC_005);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            int slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])bigRow.getRow(), null);
            T_Util.t_checkFetch(page, rh1, bigRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            if (T_Util.t_insert(page, smallRow) == null) {
                throw T_Fail.testFailMsg("expect row to have shrunk (1)");
            }
            while (page.spaceForInsert()) {
                if (T_Util.t_insert(page, smallRow) != null) continue;
            }
            this.REPORT("P039: " + (page.recordCount() - 3) + " small rows have been inserted");
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            FormatableBitSet colList = new FormatableBitSet(2);
            colList.set(1);
            T_RawStoreRow partialRow = new T_RawStoreRow(2);
            partialRow.setColumn(1, 8000, REC_006);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            int slot2 = page.getSlotNumber(rh2);
            page.updateAtSlot(slot2, (Object[])partialRow.getRow(), colList);
            bigRow.setColumn(1, 8000, REC_006);
            T_Util.t_checkFetch(page, rh2, bigRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            if (T_Util.t_insert(page, smallRow) == null) {
                throw T_Fail.testFailMsg("expect row to have shrunk (2)");
            }
            while (page.spaceForInsert()) {
                if (T_Util.t_insert(page, smallRow) != null) continue;
            }
            this.REPORT("P039: " + (page.recordCount() - 3) + " small rows have been inserted");
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            bigRow.setColumn(0, 100, REC_001);
            bigRow.setColumn(1, 200, REC_002);
            bigRow.setColumn(2, 200, REC_003);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            int slot3 = page.getSlotNumber(rh3);
            page.updateAtSlot(slot3, (Object[])bigRow.getRow(), null);
            T_Util.t_checkFetch(page, rh3, bigRow);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            if (T_Util.t_insert(page, smallRow) == null) {
                throw T_Fail.testFailMsg("expect row to have shrunk (3)");
            }
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P039");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P040() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            int insertFlag = 10;
            T_RawStoreRow row1 = new T_RawStoreRow(3);
            row1.setColumn(0, 400, REC_001);
            row1.setColumn(1, 800, REC_002);
            row1.setColumn(2, 400, REC_003);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, row1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, row1);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.t_util.t_commit(t);
            T_RawStoreRow row2 = new T_RawStoreRow(3);
            row2.setColumn(0, 1200, REC_001);
            row2.setColumn(1, 1200, REC_002);
            row2.setColumn(2, 400, REC_003);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 1, row2, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh2, row2);
            page.unlatch();
            page = null;
            nextPage = this.t_util.t_addPage(c);
            long checkNextPageNumber = nextPage.getPageNumber();
            if (checkNextPageNumber == nextPageNumber) {
                throw T_Fail.testFailMsg("expected to allocate more pages");
            }
            this.t_util.t_removePage(c, nextPage);
            this.t_util.t_commit(t);
            nextPageNumber = checkNextPageNumber;
            T_RawStoreRow partialRow = new T_RawStoreRow(2);
            partialRow.setColumn(1, 400, REC_004);
            T_RawStoreRow partialRow2 = new T_RawStoreRow(2);
            partialRow2.setColumn(0, 400, REC_004);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            FormatableBitSet colList = new FormatableBitSet(2);
            colList.set(1);
            int slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])partialRow.getRow(), colList);
            colList.clear(1);
            colList.set(0);
            int slot2 = page.getSlotNumber(rh2);
            page.updateAtSlot(slot2, (Object[])partialRow2.getRow(), colList);
            row1.setColumn(1, 400, REC_004);
            row2.setColumn(0, 400, REC_004);
            T_Util.t_checkFetch(page, rh1, row1);
            T_Util.t_checkFetch(page, rh2, row2);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            T_RawStoreRow row3 = new T_RawStoreRow(2);
            row3.setColumn(0, 400, REC_001);
            row3.setColumn(1, 800, REC_002);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            if (!page.spaceForInsert()) {
                throw T_Fail.testFailMsg("No space for insert after shrink row");
            }
            RecordHandle rh3 = T_Util.t_insertAtSlot(page, 1, row3, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh3, row3);
            page.unlatch();
            page = null;
            nextPage = this.t_util.t_addPage(c);
            checkNextPageNumber = nextPage.getPageNumber();
            if (checkNextPageNumber != nextPageNumber) {
                throw T_Fail.testFailMsg("not expected to allocate more pages " + nextPageNumber + "," + checkNextPageNumber);
            }
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P040");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P041() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(6);
            r1.setColumn(0, 400, REC_001);
            r1.setColumn(1, 500, REC_002);
            r1.setColumn(2, 400, REC_001);
            r1.setColumn(3, 500, REC_002);
            r1.setColumn(4, 400, REC_001);
            r1.setColumn(5, 500, REC_002);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            T_RawStoreRow r2 = new T_RawStoreRow(6);
            r2.setColumn(0, 100, REC_003);
            r2.setColumn(1, 100, REC_004);
            r2.setColumn(2, 100, REC_003);
            r2.setColumn(3, 500, REC_005);
            r2.setColumn(4, 500, REC_006);
            r2.setColumn(5, 500, REC_005);
            int slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])r2.getRow(), null);
            T_Util.t_checkFetch(page, rh1, r2);
            page.unlatch();
            page = null;
            Page nextpage = this.t_util.t_addPage(c);
            long nextPageNumber = nextpage.getPageNumber();
            this.t_util.t_removePage(c, nextpage);
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh1, r2);
            t.setSavePoint(SP1, null);
            slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])r1.getRow(), null);
            T_Util.t_checkFetch(page, rh1, r1);
            page.unlatch();
            page = null;
            nextpage = this.t_util.t_addPage(c);
            long checkNextPageNumber = nextpage.getPageNumber();
            nextpage.unlatch();
            if (checkNextPageNumber != nextPageNumber) {
                throw T_Fail.testFailMsg("expect next page to be unchanged");
            }
            t.rollbackToSavePoint(SP1, null);
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh1, r2);
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P041");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P042() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_RawStoreRow smallRow = new T_RawStoreRow(REC_001);
            RecordHandle rh1 = T_Util.t_insert(page, smallRow);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_RawStoreRow bigRow = new T_RawStoreRow(1);
            bigRow.setColumn(0, 6400, REC_001);
            int slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])bigRow.getRow(), null);
            T_Util.t_checkFetch(page, rh1, bigRow);
            page.unlatch();
            page = null;
            Page checkGrow = this.t_util.t_addPage(c);
            long checkGrowPageNumber = checkGrow.getPageNumber();
            if (checkGrowPageNumber == nextPageNumber) {
                throw T_Fail.testFailMsg("expect to have allocated more pages");
            }
            this.t_util.t_removePage(c, checkGrow);
            this.t_util.t_abort(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            checkGrow = this.t_util.t_getPage(c, checkGrowPageNumber);
            this.t_util.t_removePage(c, checkGrow);
            nextPage = this.t_util.t_addPage(c);
            if (nextPage.getPageNumber() != nextPageNumber) {
                throw T_Fail.testFailMsg("rollback of update to long column did not release the long column chain pages");
            }
            this.t_util.t_removePage(c, nextPage);
            this.t_util.t_commit(t);
            T_RawStoreRow row2 = new T_RawStoreRow(6);
            row2.setColumn(0, 1600, REC_001);
            row2.setColumn(1, 2000, REC_002);
            row2.setColumn(2, 1600, REC_001);
            row2.setColumn(3, 2000, REC_002);
            row2.setColumn(4, 1600, REC_001);
            row2.setColumn(5, 2000, REC_002);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            t.setSavePoint(SP1, null);
            slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])row2.getRow(), null);
            nextPage = this.t_util.t_addPage(c);
            nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            t.rollbackToSavePoint(SP1, null);
            nextPage = this.t_util.t_getPage(c, nextPageNumber);
            this.t_util.t_removePage(c, nextPage);
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            Page checkNextPage = this.t_util.t_addPage(c);
            if (checkNextPage.getPageNumber() == nextPageNumber) {
                throw T_Fail.testFailMsg("expect some pages to be freed by update rollback");
            }
            this.t_util.t_removePage(c, checkNextPage);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh1, smallRow);
            slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])row2.getRow(), null);
            nextPage = this.t_util.t_addPage(c);
            nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.t_util.t_commit(t);
            T_RawStoreRow row3 = new T_RawStoreRow(5);
            row3.setColumn(0, 4000, REC_003);
            row3.setColumn(1, 4000, REC_004);
            row3.setColumn(2, REC_001);
            row3.setColumn(3, REC_001);
            row3.setColumn(4, 4000, REC_003);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            slot1 = page.getSlotNumber(rh1);
            page.updateAtSlot(slot1, (Object[])row3.getRow(), null);
            T_Util.t_checkFetch(page, rh1, row3);
            page.unlatch();
            page = null;
            this.t_util.t_abort(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            nextPage = this.t_util.t_addPage(c);
            if (nextPage.getPageNumber() != nextPageNumber) {
                throw T_Fail.testFailMsg("expect pages to be freed by update rollback");
            }
            nextPage.unlatch();
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null && page.isLatched()) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P042");
    }

    protected void P043() {
    }

    protected void P050() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        t.setSavePoint(SP1, null);
        t.dropContainer(new ContainerKey(0L, cid));
        t.rollbackToSavePoint(SP1, null);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        this.t_util.t_addPage(c);
        this.t_util.t_commit(t);
        long cid2 = this.t_util.t_addContainer(t, 0L);
        c = this.t_util.t_openContainer(t, 0L, cid2, true);
        this.t_util.t_addPage(c);
        this.t_util.t_addPage(c);
        this.t_util.t_addPage(c);
        this.t_util.t_addPage(c);
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, 0L, cid, false);
        this.PASS("P050");
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_dropContainer(t, 0L, cid2);
        this.t_util.t_commit(t);
        t.close();
    }

    protected void P051() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        T_RawStoreRow row = new T_RawStoreRow(REC_001);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        RecordHandle rh1 = T_Util.t_insert(page, row);
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, 0L, cid, true);
        this.t_util.t_checkFetch(c, rh1, REC_001);
        row = new T_RawStoreRow(REC_002);
        RecordHandle rh2 = this.t_util.t_insert(c, row);
        this.t_util.t_checkFetch(c, rh1, REC_001);
        this.t_util.t_checkFetch(c, rh2, REC_002);
        this.t_util.t_abort(t);
        c = this.t_util.t_openContainer(t, 0L, cid, true);
        this.t_util.t_checkFetch(c, rh1, REC_001);
        page = this.t_util.t_getPage(c, rh2.getPageNumber());
        if (page.recordExists(rh2, false)) {
            throw T_Fail.testFailMsg("record insert was not undone");
        }
        page.unlatch();
        this.PASS("P051");
        this.t_util.t_dropContainer(t, 0L, cid);
        this.t_util.t_commit(t);
        t.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P053() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        try {
            long cid = this.t_util.t_addContainer(t, 0L);
            this.t_util.t_commit(t);
            ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
            Page page = this.t_util.t_addPage(c);
            T_RawStoreRow row0 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
            T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
            T_Util.t_insertAtSlot(page, 0, row0, (byte)2);
            if (T_Util.t_insertAtSlot(page, 1, row1) == null) {
                return;
            }
            if (T_Util.t_insertAtSlot(page, 2, row2, (byte)2) == null) {
                return;
            }
            if (T_Util.t_insertAtSlot(page, 3, row3) == null) {
                return;
            }
            if (T_Util.t_insertAtSlot(page, 4, row4, (byte)2) == null) {
                return;
            }
            int fillerRows = 0;
            while (page.spaceForInsert()) {
                T_Util.t_insertAtSlot(page, 4, row4);
                ++fillerRows;
            }
            T_Util.t_checkRecordCount(page, fillerRows + 5, fillerRows + 5);
            this.t_util.t_abort(t);
            c = this.t_util.t_openContainer(t, 0L, cid, true);
            page = this.t_util.t_getLastPage(c);
            T_Util.t_checkRecordCount(page, 2 + fillerRows, 0);
            T_Util.t_insert(page, row0);
            T_Util.t_insert(page, row2);
            T_Util.t_insert(page, row4);
            T_Util.t_checkRecordCount(page, 5 + fillerRows, 3);
            page.unlatch();
            this.PASS("P053");
            this.t_util.t_dropContainer(t, 0L, cid);
        }
        finally {
            this.t_util.t_commit(t);
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P054() throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        ContextManager previousCM = contextService.getCurrentContextManager();
        ContextManager cm1 = contextService.newContextManager();
        contextService.setCurrentContextManager(cm1);
        Transaction tuser = this.t_util.t_startTransaction();
        Transaction tinternal = null;
        try {
            long cid1 = this.t_util.t_addContainer(tuser, 0L);
            ContainerHandle c1 = this.t_util.t_openContainer(tuser, 0L, cid1, true);
            Page p1 = this.t_util.t_addPage(c1);
            this.t_util.t_commit(tuser);
            T_RawStoreRow row = new T_RawStoreRow(REC_001);
            c1 = this.t_util.t_openContainer(tuser, 0L, cid1, true);
            p1 = this.t_util.t_getLastPage(c1);
            RecordHandle r1 = T_Util.t_insert(p1, row);
            this.REPORT("starting internal transaction");
            tinternal = this.t_util.t_startInternalTransaction();
            long cid2 = this.t_util.t_addContainer(tinternal, 0L);
            ContainerHandle c2 = this.t_util.t_openContainer(tinternal, 0L, cid2, true);
            Page p2 = this.t_util.t_addPage(c2);
            RecordHandle r2 = T_Util.t_insert(p2, row);
            tinternal.commit();
            tinternal.abort();
            tinternal.close();
            tinternal = null;
            this.REPORT("commit internal transaction");
            this.t_util.t_abort(tuser);
            this.REPORT("rollback user transaction");
            c1 = this.t_util.t_openContainer(tuser, 0L, cid1, true);
            p1 = this.t_util.t_getPage(c1, r1.getPageNumber());
            if (p1.recordExists(r1, false)) {
                throw T_Fail.testFailMsg("user transaction failed to rollback");
            }
            c2 = this.t_util.t_openContainer(tuser, 0L, cid2, true);
            this.t_util.t_checkFetch(c2, r2, REC_001);
            p2 = this.t_util.t_getLastPage(c2);
            T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
            if (!p2.spaceForInsert()) {
                this.REPORT("P054 not run, page cannot accomodate 2 rows");
                return;
            }
            RecordHandle r21 = T_Util.t_insert(p2, row2);
            tinternal = this.t_util.t_startInternalTransaction();
            long cid3 = this.t_util.t_addContainer(tinternal, 0L);
            ContainerHandle c3 = this.t_util.t_openContainer(tinternal, 0L, cid3, true);
            Page p3 = this.t_util.t_addPage(c3);
            RecordHandle r3 = T_Util.t_insert(p3, row);
            try {
                T_Util.t_insertAtSlot(p3, 100, row);
            }
            catch (StandardException se) {
                this.REPORT("cleanup on error");
                cm1.cleanupOnError((Throwable)se, false);
                this.REPORT("done cleanup on error");
            }
            tinternal = null;
            c2 = this.t_util.t_openContainer(tuser, 0L, cid2, true);
            this.t_util.t_checkFetch(c2, r2, REC_001);
            p2 = this.t_util.t_getPage(c2, r21.getPageNumber());
            if (p2.recordExists(r21, false)) {
                throw T_Fail.testFailMsg("expect user transaction to rollback");
            }
            ContainerKey id3 = new ContainerKey(0L, cid3);
            c3 = tuser.openContainer(id3, 8);
            if (c3 != null) {
                throw T_Fail.testFailMsg("expect internal transaction to rollback");
            }
            LockingPolicy nolock = tuser.newLockingPolicy(0, 0, false);
            RawContainerHandle stub = ((RawTransaction)tuser).openDroppedContainer(id3, nolock);
            if (stub == null) {
                throw T_Fail.testFailMsg("expect container to be dropped");
            }
            if (stub.getContainerStatus() != 4) {
                throw T_Fail.testFailMsg("expect container to be committed dropped");
            }
            p3 = stub.getPage(r3.getPageNumber());
            if (p3 != null) {
                throw T_Fail.testFailMsg("should not getpage with committed dropped container");
            }
            this.PASS("P054");
            this.t_util.t_dropContainer(tuser, 0L, cid2);
            this.t_util.t_dropContainer(tuser, 0L, cid1);
            if (tinternal != null) {
                this.t_util.t_abort(tinternal);
                tinternal.close();
            }
            if (tuser != null) {
                this.t_util.t_commit(tuser);
                tuser.close();
            }
        }
        finally {
            contextService.resetCurrentContextManager(cm1);
        }
    }

    protected void P055(long segment) throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        int colSize = 90;
        T_RawStoreRow r0 = new T_RawStoreRow(10);
        r0.setColumn(0, colSize, REC_001);
        r0.setColumn(1, colSize, REC_002);
        r0.setColumn(2, colSize, REC_003);
        r0.setColumn(3, colSize, REC_004);
        r0.setColumn(4, colSize, REC_005);
        r0.setColumn(5, colSize, REC_009);
        r0.setColumn(6, colSize, REC_010);
        r0.setColumn(7, colSize, REC_011);
        r0.setColumn(8, colSize, REC_012);
        r0.setColumn(9, colSize, REC_013);
        int insertFlag = 0;
        insertFlag |= 8;
        RecordHandle rh0 = null;
        try {
            rh0 = T_Util.t_insertAtSlot(page, 0, r0, (byte)insertFlag);
        }
        catch (StandardException se) {
            throw T_Fail.testFailMsg("insert of long row failed.");
        }
        if (rh0 == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        this.REPORT("about to check fetch...");
        SQLChar column = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, false, REC_001, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, false, REC_002, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column, false, REC_003, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column, false, REC_004, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)column, false, REC_005, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)column, false, REC_009, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)column, false, REC_010, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)column, false, REC_011, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)column, false, REC_012, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)column, false, REC_013, colSize);
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow updateRow = new T_RawStoreRow(10);
        for (int i = 0; i < 10; ++i) {
            updateRow.setColumn(i, (String)null);
        }
        updateRow.setColumn(5, colSize * 2, REC_009);
        FormatableBitSet colList = new FormatableBitSet(10);
        colList.set(5);
        page.updateAtSlot(0, (Object[])updateRow.getRow(), colList);
        this.REPORT("about to check fetch after update ...");
        SQLChar column2 = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column2, false, REC_001, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column2, false, REC_002, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column2, false, REC_003, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column2, false, REC_004, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)column2, false, REC_005, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)column2, false, REC_009, colSize * 2);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)column2, false, REC_010, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)column2, false, REC_011, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)column2, false, REC_012, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)column2, false, REC_013, colSize);
        page.unlatch();
        this.t_util.t_abort(t);
        this.REPORT("about to check fetch after abort ...");
        c = this.t_util.t_openContainer(t, segment, cid, false);
        page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column2, false, REC_001, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column2, false, REC_002, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column2, false, REC_003, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column2, false, REC_004, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)column2, false, REC_005, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)column2, false, REC_009, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)column2, false, REC_010, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)column2, false, REC_011, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)column2, false, REC_012, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)column2, false, REC_013, colSize);
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P055: segment = " + segment);
    }

    protected void P056(long segment) throws StandardException, T_Fail {
        if (!testRollback) {
            return;
        }
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        int colSize = 90;
        T_RawStoreRow r0 = new T_RawStoreRow(15);
        r0.setColumn(0, colSize, REC_001);
        r0.setColumn(1, colSize, REC_002);
        r0.setColumn(2, colSize, REC_003);
        r0.setColumn(3, colSize, REC_004);
        r0.setColumn(4, colSize, REC_005);
        r0.setColumn(5, colSize, REC_009);
        r0.setColumn(6, colSize, REC_010);
        r0.setColumn(7, colSize, REC_011);
        r0.setColumn(8, colSize, REC_012);
        r0.setColumn(9, colSize, REC_013);
        r0.setColumn(10, colSize, REC_014);
        r0.setColumn(11, colSize, REC_015);
        r0.setColumn(12, colSize, REC_016);
        r0.setColumn(13, colSize, REC_017);
        r0.setColumn(14, colSize, REC_018);
        int insertFlag = 0;
        insertFlag |= 8;
        RecordHandle rh0 = null;
        try {
            rh0 = T_Util.t_insertAtSlot(page, 0, r0, (byte)insertFlag);
        }
        catch (StandardException se) {
            throw T_Fail.testFailMsg("insert of long row failed.");
        }
        if (rh0 == null) {
            throw T_Fail.testFailMsg("insert of first long row failed.");
        }
        this.REPORT("about to check fetch...");
        SQLChar column = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column, false, REC_001, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column, false, REC_002, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column, false, REC_003, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column, false, REC_004, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)column, false, REC_005, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)column, false, REC_009, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)column, false, REC_010, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)column, false, REC_011, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)column, false, REC_012, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)column, false, REC_013, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 10, (DataValueDescriptor)column, false, REC_014, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 11, (DataValueDescriptor)column, false, REC_015, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 12, (DataValueDescriptor)column, false, REC_016, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 13, (DataValueDescriptor)column, false, REC_017, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 14, (DataValueDescriptor)column, false, REC_018, colSize);
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow updateRow = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            updateRow.setColumn(i, (String)null);
        }
        updateRow.setColumn(5, colSize * 2, REC_009);
        FormatableBitSet colList = new FormatableBitSet(15);
        colList.set(5);
        page.updateAtSlot(0, (Object[])updateRow.getRow(), colList);
        this.REPORT("about to check fetch after update ...");
        SQLChar column2 = new SQLChar();
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column2, false, REC_001, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column2, false, REC_002, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column2, false, REC_003, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column2, false, REC_004, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)column2, false, REC_005, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)column2, false, REC_009, colSize * 2);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)column2, false, REC_010, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)column2, false, REC_011, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)column2, false, REC_012, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)column2, false, REC_013, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 10, (DataValueDescriptor)column2, false, REC_014, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 11, (DataValueDescriptor)column2, false, REC_015, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 12, (DataValueDescriptor)column2, false, REC_016, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 13, (DataValueDescriptor)column2, false, REC_017, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 14, (DataValueDescriptor)column2, false, REC_018, colSize);
        page.unlatch();
        this.t_util.t_abort(t);
        this.REPORT("about to check fetch after abort ...");
        c = this.t_util.t_openContainer(t, segment, cid, false);
        page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkFetchColFromSlot(page, 0, 0, (DataValueDescriptor)column2, false, REC_001, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 1, (DataValueDescriptor)column2, false, REC_002, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 2, (DataValueDescriptor)column2, false, REC_003, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 3, (DataValueDescriptor)column2, false, REC_004, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 4, (DataValueDescriptor)column2, false, REC_005, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 5, (DataValueDescriptor)column2, false, REC_009, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 6, (DataValueDescriptor)column2, false, REC_010, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 7, (DataValueDescriptor)column2, false, REC_011, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 8, (DataValueDescriptor)column2, false, REC_012, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 9, (DataValueDescriptor)column2, false, REC_013, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 10, (DataValueDescriptor)column2, false, REC_014, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 11, (DataValueDescriptor)column2, false, REC_015, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 12, (DataValueDescriptor)column2, false, REC_016, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 13, (DataValueDescriptor)column2, false, REC_017, colSize);
        T_Util.t_checkFetchColFromSlot(page, 0, 14, (DataValueDescriptor)column2, false, REC_018, colSize);
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P056: segment = " + segment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P061() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment);
        int numCols = 6;
        T_RawStoreRow row1 = new T_RawStoreRow(numCols);
        row1.setColumn(0, (String)null);
        row1.setColumn(1, REC_001);
        row1.setColumn(2, (String)null);
        row1.setColumn(3, REC_002);
        row1.setColumn(4, (String)null);
        row1.setColumn(5, REC_003);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            RecordHandle rh1 = T_Util.t_insert(page, row1);
            T_Util.t_checkFetchCol(page, rh1, 1, numCols, REC_001);
            T_Util.t_checkFetchCol(page, rh1, 3, numCols, REC_002);
            T_Util.t_checkFetchCol(page, rh1, 5, numCols, REC_003);
            this.t_util.t_checkUpdateCol(page, rh1, 1, numCols, "woody");
            this.t_util.t_checkUpdateCol(page, rh1, 3, numCols, "buzz");
            this.t_util.t_checkUpdateCol(page, rh1, 5, numCols, "andy");
            this.t_util.t_checkUpdateCol(page, rh1, 2, numCols, "dino");
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P061");
    }

    protected void P071() throws StandardException, T_Fail {
        this.PASS("P071");
    }

    protected void P701(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(0);
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        page = this.t_util.t_getPage(c, 1L);
        for (int i = 0; i < 10; ++i) {
            this.REPORT("P701 - iteration " + i);
            row = new T_RawStoreRow(i);
            for (int j = 0; j < i; ++j) {
                row.setColumn(j, 256, "XX" + j + "YY");
            }
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])row.getRow(), null);
            page.unlatch();
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh, row);
        }
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P701: segment = " + segment);
    }

    protected void P702(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(0);
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        page = this.t_util.t_getPage(c, 1L);
        for (int i = 0; i < 10; ++i) {
            this.REPORT("P702 - iteration " + i);
            FormatableBitSet colList = new FormatableBitSet(i + 1);
            colList.set(i);
            T_RawStoreRow rowU = new T_RawStoreRow(i + 1);
            rowU.setColumn(i, 256, "XX" + i + "YY");
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])rowU.getRow(), colList);
            page.unlatch();
            T_RawStoreRow rowF = new T_RawStoreRow(i + 1);
            for (int j = 0; j <= i; ++j) {
                rowF.setColumn(j, 256, "XX" + j + "YY");
            }
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh, rowF);
        }
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P702: segment = " + segment);
    }

    protected void P703(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        this.REPORT("P703 - start ");
        T_RawStoreRow row = new T_RawStoreRow(2);
        row.setColumn(0, REC_001);
        row.setColumn(1, REC_002);
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        this.REPORT("P703 - insert Ok ");
        page.unlatch();
        page = this.t_util.t_getPage(c, 1L);
        this.P703Helper(page, rh, 0, REC_006, REC_002);
        this.REPORT("P703 - case 1 passed");
        this.P703Helper(page, rh, 1, REC_007, REC_006);
        this.REPORT("P703 - case 2 passed");
        this.P703Helper(page, rh, 0, REC_003, REC_007);
        this.REPORT("P703 - case 3 passed");
        this.P703Helper(page, rh, 1, REC_004, REC_003);
        this.REPORT("P703 - case 4 passed");
        this.P703Helper(page, rh, 0, null, REC_004);
        this.REPORT("P703 - case 5 passed");
        this.P703Helper(page, rh, 1, null, null);
        this.REPORT("P703 - case 6 passed");
        this.P703Helper(page, rh, 0, REC_002, null);
        this.REPORT("P703 - case 7 passed");
        this.P703Helper(page, rh, 1, REC_001, REC_002);
        this.REPORT("P703 - case 8 passed");
        this.P703Helper(page, rh, -1, REC_002, REC_001);
        this.REPORT("P703 - case 9 passed");
        FormatableBitSet colList = new FormatableBitSet(2);
        colList.set(0);
        colList.set(1);
        row.setColumn(0, REC_004);
        row.setColumn(1, REC_003);
        int slot = page.getSlotNumber(rh);
        page.updateAtSlot(slot, (Object[])row.getRow(), colList);
        T_Util.t_checkFetch(page, rh, row);
        this.REPORT("P703 - case 10 passed");
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        t.commit();
        t.close();
        this.PASS("P703: segment = " + segment);
    }

    private void P703Helper(Page page, RecordHandle rh, int colNum, String newVal, String unchangedCol) throws StandardException, T_Fail {
        FormatableBitSet colList = new FormatableBitSet(2);
        T_RawStoreRow rowU = new T_RawStoreRow(2);
        if (colNum != -1) {
            colList.grow(colNum + 1);
            colList.set(colNum);
            rowU.setColumn(colNum, newVal);
        } else {
            colNum = 0;
        }
        int slot = page.getSlotNumber(rh);
        page.updateAtSlot(slot, (Object[])rowU.getRow(), colList);
        T_RawStoreRow row = new T_RawStoreRow(2);
        row.setColumn(colNum, newVal);
        row.setColumn(colNum == 0 ? 1 : 0, unchangedCol);
        T_Util.t_checkFetch(page, rh, row);
    }

    protected void P704(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            row.setColumn(i, 100, "XX" + i + "YY");
        }
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        page = this.t_util.t_getPage(c, 1L);
        for (int i = 0; i < 15; ++i) {
            this.REPORT("P704 - col " + i);
            FormatableBitSet colList = new FormatableBitSet(i + 1);
            colList.set(i);
            T_RawStoreRow rowU = new T_RawStoreRow(i + 1);
            rowU.setColumn(i, 400, "WW" + i + "UU");
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])rowU.getRow(), colList);
            page.unlatch();
            row.setColumn(i, 400, "WW" + i + "UU");
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh, row);
        }
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P704: segment = " + segment);
    }

    protected void P705(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            row.setColumn(i, 100, "XX" + i + "YY");
        }
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        page = this.t_util.t_getPage(c, 1L);
        for (int i = 14; i >= 0; --i) {
            this.REPORT("P705 - col " + i);
            FormatableBitSet colList = new FormatableBitSet(i + 1);
            colList.set(i);
            T_RawStoreRow rowU = new T_RawStoreRow(i + 1);
            rowU.setColumn(i, 400, "WW" + i + "UU");
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])rowU.getRow(), colList);
            page.unlatch();
            row.setColumn(i, 400, "WW" + i + "UU");
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh, row);
        }
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P705: segment = " + segment);
    }

    protected void P706(long segment, boolean multiPortion) throws StandardException, T_Fail {
        int slot;
        T_RawStoreRow rowU;
        FormatableBitSet colList;
        int i;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(15);
        for (int i2 = 0; i2 < 15; ++i2) {
            row.setColumn(i2, multiPortion ? 100 : 10, "XX" + i2 + "YY");
        }
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        page = this.t_util.t_getPage(c, 1L);
        for (i = 0; i < 15; ++i) {
            if (i % 2 == 0) continue;
            this.REPORT("P706 : multiPortion " + multiPortion + " - col " + i);
            colList = new FormatableBitSet(i + 1);
            colList.set(i);
            rowU = new T_RawStoreRow(i + 1);
            rowU.setColumn(i, 3000, "WW" + i + "UU");
            slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])rowU.getRow(), colList);
            page.unlatch();
            row.setColumn(i, 3000, "WW" + i + "UU");
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh, row);
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        for (i = 0; i < 15; ++i) {
            this.REPORT("P706 : update to null " + multiPortion + " - col " + i);
            colList = new FormatableBitSet(i + 1);
            colList.set(i);
            rowU = new T_RawStoreRow(i + 1);
            rowU.setColumn(i, (String)null);
            slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])rowU.getRow(), colList);
            page.unlatch();
            row.setColumn(i, (String)null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkFetch(page, rh, row);
        }
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P706: multiPortion " + multiPortion + " segment = " + segment);
    }

    protected void P707(long segment) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(20);
        for (int i = 0; i < 20; ++i) {
            if (i % 2 == 0) {
                row.setColumn(i, 200, "XX" + i + "YY");
                continue;
            }
            row.setColumn(i, 4000, "XX" + i + "YY");
        }
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P707: segment = " + segment);
    }

    protected void P708(long segment, boolean multiPortion) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        T_RawStoreRow row = new T_RawStoreRow(15);
        for (int i = 0; i < 15; ++i) {
            row.setColumn(i, multiPortion ? 100 : 10, "XX" + i + "YY");
        }
        RecordHandle rh = T_Util.t_insertAtSlot(page, 0, row, (byte)8);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, segment, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        for (int i = 0; i < 15; ++i) {
            if (i % 2 == 0) continue;
            this.REPORT("P708 : multiPortion " + multiPortion + " - col " + i);
            FormatableBitSet colList = new FormatableBitSet(i + 1);
            colList.set(i);
            T_RawStoreRow rowU = new T_RawStoreRow(i + 1);
            rowU.setColumn(i, 3000, "WW" + i + "UU");
            int slot = page.getSlotNumber(rh);
            page.updateAtSlot(slot, (Object[])rowU.getRow(), colList);
        }
        this.t_util.t_abort(t);
        c = this.t_util.t_openContainer(t, segment, cid, false);
        page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkFetch(page, rh, row);
        page.unlatch();
        if (segment != -1L) {
            this.t_util.t_dropContainer(t, segment, cid);
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("P708: multiPortion " + multiPortion + " segment = " + segment);
    }

    protected void P709() throws StandardException, T_Fail {
        this.logDataForPurges = false;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, 0L);
        this.t_util.t_commit(t);
        ContainerHandle c = this.t_util.t_openContainer(t, 0L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_RawStoreRow row0 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
        T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
        T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
        T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
        RecordHandle r0 = T_Util.t_insertAtSlot(page, 0, row0);
        RecordHandle r1 = T_Util.t_insertAtSlot(page, 1, row1);
        RecordHandle r2 = T_Util.t_insertAtSlot(page, 2, row2);
        RecordHandle r3 = T_Util.t_insertAtSlot(page, 3, row3);
        RecordHandle r4 = T_Util.t_insertAtSlot(page, 4, row4);
        if (r3 != null) {
            page.deleteAtSlot(3, true, (LogicalUndo)null);
        }
        this.t_util.t_commit(t);
        c = this.t_util.t_openContainer(t, 0L, cid, true);
        page = this.t_util.t_getPage(c, 1L);
        try {
            page.purgeAtSlot(-1, 1, this.logDataForPurges);
            throw T_Fail.testFailMsg("negative slot number did not cause an exception");
        }
        catch (StandardException standardException) {
            try {
                page.purgeAtSlot(4, 4, this.logDataForPurges);
                throw T_Fail.testFailMsg("purging more rows than is on page did not cause an exception");
            }
            catch (StandardException standardException2) {
                if (r4 == null) {
                    int rcount = page.recordCount();
                    page.purgeAtSlot(0, 1, this.logDataForPurges);
                    if (page.recordCount() != rcount - 1) {
                        T_Fail.testFailMsg("failed to purge a record, expect " + (rcount - 1) + " got " + page.recordCount());
                    }
                    if (testRollback) {
                        this.t_util.t_abort(t);
                        c = this.t_util.t_openContainer(t, 0L, cid, true);
                        page = this.t_util.t_getPage(c, 1L);
                        if (this.logDataForPurges) {
                            T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        } else {
                            T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        }
                        if (page.recordCount() != rcount) {
                            T_Fail.testFailMsg("failed to rollback purge, expect " + rcount + " got " + page.recordCount());
                        }
                    } else {
                        this.t_util.t_commit(t);
                    }
                    this.PASS("mimimal purging P709");
                    return;
                }
                page.purgeAtSlot(1, 2, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_003, true, true);
                T_Util.t_checkFetchBySlot(page, 2, REC_004, false, true);
                if (page.recordCount() != 3) {
                    T_Fail.testFailMsg("page expect to have 3 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(0, 3, this.logDataForPurges);
                if (page.recordCount() != 0) {
                    T_Fail.testFailMsg("page expect to have 0 records, recordCount() = " + page.recordCount());
                }
                if (testRollback) {
                    this.REPORT("testing rollback");
                    this.t_util.t_abort(t);
                    c = this.t_util.t_openContainer(t, 0L, cid, true);
                    page = this.t_util.t_getPage(c, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    page.purgeAtSlot(2, 3, this.logDataForPurges);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 2) {
                        T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                    }
                    this.t_util.t_abort(t);
                    c = this.t_util.t_openContainer(t, 0L, cid, true);
                    page = this.t_util.t_getPage(c, 1L);
                    if (this.logDataForPurges) {
                        T_Util.t_checkFetchBySlot(page, 0, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_001, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_002, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_003, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_004, false, true);
                    } else {
                        T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                        T_Util.t_checkFetchBySlot(page, 3, REC_NULL, true, true);
                        T_Util.t_checkFetchBySlot(page, 4, REC_NULL, false, true);
                    }
                    if (page.recordCount() != 5) {
                        T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                    }
                    if (page.isDeletedAtSlot(1)) {
                        T_Fail.testFailMsg("rolled back purged undeleted record cause record to be deleted");
                    }
                    if (!page.isDeletedAtSlot(3)) {
                        T_Fail.testFailMsg("rolled back purged deleted record cause record to be undeleted");
                    }
                }
                this.REPORT("purging again the purges rolled back earlier");
                page.purgeAtSlot(1, 2, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_NULL, true, true);
                T_Util.t_checkFetchBySlot(page, 2, REC_NULL, false, true);
                if (page.recordCount() != 3) {
                    T_Fail.testFailMsg("page expect to have 3 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(0, 3, this.logDataForPurges);
                if (page.recordCount() != 0) {
                    T_Fail.testFailMsg("page expect to have 0 records, recordCount() = " + page.recordCount());
                }
                this.t_util.t_abort(t);
                c = this.t_util.t_openContainer(t, 0L, cid, true);
                page = this.t_util.t_getPage(c, 1L);
                if (page.recordCount() != 5) {
                    T_Fail.testFailMsg("page expect to have 5 records, recordCount() = " + page.recordCount());
                }
                page.purgeAtSlot(2, 3, this.logDataForPurges);
                T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                if (page.recordCount() != 2) {
                    T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                }
                this.t_util.t_commit(t);
                c = this.t_util.t_openContainer(t, 0L, cid, true);
                page = this.t_util.t_getPage(c, 1L);
                T_Util.t_checkFetchBySlot(page, 0, REC_NULL, false, true);
                T_Util.t_checkFetchBySlot(page, 1, REC_NULL, false, true);
                if (page.recordCount() != 2) {
                    T_Fail.testFailMsg("page expect to have 2 records, recordCount() = " + page.recordCount());
                }
                this.PASS("P709");
                this.t_util.t_dropContainer(t, 0L, cid);
                this.t_util.t_commit(t);
                t.close();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P710() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(100);
            for (int i = 0; i < 100; ++i) {
                r1.setColumn(i, 100 + i, REC_001);
            }
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.REPORT("P710 - Nextpage is " + nextPageNumber);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh2, r1);
            page.unlatch();
            page = null;
            nextPage = this.t_util.t_addPage(c);
            long checkNextPageNumber = nextPage.getPageNumber();
            nextPage.unlatch();
            if (nextPageNumber != checkNextPageNumber) {
                throw T_Fail.testFailMsg("fail to reuse row pieces expect next page=" + nextPageNumber + " but got " + checkNextPageNumber);
            }
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            t.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            page.unlatch();
            page = null;
            Page testPage = this.t_util.t_addPage(c);
            T_RawStoreRow testRow = new T_RawStoreRow(REC_001);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            t.rollbackToSavePoint(SP1, null);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            this.t_util.t_abort(t);
            page = null;
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 1, 1);
            page.purgeAtSlot(0, 1, this.logDataForPurges);
            page.unlatch();
            page = null;
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 0, 0);
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P710");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void P711() throws StandardException, T_Fail {
        long segment = 0L;
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, segment, 4096);
        ContainerHandle c = this.t_util.t_openContainer(t, segment, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        try {
            T_Util.t_checkEmptyPage(page);
            int insertFlag = 8;
            T_RawStoreRow r1 = new T_RawStoreRow(1);
            r1.setColumn(0, 5000, REC_001);
            RecordHandle rh1 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh1, r1);
            T_RawStoreRow r2 = new T_RawStoreRow(6);
            r2.setColumn(0, 600, REC_001);
            r2.setColumn(1, 5000, REC_002);
            r2.setColumn(2, 600, REC_001);
            r2.setColumn(3, 5000, REC_002);
            r2.setColumn(4, 600, REC_001);
            r2.setColumn(5, 5000, REC_002);
            RecordHandle rh2 = T_Util.t_insertAtSlot(page, 0, r2, (byte)insertFlag);
            T_Util.t_checkFetch(page, rh2, r2);
            RecordHandle rh3 = T_Util.t_insertAtSlot(page, 0, r1, (byte)insertFlag);
            if (rh3 != null) {
                throw T_Fail.testFailMsg("expect the 3rd row to not fit on page");
            }
            page.unlatch();
            page = null;
            Page nextPage = this.t_util.t_addPage(c);
            long nextPageNumber = nextPage.getPageNumber();
            this.t_util.t_removePage(c, nextPage);
            this.REPORT("P711 - Nextpage is " + nextPageNumber);
            this.t_util.t_commit(t);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            this.t_util.t_abort(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            t.setSavePoint(SP1, null);
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            page.purgeAtSlot(0, 2, this.logDataForPurges);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
            Page testPage = this.t_util.t_addPage(c);
            T_RawStoreRow testRow = new T_RawStoreRow(REC_001);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            t.rollbackToSavePoint(SP1, null);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            this.t_util.t_commit(t);
            T_Util.t_wait(10);
            c = this.t_util.t_openContainer(t, segment, cid, true);
            testPage = this.t_util.t_addPage(c);
            T_Util.t_insert(testPage, testRow);
            testPage.unlatch();
            page = this.t_util.t_getPage(c, 1L);
            T_Util.t_checkRecordCount(page, 2, 2);
            T_Util.t_checkFetch(page, rh1, r1);
            T_RawStoreRow r2_wnl = new T_RawStoreRow(6);
            r2_wnl.setColumn(0, 4, REC_NULL);
            r2_wnl.setColumn(1, 5000, REC_002);
            r2_wnl.setColumn(2, 4, REC_NULL);
            r2_wnl.setColumn(3, 5000, REC_002);
            r2_wnl.setColumn(4, 4, REC_NULL);
            r2_wnl.setColumn(5, 5000, REC_002);
            T_Util.t_checkFetch(page, rh2, r2_wnl);
            page.unlatch();
            page = null;
            this.t_util.t_dropContainer(t, segment, cid);
        }
        finally {
            if (page != null) {
                page.unlatch();
            }
            this.t_util.t_commit(t);
            t.close();
        }
        this.PASS("P711");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void L001() throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        int loop = 10;
        int logSize = this.threadNumber == 0 ? 50000 : 50;
        try {
            T_Undoable l;
            int i;
            for (i = 0; i < loop; ++i) {
                l = new T_Undoable(t.getGlobalId(), -1, -1, 0, 0, true, 10, false, i * logSize, false);
                t.logAndDo((Loggable)l);
            }
            t.commit();
            t.close();
            t = null;
            t = this.t_util.t_startTransaction();
            for (i = 0; i < loop; ++i) {
                l = new T_Undoable(t.getGlobalId(), -1, -1, 0, 0, true, 10, false, i * logSize, false);
                t.logAndDo((Loggable)l);
            }
            this.PASS("L001");
        }
        finally {
            t.commit();
            t.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void CP001() throws StandardException, T_Fail {
        Transaction t1;
        ContextManager cm1;
        Transaction longtran;
        ContextManager previousCM;
        block13: {
            if (!testRollback) {
                return;
            }
            previousCM = contextService.getCurrentContextManager();
            longtran = null;
            cm1 = null;
            t1 = null;
            ContextManager cm2 = null;
            Transaction t2 = null;
            try {
                T_RawStoreRow row1 = new T_RawStoreRow(REC_001);
                T_RawStoreRow row2 = new T_RawStoreRow(REC_002);
                T_RawStoreRow row3 = new T_RawStoreRow(REC_003);
                T_RawStoreRow row4 = new T_RawStoreRow(REC_004);
                T_RawStoreRow row5 = new T_RawStoreRow(REC_005);
                longtran = this.t_util.t_startTransaction();
                long cid = this.t_util.t_addContainer(longtran, 0L);
                ContainerHandle c = this.t_util.t_openContainer(longtran, 0L, cid, true);
                RecordHandle r1 = this.t_util.t_insert(c, row1);
                RecordHandle r2 = this.t_util.t_insert(c, row2);
                this.t_util.t_commit(longtran);
                c = this.t_util.t_openContainer(longtran, 0L, cid, true);
                Page p2 = this.t_util.t_getPage(c, r2.getPageNumber());
                int slot2 = p2.getSlotNumber(r2);
                p2.updateAtSlot(slot2, (Object[])row5.getRow(), null);
                p2.unlatch();
                cm1 = contextService.newContextManager();
                contextService.setCurrentContextManager(cm1);
                t1 = this.t_util.t_startTransaction();
                long cid1 = this.t_util.t_addContainer(t1, 0L);
                ContainerHandle c1 = this.t_util.t_openContainer(t1, 0L, cid1, true);
                RecordHandle r3 = this.t_util.t_insert(c1, row3);
                RecordHandle r4 = this.t_util.t_insert(c1, row4);
                contextService.resetCurrentContextManager(cm1);
                cm2 = contextService.newContextManager();
                contextService.setCurrentContextManager(cm2);
                t2 = this.t_util.t_startTransaction();
                long cid2 = this.t_util.t_addContainer(t2, 0L);
                ContainerHandle c2 = this.t_util.t_openContainer(t2, 0L, cid2, true);
                RecordHandle r5 = this.t_util.t_insert(c2, row1);
                this.t_util.t_commit(t2);
                c2 = this.t_util.t_openContainer(t2, 0L, cid2, true);
                Page p5 = this.t_util.t_getPage(c2, r5.getPageNumber());
                int slot5 = p5.getSlotNumber(r5);
                p5.updateAtSlot(slot5, (Object[])row5.getRow(), null);
                p5.unlatch();
                factory.checkpoint();
                contextService.resetCurrentContextManager(cm2);
                contextService.setCurrentContextManager(previousCM);
                this.t_util.t_checkFetch(c, r1, REC_001);
                this.t_util.t_checkFetch(c, r2, REC_005);
                contextService.resetCurrentContextManager(previousCM);
                contextService.setCurrentContextManager(cm1);
                this.t_util.t_checkFetch(c1, r3, REC_003);
                this.t_util.t_checkFetch(c1, r4, REC_004);
                contextService.resetCurrentContextManager(cm1);
                contextService.setCurrentContextManager(cm2);
                this.t_util.t_checkFetch(c2, r5, REC_005);
                factory.checkpoint();
                contextService.resetCurrentContextManager(cm2);
                contextService.setCurrentContextManager(previousCM);
                Page page = this.t_util.t_addPage(c);
                RecordHandle r6 = T_Util.t_insertAtSlot(page, 0, row1, (byte)2);
                page.unlatch();
                contextService.resetCurrentContextManager(previousCM);
                contextService.setCurrentContextManager(cm1);
                this.t_util.t_commit(t1);
                contextService.resetCurrentContextManager(cm1);
                contextService.setCurrentContextManager(cm2);
                this.t_util.t_abort(t2);
                contextService.resetCurrentContextManager(cm2);
                contextService.setCurrentContextManager(previousCM);
                this.t_util.t_checkFetch(c, r1, REC_001);
                this.t_util.t_checkFetch(c, r2, REC_005);
                this.t_util.t_checkFetch(c, r6, REC_001);
                contextService.resetCurrentContextManager(previousCM);
                contextService.setCurrentContextManager(cm1);
                c1 = this.t_util.t_openContainer(t1, 0L, cid1, true);
                this.t_util.t_checkFetch(c1, r3, REC_003);
                this.t_util.t_checkFetch(c1, r4, REC_004);
                contextService.resetCurrentContextManager(cm1);
                contextService.setCurrentContextManager(cm2);
                c2 = this.t_util.t_openContainer(t2, 0L, cid2, true);
                this.t_util.t_checkFetch(c2, r5, REC_001);
                factory.checkpoint();
                contextService.resetCurrentContextManager(cm2);
                contextService.setCurrentContextManager(previousCM);
                this.t_util.t_abort(longtran);
                c = this.t_util.t_openContainer(longtran, 0L, cid, true);
                this.t_util.t_checkFetch(c, r1, REC_001);
                this.t_util.t_checkFetch(c, r2, REC_002);
                Page p6 = this.t_util.t_getPage(c, r6.getPageNumber());
                T_Util.t_checkEmptyPage(p6);
                p6.unlatch();
                this.t_util.t_dropContainer(longtran, 0L, cid);
                contextService.resetCurrentContextManager(previousCM);
                contextService.setCurrentContextManager(cm1);
                this.t_util.t_checkFetch(c1, r3, REC_003);
                this.t_util.t_checkFetch(c1, r4, REC_004);
                this.t_util.t_dropContainer(t1, 0L, cid1);
                contextService.resetCurrentContextManager(cm1);
                contextService.setCurrentContextManager(cm2);
                this.t_util.t_checkFetch(c2, r5, REC_001);
                this.t_util.t_dropContainer(t2, 0L, cid2);
                factory.checkpoint();
                contextService.resetCurrentContextManager(cm2);
                this.PASS("CP001");
                if (t2 == null) break block13;
            }
            catch (Throwable t) {
                try {
                    t.printStackTrace(System.err);
                    if (cm1 != null) {
                        cm1.cleanupOnError(t, false);
                    }
                    if (cm2 != null) {
                        cm2.cleanupOnError(t, false);
                    }
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (t2 != null) {
                        contextService.setCurrentContextManager(cm2);
                        this.t_util.t_commit(t2);
                        t2.close();
                        contextService.resetCurrentContextManager(cm2);
                    }
                    if (t1 != null) {
                        contextService.setCurrentContextManager(cm1);
                        this.t_util.t_commit(t1);
                        t1.close();
                        contextService.resetCurrentContextManager(cm1);
                    }
                    if (longtran != null) {
                        contextService.setCurrentContextManager(previousCM);
                        this.t_util.t_commit(longtran);
                        longtran.close();
                        contextService.resetCurrentContextManager(previousCM);
                    }
                }
            }
            contextService.setCurrentContextManager(cm2);
            this.t_util.t_commit(t2);
            t2.close();
            contextService.resetCurrentContextManager(cm2);
        }
        if (t1 != null) {
            contextService.setCurrentContextManager(cm1);
            this.t_util.t_commit(t1);
            t1.close();
            contextService.resetCurrentContextManager(cm1);
        }
        if (longtran != null) {
            contextService.setCurrentContextManager(previousCM);
            this.t_util.t_commit(longtran);
            longtran.close();
            contextService.resetCurrentContextManager(previousCM);
        }
    }

    protected void TC001() throws T_Fail, StandardException {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, -1L);
        this.t_util.setOpenMode(this.openMode | 0x20);
        ContainerHandle c = this.t_util.t_openContainer(t, -1L, cid, true);
        this.t_util.t_commit(t);
        ContainerKey id = new ContainerKey(-1L, cid);
        c = t.openContainer(id, 8);
        if (c != null) {
            throw T_Fail.testFailMsg("Temp Container should not exist");
        }
        cid = this.t_util.t_addContainer(t, -1L);
        c = this.t_util.t_openContainer(t, -1L, cid, true);
        c.close();
        c = this.t_util.t_openContainer(t, -1L, cid, true);
        c.close();
        this.t_util.t_commit(t);
        id = new ContainerKey(-1L, cid);
        c = t.openContainer(id, 8);
        if (c != null) {
            throw T_Fail.testFailMsg("Temp Container should not exist");
        }
        cid = this.t_util.t_addContainer(t, -1L);
        this.t_util.setOpenMode(this.openMode | 0x20);
        c = this.t_util.t_openContainer(t, -1L, cid, true);
        this.t_util.t_abort(t);
        id = new ContainerKey(-1L, cid);
        c = t.openContainer(id, 8);
        if (c != null) {
            throw T_Fail.testFailMsg("Temp Container should not exist");
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("TC001");
    }

    private int[] populateTempTable(ContainerHandle c) throws StandardException, T_Fail {
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        int[] recordCount = new int[]{0, 0, 0};
        int i = 0;
        while (i < 3) {
            while (true) {
                T_RawStoreRow row = new T_RawStoreRow(REC_001 + i + "X" + recordCount[i]);
                RecordHandle rh = T_Util.t_insert(page, row);
                if (rh == null) break;
                int n = i;
                recordCount[n] = recordCount[n] + 1;
                T_Util.t_checkRecordCount(page, recordCount[i], recordCount[i]);
            }
            page.unlatch();
            page = null;
            if (++i >= 3) continue;
            page = this.t_util.t_addPage(c);
            T_Util.t_checkEmptyPage(page);
        }
        return recordCount;
    }

    protected void TC002(int mode, boolean doCommit) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, -1L);
        this.REPORT("TC002 container id = " + cid);
        this.t_util.setOpenMode(this.openMode | mode);
        ContainerHandle c = this.t_util.t_openContainer(t, -1L, cid, true);
        int[] recordCount = this.populateTempTable(c);
        for (int i = 0; i < recordCount.length; ++i) {
            this.REPORT("RecordCount on page " + i + "=" + recordCount[i]);
        }
        long pageNumber = 1L;
        int i = 0;
        while (i < recordCount.length) {
            int j2;
            Page page = this.t_util.t_getPage(c, pageNumber);
            T_Util.t_checkRecordCount(page, recordCount[i], recordCount[i]);
            RecordHandle rh = T_Util.t_checkFetchFirst(page, REC_001 + i + "X0");
            for (j2 = 1; j2 < recordCount[i]; ++j2) {
                rh = T_Util.t_checkFetchNext(page, rh, REC_001 + i + "X" + j2);
            }
            try {
                rh = page.fetchFromSlot(null, recordCount[i], (Object[])new DataValueDescriptor[0], (FetchDescriptor)null, false);
                throw T_Fail.testFailMsg("reading more rows on page than were written");
            }
            catch (StandardException j2) {
                rh = T_Util.t_checkFetchLast(page, REC_001 + i + "X" + (recordCount[i] - 1));
                for (j2 = recordCount[i] - 2; j2 >= 0; --j2) {
                    rh = T_Util.t_checkFetchPrevious(page, rh, REC_001 + i + "X" + j2);
                }
                page.unlatch();
                page = null;
                ++i;
                ++pageNumber;
            }
        }
        c.close();
        if (doCommit) {
            this.t_util.t_commit(t);
        } else {
            this.t_util.t_abort(t);
        }
        this.t_util.setOpenMode(this.openMode);
        c = this.t_util.t_openContainer(t, -1L, cid, true);
        Page page = this.t_util.t_getPage(c, 1L);
        T_Util.t_checkEmptyPage(page);
        page.unlatch();
        page = null;
        page = c.getPage(2L);
        if (page != null) {
            throw T_Fail.testFailMsg("truncate of temp container did not succeed");
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("TC002 " + mode + " " + doCommit);
    }

    protected void TC003(int mode, boolean doCommit) throws StandardException, T_Fail {
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, -1L);
        this.REPORT("TC003 container id = " + cid);
        this.t_util.setOpenMode(this.openMode | mode);
        ContainerHandle c = this.t_util.t_openContainer(t, -1L, cid, true);
        this.populateTempTable(c);
        this.t_util.t_dropContainer(t, -1L, cid);
        ContainerKey id = new ContainerKey(-1L, cid);
        ContainerHandle ce = t.openContainer(id, 8);
        if (ce != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        if (doCommit) {
            this.t_util.t_commit(t);
        } else {
            this.t_util.t_abort(t);
        }
        ContainerHandle cd = t.openContainer(id, 8);
        if (cd != null) {
            throw T_Fail.testFailMsg("Dropped Container should not open");
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS("TC003 " + mode + " " + doCommit);
    }

    protected void TC004all() throws StandardException, T_Fail {
        int[] modes = new int[]{0, 32, 16};
        for (int m1 = 0; m1 < modes.length; ++m1) {
            for (int m2 = 0; m2 < modes.length; ++m2) {
                for (int m3 = 0; m3 < modes.length; ++m3) {
                    this.TC004(m1, m2, m3, false, false);
                    this.TC004(m1, m2, m3, false, true);
                    this.TC004(m1, m2, m3, true, false);
                    this.TC004(m1, m2, m3, true, false);
                }
            }
        }
    }

    protected void TC004(int mode1, int mode2, int mode3, boolean doCommit, boolean closeThem) throws StandardException, T_Fail {
        String testInfo = "TC004 mode1 " + mode1 + " mode2 " + mode2 + " mode3 " + mode3 + " doCommit " + doCommit + " closeThem " + closeThem;
        this.REPORT("start " + testInfo);
        Transaction t = this.t_util.t_startTransaction();
        long cid = this.t_util.t_addContainer(t, -1L);
        this.REPORT("TC004 container id = " + cid);
        this.t_util.setOpenMode(this.openMode | mode1);
        ContainerHandle c1 = this.t_util.t_openContainer(t, -1L, cid, true);
        this.populateTempTable(c1);
        if (closeThem) {
            c1.close();
        }
        this.t_util.setOpenMode(this.openMode | mode2);
        ContainerHandle c2 = this.t_util.t_openContainer(t, -1L, cid, true);
        if (closeThem) {
            c2.close();
        }
        this.t_util.setOpenMode(this.openMode | mode3);
        ContainerHandle c3 = this.t_util.t_openContainer(t, -1L, cid, true);
        if (closeThem) {
            c2.close();
        }
        if (doCommit) {
            this.t_util.t_commit(t);
        } else {
            this.t_util.t_abort(t);
        }
        int fullMode = mode1 | mode2 | mode3;
        if ((fullMode & 0x20) == 32) {
            ContainerKey id = new ContainerKey(-1L, cid);
            ContainerHandle cd = t.openContainer(id, 8);
            if (cd != null) {
                throw T_Fail.testFailMsg("Dropped Container should not open");
            }
        } else if (!doCommit || (fullMode & 0x10) == 16) {
            ContainerHandle ce = this.t_util.t_openContainer(t, -1L, cid, true);
            Page page = this.t_util.t_getPage(ce, 1L);
            T_Util.t_checkEmptyPage(page);
            page.unlatch();
            page = null;
        }
        this.t_util.t_commit(t);
        t.close();
        this.PASS(testInfo);
    }

    private static ContextService getContextService() {
        return ContextService.getFactory();
    }

    private static ModuleFactory getMonitor() {
        return Monitor.getMonitor();
    }

    private static Object createPersistentService(String factoryInterface, String serviceName, Properties properties) throws StandardException {
        return Monitor.createPersistentService((String)factoryInterface, (String)serviceName, (Properties)properties);
    }
}

