/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Map;
import org.apache.derby.impl.drda.CcsidManager;
import org.apache.derby.impl.drda.CodePointNameTable;
import org.apache.derby.impl.drda.DDMReader;
import org.apache.derby.impl.drda.DDMWriter;
import org.apache.derby.impl.drda.DRDAProtocolException;
import org.apache.derby.impl.drda.EbcdicCcsidManager;

public class ProtocolTestAdapter {
    public static final byte SPACE = new EbcdicCcsidManager().space;
    public static final int CP_SQLCARD = 9224;
    public static final int CP_SVRCOD = 4425;
    public static final int CP_CODPNT = 12;
    public static final int CP_PRCCNVCD = 4415;
    public static final int CP_SYNERRCD = 4426;
    public static final int CP_MGRLVLLS = 5124;
    public static final int CP_PRCCNVRM = 4677;
    public static final int CP_SYNTAXRM = 4684;
    public static final int CP_MGRLVLRM = 4624;
    public static final int CP_SECMEC = 4514;
    public static final int CP_SECCHKCD = 4516;
    private static final CodePointNameTable CP_NAMES = new CodePointNameTable();
    private final CcsidManager ccsidManager = new EbcdicCcsidManager();
    private final DDMWriter writer = new DDMWriter(null, null);
    private final Socket socket;
    private final DDMReader reader;
    private final OutputStream out;

    public ProtocolTestAdapter(Socket socket) throws IOException {
        this.socket = socket;
        this.reader = new DDMReader(socket.getInputStream());
        this.out = socket.getOutputStream();
    }

    public void close() throws IOException {
        this.socket.close();
    }

    public String lookupCodePoint(int codePoint) {
        return CP_NAMES.lookup(codePoint);
    }

    public Integer decodeCodePoint(String codePointName) {
        for (Map.Entry entry : CP_NAMES.entrySet()) {
            if (!codePointName.equals((String)entry.getValue())) continue;
            return (Integer)entry.getKey();
        }
        return null;
    }

    public byte[] convertFromJavaString(String str) {
        return this.ccsidManager.convertFromJavaString(str);
    }

    public void setUtf8Ccsid() {
        this.writer.setUtf8Ccsid();
        this.reader.setUtf8Ccsid();
    }

    public void wCreateDssRequest() {
        this.writer.createDssRequest();
    }

    public void wCreateDssObject() {
        this.writer.createDssObject();
    }

    public void wCreateDssReply() {
        this.writer.createDssReply();
    }

    public void wEndDss() {
        this.writer.endDss();
    }

    public void wEndDss(byte b) {
        this.writer.endDss(b);
    }

    public void wEndDdm() {
        this.writer.endDdm();
    }

    public void wEndDdmAndDss() {
        this.writer.endDdmAndDss();
    }

    public void wStartDdm(int cp) {
        this.writer.startDdm(cp);
    }

    public void wWriteScalarString(int cp, String str) {
        this.writer.writeScalarString(cp, str);
    }

    public void wWriteScalar2Bytes(int cp, int value) {
        this.writer.writeScalar2Bytes(cp, value);
    }

    public void wWriteScalar1Byte(int cp, int value) {
        this.writer.writeScalar1Byte(cp, value);
    }

    public void wWriteScalarBytes(int cp, byte[] buf) {
        this.writer.writeScalarBytes(cp, buf);
    }

    public void wWriteScalarPaddedBytes(int cp, byte[] buf, int length, byte ch) {
        this.writer.writeScalarPaddedBytes(cp, buf, length, ch);
    }

    public void wWriteByte(int b) {
        this.writer.writeByte(b);
    }

    public void wWriteBytes(byte[] buf) {
        this.writer.writeBytes(buf);
    }

    public void wWriteShort(int v) {
        this.writer.writeShort(v);
    }

    public void wWriteInt(int v) {
        this.writer.writeInt(v);
    }

    public void wWriteCodePoint4Bytes(int cp, int v) {
        this.writer.writeCodePoint4Bytes(cp, v);
    }

    public void wPadBytes(byte ch, int len) {
        this.writer.padBytes(ch, len);
    }

    public void wFlush() throws IOException {
        try {
            this.writer.finalizeChain(this.reader.getCurrChainState(), this.out);
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
        this.writer.reset(null);
    }

    public void rReadReplyDss() throws IOException {
        try {
            this.reader.readReplyDss();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public void rSkipDss() throws IOException {
        try {
            this.reader.readReplyDss();
            this.reader.skipDss();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public void rSkipDdm() throws IOException {
        try {
            this.reader.readLengthAndCodePoint(false);
            this.reader.skipBytes();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public void rSkipBytes() throws IOException {
        try {
            this.reader.skipBytes();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public boolean rMoreData() {
        return this.reader.moreData();
    }

    public boolean rMoreDssData() {
        return this.reader.moreDssData();
    }

    public boolean rMoreDdmData() {
        return this.reader.moreDssData();
    }

    public int rReadNetworkShort() throws IOException {
        try {
            return this.reader.readNetworkShort();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public byte rReadByte() throws IOException {
        try {
            return this.reader.readByte();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public byte[] rReadBytes() throws IOException {
        try {
            return this.reader.readBytes();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public int rReadLengthAndCodePoint(boolean f) throws IOException {
        try {
            return this.reader.readLengthAndCodePoint(f);
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public int rReadNetworkInt() throws IOException {
        try {
            return this.reader.readNetworkInt();
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    public String rReadString(int length, String enc) throws IOException {
        try {
            return this.reader.readString(length, enc);
        }
        catch (DRDAProtocolException dpe) {
            throw ProtocolTestAdapter.wrap(dpe);
        }
    }

    private static IOException wrap(DRDAProtocolException dpe) {
        IOException ioe = new IOException(dpe.getMessage());
        ioe.initCause(dpe);
        return ioe;
    }
}

