/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.tests.lang.DummyAwareVTI;
import org.apache.derbyTesting.functionTests.tests.lang.GeneratedColumnsHelper;
import org.apache.derbyTesting.functionTests.tests.lang.StringArrayVTI;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class AwareVTITest
extends GeneratedColumnsHelper {
    private static final String CANNOT_CHANGE_COLUMNS = "X0Y92";

    public AwareVTITest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(AwareVTITest.class);
        CleanDatabaseTestSetup cleanDatabaseTestSetup = new CleanDatabaseTestSetup((Test)baseTestSuite);
        return cleanDatabaseTestSetup;
    }

    public void test_01_basic() throws Exception {
        Connection connection = this.getConnection();
        this.vetBasic(connection, "s1", "f1");
        this.vetBasic(connection, "s2", "f2");
    }

    private void vetBasic(Connection connection, String string, String string2) throws Exception {
        this.goodStatement(connection, "create schema " + string);
        this.goodStatement(connection, "create function " + string + "." + string2 + "() returns table\n(\n    schema_name varchar( 20 ),\n    vti_name varchar( 20 ),\n    statement_text varchar( 100 )\n)\nlanguage java parameter style derby_jdbc_result_set no sql\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.AwareVTITest.dummyAwareVTI'\n");
        String string3 = "select * from table( " + string + "." + string2 + "() ) s";
        this.assertResults(connection, string3, new String[][]{{string.toUpperCase(), string2.toUpperCase(), string3}}, false);
    }

    public void test_02_StringColumnVTI() throws Exception {
        Connection connection = this.getConnection();
        String[][] stringArray = new String[][]{{"foo", "bar"}, {"wibble", "baz"}};
        UnnamedColumnsVTI unnamedColumnsVTI = new UnnamedColumnsVTI(stringArray);
        unnamedColumnsVTI.setColumnNames(new String[]{"A", "B"});
        try {
            unnamedColumnsVTI.setColumnNames(new String[]{"C", "D"});
            AwareVTITest.fail((String)"Attempt to reset column names should have failed.");
        }
        catch (SQLException sQLException) {
            AwareVTITest.assertEquals((String)CANNOT_CHANGE_COLUMNS, (String)sQLException.getSQLState());
        }
        this.assertResults((ResultSet)((Object)unnamedColumnsVTI), stringArray, false);
    }

    public void test_03_ArchiveVTI() throws Exception {
        Connection connection = this.getConnection();
        this.goodStatement(connection, "create table t1\n(\n    keyCol int,\n    aCol int,\n    bCol int\n)\n");
        this.goodStatement(connection, "create table t1_archive_001 as select * from t1 with no data");
        this.goodStatement(connection, "create table t1_archive_002 as select * from t1 with no data");
        this.goodStatement(connection, "insert into t1_archive_002 values ( 1, 100, 1000 ), ( 2, 200, 2000 ), ( 3, 300, 3000 )");
        this.goodStatement(connection, "insert into t1_archive_001 values ( 4, 400, 4000 ), ( 5, 500, 5000 ), ( 6, 600, 6000 )");
        this.goodStatement(connection, "insert into t1 values ( 7, 700, 7000 ), ( 8, 800, 8000 ), ( 9, 900, 9000 )");
        this.goodStatement(connection, "create function t1( archiveSuffix varchar( 32672 ) ) returns table\n(\n    keyCol int,\n    aCol int,\n    bCol int\n)\nlanguage java parameter style derby_jdbc_result_set reads sql data\nexternal name 'org.apache.derbyTesting.functionTests.tests.lang.ArchiveVTI.archiveVTI'\n");
        this.assertResults(connection, "select keyCol, bCol from table( t1( '_ARCHIVE_' ) ) s\nwhere keyCol between 3 and 7\norder by keyCol\n", new String[][]{{"3", "3000"}, {"4", "4000"}, {"5", "5000"}, {"6", "6000"}, {"7", "7000"}}, false);
    }

    public static DummyAwareVTI dummyAwareVTI() {
        return new DummyAwareVTI();
    }

    public static class UnnamedColumnsVTI
    extends StringArrayVTI {
        public UnnamedColumnsVTI(String[][] stringArray) {
            super(null, stringArray);
        }
    }
}

