/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.upgradeTests;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.SQLException;
import java.util.Set;
import javax.sql.DataSource;
import junit.framework.Test;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.DriverUnloader;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeChange;
import org.apache.derbyTesting.functionTests.tests.upgradeTests.UpgradeRun;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.ClassLoaderTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

final class PhaseChanger
extends BaseTestSetup {
    private final int phase;
    private final int[] version;
    private ClassLoader loader;
    private ClassLoader previousLoader;
    private boolean trace = false;
    private String upgradeAttributes = "upgrade=true";

    public PhaseChanger(Test test, int n, ClassLoader classLoader, int[] nArray, boolean bl) {
        super(test);
        this.phase = n;
        this.loader = classLoader;
        this.version = nArray;
        if (bl) {
            this.upgradeAttributes = this.upgradeAttributes + ";create=true";
        }
    }

    protected void setUp() throws SQLException {
        Object object;
        UpgradeChange.phase.set(this.phase);
        UpgradeChange.oldVersion.set(this.version);
        TestConfiguration testConfiguration = TestConfiguration.getCurrent();
        this.trace = testConfiguration.doTrace();
        if (this.trace) {
            object = UpgradeChange.oldVersion.get()[0] + "." + UpgradeChange.oldVersion.get()[1] + "." + UpgradeChange.oldVersion.get()[2] + "." + UpgradeChange.oldVersion.get()[3];
            BaseTestCase.traceit("Test upgrade from: " + (String)object + ", phase: " + UpgradeChange.PHASES[this.phase]);
            if (UpgradeChange.PHASES[this.phase].equals("UPGRADE")) {
                BaseTestCase.traceit("Upgrade attributes = " + this.upgradeAttributes);
            }
        }
        if (this.loader != null) {
            this.previousLoader = Thread.currentThread().getContextClassLoader();
            ClassLoaderTestSetup.setThreadLoader(this.loader);
        }
        object = JDBCDataSource.getDataSource();
        switch (this.phase) {
            case 4: {
                return;
            }
            case 0: {
                JDBCDataSource.setBeanProperty(object, "createDatabase", "create");
                break;
            }
            case 3: {
                JDBCDataSource.setBeanProperty(object, "connectionAttributes", this.upgradeAttributes);
                break;
            }
        }
        object.getConnection().close();
    }

    protected void tearDown() throws Exception {
        if (this.trace) {
            BaseTestCase.traceit(" Test upgrade done.");
        }
        Object object = this.getDerby23ContextService();
        DataSource dataSource = JDBCDataSource.getDataSource();
        JDBCDataSource.shutEngine(dataSource);
        if (this.phase == 4) {
            this.deregisterDriver();
            this.clearDerby4895ThreadLocal();
        }
        this.clearDerby23ThreadLocals(object);
        if (this.loader != null) {
            ClassLoaderTestSetup.setThreadLoader(this.previousLoader);
        }
        this.loader = null;
        this.previousLoader = null;
        UpgradeChange.phase.set(null);
        UpgradeChange.oldVersion.set(null);
    }

    private void deregisterDriver() throws Exception {
        boolean bl;
        boolean bl2 = UpgradeRun.lessThan(new int[]{10, 2, 0, 0}, this.version) && UpgradeRun.lessThan(this.version, new int[]{10, 8, 0, 0});
        boolean bl3 = UpgradeRun.lessThan(new int[]{10, 15, 0, 0}, this.version);
        boolean bl4 = bl = bl2 || bl3;
        if (JDBC.vmSupportsJDBC3()) {
            Class<?> clazz = Class.forName(DriverUnloader.class.getName(), true, this.loader);
            Method method = clazz.getMethod("unload", null);
            Boolean bl5 = (Boolean)method.invoke(null, (Object[])null);
            if (!JVMInfo.isModuleAware()) {
                PhaseChanger.assertEquals((String)"Unexpected result from driver unloading", (boolean)bl, (boolean)bl5);
            }
        }
    }

    private void clearDerby4895ThreadLocal() throws Exception {
        boolean bl;
        boolean bl2 = bl = UpgradeRun.lessThan(new int[]{10, 5, 0, 0}, this.version) && UpgradeRun.lessThan(this.version, new int[]{10, 5, 3, 2}) || UpgradeRun.lessThan(new int[]{10, 6, 0, 0}, this.version) && UpgradeRun.lessThan(this.version, new int[]{10, 6, 2, 3});
        if (!bl) {
            return;
        }
        if (JVMInfo.isModuleAware()) {
            return;
        }
        Class<?> clazz = Class.forName("org.apache.derby.iapi.sql.dictionary.TableDescriptor", true, this.loader);
        PhaseChanger.clearField(clazz, "referencedColumnMap", null);
    }

    private static void clearField(Class clazz, String string, Object object) throws Exception {
        Field field = clazz.getDeclaredField(string);
        field.setAccessible(true);
        field.set(object, null);
    }

    private Object getDerby23ContextService() throws Exception {
        if (this.loader != null && UpgradeRun.lessThan(this.version, new int[]{10, 2, 1, 6})) {
            Class<?> clazz = Class.forName("org.apache.derby.iapi.services.context.ContextService", true, this.loader);
            Field field = clazz.getDeclaredField("factory");
            field.setAccessible(true);
            return field.get(null);
        }
        return null;
    }

    private void clearDerby23ThreadLocals(Object object) throws Exception {
        if (object != null) {
            Class<?> clazz = object.getClass();
            Field field = clazz.getDeclaredField("threadContextList");
            field.setAccessible(true);
            ThreadLocal threadLocal = (ThreadLocal)field.get(object);
            threadLocal.set(null);
            Field field2 = clazz.getDeclaredField("allContexts");
            field2.setAccessible(true);
            Set set = (Set)field2.get(object);
            set.clear();
        }
    }
}

