/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import org.apache.derby.vti.RestrictedVTI;
import org.apache.derby.vti.Restriction;
import org.apache.derby.vti.VTITemplate;

public class RestrictedTableVTI
extends VTITemplate
implements RestrictedVTI {
    private String _schemaName;
    private String _tableName;
    private Connection _connection;
    private String[] _columnNames;
    private Restriction _restriction;
    private int[] _columnNumberMap;
    private PreparedStatement _preparedStatement;
    private ResultSet _resultSet;
    private static String _lastQuery;

    protected RestrictedTableVTI(String string, String string2) throws Exception {
        this._schemaName = string;
        this._tableName = string2;
        this._connection = RestrictedTableVTI.getDerbyConnection();
    }

    public static RestrictedTableVTI readTable(String string, String string2) throws Exception {
        return new RestrictedTableVTI(string, string2);
    }

    public static String getLastQuery() {
        return _lastQuery;
    }

    public void close() throws SQLException {
        if (!this.isClosed()) {
            this._schemaName = null;
            this._tableName = null;
            this._connection = null;
            this._columnNames = null;
            this._restriction = null;
            this._columnNumberMap = null;
            if (this._resultSet != null) {
                this._resultSet.close();
            }
            if (this._preparedStatement != null) {
                this._preparedStatement.close();
            }
            this._resultSet = null;
            this._preparedStatement = null;
        }
    }

    public boolean next() throws SQLException {
        if (!this.isClosed() && this._resultSet == null) {
            this._preparedStatement = RestrictedTableVTI.prepareStatement(this._connection, this.makeQuery());
            this._resultSet = this._preparedStatement.executeQuery();
        }
        return this._resultSet.next();
    }

    public boolean isClosed() {
        return this._connection == null;
    }

    public boolean wasNull() throws SQLException {
        return this._resultSet.wasNull();
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._resultSet.getMetaData();
    }

    public InputStream getAsciiStream(int n) throws SQLException {
        return this._resultSet.getAsciiStream(this.mapColumnNumber(n));
    }

    public BigDecimal getBigDecimal(int n) throws SQLException {
        return this._resultSet.getBigDecimal(this.mapColumnNumber(n));
    }

    @Deprecated
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        return this._resultSet.getBigDecimal(this.mapColumnNumber(n), n2);
    }

    public InputStream getBinaryStream(int n) throws SQLException {
        return this._resultSet.getBinaryStream(this.mapColumnNumber(n));
    }

    public Blob getBlob(int n) throws SQLException {
        return this._resultSet.getBlob(this.mapColumnNumber(n));
    }

    public boolean getBoolean(int n) throws SQLException {
        return this._resultSet.getBoolean(this.mapColumnNumber(n));
    }

    public byte getByte(int n) throws SQLException {
        return this._resultSet.getByte(this.mapColumnNumber(n));
    }

    public byte[] getBytes(int n) throws SQLException {
        return this._resultSet.getBytes(this.mapColumnNumber(n));
    }

    public Reader getCharacterStream(int n) throws SQLException {
        return this._resultSet.getCharacterStream(this.mapColumnNumber(n));
    }

    public Clob getClob(int n) throws SQLException {
        return this._resultSet.getClob(this.mapColumnNumber(n));
    }

    public Date getDate(int n) throws SQLException {
        return this._resultSet.getDate(this.mapColumnNumber(n));
    }

    public Date getDate(int n, Calendar calendar) throws SQLException {
        return this._resultSet.getDate(this.mapColumnNumber(n), calendar);
    }

    public double getDouble(int n) throws SQLException {
        return this._resultSet.getDouble(this.mapColumnNumber(n));
    }

    public float getFloat(int n) throws SQLException {
        return this._resultSet.getFloat(this.mapColumnNumber(n));
    }

    public int getInt(int n) throws SQLException {
        return this._resultSet.getInt(this.mapColumnNumber(n));
    }

    public long getLong(int n) throws SQLException {
        return this._resultSet.getLong(this.mapColumnNumber(n));
    }

    public Object getObject(int n) throws SQLException {
        return this._resultSet.getObject(this.mapColumnNumber(n));
    }

    public short getShort(int n) throws SQLException {
        return this._resultSet.getShort(this.mapColumnNumber(n));
    }

    public String getString(int n) throws SQLException {
        return this._resultSet.getString(this.mapColumnNumber(n));
    }

    public Time getTime(int n) throws SQLException {
        return this._resultSet.getTime(this.mapColumnNumber(n));
    }

    public Time getTime(int n, Calendar calendar) throws SQLException {
        return this._resultSet.getTime(this.mapColumnNumber(n), calendar);
    }

    public Timestamp getTimestamp(int n) throws SQLException {
        return this._resultSet.getTimestamp(this.mapColumnNumber(n));
    }

    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        return this._resultSet.getTimestamp(this.mapColumnNumber(n), calendar);
    }

    public void initScan(String[] stringArray, Restriction restriction) throws SQLException {
        this._columnNames = stringArray;
        this._restriction = restriction;
        int n = this._columnNames.length;
        this._columnNumberMap = new int[n];
        int n2 = 1;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            this._columnNumberMap[i] = n2++;
        }
    }

    private static Connection getDerbyConnection() throws SQLException {
        return DriverManager.getConnection("jdbc:default:connection");
    }

    private String makeQuery() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("select ");
        int n = this._columnNames.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            String string2 = this._columnNames[i];
            if (string2 == null) continue;
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            ++n2;
            stringBuffer.append(RestrictedTableVTI.doubleQuote(string2));
        }
        stringBuffer.append("\nfrom ");
        stringBuffer.append(RestrictedTableVTI.doubleQuote(this._schemaName));
        stringBuffer.append('.');
        stringBuffer.append(RestrictedTableVTI.doubleQuote(this._tableName));
        if (this._restriction != null && (string = this._restriction.toSQL()) != null && (string = string.trim()).length() != 0) {
            stringBuffer.append("\nwhere " + string);
        }
        _lastQuery = stringBuffer.toString();
        return _lastQuery;
    }

    private static String doubleQuote(String string) {
        return "\"" + string + "\"";
    }

    private static String singleQuote(String string) {
        return "'" + string + "'";
    }

    private static PreparedStatement prepareStatement(Connection connection, String string) throws SQLException {
        return connection.prepareStatement(string);
    }

    private int mapColumnNumber(int n) {
        return this._columnNumberMap[n - 1];
    }
}

