/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.db;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.db.Database;
import org.apache.derby.iapi.jdbc.AuthenticationService;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.ModuleFactory;
import org.apache.derby.iapi.services.monitor.ModuleSupportable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyFactory;
import org.apache.derby.iapi.services.property.PropertySetCallback;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.LanguageFactory;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;
import org.apache.derby.iapi.sql.conn.LanguageConnectionFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.FileInfoDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.store.access.AccessFactory;
import org.apache.derby.iapi.store.access.FileResource;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.store.raw.data.DataFactory;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.util.DoubleProperties;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.db.DatabaseContextImpl;
import org.apache.derby.impl.db.StoreClassFactoryContext;
import org.apache.derby.impl.sql.execute.JarUtil;
import org.apache.derby.io.StorageFactory;
import org.apache.derby.io.StorageFile;
import org.apache.derby.shared.common.error.PublicAPI;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derby.shared.common.sanity.SanityManager;

public class BasicDatabase
implements ModuleControl,
ModuleSupportable,
PropertySetCallback,
Database,
JarReader {
    protected boolean active;
    private AuthenticationService authenticationService;
    protected AccessFactory af;
    protected PropertyFactory pf;
    protected ClassFactory cfDB;
    private DataDictionary dd;
    protected LanguageConnectionFactory lcf;
    protected LanguageFactory lf;
    protected Object resourceAdapter;
    private Locale databaseLocale;
    private DateFormat dateFormat;
    private DateFormat timeFormat;
    private DateFormat timestampFormat;
    private UUID myUUID;
    protected boolean lastToBoot = true;

    @Override
    public boolean canSupport(Properties startParams) {
        String repliMode;
        boolean supported = Monitor.isDesiredCreateType(startParams, this.getEngineType());
        if (supported && (repliMode = startParams.getProperty("replication.slave.mode")) != null && !repliMode.equals("slavepremode")) {
            supported = false;
        }
        return supported;
    }

    @Override
    public void boot(boolean create, Properties startParams) throws StandardException {
        ModuleFactory monitor = BasicDatabase.getMonitor();
        if (create) {
            String localeID;
            if (startParams.getProperty("derby.__rt.storage.createWithNoLog") == null) {
                startParams.put("derby.__rt.storage.createWithNoLog", "true");
            }
            if ((localeID = startParams.getProperty("territory")) == null) {
                localeID = Locale.getDefault().toString();
            }
            this.databaseLocale = monitor.setLocale(startParams, localeID);
        } else {
            this.databaseLocale = monitor.getLocale(this);
        }
        this.setLocale(this.databaseLocale);
        this.bootValidation(create, startParams);
        DataValueFactory dvf = (DataValueFactory)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.types.DataValueFactory", startParams);
        this.bootStore(create, startParams);
        this.myUUID = this.makeDatabaseID(create, startParams);
        DoubleProperties allParams = new DoubleProperties(this.getAllDatabaseProperties(), startParams);
        if (this.pf != null) {
            this.pf.addPropertySetNotification(this);
        }
        this.bootClassFactory(create, allParams);
        this.dd = (DataDictionary)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.sql.dictionary.DataDictionary", allParams);
        this.lcf = (LanguageConnectionFactory)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.sql.conn.LanguageConnectionFactory", allParams);
        this.lf = (LanguageFactory)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.sql.LanguageFactory", allParams);
        this.bootResourceAdapter(create, allParams);
        this.authenticationService = this.bootAuthenticationService(create, allParams);
        SanityManager.ASSERT(this.authenticationService != null, "Failed to set the Authentication service for the database");
        if (create && this.lastToBoot && startParams.getProperty("derby.__rt.storage.createWithNoLog") != null) {
            this.createFinished();
        }
        this.active = true;
        if (this.dd.doCreateIndexStatsRefresher()) {
            this.dd.createIndexStatsRefresher(this, ((Properties)allParams).getProperty("derby.__rt.serviceDirectory"));
        }
    }

    @Override
    public void stop() {
        if (this.dd != null) {
            try {
                this.dd.clearSequenceCaches();
            }
            catch (StandardException se) {
                se.printStackTrace(Monitor.getStream().getPrintWriter());
            }
        }
        this.active = false;
    }

    @Override
    public int getEngineType() {
        return 2;
    }

    @Override
    public boolean isReadOnly() {
        return this.af.isReadOnly();
    }

    @Override
    public LanguageConnectionContext setupConnection(ContextManager cm, String user, String drdaID, String dbname) throws StandardException {
        TransactionController tc = this.getConnectionTransaction(cm);
        cm.setLocaleFinder(this);
        this.pushDbContext(cm);
        LanguageConnectionContext lctx = this.lcf.newLanguageConnectionContext(cm, tc, this.lf, this, user, drdaID, dbname);
        this.pushClassFactoryContext(cm, this.lcf.getClassFactory());
        ExecutionFactory ef = this.lcf.getExecutionFactory();
        ef.newExecutionContext(cm);
        lctx.initialize();
        lctx.internalCommitNoSync(5);
        return lctx;
    }

    @Override
    public final DataDictionary getDataDictionary() {
        return this.dd;
    }

    @Override
    public void pushDbContext(ContextManager cm) {
        DatabaseContextImpl dc = new DatabaseContextImpl(cm, this);
    }

    @Override
    public AuthenticationService getAuthenticationService() throws StandardException {
        SanityManager.ASSERT(this.authenticationService != null, "Unexpected - There is no valid authentication service for the database!");
        return this.authenticationService;
    }

    @Override
    public void startReplicationMaster(String dbmaster, String host, int port, String replicationMode) throws SQLException {
        try {
            this.af.startReplicationMaster(dbmaster, host, port, replicationMode);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void stopReplicationMaster() throws SQLException {
        try {
            this.af.stopReplicationMaster();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void stopReplicationSlave() throws SQLException {
        StandardException se = StandardException.newException("XRE40", new Object[0]);
        throw PublicAPI.wrapStandardException(se);
    }

    @Override
    public boolean isInSlaveMode() {
        return false;
    }

    @Override
    public void failover(String dbname) throws StandardException {
        this.af.failover(dbname);
    }

    @Override
    public void freeze() throws SQLException {
        try {
            this.af.freeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void unfreeze() throws SQLException {
        try {
            this.af.unfreeze();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backup(String backupDir, boolean wait) throws SQLException {
        try {
            this.af.backup(backupDir, wait);
            if (this.luceneLoaded()) {
                this.backupLucene(backupDir);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void backupAndEnableLogArchiveMode(String backupDir, boolean deleteOnlineArchivedLogFiles, boolean wait) throws SQLException {
        try {
            this.af.backupAndEnableLogArchiveMode(backupDir, deleteOnlineArchivedLogFiles, wait);
            if (this.luceneLoaded()) {
                this.backupLucene(backupDir);
            }
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void disableLogArchiveMode(boolean deleteOnlineArchivedLogFiles) throws SQLException {
        try {
            this.af.disableLogArchiveMode(deleteOnlineArchivedLogFiles);
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public void checkpoint() throws SQLException {
        try {
            this.af.checkpoint();
        }
        catch (StandardException se) {
            throw PublicAPI.wrapStandardException(se);
        }
    }

    @Override
    public Locale getLocale() {
        return this.databaseLocale;
    }

    @Override
    public final UUID getId() {
        return this.myUUID;
    }

    @Override
    public Locale getCurrentLocale() throws StandardException {
        if (this.databaseLocale != null) {
            return this.databaseLocale;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getDateFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.dateFormat == null) {
                this.dateFormat = DateFormat.getDateInstance(1, this.databaseLocale);
            }
            return this.dateFormat;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getTimeFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timeFormat == null) {
                this.timeFormat = DateFormat.getTimeInstance(1, this.databaseLocale);
            }
            return this.timeFormat;
        }
        throw BasicDatabase.noLocale();
    }

    @Override
    public DateFormat getTimestampFormat() throws StandardException {
        if (this.databaseLocale != null) {
            if (this.timestampFormat == null) {
                this.timestampFormat = DateFormat.getDateTimeInstance(1, 1, this.databaseLocale);
            }
            return this.timestampFormat;
        }
        throw BasicDatabase.noLocale();
    }

    private static StandardException noLocale() {
        return StandardException.newException("XCXE0.S", new Object[0]);
    }

    @Override
    public void setLocale(Locale locale) {
        this.databaseLocale = locale;
        this.dateFormat = null;
        this.timeFormat = null;
        this.timestampFormat = null;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    protected UUID makeDatabaseID(boolean create, Properties startParams) throws StandardException {
        TransactionController tc = this.af.getTransaction(BasicDatabase.getContextService().getCurrentContextManager());
        String upgradeID = null;
        UUID databaseID = (UUID)tc.getProperty("derby.databaseID");
        if (databaseID == null) {
            UUIDFactory uuidFactory = BasicDatabase.getMonitor().getUUIDFactory();
            upgradeID = startParams.getProperty("derby.databaseID");
            databaseID = upgradeID == null ? uuidFactory.createUUID() : uuidFactory.recreateUUID(upgradeID);
            tc.setProperty("derby.databaseID", databaseID, true);
        }
        if (upgradeID != null) {
            startParams.remove("derby.databaseID");
        }
        tc.commit();
        tc.destroy();
        return databaseID;
    }

    @Override
    public Object getResourceAdapter() {
        return this.resourceAdapter;
    }

    @Override
    public void init(boolean dbOnly, Dictionary p) {
    }

    @Override
    public boolean validate(String key, Serializable value, Dictionary p) throws StandardException {
        if (key.equals("derby.engineType")) {
            throw StandardException.newException("XCY02.S", key, value);
        }
        if (!key.equals("derby.database.classpath")) {
            return false;
        }
        String newClasspath = (String)((Object)value);
        String[][] dbcp = null;
        if (newClasspath != null) {
            dbcp = IdUtil.parseDbClassPath(newClasspath);
        }
        if (dbcp != null) {
            for (int ix = 0; ix < dbcp.length; ++ix) {
                SchemaDescriptor sd = this.dd.getSchemaDescriptor(dbcp[ix][0], null, false);
                FileInfoDescriptor fid = null;
                if (sd != null) {
                    fid = this.dd.getFileInfoDescriptor(sd, dbcp[ix][1]);
                }
                if (fid != null) continue;
                throw StandardException.newException("42X96", IdUtil.mkQualifiedName(dbcp[ix]));
            }
        }
        return true;
    }

    @Override
    public Serviceable apply(String key, Serializable value, Dictionary p) throws StandardException {
        if (!key.equals("derby.database.classpath")) {
            return null;
        }
        if (this.cfDB != null) {
            this.getDataDictionary().invalidateAllSPSPlans();
            String newClasspath = (String)((Object)value);
            if (newClasspath == null) {
                newClasspath = "";
            }
            this.cfDB.notifyModifyClasspath(newClasspath);
        }
        return null;
    }

    @Override
    public Serializable map(String key, Serializable value, Dictionary p) {
        return null;
    }

    protected void createFinished() throws StandardException {
        this.af.createFinished();
    }

    protected String getClasspath(Properties startParams) {
        String cp = PropertyUtil.getPropertyFromSet(startParams, "derby.database.classpath");
        if (cp == null) {
            cp = PropertyUtil.getSystemProperty("derby.database.classpath", "");
        }
        return cp;
    }

    protected void bootClassFactory(boolean create, Properties startParams) throws StandardException {
        String classpath = this.getClasspath(startParams);
        IdUtil.parseDbClassPath(classpath);
        startParams.put("derby.__rt.database.classpath", classpath);
        this.cfDB = (ClassFactory)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.services.loader.ClassFactory", startParams);
    }

    protected TransactionController getConnectionTransaction(ContextManager cm) throws StandardException {
        return this.af.getTransaction(cm);
    }

    protected AuthenticationService bootAuthenticationService(boolean create, Properties props) throws StandardException {
        return (AuthenticationService)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.jdbc.AuthenticationService", props);
    }

    protected void bootValidation(boolean create, Properties startParams) throws StandardException {
        this.pf = (PropertyFactory)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.services.property.PropertyFactory", startParams);
    }

    protected void bootStore(boolean create, Properties startParams) throws StandardException {
        this.af = (AccessFactory)BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.store.access.AccessFactory", startParams);
    }

    protected Properties getAllDatabaseProperties() throws StandardException {
        TransactionController tc = this.af.getTransaction(BasicDatabase.getContextService().getCurrentContextManager());
        Properties dbProps = tc.getProperties();
        tc.commit();
        tc.destroy();
        return dbProps;
    }

    protected void bootResourceAdapter(boolean create, Properties allParams) {
        try {
            this.resourceAdapter = BasicDatabase.bootServiceModule(create, this, "org.apache.derby.iapi.jdbc.ResourceAdapter", allParams);
        }
        catch (StandardException standardException) {
            // empty catch block
        }
    }

    protected void pushClassFactoryContext(ContextManager cm, ClassFactory cf) {
        new StoreClassFactoryContext(cm, cf, this.af, this);
    }

    @Override
    public StorageFile getJarFile(String schemaName, String sqlName) throws StandardException {
        SchemaDescriptor sd = this.dd.getSchemaDescriptor(schemaName, null, true);
        FileInfoDescriptor fid = this.dd.getFileInfoDescriptor(sd, sqlName);
        if (fid == null) {
            throw StandardException.newException("X0X13.S", sqlName, schemaName);
        }
        long generationId = fid.getGenerationId();
        ContextManager cm = BasicDatabase.getContextService().getCurrentContextManager();
        FileResource fr = this.af.getTransaction(cm).getFileHandler();
        String externalName = JarUtil.mkExternalName(fid.getUUID(), schemaName, sqlName, fr.getSeparatorChar());
        return fr.getAsFile(externalName, generationId);
    }

    private boolean luceneLoaded() throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws StandardException {
                    return BasicDatabase.this.getLuceneDir().exists();
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private StorageFile getLuceneDir() throws StandardException {
        StorageFactory dir = this.getStorageFactory();
        return dir.newStorageFile("LUCENE");
    }

    private StorageFactory getStorageFactory() throws StandardException {
        DataFactory dataFactory = (DataFactory)BasicDatabase.findServiceModule(this, "org.apache.derby.iapi.store.raw.data.DataFactory");
        return dataFactory.getStorageFactory();
    }

    private void backupLucene(String backupDir) throws StandardException {
        try {
            File backupRoot = new File(backupDir);
            StorageFactory storageFactory = this.getStorageFactory();
            String canonicalDbName = storageFactory.getCanonicalName();
            String dbname = StringUtil.shortDBName(canonicalDbName, storageFactory.getSeparator());
            File backupDB = new File(backupRoot, dbname);
            final File targetDir = new File(backupDB, "LUCENE");
            final StorageFile sourceDir = this.getLuceneDir();
            AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Boolean run() throws StandardException {
                    if (!FileUtil.copyDirectory(BasicDatabase.this.getStorageFactory(), sourceDir, targetDir, null, null, true)) {
                        throw StandardException.newException("XBM0Z.D", sourceDir.getPath(), targetDir.getAbsolutePath());
                    }
                    return null;
                }
            });
        }
        catch (IOException ioe) {
            throw StandardException.plainWrapException(ioe);
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private static ContextService getContextService() {
        return AccessController.doPrivileged(new PrivilegedAction<ContextService>(){

            @Override
            public ContextService run() {
                return ContextService.getFactory();
            }
        });
    }

    private static ModuleFactory getMonitor() {
        return AccessController.doPrivileged(new PrivilegedAction<ModuleFactory>(){

            @Override
            public ModuleFactory run() {
                return Monitor.getMonitor();
            }
        });
    }

    private static Object bootServiceModule(final boolean create, final Object serviceModule, final String factoryInterface, final Properties properties) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.bootServiceModule(create, serviceModule, factoryInterface, properties);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }

    private static Object findServiceModule(final Object serviceModule, final String factoryInterface) throws StandardException {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws StandardException {
                    return Monitor.findServiceModule(serviceModule, factoryInterface);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw StandardException.plainWrapException(pae);
        }
    }
}

