/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import org.apache.derbyTesting.system.nstest.NsTestError;
import org.apache.derbyTesting.system.nstest.NsTestPrintStream;
import org.apache.derbyTesting.system.nstest.TimerThread;
import org.apache.derbyTesting.system.nstest.init.DbSetup;
import org.apache.derbyTesting.system.nstest.init.Initializer;
import org.apache.derbyTesting.system.nstest.init.NWServerThread;
import org.apache.derbyTesting.system.nstest.tester.BackupRestoreReEncryptTester;
import org.apache.derbyTesting.system.nstest.tester.Tester1;
import org.apache.derbyTesting.system.nstest.tester.Tester2;
import org.apache.derbyTesting.system.nstest.tester.Tester3;
import org.apache.derbyTesting.system.nstest.utils.MemCheck;
import org.apache.derbyTesting.system.nstest.utils.SequenceReader;

public class NsTest
extends Thread {
    private static final String BACKUP_FLAG = "derby.nstest.backupRestore";
    private static final String OUTPUT_FILE = "derby.nstest.outputFile";
    private static final String JUST_COUNT_ERRORS = "derby.nstest.justCountErrors";
    private static final String QUIET = "derby.nstest.quiet";
    private static final String DURATION = "derby.nstest.durationInMinutes";
    private static final long MILLIS_PER_MINUTE = 60000L;
    private static final String USAGE = "Usage:\n\n    java org.apache.derbyTesting.system.nstest.NsTest [ DerbyClient | Embedded [ small ] ]\n\nIf no arguments are specified, the test defaults to a client/server configuration (DerbyClient)\n\nThe following flags can be set:\n\n    -Dderby.nstest.backupRestore=false    Turns off backup, restore, and re-encryption.\n\n    -Dderby.nstest.outputFile=fileName    Redirects output and errors to a file.\n\n    -Dderby.nstest.justCountErrors=true    Makes the test run quietly at steady-state, counting errors, and printing a summary at the end.\n\n    -Dderby.nstest.durationInMinutes=$number    Run for this number of minutes.\n";
    private static final String ERROR_BANNER1 = "//////////////////////////////////////////////////////////////\n";
    private static final String ERROR_BANNER2 = "//    ";
    public static final String DEAD_CONNECTION = "08003";
    public static final String dbName = "nstestdb";
    public static final String user = "nstest";
    public static final String password = "nstest";
    public static final String clientURL = "jdbc:derby://localhost:1900/";
    public static final String embedURL = "jdbc:derby:";
    public static final String dataEncypt = "dataEncryption=true";
    public static final String bootPwd = "bootPassword=12345678";
    public static final String clientDbURL = new String("jdbc:derby://localhost:1900/nstestdb;create=true");
    public static final String retrieveMessagePart = "retrieveMessagesFromServerOnGetMessage=true;";
    public static final String embedDbURL = new String("jdbc:derby:nstestdb;create=true");
    public static boolean embeddedMode = false;
    public static final String driver = new String("org.apache.derby.jdbc.ClientDriver");
    public static final String embedDriver = new String("org.apache.derby.jdbc.EmbeddedDriver");
    private static PrintStream statisticsLogger;
    public static NsTestPrintStream logger;
    public static Properties prop;
    public static int INIT;
    public static int TESTER1;
    public static int TESTER2;
    public static int TESTER3;
    public static int BACKUP;
    public static String BACKUPDIR;
    public static String RESTOREDIR;
    public static boolean START_SERVER_IN_SAME_VM;
    public static boolean AUTO_COMMIT_OFF;
    public static boolean CREATE_DATABASE_ONLY;
    public static boolean schemaCreated;
    public static int INIT_THREADS;
    public static int MAX_INITIAL_ROWS;
    public static int MAX_ITERATIONS;
    public static int MAX_LOW_STRESS_ROWS;
    public static int MAX_OPERATIONS_PER_CONN;
    public static int NUMTESTER1;
    public static int NUMTESTER2;
    public static int NUMTESTER3;
    public static int NUM_HIGH_STRESS_ROWS;
    public static int NUM_UNTOUCHED_ROWS;
    public static int numInserts;
    public static int numUpdates;
    public static int numDeletes;
    public static int numSelects;
    public static int numFailedInserts;
    public static int numFailedUpdates;
    public static int numFailedDeletes;
    public static int numFailedSelects;
    public static int numConnections;
    public static int INSERT;
    public static int UPDATE;
    public static int DELETE;
    public static int SELECT;
    public static int FAILED_INSERT;
    public static int FAILED_UPDATE;
    public static int FAILED_DELETE;
    public static int FAILED_SELECT;
    public static int CONNECTIONS_MADE;
    public static final String SUCCESS = " *** SUCCESS *** ";
    public static String driver_type;
    private int type;
    private static NsTest[] testThreads;
    private static boolean _justCountErrors;
    private static HashMap<String, NsTestError> _errors;
    private static long _duration;
    private static boolean _statisticsAlreadyPrinted;
    private static long _maxSequenceCounter;
    private static long _startTimestamp;
    private static long _endTimestamp;
    private static long _totalMemory;
    private static long _freeMemory;
    private static Date _lastMemoryCheckTime;

    public static int numActiveTestThreads() {
        int activeThreadCount = 0;
        if (testThreads != null) {
            for (int i = 0; i < testThreads.length; ++i) {
                if (testThreads[i] == null || !testThreads[i].isAlive()) continue;
                ++activeThreadCount;
            }
        }
        return activeThreadCount;
    }

    public static void updateMemoryTracker(long newTotalMemory, long newFreeMemory, Date newTimestamp) {
        _totalMemory = newTotalMemory;
        _freeMemory = newFreeMemory;
        _lastMemoryCheckTime = newTimestamp;
    }

    public static void updateSequenceTracker(long newValue) {
        _maxSequenceCounter = newValue;
    }

    public static boolean justCountErrors() {
        return _justCountErrors;
    }

    public static synchronized void addError(Throwable t) {
        String key = NsTest.getStackTrace(t);
        NsTestError error = _errors.get(key);
        if (error != null) {
            error.increment();
        } else {
            error = new NsTestError(t);
            _errors.put(key, error);
        }
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        sw.flush();
        return sw.toString();
    }

    public static synchronized void addStats(int type, int addValue) {
        switch (type) {
            case 0: {
                numInserts += addValue;
                break;
            }
            case 1: {
                numUpdates += addValue;
                break;
            }
            case 2: {
                numDeletes += addValue;
                break;
            }
            case 3: {
                numSelects += addValue;
                break;
            }
            case 4: {
                numFailedInserts += addValue;
                break;
            }
            case 5: {
                numFailedUpdates += addValue;
                break;
            }
            case 6: {
                numFailedDeletes += addValue;
                break;
            }
            case 7: {
                numFailedSelects += addValue;
                break;
            }
            case 8: {
                numConnections += addValue;
            }
        }
    }

    NsTest(int ttype, int k) throws Exception {
        this.type = ttype;
        if (ttype == INIT) {
            this.setName("InitThread " + k);
        } else if (ttype == TESTER1 || ttype == TESTER2 || ttype == TESTER3) {
            this.setName("Thread " + k);
        }
    }

    private static void setSmallConfig() {
        INIT_THREADS = 3;
        MAX_INITIAL_ROWS = 150;
        MAX_ITERATIONS = 50;
        MAX_LOW_STRESS_ROWS = 10;
        MAX_OPERATIONS_PER_CONN = 10;
        NUMTESTER1 = 3;
        NUMTESTER2 = 4;
        NUMTESTER3 = 3;
        NUM_HIGH_STRESS_ROWS = 20;
        NUM_UNTOUCHED_ROWS = 50;
    }

    public static void main(String[] args) throws SQLException, IOException, InterruptedException, Exception, Throwable {
        String testConfiguration;
        String duration;
        _startTimestamp = System.currentTimeMillis();
        String outputFile = System.getProperty(OUTPUT_FILE);
        statisticsLogger = System.out;
        if (outputFile != null) {
            statisticsLogger = new PrintStream(outputFile);
        }
        if ((duration = System.getProperty(DURATION)) != null) {
            _duration = Long.parseLong(duration) * 60000L;
        }
        logger = new NsTestPrintStream(statisticsLogger, !(_justCountErrors = Boolean.getBoolean(JUST_COUNT_ERRORS)));
        Runtime.getRuntime().addShutdownHook(new Thread(new ShutdownHook()));
        Connection conn = null;
        if (args.length >= 1) {
            driver_type = args[0];
            if (!driver_type.equalsIgnoreCase("DerbyClient") && !driver_type.equalsIgnoreCase("Embedded")) {
                NsTest.printUsage();
                return;
            }
            logger.println("Test nstest starting....., using driver: " + driver_type);
        } else {
            driver_type = "DerbyClient";
        }
        if (args.length >= 2 && (testConfiguration = args[1]).equalsIgnoreCase("small")) {
            logger.println("using small config");
            NsTest.setSmallConfig();
        }
        TimerThread timerThread = null;
        if (_duration > 0L) {
            timerThread = new TimerThread(_duration);
            timerThread.start();
        }
        Object jdbcUrl = "";
        try {
            Class<?> clazz;
            if (driver_type.equalsIgnoreCase("Embedded")) {
                logger.println("Loading the embedded driver...");
                clazz = Class.forName(embedDriver);
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                jdbcUrl = embedDbURL + ";dataEncryption=true;bootPassword=12345678";
                embeddedMode = true;
            } else {
                logger.println("Driver type : " + driver_type);
                logger.println("Loading the Derby Client driver..." + driver);
                clazz = Class.forName(driver);
                clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                logger.println("Client Driver loaded");
                jdbcUrl = clientDbURL + ";dataEncryption=true;bootPassword=12345678";
            }
            if (!embeddedMode && START_SERVER_IN_SAME_VM) {
                NsTest.startNetworkServer();
            }
            prop.setProperty("user", "nstest");
            prop.setProperty("password", "nstest");
            logger.println("Getting a connection using the url: " + (String)jdbcUrl);
            logger.println("JDBC url= " + (String)jdbcUrl);
            conn = DriverManager.getConnection((String)jdbcUrl, prop);
        }
        catch (SQLException sqe) {
            logger.println("\n\n " + sqe + sqe.getErrorCode() + " " + sqe.getSQLState());
            if (sqe.getErrorCode() == 40000 || sqe.getSQLState().equalsIgnoreCase("08001")) {
                logger.println("\n Unable to connect, test cannot proceed. Please verify if the Network Server is started on port 1900.");
                return;
            }
        }
        catch (ClassNotFoundException cnfe) {
            logger.println("Driver not found: " + cnfe.getMessage());
            cnfe.printStackTrace(logger);
            return;
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            logger.println("Unexpected Failure");
            NsTest.printException("nstest.main() method ==> ", e);
        }
        if (!DbSetup.doIt(conn)) {
            logger.println("Error in dbSetup, test will exit");
            System.exit(1);
        }
        try {
            conn.close();
        }
        catch (Exception e) {
            logger.println("FAIL - Error closing the connection in nstest.main():");
            NsTest.printException("Closing connection in nstest.main()", e);
        }
        logger.println("Starting memory checker thread");
        MemCheck mc = new MemCheck(200000);
        mc.start();
        if (!schemaCreated) {
            int i;
            logger.println("Kicking off initialization threads that will populate the test table");
            NsTest[] initThreads = new NsTest[INIT_THREADS];
            for (i = 0; i < INIT_THREADS; ++i) {
                initThreads[i] = new NsTest(INIT, i);
                initThreads[i].start();
                NsTest.sleep(3000L);
            }
            for (i = 0; i < INIT_THREADS; ++i) {
                initThreads[i].join();
            }
        }
        if (schemaCreated) {
            logger.println("Schema has already been created by another process!");
        }
        if (CREATE_DATABASE_ONLY) {
            logger.println("Finished creating the database, TEST THREADS WILL NOT RUN!!");
            mc.stopNow = true;
            mc.join();
            return;
        }
        logger.println("Kicking off test threads that will work over the test table");
        int numTestThread = 0;
        int maxTestThreads = 0;
        String runBackup = System.getProperty(BACKUP_FLAG);
        maxTestThreads = runBackup != null && runBackup.equalsIgnoreCase("false") ? NUMTESTER1 + NUMTESTER2 + NUMTESTER3 : 1 + NUMTESTER1 + NUMTESTER2 + NUMTESTER3;
        testThreads = new NsTest[maxTestThreads];
        while (numTestThread < maxTestThreads) {
            int j;
            if (runBackup != null && runBackup.equalsIgnoreCase("false")) {
                logger.println("BackupRestore Thread not started...");
            } else {
                NsTest.testThreads[numTestThread] = new NsTest(BACKUP, numTestThread);
                testThreads[numTestThread].start();
                ++numTestThread;
            }
            for (j = 0; j < NUMTESTER1; ++j) {
                NsTest.testThreads[numTestThread] = new NsTest(TESTER1, numTestThread);
                testThreads[numTestThread].start();
                NsTest.sleep(3000L);
                ++numTestThread;
            }
            for (j = 0; j < NUMTESTER2; ++j) {
                NsTest.testThreads[numTestThread] = new NsTest(TESTER2, numTestThread);
                testThreads[numTestThread].start();
                NsTest.sleep(3000L);
                ++numTestThread;
            }
            for (j = 0; j < NUMTESTER3; ++j) {
                NsTest.testThreads[numTestThread] = new NsTest(TESTER3, numTestThread);
                testThreads[numTestThread].start();
                NsTest.sleep(3000L);
                ++numTestThread;
            }
        }
        logger.println("Starting sequence reader thread");
        SequenceReader sequenceReader = new SequenceReader(DriverManager.getConnection((String)jdbcUrl, prop), 60000);
        sequenceReader.start();
        for (int j = 0; j < maxTestThreads; ++j) {
            logger.println("Waiting for thread " + j + " to join back/finish");
            testThreads[j].join();
        }
        if (timerThread != null) {
            timerThread.stopNow();
            timerThread.interrupt();
            timerThread.join();
        }
        sequenceReader.stopNow = true;
        sequenceReader.interrupt();
        sequenceReader.join();
        NsTest.printStatistics();
        mc.stopNow = true;
        mc.join();
        logger.println("End of test nstest! Look for 'FAIL' messages in the output and derby.log");
    }

    public static void printStatistics() {
        if (_statisticsAlreadyPrinted) {
            return;
        }
        _statisticsAlreadyPrinted = true;
        _endTimestamp = System.currentTimeMillis();
        statisticsLogger.println("");
        statisticsLogger.println("STATISTICS OF OPERATIONS DONE");
        statisticsLogger.println("-----------------------------");
        statisticsLogger.println("\n\n");
        statisticsLogger.println("Start time = " + new Timestamp(_startTimestamp).toString());
        statisticsLogger.println("End time = " + new Timestamp(_endTimestamp).toString());
        statisticsLogger.println("Duration = " + (_endTimestamp - _startTimestamp) / 60000L + " minutes");
        statisticsLogger.println("\n\n");
        statisticsLogger.println("SUCCESSFUL: ");
        statisticsLogger.println("\tNumber of INSERTS = " + numInserts);
        statisticsLogger.println("\tNumber of UPDATES = " + numUpdates);
        statisticsLogger.println("\tNumber of DELETES = " + numDeletes);
        statisticsLogger.println("\tNumber of SELECTS = " + numSelects);
        statisticsLogger.println("");
        statisticsLogger.println("FAILED: ");
        statisticsLogger.println("\tNumber of failed INSERTS = " + numFailedInserts);
        statisticsLogger.println("\tNumber of failed UPDATES = " + numFailedUpdates);
        statisticsLogger.println("\tNumber of failed DELETES = " + numFailedDeletes);
        statisticsLogger.println("\tNumber of failed SELECTS = " + numFailedSelects);
        statisticsLogger.println("");
        statisticsLogger.println("  Note that this may not be the same as the server side connections made\n   to the database especially if connection pooling is employed");
        statisticsLogger.println("");
        statisticsLogger.println("NOTE: Failing operations could be because of locking issue that are\ndirectly related to the application logic.  They are not necessarily bugs.");
        statisticsLogger.println("\nMax sequence counter peeked at = " + _maxSequenceCounter + "\n");
        statisticsLogger.println("\nLast total memory = " + _totalMemory + ", last free memory = " + _freeMemory + " as measured at " + _lastMemoryCheckTime + "\n");
        if (_errors.size() > 0) {
            Object[] errors = new NsTestError[_errors.size()];
            _errors.values().toArray(errors);
            Arrays.sort(errors);
            NsTest.countAndPrintSQLStates();
            for (Object error : errors) {
                NsTest.printError((NsTestError)error);
            }
        }
    }

    private static void countAndPrintSQLStates() {
        HashMap<String, int[]> results = new HashMap<String, int[]>();
        for (String key : _errors.keySet()) {
            SQLException se;
            String sqlState;
            NsTestError error = _errors.get(key);
            int count = error.count();
            Throwable throwable = error.throwable();
            if (!(throwable instanceof SQLException) || (sqlState = (se = (SQLException)throwable).getSQLState()) == null) continue;
            int[] holder = (int[])results.get(sqlState);
            if (holder == null) {
                holder = new int[]{count};
                results.put(sqlState, holder);
                continue;
            }
            holder[0] = holder[0] + count;
        }
        statisticsLogger.println("\n");
        for (String sqlState : results.keySet()) {
            statisticsLogger.println("\tNumber of " + sqlState + " = " + ((int[])results.get(sqlState))[0]);
        }
        statisticsLogger.println("\n");
    }

    private static void printError(NsTestError error) {
        Throwable throwable = error.throwable();
        String stackTrace = NsTest.getStackTrace(throwable);
        int count = error.count();
        Timestamp firstOccurrenceTime = new Timestamp(error.getFirstOccurrenceTime());
        Timestamp lastOccurrenceTime = new Timestamp(error.getLastOccurrenceTime());
        String sqlState = throwable instanceof SQLException ? ((SQLException)throwable).getSQLState() : null;
        StringBuilder buffer = new StringBuilder();
        buffer.append(ERROR_BANNER1);
        buffer.append(ERROR_BANNER2);
        buffer.append("\n");
        buffer.append(ERROR_BANNER2);
        buffer.append("Count = " + count);
        if (sqlState != null) {
            buffer.append(", SQLState = " + sqlState);
        }
        buffer.append(", Message = " + throwable.getMessage());
        buffer.append("\n");
        buffer.append(ERROR_BANNER2);
        buffer.append("\n");
        buffer.append(ERROR_BANNER2);
        buffer.append("First occurrence at " + firstOccurrenceTime);
        buffer.append(", last occurrence at " + lastOccurrenceTime);
        buffer.append("\n");
        buffer.append(ERROR_BANNER2);
        buffer.append("\n");
        buffer.append(ERROR_BANNER1);
        buffer.append("\n");
        buffer.append(stackTrace);
        buffer.append("\n");
        statisticsLogger.println(buffer.toString());
    }

    @Override
    public void run() {
        logger.println(this.getName() + " is now running");
        if (this.type == INIT) {
            Initializer Init = new Initializer(this.getName());
            Init.startInserts();
        } else if (this.type == TESTER1) {
            Tester1 Tstr1 = new Tester1("Tester1" + this.getName());
            Tstr1.startTesting();
        } else if (this.type == TESTER2) {
            Tester2 Tstr2 = new Tester2("Tester2" + this.getName());
            Tstr2.startTesting();
        } else if (this.type == TESTER3) {
            Tester3 Tstr3 = new Tester3("Tester3" + this.getName());
            Tstr3.startTesting();
        } else if (this.type == BACKUP) {
            BackupRestoreReEncryptTester Tstr4 = null;
            try {
                Tstr4 = new BackupRestoreReEncryptTester("BackupRestoreReEncrypt" + this.getName());
            }
            catch (IOException ioe) {
                logger.println(ioe + "=====> Unable to create backup log file, test cannot proceed ");
                ioe.printStackTrace(logger);
                return;
            }
            Tstr4.startTesting();
        } else {
            logger.println("FAIL: Invalid thread type, should be INIT or TESTERx or BACKUP");
            logger.println("You should check the code and restart");
            return;
        }
        logger.println(this.getName() + " finished and is now exiting");
    }

    public static synchronized void printException(String where, Exception e) {
        if (NsTest.justCountErrors()) {
            NsTest.addError(e);
            NsTest.vetError(e);
            return;
        }
        if (e instanceof SQLException) {
            SQLException se = (SQLException)e;
            if (se.getSQLState() != null) {
                if (se.getSQLState().equals("40001")) {
                    logger.println("deadlocked detected");
                }
                if (se.getSQLState().equals("40XL1")) {
                    logger.println(" lock timeout exception");
                }
                if (se.getSQLState().equals("23500")) {
                    logger.println(" duplicate key violation");
                }
            }
            if (se.getNextException() != null) {
                String m = se.getNextException().getSQLState();
                logger.println(se.getNextException().getMessage() + " SQLSTATE: " + m);
            }
        }
        if (e.getMessage() == null) {
            logger.println("NULL error message detected");
            logger.println("Here is the NULL exection - " + e.toString());
            logger.println("Stack trace of the NULL exception - ");
            e.printStackTrace(logger);
        }
        logger.println("At this point - " + where + ", exception thrown was : " + e.getMessage());
        NsTest.vetError(e);
    }

    private static void vetError(Throwable t) {
        if (t == null) {
            return;
        }
        if (t instanceof OutOfMemoryError) {
            NsTest.printStatistics();
            Runtime.getRuntime().halt(0);
        }
        NsTest.vetError(t.getCause());
        if (t instanceof SQLException) {
            SQLException sqlException = (SQLException)t;
            NsTest.vetError(sqlException.getNextException());
        }
    }

    public static String getDriverURL() {
        if (driver_type.equalsIgnoreCase("DerbyClient")) {
            return clientURL;
        }
        return embedURL;
    }

    public static void startNetworkServer() throws Exception {
        try {
            NWServerThread nsw = new NWServerThread("localhost", 1900);
            nsw.start();
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            e.printStackTrace(logger);
            throw e;
        }
    }

    public static boolean deadConnection(Throwable t) {
        SQLException se;
        return t instanceof SQLException && DEAD_CONNECTION.equals((se = (SQLException)t).getSQLState());
    }

    public static void printUsage() {
        _statisticsAlreadyPrinted = true;
        System.out.println(USAGE);
    }

    static {
        prop = new Properties();
        INIT = 0;
        TESTER1 = 1;
        TESTER2 = 2;
        TESTER3 = 3;
        BACKUP = 4;
        BACKUPDIR = "backupdir";
        RESTOREDIR = "restoredir";
        START_SERVER_IN_SAME_VM = false;
        AUTO_COMMIT_OFF = false;
        CREATE_DATABASE_ONLY = false;
        schemaCreated = false;
        INIT_THREADS = 6;
        MAX_INITIAL_ROWS = 6000;
        MAX_ITERATIONS = 2000;
        MAX_LOW_STRESS_ROWS = 30;
        MAX_OPERATIONS_PER_CONN = 25;
        NUMTESTER1 = 15;
        NUMTESTER2 = 45;
        NUMTESTER3 = 10;
        NUM_HIGH_STRESS_ROWS = 25000;
        NUM_UNTOUCHED_ROWS = 6000;
        numInserts = 0;
        numUpdates = 0;
        numDeletes = 0;
        numSelects = 0;
        numFailedInserts = 0;
        numFailedUpdates = 0;
        numFailedDeletes = 0;
        numFailedSelects = 0;
        numConnections = 0;
        INSERT = 0;
        UPDATE = 1;
        DELETE = 2;
        SELECT = 3;
        FAILED_INSERT = 4;
        FAILED_UPDATE = 5;
        FAILED_DELETE = 6;
        FAILED_SELECT = 7;
        CONNECTIONS_MADE = 8;
        driver_type = null;
        testThreads = null;
        _errors = new HashMap();
        _statisticsAlreadyPrinted = false;
    }

    public static class ShutdownHook
    implements Runnable {
        @Override
        public void run() {
            NsTest.printStatistics();
        }
    }
}

