/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.engine;

import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Enumeration;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ShutdownWithoutDeregisterPermissionTest
extends BaseJDBCTestCase {
    public ShutdownWithoutDeregisterPermissionTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new SecurityManagerSetup(TestConfiguration.embeddedSuite(ShutdownWithoutDeregisterPermissionTest.class), "org/apache/derbyTesting/functionTests/tests/engine/noDeregisterPermission.policy");
    }

    public void testShutdownWithoutPermission() throws SQLException {
        this.getConnection().close();
        TestConfiguration config = TestConfiguration.getCurrent();
        config.shutdownEngine();
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        Driver found = null;
        while (found == null && drivers.hasMoreElements()) {
            Driver driver = drivers.nextElement();
            if (!driver.getClass().getName().startsWith("org.apache.derby.iapi.jdbc.AutoloadedDriver")) continue;
            found = driver;
        }
        if (JDBC.vmSupportsJDBC42()) {
            ShutdownWithoutDeregisterPermissionTest.assertNotNull((String)"Expected driver to be registered", found);
        } else {
            ShutdownWithoutDeregisterPermissionTest.assertNull((String)"Expected driver to be deregistered", found);
        }
    }
}

