/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Derby5937SlaveShutdownTest
extends BaseJDBCTestCase {
    private static final String MASTER_DB = "d5937-master-db";
    private static final String SLAVE_DB = "d5937-slave-db";
    private static final String FAILOVER_SUCCESS = "XRE20";
    private static final String DB_SHUTDOWN_SUCCESS = "08006";
    private static final long RETRY_INTERVAL = 50L;

    public Derby5937SlaveShutdownTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (BaseTestCase.isJ9Platform()) {
            BaseTestSuite test = new BaseTestSuite("Derby5937SlaveShutdownTest");
            return test;
        }
        Class<Derby5937SlaveShutdownTest> klass = Derby5937SlaveShutdownTest.class;
        return new SecurityManagerSetup((Test)TestConfiguration.singleUseDatabaseDecorator(TestConfiguration.embeddedSuite(klass), MASTER_DB), klass.getName().replace('.', '/') + ".policy", true);
    }

    public void testSlaveFailoverLeak() throws Exception {
        this.getConnection().close();
        TestConfiguration config = TestConfiguration.getCurrent();
        config.shutdownDatabase();
        String masterDb = config.getDatabasePath(MASTER_DB);
        String slaveDb = config.getDatabasePath(SLAVE_DB);
        PrivilegedFileOpsForTests.copy(new File(masterDb), new File(slaveDb));
        DataSource startSlaveDS = JDBCDataSource.getDataSource(SLAVE_DB);
        JDBCDataSource.setBeanProperty(startSlaveDS, "connectionAttributes", "startSlave=true;slaveHost=" + config.getHostName() + ";slavePort=" + config.getPort());
        SlaveThread slave = new SlaveThread(startSlaveDS);
        slave.start();
        DataSource startMasterDS = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(startMasterDS, "connectionAttributes", "startMaster=true;slaveHost=" + config.getHostName() + ";slavePort=" + config.getPort());
        long giveUp = System.currentTimeMillis() + NetworkServerTestSetup.getWaitTime();
        Connection c = null;
        while (c == null) {
            try {
                c = startMasterDS.getConnection();
            }
            catch (SQLException sqle) {
                slave.checkError();
                if (System.currentTimeMillis() > giveUp) {
                    Derby5937SlaveShutdownTest.fail("Master won't start", sqle);
                    continue;
                }
                Derby5937SlaveShutdownTest.println("Retrying after startMaster failed with: " + sqle);
                Thread.sleep(50L);
            }
        }
        c.close();
        slave.join();
        slave.checkError();
        DataSource failoverDS = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(failoverDS, "connectionAttributes", "failover=true");
        try {
            failoverDS.getConnection();
            Derby5937SlaveShutdownTest.fail((String)"failover should receive exception");
        }
        catch (SQLException sqle) {
            Derby5937SlaveShutdownTest.assertSQLState(FAILOVER_SUCCESS, sqle);
        }
        giveUp = System.currentTimeMillis() + NetworkServerTestSetup.getWaitTime();
        DataSource slaveShutdownDS = JDBCDataSource.getDataSource(SLAVE_DB);
        JDBCDataSource.setBeanProperty(slaveShutdownDS, "shutdownDatabase", "shutdown");
        while (true) {
            try {
                while (true) {
                    slaveShutdownDS.getConnection();
                    Derby5937SlaveShutdownTest.fail((String)"Shutdown of slave database didn't throw an exception");
                }
            }
            catch (SQLException sqle) {
                if (!DB_SHUTDOWN_SUCCESS.equals(sqle.getSQLState())) {
                    if (System.currentTimeMillis() > giveUp) {
                        Derby5937SlaveShutdownTest.fail("Could not shut down slave database", sqle);
                        continue;
                    }
                    Derby5937SlaveShutdownTest.println("Retrying after failover failed with: " + sqle);
                    Thread.sleep(50L);
                    continue;
                }
                Derby5937SlaveShutdownTest.assertDirectoryDeleted(new File(slaveDb));
                return;
            }
            break;
        }
    }

    private class SlaveThread
    extends Thread {
        private final DataSource ds;
        private volatile Throwable error;

        SlaveThread(DataSource ds) {
            this.ds = ds;
        }

        @Override
        public void run() {
            try {
                this.run_();
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        private void run_() throws Exception {
            BaseTestCase.println("Slave thread started.");
            try {
                this.ds.getConnection();
                Assert.fail((String)"startSlave should throw exception");
            }
            catch (SQLException sqle) {
                BaseJDBCTestCase.assertSQLState("XRE08", sqle);
            }
        }

        void checkError() {
            if (this.error != null) {
                BaseTestCase.fail("Slave thread failed", this.error);
            }
        }
    }
}

