/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.harness;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.derby.impl.tools.sysinfo.Main;
import org.apache.derby.impl.tools.sysinfo.ZipInfoProperties;
import org.apache.derby.shared.common.info.JVMInfo;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public abstract class jvm {
    public String flags = null;
    public boolean noasyncgc = false;
    public boolean verbosegc = false;
    public boolean noclassgc = false;
    public long ss = -1L;
    public long oss = -1L;
    public long ms = -1L;
    public long mx = -1L;
    public String classpath = null;
    public String prof = null;
    public boolean verify = false;
    public boolean noverify = false;
    public boolean nojit = false;
    public Vector<String> D = null;
    public String javaCmd = "java";
    public String majorVersion = "";
    public String minorVersion = "";
    public int imajor = 0;
    public int iminor = 0;
    String hostName;
    private static String DEFAULT_POLICY = "util/derby_tests.policy";
    private static String DEFAULT_CODEBASE = "/classes";
    int verboselevel = -1;

    public jvm() {
    }

    public jvm(boolean noasyncgc, boolean verbosegc, boolean noclassgc, long ss, long oss, long ms, long mx, String classpath, String prof, boolean verify, boolean noverify, boolean nojit, Vector<String> D) {
        this.noasyncgc = noasyncgc;
        this.noclassgc = noclassgc;
        this.verbosegc = verbosegc;
        this.ss = ss;
        this.oss = oss;
        this.ms = ms;
        this.mx = mx;
        this.classpath = classpath;
        this.prof = prof;
        this.verify = verify;
        this.noverify = noverify;
        this.nojit = nojit;
        this.D = D;
    }

    public jvm(String classpath, Vector<String> D) {
        this.classpath = classpath;
        this.D = D;
    }

    public jvm(long ms, long mx, String classpath, Vector<String> D) {
        this.ms = ms;
        this.mx = mx;
        this.classpath = classpath;
        this.D = D;
    }

    public abstract String getDintro();

    public abstract String getName();

    public void setNoasyncgc(boolean noasyncgc) {
        this.noasyncgc = noasyncgc;
    }

    public void setNoclassgc(boolean noclassgc) {
        this.noclassgc = noclassgc;
    }

    public void setVerbosegc(boolean verbosegc) {
        this.verbosegc = verbosegc;
    }

    public void setSs(long ss) {
        this.ss = ss;
    }

    public void setOss(long oss) {
        this.oss = oss;
    }

    public void setMs(long ms) {
        this.ms = ms;
    }

    public void setMx(long mx) {
        this.mx = mx;
    }

    public void setClasspath(String classpath) {
        this.classpath = classpath;
    }

    public void setProf(String prof) {
        this.prof = prof;
    }

    public void setVerify(boolean verify) {
        this.verify = verify;
    }

    public void setNoverify(boolean noverify) {
        this.noverify = noverify;
    }

    public void setNojit(boolean nojit) {
        this.nojit = nojit;
    }

    public void setD(Vector<String> D) {
        this.D = D;
    }

    public void setFlags(String flags) {
        this.flags = flags;
    }

    public void setJavaCmd(String jcmd) {
        this.javaCmd = jcmd;
    }

    public Vector<String> getCommandLine() {
        Vector<String> v = new Vector<String>();
        v.addElement(this.javaCmd);
        v.addElement("-Duser.language=en");
        v.addElement("-Duser.country=US");
        if (this.flags != null && this.flags.length() > 0) {
            StringTokenizer st = new StringTokenizer(this.flags);
            while (st.hasMoreTokens()) {
                v.addElement(st.nextToken());
            }
        }
        return v;
    }

    public void warn(String msg) {
        if (this.verboselevel == -1) {
            try {
                this.verboselevel = Integer.parseInt(System.getProperty("verbose"));
            }
            catch (Exception e) {
                this.verboselevel = 0;
            }
        }
        if (this.verboselevel > 0) {
            System.out.println("jvm: " + msg);
        }
    }

    public static jvm getJvm(String jvmName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        jvm result = null;
        try {
            Class<?> clazz = Class.forName(jvmName);
            result = (jvm)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException e) {
            Class<?> clazz = Class.forName("org.apache.derbyTesting.functionTests.harness." + jvmName);
            result = (jvm)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return result;
    }

    public static jvm getCurrentJvm() throws Exception {
        String jvmName = System.getProperty("jvm");
        if (jvmName == null || jvmName.length() == 0) {
            String javaVersion = System.getProperty("java.version");
            jvmName = javaVersion.startsWith("1.2") ? "jdk12" : "currentjvm";
        }
        return jvm.getJvm(jvmName);
    }

    public int getMajorVersion() {
        return this.imajor;
    }

    public int getMinorVersion() {
        return this.iminor;
    }

    public void setVersion() throws Exception {
        String javaVersion = System.getProperty("java.version");
        int i = javaVersion.indexOf(46);
        int j = javaVersion.indexOf(46, i + 1);
        this.majorVersion = javaVersion.substring(0, i);
        this.minorVersion = javaVersion.substring(i + 1, j);
        Integer minor = Integer.valueOf(this.minorVersion);
        this.iminor = minor;
        Integer major = Integer.valueOf(this.majorVersion);
        this.imajor = major;
        Object jvmName = System.getProperty("jvm");
        if (jvmName == null || ((String)jvmName).length() == 0) {
            jvmName = this.iminor < 2 ? "currentjvm" : "jdk" + this.majorVersion + this.minorVersion;
        }
    }

    protected static String guessWSHome() {
        String sep;
        String wshome = "";
        String jhome = System.getProperty("java.home");
        int havejre = jhome.indexOf((sep = System.getProperty("file.separator")) + "jre");
        if (havejre > 0 && (wshome = jhome.substring(0, jhome.indexOf(sep + "jre"))).lastIndexOf(sep) >= 0) {
            wshome = wshome.substring(0, wshome.lastIndexOf(sep));
        }
        if (jhome.lastIndexOf(sep) >= 0) {
            wshome = jhome.substring(0, jhome.lastIndexOf(sep));
        }
        return wshome;
    }

    public static String findCodeBase(boolean[] isJar) {
        String classpath = JVMInfo.isModuleAware() ? JVMInfo.getSystemModulePath() : System.getProperty("java.class.path");
        int sep = 47;
        ZipInfoProperties[] zip = Main.getAllInfo((String)classpath);
        for (int i = 0; i < zip.length; ++i) {
            String location = zip[i].getLocation().replace('\\', '/');
            if (location.indexOf("derbynet.jar") != -1) {
                isJar[0] = true;
                return location.substring(0, location.lastIndexOf(sep));
            }
            if (location.indexOf("classes") == -1 || location.indexOf(".jar") != -1) continue;
            isJar[0] = false;
            return location;
        }
        return null;
    }

    protected void setSecurityProps() throws IOException, ClassNotFoundException {
        this.D = jvm.getSecurityProps(this.D);
    }

    static Vector<String> getSecurityProps(Vector<String> D) throws ClassNotFoundException, IOException {
        if (D == null) {
            D = new Vector();
        }
        String userDir = System.getProperty("user.dir");
        String policyFile = userDir + jvm.baseName(DEFAULT_POLICY);
        Object serverCodeBase = System.getProperty("serverCodeBase");
        boolean[] isJar = new boolean[1];
        if (serverCodeBase == null) {
            serverCodeBase = jvm.findCodeBase(isJar);
        }
        if (serverCodeBase == null) {
            String ws = jvm.guessWSHome();
            serverCodeBase = ws + DEFAULT_CODEBASE;
        }
        File pf = new File(policyFile);
        File cb = new File((String)serverCodeBase);
        if (!pf.exists()) {
            System.out.println("WARNING: Running without Security manager.policy File (" + policyFile + ") or serverCodeBase(" + (String)serverCodeBase + ") not available");
            return D;
        }
        D.addElement("java.security.manager");
        D.addElement("java.security.policy=" + pf.getAbsolutePath());
        Properties jusetup = SecurityManagerSetup.getPolicyFilePropertiesForOldHarness();
        Enumeration<Object> p = jusetup.keys();
        while (p.hasMoreElements()) {
            String key = (String)p.nextElement();
            D.addElement(key + "=" + jusetup.getProperty(key));
        }
        D.addElement("derbyTesting.codedir=" + cb.getAbsolutePath());
        String hostName = System.getProperty("hostName");
        if (hostName == null) {
            hostName = "localhost";
        }
        D.addElement("derbyTesting.serverhost=" + hostName);
        D.addElement("derbyTesting.clienthost=" + hostName);
        return D;
    }

    private static String baseName(String resourceName) {
        return resourceName.substring(resourceName.lastIndexOf("/"), resourceName.length());
    }
}

