/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.store;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class checkPoint {
    private static String derbyHome;
    private static File dbDir;
    private static File logDir;
    private static File logControlFile;
    private static long lastCheckPointTime;

    public static void main(String[] stringArray) {
        Connection connection;
        System.out.println("Test checkpoint starting");
        try {
            ij.getPropertyArg((String[])stringArray);
            connection = ij.startJBMS();
            checkPoint.setupAllTestFiles();
            Statement statement = connection.createStatement();
            statement.executeUpdate("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() DYNAMIC RESULT SETS 0 LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
            statement.executeUpdate("create table t1(c1 int not null primary key , c2 varchar(200) not null unique , c3 char(200) not null unique)");
            connection.setAutoCommit(true);
            String string = "insert into t1 values(?,?,?)";
            PreparedStatement preparedStatement = connection.prepareStatement(string);
            statement.executeUpdate("CALL SYSCS_UTIL.SYSCS_CHECKPOINT_DATABASE()");
            statement.executeUpdate("call WAIT_FOR_POST_COMMIT()");
            checkPoint.checkpointOccured();
            boolean bl = false;
            for (int i = 0; i < 3500; ++i) {
                preparedStatement.setLong(1, i);
                preparedStatement.setString(2, "IBM GREAT COMPANY " + i);
                preparedStatement.setString(3, "IBM GREAT COMPANY " + i);
                preparedStatement.executeUpdate();
                if (i % 400 == 0) {
                    System.out.println("Checking logs and Checkpoint at Insert:" + i);
                    statement.executeUpdate("call WAIT_FOR_POST_COMMIT()");
                    checkPoint.checkpointOccured();
                }
                if (i <= 2500 || bl) continue;
                System.out.println("Modifying the checkpoint/log intervals");
                String string2 = "150001";
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.logSwitchInterval', '" + string2 + "')");
                statement.executeUpdate("call SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY('derby.storage.checkpointInterval', '" + string2 + "')");
                ResultSet resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.storage.checkpointInterval')");
                while (resultSet.next()) {
                    System.out.println("checkPointInterval:" + resultSet.getString(1));
                }
                resultSet = statement.executeQuery("values SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY('derby.storage.logSwitchInterval')");
                while (resultSet.next()) {
                    System.out.println("logSwitchInterval:" + resultSet.getString(1));
                }
                bl = true;
            }
            checkPoint.numberOfLogFiles();
            connection.commit();
            statement.close();
            preparedStatement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            checkPoint.dumpSQLExceptions(sQLException);
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        try {
            connection = DriverManager.getConnection("jdbc:derby:wombat;shutdown=true");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState() != null && sQLException.getSQLState().equals("08006")) {
                System.out.println("database shutdown properly\n");
            } else {
                checkPoint.dumpSQLExceptions(sQLException);
            }
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception:" + throwable.toString());
        }
        System.out.println("Test checkpoint finished");
    }

    private static void dumpSQLExceptions(SQLException sQLException) {
        System.out.println("FAIL -- unexpected exception: " + sQLException.toString());
        while (sQLException != null) {
            System.out.print("SQLSTATE(" + sQLException.getSQLState() + "):");
            sQLException = sQLException.getNextException();
        }
    }

    private static void setupAllTestFiles() {
        derbyHome = System.getProperty("derby.system.home");
        dbDir = new File(derbyHome, "wombat");
        logDir = new File(dbDir, "log");
        logControlFile = new File(logDir, "log.ctrl");
        lastCheckPointTime = logControlFile.lastModified();
    }

    private static boolean checkpointOccured() {
        long l = logControlFile.lastModified();
        if (l > lastCheckPointTime) {
            lastCheckPointTime = l;
            System.out.println("CHECKPOINT WAS DONE");
            return true;
        }
        return false;
    }

    private static int numberOfLogFiles() {
        File[] fileArray = logDir.listFiles();
        int n = fileArray == null ? 0 : fileArray.length;
        String string = "";
        for (int i = 0; i < n; ++i) {
            String string2 = fileArray[i].getName();
            if (string2.compareTo("log.ctrl") == 0 || string2.compareTo("logmirror.ctrl") == 0 || string2.compareTo(string) <= 0) continue;
            string = string2;
        }
        if (string.compareTo("log21.dat") > 0) {
            System.out.println("There seems to be too many log files");
            System.out.println(string);
        }
        fileArray = null;
        return n - 2;
    }

    static {
        lastCheckPointTime = 0L;
    }
}

