/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimpleJsonPermsTest
extends BaseJDBCTestCase {
    private static final String DB_NAME = "simplejsonpermsdb";
    private static final String TEST_DBO = "TEST_DBO";
    private static final String ALICE = "ALICE";
    private static final String[] LEGAL_USERS = new String[]{"TEST_DBO", "ALICE"};
    private static final String LOAD_TOOL = "call syscs_util.syscs_register_tool( 'simpleJson', true )";
    private static final String UNLOAD_TOOL = "call syscs_util.syscs_register_tool( 'simpleJson', false )";
    private static final String LACK_EXECUTE_PRIV = "42504";

    public SimpleJsonPermsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite = (BaseTestSuite)TestConfiguration.embeddedSuite(SimpleJsonPermsTest.class);
        SupportFilesSetup supportFilesSetup = new SupportFilesSetup((Test)baseTestSuite, new String[]{"functionTests/tests/lang/json.dat"});
        Test test = DatabasePropertyTestSetup.builtinAuthentication((Test)supportFilesSetup, LEGAL_USERS, "SimpleJsonPermissions");
        Test test2 = TestConfiguration.sqlAuthorizationDecoratorSingleUse(test, DB_NAME, true);
        return test2;
    }

    public void test_001_basic() throws Exception {
        Connection connection = this.openUserConnection(TEST_DBO);
        Connection connection2 = this.openUserConnection(ALICE);
        this.goodStatement(connection2, "create table t( a int )");
        this.expectExecutionError(connection2, LACK_EXECUTE_PRIV, LOAD_TOOL);
        this.goodStatement(connection, LOAD_TOOL);
        this.goodStatement(connection2, "create function f_double( jsonArray test_dbo.JSONArray )\nreturns table\n(\n  str_col varchar( 10 ),\n  bool_col boolean,\n  num_col double\n)\nlanguage java parameter style derby_jdbc_result_set contains sql\nexternal name 'org.apache.derby.optional.api.SimpleJsonVTI.readArray'\n");
        String[][] stringArray = new String[][]{{"abc", "true", "127.0"}};
        String[][] stringArray2 = new String[][]{{"abc", "true", "127.0"}, {"def", "false", "1.2"}, {"ghi", null, "345.67"}, {"lmn", "true", "9.223372036854776E18"}};
        this.assertResults(connection2, "select * from table\n(\n    f_double\n    (\n        test_dbo.readArrayFromString\n        ( '[{ \"STR_COL\" : \"abc\", \"BOOL_COL\" : true, \"NUM_COL\" : 127 }]' )\n    )\n) t\n", stringArray, false);
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        File file = SupportFilesSetup.getReadOnly("json.dat");
        preparedStatement = connection2.prepareStatement("select * from table\n( f_double( test_dbo.readArrayFromFile( ?, 'UTF-8' ) ) ) t");
        preparedStatement.setString(1, PrivilegedFileOpsForTests.getAbsolutePath(file));
        resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, stringArray2, false);
        resultSet.close();
        preparedStatement.close();
        preparedStatement = connection2.prepareStatement("select * from table\n( f_double( test_dbo.readArrayFromURL( ?, 'UTF-8' ) ) ) t");
        String string = PrivilegedFileOpsForTests.toURI(file).toURL().toString();
        preparedStatement.setString(1, string);
        resultSet = preparedStatement.executeQuery();
        this.assertResults(resultSet, stringArray2, false);
        resultSet.close();
        preparedStatement.close();
        this.goodStatement(connection2, "drop table t");
        this.goodStatement(connection2, "drop function f_double");
        this.expectExecutionError(connection2, LACK_EXECUTE_PRIV, UNLOAD_TOOL);
        this.goodStatement(connection, UNLOAD_TOOL);
    }
}

