/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.CallableStatement;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class RowIdNotImplementedTest
extends BaseJDBCTestCase {
    public RowIdNotImplementedTest(String string) {
        super(string);
    }

    public void testRowIdInPreparedStatementSetRowId() throws SQLException {
        PreparedStatement preparedStatement = this.prepareStatement("select count(*) from sys.systables");
        try {
            preparedStatement.setRowId(1, null);
            RowIdNotImplementedTest.fail((String)"PreparedStatement.setRowId should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInCallableStatementGetRowIdInt() throws SQLException {
        CallableStatement callableStatement = this.getCallableStatement();
        try {
            callableStatement.getRowId(1);
            RowIdNotImplementedTest.fail((String)"CallableStatement.getRowId(int) should not be implemented.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInCallableStatementGetRowIdString() throws SQLException {
        CallableStatement callableStatement = this.getCallableStatement();
        try {
            callableStatement.getRowId("some-parameter-name");
            RowIdNotImplementedTest.fail((String)"CallableStatement.getRowId(String) should not be implemented.");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInCallableStatementSetRowId() throws SQLException {
        CallableStatement callableStatement = this.getCallableStatement();
        try {
            callableStatement.setRowId("some-parameter-name", null);
            RowIdNotImplementedTest.fail((String)"CallableStatement.setRowId should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInResultSetGetRowIdInt() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        try {
            resultSet.getRowId(1);
            RowIdNotImplementedTest.fail((String)"ResultSet.getRowId(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInResultSetGetRowIdString() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        try {
            resultSet.getRowId("some-parameter-name");
            RowIdNotImplementedTest.fail((String)"ResultSet.getRowId(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInResultSetUpdateRowIdInt() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        try {
            resultSet.updateRowId(1, null);
            RowIdNotImplementedTest.fail((String)"ResultSet.updateRowId(int) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInResultSetUpdateRowIdString() throws SQLException {
        ResultSet resultSet = this.getResultSet();
        try {
            resultSet.updateRowId("some-parameter-name", null);
            RowIdNotImplementedTest.fail((String)"ResultSet.updateRowId(String) should not be implemented");
        }
        catch (SQLFeatureNotSupportedException sQLFeatureNotSupportedException) {
            // empty catch block
        }
    }

    public void testRowIdInDatabaseMetaDataRowIdLifeTime() throws SQLException {
        DatabaseMetaData databaseMetaData = this.getConnection().getMetaData();
        RowIdLifetime rowIdLifetime = databaseMetaData.getRowIdLifetime();
        RowIdNotImplementedTest.assertEquals((String)"RowIdLifetime should be ROWID_UNSUPPORTED", (Object)((Object)RowIdLifetime.ROWID_UNSUPPORTED), (Object)((Object)rowIdLifetime));
        databaseMetaData = null;
    }

    private CallableStatement getCallableStatement() throws SQLException {
        return this.prepareCall("values 1");
    }

    private ResultSet getResultSet() throws SQLException {
        return this.createStatement().executeQuery("values 1");
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(RowIdNotImplementedTest.class);
    }
}

