/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Random;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derby.impl.tools.planexporter.AccessDatabase;
import org.apache.derby.tools.PlanExporter;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.XML;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XplainStatisticsTest
extends BaseJDBCTestCase {
    private static long timeSuiteStarted;
    private static String[] tableNames;

    public XplainStatisticsTest(String string) {
        super(string);
    }

    public static Test suite() {
        BaseTestSuite baseTestSuite;
        timeSuiteStarted = new Date().getTime();
        Object object = baseTestSuite = new BaseTestSuite(XplainStatisticsTest.class, "XplainStatisticsTest");
        object = new SupportFilesSetup((Test)object);
        return new CleanDatabaseTestSetup((Test)object){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                XplainStatisticsTest.createSchemaObjects(statement);
            }
        };
    }

    protected void setUp() throws SQLException {
        this.emptyStatementCache();
    }

    private static void createSchemaObjects(Statement statement) throws SQLException {
        statement.executeUpdate("CREATE TABLE AIRLINES (      AIRLINE CHAR(2) NOT NULL ,      AIRLINE_FULL VARCHAR(24),      BASIC_RATE DOUBLE PRECISION,      DISTANCE_DISCOUNT DOUBLE PRECISION,      BUSINESS_LEVEL_FACTOR DOUBLE PRECISION,      FIRSTCLASS_LEVEL_FACTOR DOUBLE PRECISION,      ECONOMY_SEATS INTEGER,      BUSINESS_SEATS INTEGER,      FIRSTCLASS_SEATS INTEGER)");
        statement.executeUpdate("ALTER TABLE AIRLINES   ADD CONSTRAINT AIRLINES_PK Primary Key (AIRLINE)");
        statement.executeUpdate("CREATE TABLE COUNTRIES (      COUNTRY VARCHAR(26) NOT NULL,      COUNTRY_ISO_CODE CHAR(2) NOT NULL ,      REGION VARCHAR(26))");
        statement.executeUpdate("ALTER TABLE COUNTRIES   ADD CONSTRAINT COUNTRIES_PK Primary Key (COUNTRY_ISO_CODE)");
        statement.executeUpdate("ALTER TABLE COUNTRIES   ADD CONSTRAINT COUNTRIES_UNQ_NM Unique (COUNTRY)");
        statement.executeUpdate("CREATE TABLE CITIES (      CITY_ID INTEGER NOT NULL ,      CITY_NAME VARCHAR(24) NOT NULL,\tCOUNTRY VARCHAR(26) NOT NULL,\tAIRPORT VARCHAR(3),\tLANGUAGE  VARCHAR(16),      COUNTRY_ISO_CODE CHAR(2) )");
        statement.executeUpdate("ALTER TABLE CITIES   ADD CONSTRAINT CITIES_PK Primary Key (CITY_ID)");
        statement.executeUpdate("ALTER TABLE CITIES   ADD CONSTRAINT COUNTRIES_FK Foreign Key (COUNTRY_ISO_CODE)   REFERENCES COUNTRIES (COUNTRY_ISO_CODE)");
        statement.executeUpdate("CREATE TABLE FLIGHTS (      FLIGHT_ID CHAR(6) NOT NULL ,      SEGMENT_NUMBER INTEGER NOT NULL ,      ORIG_AIRPORT CHAR(3),      DEPART_TIME TIME,      DEST_AIRPORT CHAR(3),      ARRIVE_TIME TIME,      MEAL CHAR(1),      FLYING_TIME DOUBLE PRECISION,      MILES INTEGER,      AIRCRAFT VARCHAR(6))");
        statement.executeUpdate("CREATE INDEX DESTINDEX ON FLIGHTS (DEST_AIRPORT) ");
        statement.executeUpdate("CREATE INDEX ORIGINDEX ON FLIGHTS (ORIG_AIRPORT) ");
        statement.executeUpdate("ALTER TABLE FLIGHTS   ADD CONSTRAINT FLIGHTS_PK Primary Key (FLIGHT_ID, SEGMENT_NUMBER)");
        statement.executeUpdate("CREATE TABLE FLIGHTAVAILABILITY (      FLIGHT_ID CHAR(6) NOT NULL ,      SEGMENT_NUMBER INTEGER NOT NULL ,      FLIGHT_DATE DATE NOT NULL ,      ECONOMY_SEATS_TAKEN INTEGER DEFAULT 0,      BUSINESS_SEATS_TAKEN INTEGER DEFAULT 0,      FIRSTCLASS_SEATS_TAKEN INTEGER DEFAULT 0)");
        statement.executeUpdate("ALTER TABLE FLIGHTAVAILABILITY   ADD CONSTRAINT FLIGHTAVAIL_PK Primary Key        (FLIGHT_ID, SEGMENT_NUMBER, FLIGHT_DATE)");
        statement.executeUpdate("ALTER TABLE FLIGHTAVAILABILITY   ADD CONSTRAINT FLIGHTS_FK2 Foreign Key (FLIGHT_ID, SEGMENT_NUMBER)   REFERENCES FLIGHTS (FLIGHT_ID, SEGMENT_NUMBER)");
        statement.executeUpdate("CREATE TABLE MAPS (      MAP_ID INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY              (START WITH 1, INCREMENT BY 1),      MAP_NAME VARCHAR(24) NOT NULL,      REGION VARCHAR(26),      AREA DECIMAL(8,4) NOT NULL,      PHOTO_FORMAT VARCHAR(26) NOT NULL,      PICTURE BLOB(102400),      UNIQUE (MAP_ID, MAP_NAME))");
        statement.executeUpdate("CREATE TABLE FLIGHTS_HISTORY (      FLIGHT_ID CHAR(6),      SEGMENT_NUMBER INTEGER,      ORIG_AIRPORT CHAR(3),      DEPART_TIME TIME,      DEST_AIRPORT CHAR(3),      ARRIVE_TIME TIME,      MEAL CHAR(1),      FLYING_TIME DOUBLE PRECISION,      MILES INTEGER,      AIRCRAFT VARCHAR(6),       STATUS VARCHAR (20))");
        statement.executeUpdate("insert into FLIGHTS values ('AA1111',1,'ABQ','09:00:00','LAX','09:19:00','S',1.328,664,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1112',1,'LAX','09:00:00','ABQ','11:19:00','S',1.328,664,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1113',1,'ABQ','09:00:00','PHX','09:39:00','S',0.658,329,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1114',1,'PHX','09:00:00','ABQ','09:39:00','S',0.658,329,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1115',1,'ABQ','09:00:00','OKC','11:02:00','B',1.034,517,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1116',1,'OKC','09:00:00','ABQ','09:02:00','B',1.034,517,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1117',1,'AKL','09:00:00','HNL','18:48:00','L',8.804,4402,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1118',1,'HNL','13:30:00','AKL','21:18:00','D',8.804,4402,'DC10')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1119',1,'AKL','09:00:00','NRT','15:59:00','L',10.996,5498,'B747')");
        statement.executeUpdate("insert into FLIGHTS values ('AA1120',1,'NRT','09:00:00','AKL','23:59:00','L',10.996,5498,'B747')");
        statement.executeUpdate("insert into COUNTRIES values ( 'Afghanistan','AF','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ( 'Albania','AL','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Algeria','DZ','North Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('American Samoa','AS','Pacific Islands')");
        statement.executeUpdate("insert into COUNTRIES values ('Angola','AO','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Argentina','AR','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Armenia','AM','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Australia','AU','Australia and New Zealand')");
        statement.executeUpdate("insert into COUNTRIES values ('Austria','AT','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Azerbaijan','AZ','Central Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Bahamas','BS','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Bangladesh','BD','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Barbados','BB','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Belgium','BE','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Belize','BZ','Central America')");
        statement.executeUpdate("insert into COUNTRIES values ('Bermuda','BM','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Bolivia','BO','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Botswana','BW','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Brazil','BR','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Bulgaria','BG','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Cambodia','KH','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Cameroon','CM','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Canada','CA','North America')");
        statement.executeUpdate("insert into COUNTRIES values ('Cape Verde','CV','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Chile','CL','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('China','CN','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Colombia','CO','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Congo','CG','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Costa Rica','CR','Central America')");
        statement.executeUpdate("insert into COUNTRIES values ('Cote d''Ivoire','CI','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Cuba','CU','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Czech Republic','CZ','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Denmark','DK','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Dominical Republic','DO','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Ecuador','EC','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Egypt','EG','North Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('El Salvador','SV','Central America')");
        statement.executeUpdate("insert into COUNTRIES values ('Ethiopia','ET','North Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Falkland Islands','FK','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Fiji','FJ','Pacific Islands')");
        statement.executeUpdate("insert into COUNTRIES values ('Finland','FI','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('France','FR','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Georgia','GE','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Germany','DE','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Ghana','GH','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Greece','GR','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Guadeloupe','GP','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Guatemala','GT','Central America')");
        statement.executeUpdate("insert into COUNTRIES values ('Honduras','HN','Central America')");
        statement.executeUpdate("insert into COUNTRIES values ('Hungary','HU','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Iceland','IS','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('India','IN','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Indonesia','ID','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Iran','IR','Middle East')");
        statement.executeUpdate("insert into COUNTRIES values ('Iraq','IQ','Middle East')");
        statement.executeUpdate("insert into COUNTRIES values ('Ireland','IE','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Israel','IL','Middle East')");
        statement.executeUpdate("insert into COUNTRIES values ('Italy','IT','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Jamaica','JM','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Japan','JP','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Jordan','JO','Middle East')");
        statement.executeUpdate("insert into COUNTRIES values ('Kenya','KE','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Korea, Republic of','KR','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Lebanon','LB','Middle East')");
        statement.executeUpdate("insert into COUNTRIES values ('Lithuania','LT','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Madagascar','MG','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Malaysia','MY','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Mali','ML','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Mexico','MX','North America')");
        statement.executeUpdate("insert into COUNTRIES values ('Morocco','MA','North Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Mozambique','MZ','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Nepal','NP','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Netherlands','NL','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('New Zealand','NZ','Australia and New Zealand')");
        statement.executeUpdate("insert into COUNTRIES values ('Nicaragua','NI','Central America')");
        statement.executeUpdate("insert into COUNTRIES values ('Nigeria','NG','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Norway','NO','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Pakistan','PK','Central Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Paraguay','PY','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Peru','PE','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Philippines','PH','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Poland','PL','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Portugal','PT','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Russia','RU','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Samoa','WS','Pacific Islands')");
        statement.executeUpdate("insert into COUNTRIES values ('Senegal','SN','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Sierra Leone','SL','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Singapore','SG','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Slovakia','SK','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('South Africa','ZA','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Spain','ES','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Sri Lanka','LK','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Sudan','SD','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Sweden','SE','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Switzerland','CH','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Syrian Arab Republic','SY','Middle East')");
        statement.executeUpdate("insert into COUNTRIES values ('Tajikistan','TJ','Central Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Tanzania','TZ','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Thailand','TH','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Trinidad and Tobago','TT','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Tunisia','TN','North Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Turkey','TR','Middle East')");
        statement.executeUpdate("insert into COUNTRIES values ('Ukraine','UA','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('United Kingdom','GB','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('United States','US','North America')");
        statement.executeUpdate("insert into COUNTRIES values ('Uruguay','UY','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Uzbekistan','UZ','Central Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Venezuela','VE','South America')");
        statement.executeUpdate("insert into COUNTRIES values ('Viet Nam','VN','Asia')");
        statement.executeUpdate("insert into COUNTRIES values ('Virgin Islands (British)','VG','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Virgin Islands (U.S.)','VI','Caribbean')");
        statement.executeUpdate("insert into COUNTRIES values ('Yugoslavia','YU','Europe')");
        statement.executeUpdate("insert into COUNTRIES values ('Zaire','ZR','Africa')");
        statement.executeUpdate("insert into COUNTRIES values ('Zimbabwe','ZW','Africa')");
        statement.executeUpdate("create table t (x int not null primary key, y char(250))");
        statement.executeUpdate("insert into t values (1, 'a'), (2,'b'), (3,'c'), (4,'d')");
        statement.executeUpdate("delete from t where x = 3");
    }

    private static boolean hasTable(Statement statement, String string, String string2) throws SQLException {
        ResultSet resultSet = statement.getConnection().getMetaData().getTables(null, string, string2, new String[]{"TABLE"});
        boolean bl = resultSet.next();
        resultSet.close();
        return bl;
    }

    private static void enableXplainStyle(Statement statement) throws SQLException {
        XplainStatisticsTest.verifyXplainUnset(statement);
        for (int i = 0; i < tableNames.length; ++i) {
            if (!XplainStatisticsTest.hasTable(statement, "XPLTEST", tableNames[i])) continue;
            statement.execute("delete from XPLTEST." + tableNames[i]);
        }
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(1)");
        statement.execute("call syscs_util.syscs_set_xplain_schema('XPLTEST')");
        statement.execute("call syscs_util.syscs_set_xplain_mode(0)");
    }

    private static void enableXplainStyleWithTiming(Statement statement) throws SQLException {
        XplainStatisticsTest.enableXplainStyle(statement);
        statement.execute("call syscs_util.syscs_set_statistics_timing(1)");
    }

    private static void enableXplainOnlyMode(Statement statement) throws SQLException {
        statement.execute("call syscs_util.syscs_set_xplain_mode(1)");
    }

    private static void clearXplainOnlyMode(Statement statement) throws SQLException {
        statement.execute("call syscs_util.syscs_set_xplain_mode(0)");
    }

    private static void disableXplainStyle(Statement statement, boolean bl) throws Exception {
        statement.execute("call SYSCS_UTIL.SYSCS_SET_RUNTIMESTATISTICS(0)");
        if (bl) {
            String string = statement.getConnection().getMetaData().getURL();
            ResultSet resultSet = statement.executeQuery("select stmt_id from XPLTEST.sysxplain_statements");
            while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                String string3 = XplainStatisticsTest.invokePlanExporterTool(string, "XPLTEST", string2, "-xml", SupportFilesSetup.getReadWriteFileName(string2 + ".xml"));
                XplainStatisticsTest.assertEquals((String)"Unexpected output from PlanExporter", (String)"", (String)string3);
            }
        }
        statement.execute("call syscs_util.syscs_set_xplain_schema('')");
    }

    private static void verifyXplainUnset(Statement statement) throws SQLException {
        JDBC.assertFullResultSet(statement.executeQuery("values SYSCS_UTIL.syscs_get_xplain_schema()"), new String[][]{{""}});
        JDBC.assertFullResultSet(statement.executeQuery("values SYSCS_UTIL.syscs_get_xplain_mode()"), new String[][]{{"0"}});
    }

    private void verifyNonNullDRDA_ID(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select drda_id from xpltest.sysxplain_statements");
        while (resultSet.next()) {
            String string = resultSet.getString("DRDA_ID");
            if (!resultSet.wasNull() && string != null && string.trim().length() != 0) continue;
            XplainStatisticsTest.fail((String)"While running in a network-client configuration, DRDA_ID was null or blank.");
        }
        resultSet.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String invokePlanExporterTool(String ... stringArray) {
        PrintStream printStream = System.out;
        PrintStream printStream2 = System.err;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintStream printStream3 = new PrintStream(byteArrayOutputStream);
        XplainStatisticsTest.setSystemOut(printStream3);
        XplainStatisticsTest.setSystemErr(printStream3);
        try {
            PlanExporter.main((String[])stringArray);
        }
        finally {
            XplainStatisticsTest.setSystemOut(printStream);
            XplainStatisticsTest.setSystemErr(printStream2);
        }
        printStream3.flush();
        return byteArrayOutputStream.toString();
    }

    private void dumpResultSets(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select * from xpltest.sysxplain_resultsets");
        while (resultSet.next()) {
            System.out.println(resultSet.getString("rs_id") + "," + resultSet.getString("op_identifier") + "," + resultSet.getString("op_details") + "," + resultSet.getString("no_opens") + "," + resultSet.getString("no_index_updates") + "," + resultSet.getString("lock_mode") + "," + resultSet.getString("lock_granularity") + "," + resultSet.getString("parent_rs_id") + "," + resultSet.getString("est_row_count") + "," + resultSet.getString("est_cost") + "," + resultSet.getString("affected_rows") + "," + resultSet.getString("deferred_rows") + "," + resultSet.getString("input_rows") + "," + resultSet.getString("seen_rows") + "," + resultSet.getString("seen_rows_right") + "," + resultSet.getString("filtered_rows") + "," + resultSet.getString("returned_rows") + "," + resultSet.getString("empty_right_rows") + "," + resultSet.getString("index_key_opt") + "," + resultSet.getString("scan_rs_id") + "," + resultSet.getString("sort_rs_id") + "," + resultSet.getString("stmt_id") + "," + resultSet.getString("timing_id"));
        }
        resultSet.close();
    }

    private void dumpStatements(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select * from xpltest.sysxplain_statements");
        while (resultSet.next()) {
            System.out.println(resultSet.getString("stmt_id") + "," + resultSet.getString("stmt_name") + "," + resultSet.getString("stmt_type") + "," + resultSet.getString("stmt_text") + "," + resultSet.getString("jvm_id") + "," + resultSet.getString("os_identifier") + "," + resultSet.getString("xplain_mode") + "," + resultSet.getString("xplain_time") + "," + resultSet.getString("xplain_thread_id") + "," + resultSet.getString("transaction_id") + "," + resultSet.getString("session_id") + "," + resultSet.getString("database_name") + "," + resultSet.getString("drda_id") + "," + resultSet.getString("timing_id"));
        }
        resultSet.close();
    }

    private String getStmtID(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select stmt_id from XPLTEST.sysxplain_statements");
        resultSet.next();
        String string = resultSet.getString(1);
        resultSet.close();
        return string;
    }

    private String[] getStmtIDArray(Statement statement, int n) throws SQLException {
        String[] stringArray = new String[n];
        int n2 = 0;
        ResultSet resultSet = statement.executeQuery("select stmt_id from XPLTEST.sysxplain_statements");
        while (resultSet.next()) {
            stringArray[n2] = resultSet.getString(1);
            if (++n2 != n) continue;
            XplainStatisticsTest.assertFalse((boolean)resultSet.next());
        }
        resultSet.close();
        return stringArray;
    }

    private Object getADocument(final String string) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        InputSource inputSource = new InputSource(AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

            @Override
            public InputStream run() throws Exception {
                return new FileInputStream(SupportFilesSetup.getReadWriteURL(string + ".xml").getPath());
            }
        }));
        Document document = documentBuilder.parse(inputSource);
        document.getDocumentElement().normalize();
        return document;
    }

    private String readStatement(String string) throws Exception {
        Document document = (Document)this.getADocument(string);
        return document.getElementsByTagName("statement").item(0).getChildNodes().item(0).getNodeValue();
    }

    private int countNode(String string) throws Exception {
        Document document = (Document)this.getADocument(string);
        return document.getElementsByTagName("node").getLength();
    }

    private String getNodeName(String string) throws Exception {
        Document document = (Document)this.getADocument(string);
        NodeList nodeList = document.getElementsByTagName("node");
        Object object = "";
        for (int i = 0; i < nodeList.getLength(); ++i) {
            object = (String)object + nodeList.item(i).getAttributes().getNamedItem("name").getNodeValue() + "|";
        }
        return object;
    }

    private String getNodeAttribute(String string, String string2, int n) throws Exception {
        Document document = (Document)this.getADocument(string);
        NodeList nodeList = document.getElementsByTagName("node");
        if (nodeList.item(n).getAttributes().getNamedItem(string2) == null) {
            return "";
        }
        return nodeList.item(n).getAttributes().getNamedItem(string2).getNodeValue();
    }

    public void testPlanExporterSchemaExistence() throws Exception {
        AccessDatabase accessDatabase = new AccessDatabase(this.getConnection(), "NoSuchSchema", "nostmt");
        XplainStatisticsTest.assertTrue((String)"Unexpectedly thought schema exists", (!accessDatabase.verifySchemaExistance() ? 1 : 0) != 0);
    }

    public void testPlanExporterIllegalFileAccess() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        JDBC.assertDrainResults(statement.executeQuery("values 1"));
        XplainStatisticsTest.disableXplainStyle(statement, true);
        ResultSet resultSet = statement.executeQuery("select stmt_id from XPLTEST.sysxplain_statements");
        XplainStatisticsTest.assertTrue((String)"no statements", (boolean)resultSet.next());
        String string = resultSet.getString("stmt_id");
        JDBC.assertEmpty(resultSet);
        String string2 = XplainStatisticsTest.invokePlanExporterTool(this.getConnection().getMetaData().getURL(), "XPLTEST", string, "-xml", "/illegal.xml");
        if (!string2.contains("java.security.AccessControlException")) {
            XplainStatisticsTest.fail((String)("Unexpected output from PlanExporter: " + string2));
        }
    }

    public void testPlanExporterSpecialCharactersInSchema() throws Exception {
        String string = "DERBY-4904 \"double\" and 'single' quoted schema";
        String string2 = "select * from sysibm.sysdummy1";
        PreparedStatement preparedStatement = this.prepareStatement("call syscs_util.syscs_set_runtimestatistics(?)");
        PreparedStatement preparedStatement2 = this.prepareStatement("call syscs_util.syscs_set_xplain_schema(?)");
        preparedStatement.setInt(1, 1);
        preparedStatement.execute();
        preparedStatement2.setString(1, string);
        preparedStatement2.execute();
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery(string2), "Y");
        preparedStatement.setInt(1, 0);
        preparedStatement.execute();
        preparedStatement2.setString(1, "");
        preparedStatement2.execute();
        ResultSet resultSet = statement.executeQuery("select stmt_id, stmt_text from " + JDBC.escape(string, "SYSXPLAIN_STATEMENTS"));
        XplainStatisticsTest.assertTrue((boolean)resultSet.next());
        String string3 = resultSet.getString(1);
        XplainStatisticsTest.assertEquals((String)string2, (String)resultSet.getString(2));
        XplainStatisticsTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        String string4 = XplainStatisticsTest.invokePlanExporterTool(this.getConnection().getMetaData().getURL(), string, string3, "-xml", SupportFilesSetup.getReadWriteFileName(string3 + ".xml"));
        XplainStatisticsTest.assertEquals((String)"Unexpected output from PlanExporter", (String)"", (String)string4);
        if (XML.classpathMeetsXMLReqs()) {
            XplainStatisticsTest.assertEquals((String)string2, (String)this.readStatement(string3));
        }
    }

    public void testSimpleQueryMultiWithInvalidation() throws Exception {
        long l = 10000L;
        MTSimpleSelect mTSimpleSelect = new MTSimpleSelect(this.openDefaultConnection(), l);
        MTSimpleInvalidate mTSimpleInvalidate = new MTSimpleInvalidate(this.openDefaultConnection(), l);
        Thread thread = new Thread(mTSimpleInvalidate);
        Thread thread2 = new Thread(mTSimpleSelect);
        thread.start();
        thread2.start();
        thread.join();
        thread2.join();
        int n = mTSimpleSelect.getActionCount();
        int n2 = mTSimpleInvalidate.getActionCount();
        XplainStatisticsTest.println("selects=" + n + ", invalidations=" + n2);
        if (mTSimpleSelect.failed()) {
            XplainStatisticsTest.fail("select-thread failed", mTSimpleSelect.getError());
        }
        if (mTSimpleInvalidate.failed()) {
            XplainStatisticsTest.fail("invalidate-thread failed", mTSimpleInvalidate.getError());
        }
        Statement statement = this.createStatement();
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statements"), Integer.toString(n));
    }

    public void testSimpleQuery() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(statement);
        String string = "SELECT country from countries WHERE region = 'Central America'";
        JDBC.assertUnorderedResultSet(statement.executeQuery(string), new String[][]{{"Belize"}, {"Costa Rica"}, {"El Salvador"}, {"Guatemala"}, {"Honduras"}, {"Nicaragua"}});
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statements"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statement_timings"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultset_timings"), "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_scan_props"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_sort_props"), "0");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statements  where stmt_text like '%from countries%' "), "1");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets"), new String[][]{{"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select stmt_type, stmt_text, xplain_mode  from xpltest.sysxplain_statements"), new String[][]{{"S", string, "F"}});
        if (!XplainStatisticsTest.usingDerbyNetClient()) {
            JDBC.assertSingleValueResultSet(statement.executeQuery("select drda_id from xpltest.sysxplain_statements"), null);
        } else {
            this.verifyNonNullDRDA_ID(statement);
        }
        JDBC.assertSingleValueResultSet(statement.executeQuery("select no_opens from xpltest.sysxplain_resultsets where op_identifier = 'TABLESCAN'"), "1");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select no_opens, seen_rows, returned_rows,        lock_mode, lock_granularity from xpltest.sysxplain_resultsets where op_identifier = 'TABLESCAN'"), new String[][]{{"1", "6", "6", "IS", "R"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_fetched_columns, sp.bitset_of_fetched_columns from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='TABLESCAN'"), new String[][]{{"COUNTRIES", "T", "HEAP", "RC", "114", "6", "2", "2", "{0, 2}"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select sp.no_visited_rows from xpltest.sysxplain_scan_props sp,      xpltest.sysxplain_resultsets rs,      xpltest.sysxplain_statements st where st.stmt_id = rs.stmt_id and      rs.scan_rs_id = sp.scan_rs_id and      rs.op_identifier = 'TABLESCAN' and      sp.scan_object_name = 'COUNTRIES'"), "114");
        this.verifySensibleStatementTimings(statement);
        this.verifySensibleResultSetTimings(statement);
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)2, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|TABLESCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"COUNTRIES", (String)this.getNodeAttribute(string2, "scanned_object", 1));
            Assert.assertEquals((String)"HEAP", (String)this.getNodeAttribute(string2, "scan_type", 1));
            Assert.assertEquals((String)"2", (String)this.getNodeAttribute(string2, "visited_pages", 1));
        }
    }

    private String getStmtIDByName(Statement statement, String string) throws SQLException {
        String string2 = "?";
        ResultSet resultSet = statement.executeQuery("select stmt_id from XPLTEST.sysxplain_statements where stmt_name='" + string + "'");
        if (resultSet.next()) {
            string2 = resultSet.getString(1);
        }
        resultSet.close();
        return string2;
    }

    public void testSimpleXplainOnly() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        XplainStatisticsTest.enableXplainOnlyMode(statement);
        statement.setCursorName("1");
        JDBC.assertEmpty(statement.executeQuery("SELECT country from countries WHERE region = 'Central America'"));
        XplainStatisticsTest.clearXplainOnlyMode(statement);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statements"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statements where stmt_name='1'"), "1");
        String string = this.getStmtIDByName(statement, "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + string + "'"), "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + string + "' and op_identifier='PROJECTION'"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + string + "' and op_identifier='TABLESCAN'"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select op_details from xpltest.sysxplain_resultsets where stmt_id='" + string + "' and op_identifier='TABLESCAN'"), "T: COUNTRIES");
        XplainStatisticsTest.enableXplainStyle(statement);
        XplainStatisticsTest.enableXplainOnlyMode(statement);
        statement.setCursorName("2");
        JDBC.assertEmpty(statement.executeQuery("select sql_text from syscs_diag.transaction_table where status != 'IDLE'"));
        XplainStatisticsTest.clearXplainOnlyMode(statement);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statements"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_statements where stmt_name='2'"), "1");
        string = this.getStmtIDByName(statement, "2");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + string + "' and op_identifier='PROJECTION'"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + string + "' and       op_identifier='PROJECT-FILTER'"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where stmt_id='" + string + "' and op_identifier='VTI'"), "1");
        String string2 = "select region, count(country) from app.countries group by region";
        XplainStatisticsTest.enableXplainStyle(statement);
        XplainStatisticsTest.enableXplainOnlyMode(statement);
        statement.setCursorName("3");
        JDBC.assertEmpty(statement.executeQuery(string2));
        XplainStatisticsTest.clearXplainOnlyMode(statement);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(statement.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{string2, "GROUPBY", "0", "0"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "0", "0", null, null, null, "N", "N"}});
    }

    public void testXplainOnlyExecutePrepared() throws Exception {
        Statement statement = this.createStatement();
        String string = "select region, count(country) from app.countries group by region";
        PreparedStatement preparedStatement = this.prepareStatement(string);
        XplainStatisticsTest.enableXplainStyle(statement);
        XplainStatisticsTest.enableXplainOnlyMode(statement);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        XplainStatisticsTest.clearXplainOnlyMode(statement);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(statement.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{string, "GROUPBY", "0", "0"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "0", "0", null, null, null, "N", "N"}});
        JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), new String[][]{{"Africa", "19"}, {"Asia", "15"}, {"Australia and New Zealand", "2"}, {"Caribbean", "10"}, {"Central America", "6"}, {"Central Asia", "4"}, {"Europe", "29"}, {"Middle East", "7"}, {"North Africa", "5"}, {"North America", "3"}, {"Pacific Islands", "3"}, {"South America", "11"}});
        XplainStatisticsTest.enableXplainStyle(statement);
        XplainStatisticsTest.enableXplainOnlyMode(statement);
        JDBC.assertEmpty(preparedStatement.executeQuery());
        XplainStatisticsTest.clearXplainOnlyMode(statement);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertDrainResults(statement.executeQuery("select * from xpltest.sysxplain_statements"), 1);
    }

    public void testXplainOnlyPrepared() throws Exception {
        Statement statement = this.createStatement();
        String string = "select region, count(country) from app.countries group by region";
        XplainStatisticsTest.enableXplainStyle(statement);
        XplainStatisticsTest.enableXplainOnlyMode(statement);
        PreparedStatement preparedStatement = this.prepareStatement(string);
        XplainStatisticsTest.clearXplainOnlyMode(statement);
        JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), new String[][]{{"Africa", "19"}, {"Asia", "15"}, {"Australia and New Zealand", "2"}, {"Caribbean", "10"}, {"Central America", "6"}, {"Central Asia", "4"}, {"Europe", "29"}, {"Middle East", "7"}, {"North Africa", "5"}, {"North America", "3"}, {"Pacific Islands", "3"}, {"South America", "11"}});
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(statement.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{string, "GROUPBY", "114", "12"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "114", "12", null, null, null, "N", "N"}});
    }

    private void verifySensibleStatementTimings(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select * from xpltest.sysxplain_statement_timings");
        while (resultSet.next()) {
            long l = this.getNonNegativeLong(resultSet, "PARSE_TIME");
            long l2 = this.getNonNegativeLong(resultSet, "BIND_TIME");
            long l3 = this.getNonNegativeLong(resultSet, "OPTIMIZE_TIME");
            long l4 = this.getNonNegativeLong(resultSet, "GENERATE_TIME");
            long l5 = this.getNonNegativeLong(resultSet, "COMPILE_TIME");
            long l6 = this.getNonNegativeLong(resultSet, "EXECUTE_TIME");
            long l7 = l5 - (l + l2 + l3 + l4);
            if (l7 < 0L || l7 > 2L) {
                XplainStatisticsTest.assertEquals((String)("compilation time did not compute (" + l + "," + l2 + "," + l3 + "," + l4 + ")"), (long)l5, (long)(l + l2 + l3 + l4));
            }
            Timestamp timestamp = this.getNonNullTimestamp(resultSet, "BEGIN_COMP_TIME");
            Timestamp timestamp2 = this.getNonNullTimestamp(resultSet, "END_COMP_TIME");
            Timestamp timestamp3 = this.getNonNullTimestamp(resultSet, "BEGIN_EXE_TIME");
            Timestamp timestamp4 = this.getNonNullTimestamp(resultSet, "END_EXE_TIME");
            if (timestamp2.before(timestamp)) {
                XplainStatisticsTest.fail((String)("END_COMP_TIME " + timestamp2 + " unexpectedly before BEGIN_COMP_TIME " + timestamp));
            }
            if (timestamp3.before(timestamp2)) {
                XplainStatisticsTest.fail((String)("BEGIN_EXE_TIME " + timestamp3 + " unexpectedly before END_COMP_TIME " + timestamp2));
            }
            if (!timestamp4.before(timestamp3)) continue;
            XplainStatisticsTest.fail((String)("END_EXE_TIME " + timestamp4 + " unexpectedly before BEGIN_EXE_TIME " + timestamp3));
        }
        resultSet.close();
    }

    private void verifySensibleResultSetTimings(Statement statement) throws SQLException {
        ResultSet resultSet = statement.executeQuery("select rs.op_identifier, rs.returned_rows, rt.* from xpltest.sysxplain_resultsets rs left outer join      xpltest.sysxplain_resultset_timings rt on rs.timing_id = rt.timing_id");
        while (resultSet.next()) {
            String string = resultSet.getString("OP_IDENTIFIER");
            String string2 = resultSet.getString("TIMING_ID");
            XplainStatisticsTest.assertNotNull((String)("RESULTSET row missing for " + string), (Object)string2);
            this.getNonNegativeLong(resultSet, "CONSTRUCTOR_TIME");
            this.getNonNegativeLong(resultSet, "OPEN_TIME");
            this.getNonNegativeLong(resultSet, "NEXT_TIME");
            this.getNonNegativeLong(resultSet, "CLOSE_TIME");
            long l = resultSet.getLong("RETURNED_ROWS");
            if (l > 0L) {
                this.getNonNegativeLong(resultSet, "AVG_NEXT_TIME_PER_ROW");
            } else {
                long l2 = resultSet.getLong("AVG_NEXT_TIME_PER_ROW");
                XplainStatisticsTest.assertTrue((String)("Expected NULL for avg-next on rs " + string), (boolean)resultSet.wasNull());
            }
            if (string.equals("PROJECTION")) {
                this.getNonNegativeLong(resultSet, "PROJECTION_TIME");
                this.getNonNegativeLong(resultSet, "RESTRICTION_TIME");
            } else {
                resultSet.getLong("PROJECTION_TIME");
                XplainStatisticsTest.assertTrue((String)("Expected NULL PROJECTION_TIME for " + string), (boolean)resultSet.wasNull());
                resultSet.getLong("RESTRICTION_TIME");
                XplainStatisticsTest.assertTrue((String)("Expected NULL RESTRICTION_TIME for " + string), (boolean)resultSet.wasNull());
            }
            if (string.equals("MATERIALIZE")) {
                this.getNonNegativeLong(resultSet, "TEMP_CONG_CREATE_TIME");
                this.getNonNegativeLong(resultSet, "TEMP_CONG_FETCH_TIME");
                continue;
            }
            resultSet.getLong("TEMP_CONG_CREATE_TIME");
            XplainStatisticsTest.assertTrue((String)("Expected NULL TEMP_CONG_CREATE_TIME for " + string), (boolean)resultSet.wasNull());
            resultSet.getLong("TEMP_CONG_FETCH_TIME");
            XplainStatisticsTest.assertTrue((String)("Expected NULL TEMP_CONG_FETCH_TIME for " + string), (boolean)resultSet.wasNull());
        }
    }

    private long getNonNegativeLong(ResultSet resultSet, String string) throws SQLException {
        long l = resultSet.getLong(string);
        XplainStatisticsTest.assertTrue((String)(string + " unexpectedly NULL"), (!resultSet.wasNull() ? 1 : 0) != 0);
        XplainStatisticsTest.assertTrue((String)(string + " unexpectedly negative(" + l + ")"), (l >= 0L ? 1 : 0) != 0);
        return l;
    }

    private Timestamp getNonNullTimestamp(ResultSet resultSet, String string) throws SQLException {
        Timestamp timestamp = resultSet.getTimestamp(string);
        XplainStatisticsTest.assertTrue((String)(string + " unexpectedly NULL"), (!resultSet.wasNull() ? 1 : 0) != 0);
        XplainStatisticsTest.assertNotNull((String)(string + " unexpectedly NULL"), (Object)timestamp);
        XplainStatisticsTest.assertTrue((String)("Test started at " + timeSuiteStarted + " but " + string + " value is " + timestamp.getTime()), (timestamp.getTime() >= timeSuiteStarted ? 1 : 0) != 0);
        return timestamp;
    }

    public void testIndexScan() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(statement);
        String string = "SELECT flight_id from flights where dest_airport = 'ABQ'";
        JDBC.assertUnorderedResultSet(statement.executeQuery(string), new String[][]{{"AA1112"}, {"AA1114"}, {"AA1116"}});
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets"), new String[][]{{"PROJECTION"}, {"ROWIDSCAN"}, {"INDEXSCAN"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select p.parent_rs_id  from xpltest.sysxplain_resultsets p,       xpltest.sysxplain_resultsets r,       xpltest.sysxplain_resultsets i   where p.rs_id = r.parent_rs_id and        r.rs_id = i.parent_rs_id and        p.op_identifier='PROJECTION' and        r.op_identifier='ROWIDSCAN' and        i.op_identifier='INDEXSCAN'"), null);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(rs.op_identifier)  from xpltest.sysxplain_statements st  join xpltest.sysxplain_resultsets rs    on st.stmt_id = rs.stmt_id"), "3");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, rs.lock_mode, rs.lock_granularity, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.btree_height, sp.fetch_size, sp.no_fetched_columns, sp.bitset_of_fetched_columns from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='INDEXSCAN'"), new String[][]{{"DESTINDEX", "I", "BTREE", "RC", "IS", "R", "4", "3", "1", "-1", "16", "2", "ALL"}});
        this.verifySensibleStatementTimings(statement);
        this.verifySensibleResultSetTimings(statement);
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)3, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|ROWIDSCAN|INDEXSCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"DESTINDEX", (String)this.getNodeAttribute(string2, "scanned_object", 2));
            Assert.assertEquals((String)"BTREE", (String)this.getNodeAttribute(string2, "scan_type", 2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "visited_pages", 2));
        }
    }

    public void testConstraintScan() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "SELECT region from countries where country = 'Cameroon'";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "Africa");
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets"), new String[][]{{"PROJECTION"}, {"ROWIDSCAN"}, {"CONSTRAINTSCAN"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, rs.lock_mode, rs.lock_granularity, sp.no_fetched_columns, sp.bitset_of_fetched_columns from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='CONSTRAINTSCAN'"), new String[][]{{"COUNTRIES_UNQ_NM", "C", "BTREE", "RC", "1", "1", "1", "SH", "R", "2", "ALL"}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)3, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|ROWIDSCAN|CONSTRAINTSCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"COUNTRIES_UNQ_NM", (String)this.getNodeAttribute(string2, "scanned_object", 2));
            Assert.assertEquals((String)"BTREE", (String)this.getNodeAttribute(string2, "scan_type", 2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "visited_pages", 2));
        }
    }

    public void testGroupBySortProps() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(statement);
        String string = "select region, count(country) from countries group by region";
        JDBC.assertUnorderedResultSet(statement.executeQuery(string), new String[][]{{"Africa", "19"}, {"Asia", "15"}, {"Australia and New Zealand", "2"}, {"Caribbean", "10"}, {"Central America", "6"}, {"Central Asia", "4"}, {"Europe", "29"}, {"Middle East", "7"}, {"North Africa", "5"}, {"North America", "3"}, {"Pacific Islands", "3"}, {"South America", "11"}});
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertFullResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets order by op_identifier"), new String[][]{{"GROUPBY"}, {"PROJECTION"}, {"PROJECTION"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where scan_rs_id is not null"), "1");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets where sort_rs_id is not null"), "1");
        JDBC.assertFullResultSet(statement.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{string, "GROUPBY", "114", "12"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "114", "12", null, null, null, "N", "N"}});
        this.verifySensibleStatementTimings(statement);
        this.verifySensibleResultSetTimings(statement);
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)4, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|GROUPBY|PROJECTION|TABLESCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(string2, "sort_type", 1));
            Assert.assertEquals((String)"12", (String)this.getNodeAttribute(string2, "sorter_output", 1));
        }
    }

    public void testDistinctAggregateSortProps() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyleWithTiming(statement);
        String string = "select orig_airport, avg(distinct miles) from flights group by orig_airport";
        statement.executeQuery(string).close();
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_sort_props"), "1");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select srt.sort_type, srt.no_input_rows,  srt.no_output_rows, srt.no_merge_runs,  srt.merge_run_details, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate from xpltest.sysxplain_sort_props srt join xpltest.sysxplain_resultsets rs on srt.sort_rs_id = rs.sort_rs_id where rs.op_identifier='GROUPBY'"), new String[][]{{"IN", "10", "10", null, null, null, "N", "Y"}});
        this.verifySensibleStatementTimings(statement);
        this.verifySensibleResultSetTimings(statement);
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)4, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|GROUPBY|PROJECTION|TABLESCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(string2, "sort_type", 1));
            Assert.assertEquals((String)"10", (String)this.getNodeAttribute(string2, "sorter_output", 1));
        }
    }

    public void testAggregationResultSet() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "select count(distinct region) from countries";
        JDBC.assertSingleValueResultSet(statement.executeQuery(string), "12");
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens from xpltest.sysxplain_resultsets where op_identifier = 'AGGREGATION'"), new String[][]{{"AGGREGATION", "DISTINCT", "1"}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)4, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|AGGREGATION|PROJECTION|TABLESCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "no_opens", 1));
        }
    }

    public void testInsertResultSet() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("delete from AIRLINES");
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "insert into AIRLINES values ('AA','Amazonian Airways',0.18,0.03,0.5,1.5,20,10,5)";
        int n = statement.executeUpdate(string);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        XplainStatisticsTest.assertEquals((String)"Failed to insert into AIRLINES", (int)1, (int)n);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"I", string}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "3");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details,        no_index_updates, lock_mode,        lock_granularity, parent_rs_id,        affected_rows, deferred_rows from xpltest.sysxplain_resultsets where op_identifier = 'INSERT'"), new String[][]{{"INSERT", null, "1", null, "R", null, "1", "N"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'NORMALIZE'"), new String[][]{{"NORMALIZE", null, "1", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'ROW'"), new String[][]{{"ROW", null, "1", "0", "0", "1"}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)3, (int)this.countNode(string2));
            Assert.assertEquals((String)"INSERT|NORMALIZE|ROW|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "no_opens", 1));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "returned_rows", 1));
        }
    }

    public void testUpdateResultSet() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("delete from AIRLINES");
        String string = "insert into AIRLINES values ('AA','Amazonian Airways',0.18,0.03,0.5,1.5,20,10,5)";
        int n = statement.executeUpdate(string);
        XplainStatisticsTest.assertEquals((String)"Failed to insert into AIRLINES", (int)1, (int)n);
        String string2 = "update AIRLINES set economy_seats=23,business_seats=7  where airline='AA'";
        XplainStatisticsTest.enableXplainStyle(statement);
        n = statement.executeUpdate(string2);
        XplainStatisticsTest.assertEquals((String)"Failed to update AIRLINES", (int)1, (int)n);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"U", string2}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets  where scan_rs_id is not null"), "CONSTRAINTSCAN");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        no_index_updates, lock_mode,        lock_granularity, parent_rs_id,        affected_rows, deferred_rows from xpltest.sysxplain_resultsets where op_identifier = 'UPDATE'"), new String[][]{{"UPDATE", null, null, "0", null, "R", null, "1", "N"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'PROJECTION'"), new String[][]{{"PROJECTION", "2;", "1", "1", "0", "1"}});
        ResultSet resultSet = statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'ROWIDSCAN'");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'ROWIDSCAN'"), new String[][]{{"ROWIDSCAN", "(0),AIRLINES", "1", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        lock_mode, lock_granularity,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'CONSTRAINTSCAN'"), new String[][]{{"CONSTRAINTSCAN", "C: AIRLINES_PK", "1", "EX", "R", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select sp.scan_object_name, sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_visited_deleted_rows, sp.no_fetched_columns, sp.bitset_of_fetched_columns, sp.scan_qualifiers from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='CONSTRAINTSCAN'"), new String[][]{{"AIRLINES_PK", "C", "BTREE", "RC", "1", "1", "1", "0", "2", "ALL", "None"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_scan_props   where start_position is not null     and stop_position is not null"), "1");
        if (XML.classpathMeetsXMLReqs()) {
            String string3 = this.getStmtID(statement);
            Assert.assertEquals((String)string2, (String)this.readStatement(string3));
            Assert.assertEquals((int)4, (int)this.countNode(string3));
            Assert.assertEquals((String)"UPDATE|PROJECTION|ROWIDSCAN|CONSTRAINTSCAN|", (String)this.getNodeName(string3));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(string3, "no_opens", 0));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string3, "returned_rows", 1));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string3, "no_opens", 1));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string3, "returned_rows", 2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string3, "no_opens", 2));
            Assert.assertEquals((String)"None", (String)this.getNodeAttribute(string3, "scan_qualifiers", 3));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string3, "visited_pages", 3));
        }
    }

    public void testDeleteResultSet() throws Exception {
        Statement statement = this.createStatement();
        statement.executeUpdate("delete from AIRLINES");
        String string = "insert into AIRLINES values ('AA','Amazonian Airways',0.18,0.03,0.5,1.5,20,10,5)";
        int n = statement.executeUpdate(string);
        XplainStatisticsTest.assertEquals((String)"Failed to insert into AIRLINES", (int)1, (int)n);
        String string2 = "delete from airlines where airline='AA'";
        XplainStatisticsTest.enableXplainStyle(statement);
        n = statement.executeUpdate(string2);
        XplainStatisticsTest.assertEquals((String)"Failed to delete from AIRLINES", (int)1, (int)n);
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"D", string2}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select distinct op_identifier  from xpltest.sysxplain_resultsets  order by op_identifier"), new String[][]{{"CONSTRAINTSCAN"}, {"DELETE"}, {"PROJECTION"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        no_index_updates, lock_mode,        lock_granularity, parent_rs_id,        affected_rows, deferred_rows from xpltest.sysxplain_resultsets where op_identifier = 'DELETE'"), new String[][]{{"DELETE", null, null, "1", null, "R", null, "1", "N"}});
        if (XML.classpathMeetsXMLReqs()) {
            String string3 = this.getStmtID(statement);
            Assert.assertEquals((String)string2, (String)this.readStatement(string3));
            Assert.assertEquals((int)4, (int)this.countNode(string3));
            Assert.assertEquals((String)"DELETE|PROJECTION|PROJECTION|CONSTRAINTSCAN|", (String)this.getNodeName(string3));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(string3, "no_opens", 0));
        }
    }

    public void testSortResultSet() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "select region from countries order by country";
        statement.executeQuery(string).close();
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "4");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        input_rows, seen_rows, filtered_rows,        returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'SORT'"), new String[][]{{"SORT", null, "1", "114", "0", "0", "0"}});
        JDBC.assertFullResultSet(statement.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows,  srt.sort_type, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{string, "SORT", "114", "114", "IN", "N", "N", null}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)4, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|SORT|PROJECTION|TABLESCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(string2, "sort_type", 1));
            Assert.assertEquals((String)"114", (String)this.getNodeAttribute(string2, "sorter_output", 1));
            Assert.assertEquals((String)"114", (String)this.getNodeAttribute(string2, "input_rows", 1));
        }
    }

    public void testUnionQuery() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "select country from countries where region = 'Central America'  union select country from countries where region = 'Africa'";
        statement.executeQuery(string).close();
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "6");
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets   where parent_rs_id =         (select rs_id from xpltest.sysxplain_resultsets         where op_identifier = 'UNION')"), "2");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets where scan_rs_id is not null"), new String[][]{{"TABLESCAN"}, {"TABLESCAN"}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets  where sort_rs_id is not null and parent_rs_id is null"), "SORT");
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, seen_rows_right, filtered_rows,        returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'UNION'"), new String[][]{{"UNION", "(2)", "1", "6", "19", "0", "25"}});
        JDBC.assertFullResultSet(statement.executeQuery("select s.stmt_text, rs.op_identifier, srt.no_input_rows, srt.no_output_rows,  srt.sort_type, srt.eliminate_duplicates,  srt.in_sort_order, srt.distinct_aggregate  from xpltest.sysxplain_sort_props srt,  xpltest.sysxplain_resultsets rs,  xpltest.sysxplain_statements s  where rs.stmt_id = s.stmt_id and  rs.sort_rs_id = srt.sort_rs_id"), new String[][]{{string, "SORT", "25", "25", "IN", "Y", "N", null}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)6, (int)this.countNode(string2));
            Assert.assertEquals((String)"SORT|UNION|PROJECTION|TABLESCAN|PROJECTION|TABLESCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"IN", (String)this.getNodeAttribute(string2, "sort_type", 0));
            Assert.assertEquals((String)"25", (String)this.getNodeAttribute(string2, "sorter_output", 0));
            Assert.assertEquals((String)"25", (String)this.getNodeAttribute(string2, "input_rows", 0));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "no_opens", 1));
            Assert.assertEquals((String)"25", (String)this.getNodeAttribute(string2, "returned_rows", 1));
        }
    }

    public void testDDLCreateTable() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "create table t1 (a int, b char(10), c timestamp)";
        statement.executeUpdate(string);
        XplainStatisticsTest.disableXplainStyle(statement, false);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select stmt_type, stmt_text  from xpltest.sysxplain_statements"), new String[][]{{"DDL", string}});
        JDBC.assertSingleValueResultSet(statement.executeQuery("select count(*) from xpltest.sysxplain_resultsets"), "0");
    }

    public void testMaxFromIndex() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "select max(country_iso_code) from countries";
        statement.executeQuery(string).close();
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        input_rows, seen_rows, filtered_rows,        returned_rows, index_key_opt from xpltest.sysxplain_resultsets where op_identifier = 'AGGREGATION'"), new String[][]{{"AGGREGATION", null, "1", "0", "0", "0", "0", "Y"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, filtered_rows, returned_rows from xpltest.sysxplain_resultsets where op_identifier = 'LASTINDEXKEYSCAN'"), new String[][]{{"LASTINDEXKEYSCAN", "I: COUNTRIES_PK, T: COUNTRIES", "1", "1", "0", "1"}});
        JDBC.assertUnorderedResultSet(statement.executeQuery("select sp.scan_object_name, sp.scan_object_type,  sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_visited_deleted_rows, sp.no_fetched_columns, sp.bitset_of_fetched_columns, sp.scan_qualifiers from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='LASTINDEXKEYSCAN'"), new String[][]{{"COUNTRIES_PK", "I", "RC", null, null, null, null, null, null, null}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)4, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|AGGREGATION|PROJECTION|LASTINDEXKEYSCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "no_opens", 3));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "returned_rows", 3));
            Assert.assertEquals((String)"COUNTRIES_PK", (String)this.getNodeAttribute(string2, "scanned_object", 3));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(string2, "visited_pages", 3));
            Assert.assertEquals((String)"", (String)this.getNodeAttribute(string2, "scan_qualifiers", 3));
        }
    }

    public void testOuterJoin() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "select f.orig_airport,c.country  from flights f left outer join countries c  on f.orig_airport = c.country_iso_code";
        JDBC.assertUnorderedResultSet(statement.executeQuery(string), new String[][]{{"ABQ", null}, {"LAX", null}, {"ABQ", null}, {"PHX", null}, {"ABQ", null}, {"OKC", null}, {"AKL", null}, {"HNL", null}, {"AKL", null}, {"NRT", null}});
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertUnorderedResultSet(statement.executeQuery("select op_identifier from xpltest.sysxplain_resultsets "), new String[][]{{"PROJECTION"}, {"LONLJOIN"}, {"INDEXSCAN"}, {"ROWIDSCAN"}, {"CONSTRAINTSCAN"}});
        JDBC.assertFullResultSet(statement.executeQuery("select op_identifier, op_details, no_opens,        seen_rows, seen_rows_right, filtered_rows,        returned_rows, empty_right_rows from xpltest.sysxplain_resultsets where op_identifier = 'LONLJOIN'"), new String[][]{{"LONLJOIN", "(1), Nested Loop Left Outer Join ResultSet", "1", "10", "0", "0", "10", "0"}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)5, (int)this.countNode(string2));
            Assert.assertEquals((String)"PROJECTION|LONLJOIN|INDEXSCAN|ROWIDSCAN|CONSTRAINTSCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "no_opens", 1));
            Assert.assertEquals((String)"10", (String)this.getNodeAttribute(string2, "returned_rows", 1));
        }
    }

    public void testScanPositions() throws Exception {
        String[] stringArray;
        Statement statement = this.createStatement();
        String[] stringArray2 = new String[]{"select * from flights where dest_airport = 'ABQ'", "select * from flights where dest_airport > 'HNL'", "select * from flights where dest_airport < 'HNL'", "select * from flights where dest_airport between 'H' and 'J'", "select * from flights where dest_airport like 'AB%'"};
        String[] stringArray3 = new String[]{">= on first 1 column(s).", "> on first 1 column(s).", "None", ">= on first 1 column(s).", ">= on first 1 column(s)."};
        String[] stringArray4 = new String[]{"> on first 1 column(s).", "None", ">= on first 1 column(s).", "> on first 1 column(s).", ">= on first 1 column(s)."};
        XplainStatisticsTest.enableXplainStyle(statement);
        for (int i = 0; i < stringArray2.length; ++i) {
            statement.executeQuery(stringArray2[i]).close();
        }
        XplainStatisticsTest.disableXplainStyle(statement, true);
        ResultSet resultSet = statement.executeQuery("select s.stmt_text, sp.start_position, sp.stop_position   from xpltest.sysxplain_statements s,        xpltest.sysxplain_resultsets rs,        xpltest.sysxplain_scan_props sp  where s.stmt_id = rs.stmt_id and        rs.scan_rs_id = sp.scan_rs_id");
        int n = 0;
        while (resultSet.next()) {
            stringArray = resultSet.getString("stmt_text");
            String string = resultSet.getString("start_position").trim();
            String string2 = resultSet.getString("stop_position").trim();
            boolean bl = false;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!stringArray2[i].equals(stringArray)) continue;
                ++n;
                bl = true;
                if (!string.startsWith(stringArray3[i])) {
                    XplainStatisticsTest.fail((String)("Expected start_position for statement '" + stringArray2[i] + "' to start with '" + stringArray3[i] + "', but it actually was " + string));
                }
                if (string2.startsWith(stringArray4[i])) break;
                XplainStatisticsTest.fail((String)("Expected stop_position for statement '" + stringArray2[i] + "' to start with '" + stringArray4[i] + "', but it actually was " + string2));
                break;
            }
            XplainStatisticsTest.assertTrue((String)("Found unexpected statement " + (String)stringArray), (boolean)bl);
        }
        XplainStatisticsTest.assertEquals((String)"Captured wrong number of statements?", (int)stringArray2.length, (int)n);
        if (XML.classpathMeetsXMLReqs()) {
            stringArray = this.getStmtIDArray(statement, stringArray2.length);
            for (int i = 0; i < stringArray.length; ++i) {
                Assert.assertEquals((String)stringArray2[i], (String)this.readStatement(stringArray[i]));
            }
        }
    }

    public void testScanDeletedRows() throws Exception {
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        String string = "select x from t";
        JDBC.assertUnorderedResultSet(statement.executeQuery(string), new String[][]{{"1"}, {"2"}, {"4"}});
        XplainStatisticsTest.disableXplainStyle(statement, true);
        JDBC.assertFullResultSet(statement.executeQuery("select sp.scan_object_type, sp.scan_type, sp.isolation_level, sp.no_visited_rows, sp.no_qualified_rows, sp.no_visited_pages, sp.no_visited_deleted_rows, sp.no_fetched_columns, sp.bitset_of_fetched_columns, sp.scan_qualifiers from xpltest.sysxplain_scan_props sp join xpltest.sysxplain_resultsets rs on sp.scan_rs_id = rs.scan_rs_id where rs.op_identifier='CONSTRAINTSCAN'"), new String[][]{{"C", "BTREE", "RC", "4", "3", "1", "1", "1", "{0}", "None"}});
        if (XML.classpathMeetsXMLReqs()) {
            String string2 = this.getStmtID(statement);
            Assert.assertEquals((String)string, (String)this.readStatement(string2));
            Assert.assertEquals((int)1, (int)this.countNode(string2));
            Assert.assertEquals((String)"CONSTRAINTSCAN|", (String)this.getNodeName(string2));
            Assert.assertEquals((String)"BTREE", (String)this.getNodeAttribute(string2, "scan_type", 0));
            Assert.assertEquals((String)"1", (String)this.getNodeAttribute(string2, "visited_pages", 0));
            Assert.assertEquals((String)"None", (String)this.getNodeAttribute(string2, "scan_qualifiers", 0));
        }
    }

    public void testAlwaysEmptyResultSet() throws Exception {
        String string = "select * from sysibm.sysdummy1 where false -- DERBY-6268";
        Statement statement = this.createStatement();
        XplainStatisticsTest.enableXplainStyle(statement);
        JDBC.assertEmpty(statement.executeQuery(string));
        XplainStatisticsTest.disableXplainStyle(statement, true);
        PreparedStatement preparedStatement = this.prepareStatement("select * from xpltest.sysxplain_statements where stmt_text = ?");
        preparedStatement.setString(1, string);
        JDBC.assertDrainResults(preparedStatement.executeQuery(), 1);
    }

    public void testTableNotValid() throws SQLException {
        Statement statement = this.createStatement();
        for (int i = 0; i < tableNames.length; ++i) {
            if (!XplainStatisticsTest.hasTable(statement, "XPLTEST", tableNames[i])) continue;
            statement.executeUpdate("drop table xpltest." + tableNames[i]);
        }
        statement.executeUpdate("create table xpltest.sysxplain_resultsets(a int)");
        try {
            XplainStatisticsTest.enableXplainStyle(statement);
            XplainStatisticsTest.fail((String)"Expected an error from table with wrong shape");
        }
        catch (SQLException sQLException) {
            XplainStatisticsTest.assertSQLState("Expected 42X14 error for missing column", "42X14", sQLException);
            if (sQLException.getMessage().indexOf("RS_ID") < 0) {
                XplainStatisticsTest.fail((String)("Expected message about missing column RS_ID, not " + sQLException.getMessage()));
            }
        }
        finally {
            statement.executeUpdate("drop table xpltest.sysxplain_resultsets");
        }
    }

    public void testPlanExporterEncoding() throws Exception {
        String string = "D4902_BL\u00c5B\u00c6R";
        String string2 = "SELECT * FROM " + string;
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE " + string + "(X INT)");
        XplainStatisticsTest.enableXplainStyle(statement);
        JDBC.assertEmpty(statement.executeQuery(string2));
        XplainStatisticsTest.disableXplainStyle(statement, true);
        ResultSet resultSet = statement.executeQuery("SELECT STMT_ID, STMT_TEXT FROM XPLTEST.SYSXPLAIN_STATEMENTS");
        XplainStatisticsTest.assertTrue((boolean)resultSet.next());
        String string3 = resultSet.getString(1);
        XplainStatisticsTest.assertEquals((String)string2, (String)resultSet.getString(2));
        XplainStatisticsTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        if (XML.classpathMeetsXMLReqs()) {
            XplainStatisticsTest.assertEquals((String)string2, (String)this.readStatement(string3));
        }
    }

    public void testPlanExporterHandlingSpecialCharacters() throws Exception {
        String string = "A \"double\" and 'single' quoted table name with some other special characters, like <, > and &";
        String string2 = JDBC.escape(string);
        String string3 = "SELECT * FROM " + string2 + " WHERE X < LENGTH('a & b') AND X > 1";
        Statement statement = this.createStatement();
        statement.execute("CREATE TABLE " + string2 + "(X INT)");
        XplainStatisticsTest.enableXplainStyle(statement);
        JDBC.assertEmpty(statement.executeQuery(string3));
        XplainStatisticsTest.disableXplainStyle(statement, true);
        ResultSet resultSet = statement.executeQuery("SELECT STMT_ID, STMT_TEXT FROM XPLTEST.SYSXPLAIN_STATEMENTS");
        XplainStatisticsTest.assertTrue((boolean)resultSet.next());
        String string4 = resultSet.getString(1);
        XplainStatisticsTest.assertEquals((String)string3, (String)resultSet.getString(2));
        XplainStatisticsTest.assertFalse((boolean)resultSet.next());
        resultSet.close();
        if (XML.classpathMeetsXMLReqs()) {
            XplainStatisticsTest.assertEquals((String)string3, (String)this.readStatement(string4));
            Assert.assertEquals((String)"TABLESCAN|", (String)this.getNodeName(string4));
            XplainStatisticsTest.assertEquals((String)string, (String)this.getNodeAttribute(string4, "scanned_object", 0));
        }
    }

    static {
        tableNames = new String[]{"SYSXPLAIN_STATEMENTS", "SYSXPLAIN_STATEMENT_TIMINGS", "SYSXPLAIN_RESULTSETS", "SYSXPLAIN_RESULTSET_TIMINGS", "SYSXPLAIN_SORT_PROPS", "SYSXPLAIN_SCAN_PROPS"};
    }

    private static class MTSimpleInvalidate
    extends AbstractMTThread {
        public MTSimpleInvalidate(Connection connection, long l) {
            super(connection, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            long l = System.currentTimeMillis();
            try {
                PreparedStatement preparedStatement = this.con.prepareStatement("call SYSCS_UTIL.SYSCS_UPDATE_STATISTICS(?, ?, ?)");
                preparedStatement.setString(1, "APP");
                preparedStatement.setString(2, "COUNTRIES");
                preparedStatement.setNull(3, 12);
                while (System.currentTimeMillis() - l < this.runTime) {
                    preparedStatement.execute();
                    ++this.count;
                }
                preparedStatement.close();
            }
            catch (Throwable throwable) {
                this.error = throwable;
            }
            finally {
                try {
                    this.con.rollback();
                    this.con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static class MTSimpleSelect
    extends AbstractMTThread {
        public MTSimpleSelect(Connection connection, long l) {
            super(connection, l);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Random random = new Random();
            long l = System.currentTimeMillis();
            try {
                Statement statement = this.con.createStatement();
                XplainStatisticsTest.enableXplainStyleWithTiming(statement);
                PreparedStatement preparedStatement = this.con.prepareStatement("SELECT country from countries WHERE region = 'Central America'");
                while (System.currentTimeMillis() - l < this.runTime) {
                    JDBC.assertUnorderedResultSet(preparedStatement.executeQuery(), new String[][]{{"Belize"}, {"Costa Rica"}, {"El Salvador"}, {"Guatemala"}, {"Honduras"}, {"Nicaragua"}});
                    ++this.count;
                    try {
                        Thread.sleep(random.nextInt(50));
                    }
                    catch (InterruptedException interruptedException) {}
                }
                statement.close();
                preparedStatement.close();
            }
            catch (Throwable throwable) {
                this.error = throwable;
            }
            finally {
                try {
                    this.con.rollback();
                    this.con.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    private static abstract class AbstractMTThread
    implements Runnable {
        protected final Connection con;
        protected final long runTime;
        protected int count;
        protected Throwable error;

        protected AbstractMTThread(Connection connection, long l) {
            this.con = connection;
            this.runTime = l;
        }

        public int getActionCount() {
            return this.count;
        }

        public boolean failed() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }
    }
}

