/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.lang;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.types.Like;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_Generic;

public class T_Like
extends T_Generic {
    private static final String testService = "likeTest";
    boolean didFAIL;

    @Override
    public String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.sql.execute.ExecutionFactory";
    }

    @Override
    protected void runTests() throws T_Fail {
        Object f = null;
        boolean pass = false;
        this.didFAIL = false;
        this.out.println("likeTest underway");
        if (this.startParams == null) {
            this.startParams = new Properties();
        }
        this.startParams.put("derby.database.noAutoBoot", Boolean.TRUE.toString());
        this.REPORT("(unitTestMain) Testing likeTest");
        try {
            this.tests();
        }
        catch (StandardException e) {
            this.FAIL("exception:" + (Object)((Object)e));
        }
        if (this.didFAIL) {
            throw T_Fail.testFailMsg("see log for details");
        }
        this.out.println("likeTest complete");
    }

    private void expect(String desc, Boolean test, Boolean result) {
        boolean pass;
        boolean bl = pass = test == null && result == null || test != null && result != null && test.equals(result);
        if (pass) {
            this.PASS("TEST [" + desc + "] == result[" + result + "] ");
        } else {
            this.FAIL("TEST [" + desc + "] != result[" + result + "] ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tests() throws StandardException {
        boolean gotLE = false;
        Boolean t = null;
        char[] caNull = null;
        char[] caHello = "hello".toCharArray();
        String msg = null;
        String desc = null;
        this.REPORT("testing null combinations...");
        try {
            this.expect("null like null escape null", Like.like(caNull, (int)0, caNull, (int)0, caNull, (int)0, null), null);
            this.expect("null like 'hello' escape null", Like.like(caNull, (int)0, (char[])caHello, (int)caHello.length, caNull, (int)0, null), null);
            this.expect("'hello' like null escape null", Like.like((char[])caHello, (int)caHello.length, caNull, (int)0, caNull, (int)0, null), null);
            this.expect("null like null escape '\\'", Like.like(caNull, (int)0, caNull, (int)0, (char[])"\\".toCharArray(), (int)"\\".toCharArray().length, null), null);
            this.expect("null like null escape 'hello'", Like.like(caNull, (int)0, caNull, (int)0, (char[])caHello, (int)caHello.length, null), null);
            this.expect("null like 'hello\\' escape '\\'", Like.like(caNull, (int)0, (char[])"hello\\".toCharArray(), (int)"hello\\".toCharArray().length, (char[])"\\".toCharArray(), (int)"\\".toCharArray().length, null), null);
        }
        catch (StandardException leOuter1) {
            leOuter1.printStackTrace();
            this.FAIL("unexpected exception");
        }
        this.REPORT("testing valid match cases...");
        try {
            this.expect("'hello' like 'hello' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])caHello, (int)caHello.length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like 'h_llo' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"h_llo".toCharArray(), (int)"h_llo".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like '_ello' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"_ello".toCharArray(), (int)"_ello".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like 'hell_' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"hell_".toCharArray(), (int)"hell_".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like '_____' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"_____".toCharArray(), (int)"_____".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'hello' like 'h___e' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"h___o".toCharArray(), (int)"h___o".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'h' like 'h' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"h".toCharArray(), (int)"h".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '_' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"_".toCharArray(), (int)"_".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '%' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"%".toCharArray(), (int)"%".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '_%' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"_%".toCharArray(), (int)"_%".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '%_' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"%_".toCharArray(), (int)"%_".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'h' like '%' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"%".toCharArray(), (int)"%".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'' like '%' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"%".toCharArray(), (int)"%".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'' like '%%' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"%%".toCharArray(), (int)"%%".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
            this.expect("'' like '%%%' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"%%%".toCharArray(), (int)"%%%".toCharArray().length, caNull, (int)0, null), Boolean.TRUE);
        }
        catch (StandardException leOuter2) {
            leOuter2.printStackTrace();
            this.FAIL("unexpected exception");
        }
        this.REPORT("testing valid nonmatch cases...");
        try {
            this.expect("'hello' like 'hello ' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"hello ".toCharArray(), (int)"hello ".toCharArray().length, caNull, (int)0, null), Boolean.FALSE);
            this.expect("'hello ' like 'hello' escape null", Like.like((char[])"hello ".toCharArray(), (int)"hello ".toCharArray().length, (char[])caHello, (int)caHello.length, caNull, (int)0, null), Boolean.FALSE);
            this.expect("'hello' like 'hellox' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"hellox".toCharArray(), (int)"hellox".toCharArray().length, caNull, (int)0, null), Boolean.FALSE);
            this.expect("'hellox' like 'hello' escape null", Like.like((char[])"hellox".toCharArray(), (int)"hellox".toCharArray().length, (char[])caHello, (int)caHello.length, caNull, (int)0, null), Boolean.FALSE);
            this.expect("'xhellox' like 'hello' escape null", Like.like((char[])"xhellox".toCharArray(), (int)"xhellox".toCharArray().length, (char[])caHello, (int)caHello.length, caNull, (int)0, null), Boolean.FALSE);
            this.expect("'hello' like 'xhellox' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"xhellox".toCharArray(), (int)"xhellox".toCharArray().length, null, (int)0, null), Boolean.FALSE);
            this.expect("'hello' like 'h___' escape null", Like.like((char[])caHello, (int)caHello.length, (char[])"h___".toCharArray(), (int)"h___".toCharArray().length, caNull, (int)0, null), Boolean.FALSE);
            this.expect("'h' like '_%_' escape null", Like.like((char[])"h".toCharArray(), (int)"h".toCharArray().length, (char[])"_%_".toCharArray(), (int)"_%_".toCharArray().length, caNull, (int)0, null), Boolean.FALSE);
            this.expect("'' like '_' escape null", Like.like((char[])"".toCharArray(), (int)"".toCharArray().length, (char[])"_".toCharArray(), (int)"_".toCharArray().length, caNull, (int)0, null), Boolean.FALSE);
        }
        catch (StandardException leOuter3) {
            leOuter3.printStackTrace();
            this.FAIL("unexpected exception");
        }
        this.REPORT("testing error cases...");
        try {
            msg = null;
            gotLE = false;
            desc = "null like null escape 'hello'";
            t = Like.like((char[])caHello, (int)caHello.length, (char[])caHello, (int)caHello.length, (char[])caHello, (int)caHello.length, null);
        }
        catch (StandardException le) {
            gotLE = true;
            msg = le.getMessage();
        }
        finally {
            if (gotLE) {
                this.PASS("TEST [" + desc + "] got exception " + msg);
            } else {
                this.FAIL("TEST [" + desc + "] didn't get exception");
            }
        }
        try {
            msg = null;
            gotLE = false;
            desc = "'hello' like 'hhh' escape 'h'";
            t = Like.like((char[])caHello, (int)caHello.length, (char[])"hhh".toCharArray(), (int)"hhh".toCharArray().length, (char[])"h".toCharArray(), (int)"h".toCharArray().length, null);
        }
        catch (StandardException le) {
            gotLE = true;
            msg = le.getMessage();
        }
        finally {
            if (gotLE) {
                this.PASS("TEST [" + desc + "] got exception " + msg);
            } else {
                this.FAIL("TEST [" + desc + "] didn't get exception");
            }
        }
        try {
            msg = null;
            gotLE = false;
            desc = "'hello' like 'he%' escape 'h'";
            t = Like.like((char[])caHello, (int)caHello.length, (char[])"he%".toCharArray(), (int)"he%".toCharArray().length, (char[])"h".toCharArray(), (int)"h".toCharArray().length, null);
        }
        catch (StandardException le) {
            gotLE = true;
            msg = le.getMessage();
        }
        finally {
            if (gotLE) {
                this.PASS("TEST [" + desc + "] got exception " + msg);
            } else {
                this.FAIL("TEST [" + desc + "] didn't get exception");
            }
        }
    }

    @Override
    protected boolean FAIL(String msg) {
        super.FAIL(msg);
        this.didFAIL = true;
        return true;
    }
}

