/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.drda;

import java.sql.SQLException;
import java.util.Properties;
import javax.sql.XAConnection;
import javax.transaction.xa.XAResource;
import org.apache.derby.iapi.jdbc.EngineConnection;
import org.apache.derby.iapi.jdbc.ResourceAdapter;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.impl.drda.Database;
import org.apache.derby.jdbc.EmbeddedXADataSourceInterface;

class XADatabase
extends Database {
    private EmbeddedXADataSourceInterface xaDataSource;
    private XAResource xaResource;
    private XAConnection xaConnection;
    private ResourceAdapter ra;

    XADatabase(String dbName) {
        super(dbName);
    }

    @Override
    synchronized void makeConnection(Properties p) throws SQLException {
        EngineConnection conn;
        if (this.xaDataSource == null) {
            try {
                Class<?> clazz;
                if (JVMInfo.hasJNDI()) {
                    clazz = Class.forName("org.apache.derby.jdbc.EmbeddedXADataSource");
                    this.xaDataSource = (EmbeddedXADataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                } else {
                    clazz = Class.forName("org.apache.derby.jdbc.BasicEmbeddedXADataSource40");
                    this.xaDataSource = (EmbeddedXADataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                SQLException ne = new SQLException(MessageService.getTextMessage("I024", new Object[0]), "08006", 45000);
                ne.initCause(e);
                throw ne;
            }
        }
        this.xaDataSource.setDatabaseName(this.getShortDbName());
        this.appendAttrString(p);
        if (this.attrString != null) {
            this.xaDataSource.setConnectionAttributes(this.attrString);
        }
        if ((conn = this.getConnection()) == null) {
            this.xaConnection = this.xaDataSource.getXAConnection(this.userId, this.password);
            this.ra = this.xaDataSource.getResourceAdapter();
            this.setXAResource(this.xaConnection.getXAResource());
        } else {
            conn.close();
        }
        conn = (EngineConnection)this.xaConnection.getConnection();
        conn.setAutoCommit(false);
        this.setConnection(conn);
    }

    protected void setXAResource(XAResource resource) {
        this.xaResource = resource;
    }

    protected XAResource getXAResource() {
        return this.xaResource;
    }

    ResourceAdapter getResourceAdapter() {
        return this.ra;
    }
}

