/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class WISCInsert {
    private static final char[] chars = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    int numrows;
    int prime;
    int generator;
    int rowsReturned = 0;
    int unique1;
    int unique2;
    int two;
    int four;
    int ten;
    int twenty;
    int onePercent;
    int tenPercent;
    int twentyPercent;
    int fiftyPercent;
    int unique3;
    int evenOnePercent;
    int oddOnePercent;
    String stringu1;
    String stringu2;
    String string4;
    int seed;
    static final String[] cyclicStrings = new String[]{"AAAAxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "HHHHxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "OOOOxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", "VVVVxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx"};
    boolean closed = false;

    public int doWISCInsert(int numrows, String tableName, Connection conn) throws SQLException {
        this.numrows = numrows;
        if (numrows <= 1000) {
            this.generator = 279;
            this.prime = 1009;
        } else if (numrows <= 10000) {
            this.generator = 2969;
            this.prime = 10007;
        } else if (numrows <= 100000) {
            this.generator = 21395;
            this.prime = 100003;
        } else if (numrows <= 1000000) {
            this.generator = 2107;
            this.prime = 1000003;
        } else if (numrows <= 10000000) {
            this.generator = 211;
            this.prime = 10000019;
        } else if (numrows <= 100000000) {
            this.generator = 21;
            this.prime = 100000007;
        } else {
            throw new SQLException("Too many rows - maximum is 100000000, " + numrows + " requested.");
        }
        this.seed = this.generator;
        String insertString = "insert into " + tableName + " values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
        PreparedStatement ps = conn.prepareStatement(insertString);
        for (int i = 0; i < numrows; ++i) {
            this.next();
            ps.setInt(1, this.unique1);
            ps.setInt(2, this.unique2);
            ps.setInt(3, this.two);
            ps.setInt(4, this.four);
            ps.setInt(5, this.ten);
            ps.setInt(6, this.twenty);
            ps.setInt(7, this.onePercent);
            ps.setInt(8, this.tenPercent);
            ps.setInt(9, this.twentyPercent);
            ps.setInt(10, this.fiftyPercent);
            ps.setInt(11, this.unique3);
            ps.setInt(12, this.evenOnePercent);
            ps.setInt(13, this.oddOnePercent);
            ps.setString(14, this.stringu1);
            ps.setString(15, this.stringu2);
            ps.setString(16, this.string4);
            ps.executeUpdate();
        }
        return numrows;
    }

    public boolean next() throws SQLException {
        if (this.rowsReturned >= this.numrows) {
            return false;
        }
        this.seed = this.rand(this.seed, this.numrows);
        this.unique1 = this.seed - 1;
        this.unique2 = this.rowsReturned;
        this.two = this.unique1 % 2;
        this.four = this.unique1 % 4;
        this.ten = this.unique1 % 10;
        this.twenty = this.unique1 % 20;
        this.onePercent = this.unique1 % 100;
        this.tenPercent = this.unique1 % 10;
        this.twentyPercent = this.unique1 % 5;
        this.fiftyPercent = this.unique1 % 2;
        this.unique3 = this.unique1;
        this.evenOnePercent = this.onePercent * 2;
        this.oddOnePercent = this.evenOnePercent + 1;
        this.stringu1 = this.uniqueString(this.unique1);
        this.stringu2 = this.uniqueString(this.unique2);
        this.string4 = cyclicStrings[this.rowsReturned % cyclicStrings.length];
        ++this.rowsReturned;
        return true;
    }

    private int rand(int seed, int limit) {
        while ((seed = this.generator * seed % this.prime) > limit) {
        }
        return seed;
    }

    private String uniqueString(int unique) {
        int i;
        char[] retval = new char[52];
        for (i = 0; i < 7; ++i) {
            retval[i] = 65;
        }
        for (i = 7; i < retval.length; ++i) {
            retval[i] = 120;
        }
        i = 6;
        while (unique > 0) {
            int rem = unique % 26;
            retval[i] = chars[rem];
            unique /= 26;
            --i;
        }
        return new String(retval);
    }

    public String getShortTestDescription() {
        StringBuffer st = new StringBuffer("insert values into wisconsin benchmark schema.");
        st.append("See The Benchmark Handbook, Second Edition (edited by Jim Gray).");
        return st.toString();
    }

    public String getLongTestDescription() {
        StringBuffer st = new StringBuffer(this.getShortTestDescription() + "\n Called from performance.wisc.WiscLoad. This is not actually a test itself. Based on a scale value by which to multiply the number of rows, the values are generated. This class is based on the vti org.apache.derbyTesting.functionTests.tests.lang.Wisc, however, this will work with any database, not just Cloudscape.");
        return st.toString();
    }

    public boolean isCloudscapeSpecificTest() {
        return false;
    }
}

