/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.i18n;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.derby.iapi.services.i18n.BundleFinder;
import org.apache.derby.shared.common.error.ShutdownException;

public final class MessageService {
    private static final Locale EN = new Locale("en", "US");
    private static BundleFinder finder;

    private MessageService() {
    }

    public static ResourceBundle getBundleForLocale(Locale locale, String msgId) {
        try {
            return MessageService.getBundleWithEnDefault("org.apache.derby.loc.m" + MessageService.hashString50(msgId), locale);
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static void setFinder(BundleFinder theFinder) {
        finder = theFinder;
    }

    public static String getTextMessage(String messageId, Object ... arguments) {
        try {
            return MessageService.formatMessage(MessageService.getBundle(messageId), messageId, arguments, true);
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ShutdownException shutdownException) {
            // empty catch block
        }
        return MessageService.formatMessage(MessageService.getBundleForLocale(EN, messageId), messageId, arguments, false);
    }

    public static String getProperty(String messageId, String propertyName) {
        ResourceBundle bundle = MessageService.getBundle(messageId);
        try {
            if (bundle != null) {
                return bundle.getString(messageId.concat(".").concat(propertyName));
            }
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return null;
    }

    public static String formatMessage(ResourceBundle bundle, String messageId, Object[] arguments, boolean lastChance) {
        block12: {
            if (arguments == null) {
                arguments = new Object[]{};
            }
            if (bundle != null) {
                try {
                    messageId = bundle.getString(messageId);
                    try {
                        return MessageFormat.format(messageId, arguments);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                    }
                    catch (NullPointerException nullPointerException) {
                    }
                }
                catch (MissingResourceException mre) {
                    if (!lastChance) break block12;
                    throw mre;
                }
            }
        }
        if (messageId == null) {
            messageId = "UNKNOWN";
        }
        StringBuffer sb = new StringBuffer(messageId);
        int len = arguments.length;
        if (len > 0) {
            sb.append(" : ");
        }
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append('[');
            sb.append(i);
            sb.append("] ");
            if (arguments[i] == null) {
                sb.append("null");
                continue;
            }
            sb.append(arguments[i].toString());
        }
        return sb.toString();
    }

    private static ResourceBundle getBundle(String messageId) {
        ResourceBundle bundle = null;
        if (finder != null) {
            bundle = finder.getBundle(messageId);
        }
        if (bundle == null) {
            bundle = MessageService.getBundleForLocale(Locale.getDefault(), messageId);
        }
        return bundle;
    }

    public static ResourceBundle getBundleWithEnDefault(String resource, Locale locale) {
        try {
            return ResourceBundle.getBundle(resource, locale);
        }
        catch (MissingResourceException mre) {
            return ResourceBundle.getBundle(resource, EN);
        }
    }

    public static int hashString50(String key) {
        int hash = 0;
        int len = key.length();
        if (len > 5) {
            len = 5;
        }
        for (int i = 0; i < len; ++i) {
            hash += key.charAt(i);
        }
        return hash %= 50;
    }
}

